/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.BBox;
import com.sun.j3d.utils.geometry.Heap;
import com.sun.j3d.utils.geometry.NoHash;
import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class EarClip {
    EarClip() {
    }

    static void classifyAngles(Triangulator triangulator, int n2) {
        int n3;
        int n4 = n2;
        int n5 = triangulator.fetchData(n4);
        int n6 = triangulator.fetchPrevData(n4);
        int n7 = triangulator.fetchData(n6);
        do {
            n3 = triangulator.fetchNextData(n4);
            int n8 = triangulator.fetchData(n3);
            int n9 = Numerics.isConvexAngle(triangulator, n7, n5, n8, n4);
            triangulator.setAngle(n4, n9);
            n7 = n5;
            n5 = n8;
        } while ((n4 = n3) != n2);
    }

    static void classifyEars(Triangulator triangulator, int n2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        double[] dArray = new double[1];
        Heap.initHeap(triangulator);
        int n3 = n2;
        int n4 = triangulator.fetchData(n3);
        do {
            if (triangulator.getAngle(n3) > 0 && EarClip.isEar(triangulator, n3, nArray, nArray2, dArray)) {
                Heap.dumpOnHeap(triangulator, dArray[0], n3, nArray[0], nArray2[0]);
            }
            n3 = triangulator.fetchNextData(n3);
            n4 = triangulator.fetchData(n3);
        } while (n3 != n2);
    }

    static boolean isEar(Triangulator triangulator, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        BBox bBox;
        int n3 = triangulator.fetchData(n2);
        nArray2[0] = triangulator.fetchNextData(n2);
        int n4 = triangulator.fetchData(nArray2[0]);
        int n5 = triangulator.fetchNextData(nArray2[0]);
        int n6 = triangulator.fetchData(n5);
        nArray[0] = triangulator.fetchPrevData(n2);
        int n7 = triangulator.fetchData(nArray[0]);
        int n8 = triangulator.fetchPrevData(nArray[0]);
        int n9 = triangulator.fetchData(n8);
        if (n7 == n4 || n7 == n3 || n3 == n4 || triangulator.getAngle(n2) == 2) {
            dArray[0] = 0.0;
            return true;
        }
        if (n9 == n4) {
            if (triangulator.getAngle(n8) < 0 || triangulator.getAngle(nArray2[0]) < 0) {
                dArray[0] = 0.0;
                return true;
            }
            return false;
        }
        if (n7 == n6) {
            if (triangulator.getAngle(nArray[0]) < 0 || triangulator.getAngle(n5) < 0) {
                dArray[0] = 0.0;
                return true;
            }
            return false;
        }
        boolean bl = triangulator.getAngle(nArray[0]) > 0;
        boolean bl2 = Numerics.isInCone(triangulator, n9, n7, n3, n4, bl);
        if (!bl2) {
            return false;
        }
        bl = triangulator.getAngle(nArray2[0]) > 0;
        bl2 = Numerics.isInCone(triangulator, n3, n4, n6, n7, bl);
        if (bl2 && !NoHash.noHashIntersectionExists(triangulator, n3, n2, n4, n7, bBox = new BBox(triangulator, n7, n4))) {
            dArray[0] = triangulator.earsSorted ? Numerics.getRatio(triangulator, n7, n4, n3) : 1.0;
            return true;
        }
        return false;
    }

    static boolean clipEar(Triangulator triangulator, boolean[] blArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        boolean bl = false;
        do {
            if (!Heap.deleteFromHeap(triangulator, nArray6, nArray2, nArray4)) {
                return false;
            }
            n5 = triangulator.fetchPrevData(nArray6[0]);
            n3 = triangulator.fetchData(n5);
            n4 = triangulator.fetchNextData(nArray6[0]);
            n2 = triangulator.fetchData(n4);
        } while (nArray2[0] != n5 || nArray4[0] != n4);
        int n6 = triangulator.fetchData(nArray6[0]);
        triangulator.deleteLinks(nArray6[0]);
        triangulator.storeTriangle(n5, nArray6[0], n4);
        int n7 = triangulator.fetchPrevData(n5);
        int n8 = triangulator.fetchData(n7);
        if (n7 == n4) {
            blArray[0] = true;
            return true;
        }
        int n9 = Numerics.isConvexAngle(triangulator, n8, n3, n2, n5);
        int n10 = triangulator.fetchNextData(n4);
        int n11 = triangulator.fetchData(n10);
        int n12 = Numerics.isConvexAngle(triangulator, n3, n2, n11, n4);
        if (n3 != n2) {
            if (n9 >= 0 && triangulator.getAngle(n5) < 0) {
                NoHash.deleteReflexVertex(triangulator, n5);
            }
            if (n12 >= 0 && triangulator.getAngle(n4) < 0) {
                NoHash.deleteReflexVertex(triangulator, n4);
            }
        } else if (n9 >= 0 && triangulator.getAngle(n5) < 0) {
            NoHash.deleteReflexVertex(triangulator, n5);
        } else if (n12 >= 0 && triangulator.getAngle(n4) < 0) {
            NoHash.deleteReflexVertex(triangulator, n4);
        }
        triangulator.setAngle(n5, n9);
        triangulator.setAngle(n4, n12);
        if (n9 > 0 && EarClip.isEar(triangulator, n5, nArray, nArray3, dArray)) {
            Heap.insertIntoHeap(triangulator, dArray[0], n5, nArray[0], nArray3[0]);
        }
        if (n12 > 0 && EarClip.isEar(triangulator, n4, nArray3, nArray5, dArray)) {
            Heap.insertIntoHeap(triangulator, dArray[0], n4, nArray3[0], nArray5[0]);
        }
        n7 = triangulator.fetchPrevData(n5);
        n8 = triangulator.fetchData(n7);
        n10 = triangulator.fetchNextData(n4);
        n11 = triangulator.fetchData(n10);
        if (n7 == n10) {
            triangulator.storeTriangle(n5, n4, n10);
            blArray[0] = true;
        } else {
            blArray[0] = false;
        }
        return true;
    }
}

