/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;

class Quadrics {
    Quadrics() {
    }

    GeomBuffer disk(double d2, int n2, double d3, boolean bl, boolean bl2) {
        double d4 = bl ? 1.0 : -1.0;
        double d5 = Math.PI * 2 / (double)n2;
        GeomBuffer geomBuffer = new GeomBuffer(n2 + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, 1.0 * d4, 0.0);
        geomBuffer.texCoord2d(0.5, 0.5);
        geomBuffer.vertex3d(0.0, d3, 0.0);
        if (!bl) {
            for (int i2 = 0; i2 <= n2; ++i2) {
                double d6 = (double)i2 * d5;
                double d7 = Math.sin(d6 - 1.5707963267948966);
                double d8 = Math.cos(d6 - 1.5707963267948966);
                geomBuffer.normal3d(0.0, 1.0 * d4, 0.0);
                if (bl2) {
                    geomBuffer.texCoord2d(0.5 + d8 * 0.5, 1.0 - (0.5 + d7 * 0.5));
                } else {
                    geomBuffer.texCoord2d(0.5 + d8 * 0.5, 0.5 + d7 * 0.5);
                }
                geomBuffer.vertex3d(d2 * d8, d3, d2 * d7);
            }
        } else {
            for (int i3 = n2; i3 >= 0; --i3) {
                double d9 = (double)i3 * d5;
                double d10 = Math.sin(d9 - 1.5707963267948966);
                double d11 = Math.cos(d9 - 1.5707963267948966);
                geomBuffer.normal3d(0.0, 1.0 * d4, 0.0);
                if (bl2) {
                    geomBuffer.texCoord2d(0.5 + d11 * 0.5, 1.0 - (0.5 - d10 * 0.5));
                } else {
                    geomBuffer.texCoord2d(0.5 + d11 * 0.5, 0.5 - d10 * 0.5);
                }
                geomBuffer.vertex3d(d11 * d2, d3, d10 * d2);
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer cylinder(double d2, double d3, int n2, int n3, boolean bl, boolean bl2) {
        double d4 = bl ? 1.0 : -1.0;
        double d5 = Math.PI * 2 / (double)n2;
        double d6 = d2 / (double)n3;
        double d7 = 1.0 / (double)n2;
        double d8 = 1.0 / (double)n3;
        GeomBuffer geomBuffer = new GeomBuffer(n3 * 2 * (n2 + 1));
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = -d2 / 2.0;
        geomBuffer.begin(1);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            double d12;
            double d13;
            double d14;
            double d15;
            double d16 = d11 + d6;
            if (bl) {
                d15 = Math.cos((double)n2 * d5 - 1.5707963267948966);
                d14 = Math.sin((double)n2 * d5 - 1.5707963267948966);
                d13 = Math.cos((double)(n2 - 1) * d5 - 1.5707963267948966);
                d12 = Math.sin((double)(n2 - 1) * d5 - 1.5707963267948966);
                geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9, 1.0 - (d10 + d8));
                } else {
                    geomBuffer.texCoord2d(d9, d10 + d8);
                }
                geomBuffer.vertex3d(d15 * d3, d16, d14 * d3);
                geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9, 1.0 - d10);
                } else {
                    geomBuffer.texCoord2d(d9, d10);
                }
                geomBuffer.vertex3d(d15 * d3, d11, d14 * d3);
                geomBuffer.normal3d(d13 * d4, 0.0, d12 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9 + d7, 1.0 - (d10 + d8));
                } else {
                    geomBuffer.texCoord2d(d9 + d7, d10 + d8);
                }
                geomBuffer.vertex3d(d13 * d3, d16, d12 * d3);
                geomBuffer.normal3d(d13 * d4, 0.0, d12 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9 + d7, 1.0 - d10);
                } else {
                    geomBuffer.texCoord2d(d9 + d7, d10);
                }
                geomBuffer.vertex3d(d13 * d3, d11, d12 * d3);
                d9 += d7 * 2.0;
                for (n4 = n2 - 2; n4 >= 0; --n4) {
                    d15 = Math.cos((double)n4 * d5 - 1.5707963267948966);
                    d14 = Math.sin((double)n4 * d5 - 1.5707963267948966);
                    geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                    if (bl2) {
                        geomBuffer.texCoord2d(d9, 1.0 - (d10 + d8));
                    } else {
                        geomBuffer.texCoord2d(d9, d10 + d8);
                    }
                    geomBuffer.vertex3d(d15 * d3, d16, d14 * d3);
                    geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                    if (bl2) {
                        geomBuffer.texCoord2d(d9, 1.0 - d10);
                    } else {
                        geomBuffer.texCoord2d(d9, d10);
                    }
                    geomBuffer.vertex3d(d15 * d3, d11, d14 * d3);
                    d9 += d7;
                }
            } else {
                d15 = Math.cos(-1.5707963267948966);
                d14 = Math.sin(-1.5707963267948966);
                d13 = Math.cos(d5 - 1.5707963267948966);
                d12 = Math.sin(d5 - 1.5707963267948966);
                geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9, 1.0 - (d10 + d8));
                } else {
                    geomBuffer.texCoord2d(d9, d10 + d8);
                }
                geomBuffer.vertex3d(d15 * d3, d16, d14 * d3);
                geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9, 1.0 - d10);
                } else {
                    geomBuffer.texCoord2d(d9, d10);
                }
                geomBuffer.vertex3d(d15 * d3, d11, d14 * d3);
                geomBuffer.normal3d(d13 * d4, 0.0, d12 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9 + d7, 1.0 - (d10 + d8));
                } else {
                    geomBuffer.texCoord2d(d9 + d7, d10 + d8);
                }
                geomBuffer.vertex3d(d13 * d3, d16, d12 * d3);
                geomBuffer.normal3d(d13 * d4, 0.0, d12 * d4);
                if (bl2) {
                    geomBuffer.texCoord2d(d9 + d7, 1.0 - d10);
                } else {
                    geomBuffer.texCoord2d(d9 + d7, d10);
                }
                geomBuffer.vertex3d(d13 * d3, d11, d12 * d3);
                d9 += d7 * 2.0;
                for (n4 = 2; n4 <= n2; ++n4) {
                    d15 = Math.cos((double)n4 * d5 - 1.5707963267948966);
                    d14 = Math.sin((double)n4 * d5 - 1.5707963267948966);
                    geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                    if (bl2) {
                        geomBuffer.texCoord2d(d9, 1.0 - (d10 + d8));
                    } else {
                        geomBuffer.texCoord2d(d9, d10 + d8);
                    }
                    geomBuffer.vertex3d(d15 * d3, d16, d14 * d3);
                    geomBuffer.normal3d(d15 * d4, 0.0, d14 * d4);
                    if (bl2) {
                        geomBuffer.texCoord2d(d9, 1.0 - d10);
                    } else {
                        geomBuffer.texCoord2d(d9, d10);
                    }
                    geomBuffer.vertex3d(d15 * d3, d11, d14 * d3);
                    d9 += d7;
                }
            }
            d9 = 0.0;
            d10 += d8;
            d11 += d6;
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneBody(double d2, double d3, double d4, double d5, int n2, int n3, double d6, boolean bl, boolean bl2) {
        double d7 = bl ? 1.0 : -1.0;
        double d8 = Math.PI * 2 / (double)n2;
        double d9 = (d5 - d4) / (double)n3;
        double d10 = d3 - d2;
        double d11 = d10 / (double)n3;
        double d12 = (d4 - d5) / d10;
        double d13 = 1.0 / (double)n2;
        GeomBuffer geomBuffer = new GeomBuffer(n3 * 2 * (n2 + 1));
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = d2;
        double d17 = d4;
        geomBuffer.begin(1);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            double d18;
            double d19;
            double d20;
            double d21;
            double d22 = d16 + d11;
            if (bl) {
                d21 = Math.cos((double)n2 * d8 - 1.5707963267948966);
                d20 = Math.sin((double)n2 * d8 - 1.5707963267948966);
                d19 = Math.cos((double)(n2 - 1) * d8 - 1.5707963267948966);
                d18 = Math.sin((double)(n2 - 1) * d8 - 1.5707963267948966);
                geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14, 1.0 - (d15 + d6));
                } else {
                    geomBuffer.texCoord2d(d14, d15 + d6);
                }
                geomBuffer.vertex3d(d21 * (d17 + d9), d22, d20 * (d17 + d9));
                geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14, 1.0 - d15);
                } else {
                    geomBuffer.texCoord2d(d14, d15);
                }
                geomBuffer.vertex3d(d21 * d17, d16, d20 * d17);
                geomBuffer.normal3d(d19 * d7, d12 * d7, d18 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14 + d13, 1.0 - (d15 + d6));
                } else {
                    geomBuffer.texCoord2d(d14 + d13, d15 + d6);
                }
                geomBuffer.vertex3d(d19 * (d17 + d9), d22, d18 * (d17 + d9));
                geomBuffer.normal3d(d19 * d7, d12 * d7, d18 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14 + d13, 1.0 - d15);
                } else {
                    geomBuffer.texCoord2d(d14 + d13, d15);
                }
                geomBuffer.vertex3d(d19 * d17, d16, d18 * d17);
                d14 += d13 * 2.0;
                for (n4 = n2 - 2; n4 >= 0; --n4) {
                    d21 = Math.cos((double)n4 * d8 - 1.5707963267948966);
                    d20 = Math.sin((double)n4 * d8 - 1.5707963267948966);
                    geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                    if (bl2) {
                        geomBuffer.texCoord2d(d14, 1.0 - (d15 + d6));
                    } else {
                        geomBuffer.texCoord2d(d14, d15 + d6);
                    }
                    geomBuffer.vertex3d(d21 * (d17 + d9), d22, d20 * (d17 + d9));
                    geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                    if (bl2) {
                        geomBuffer.texCoord2d(d14, 1.0 - d15);
                    } else {
                        geomBuffer.texCoord2d(d14, d15);
                    }
                    geomBuffer.vertex3d(d21 * d17, d16, d20 * d17);
                    d14 += d13;
                }
            } else {
                d21 = Math.cos(-1.5707963267948966);
                d20 = Math.sin(-1.5707963267948966);
                d19 = Math.cos(d8 - 1.5707963267948966);
                d18 = Math.sin(d8 - 1.5707963267948966);
                geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14, 1.0 - (d15 + d6));
                } else {
                    geomBuffer.texCoord2d(d14, d15 + d6);
                }
                geomBuffer.vertex3d(d21 * (d17 + d9), d22, d20 * (d17 + d9));
                geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14, 1.0 - d15);
                } else {
                    geomBuffer.texCoord2d(d14, d15);
                }
                geomBuffer.vertex3d(d21 * d17, d16, d20 * d17);
                geomBuffer.normal3d(d19 * d7, d12 * d7, d18 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14 + d13, 1.0 - (d15 + d6));
                } else {
                    geomBuffer.texCoord2d(d14 + d13, d15 + d6);
                }
                geomBuffer.vertex3d(d19 * (d17 + d9), d22, d18 * (d17 + d9));
                geomBuffer.normal3d(d19 * d7, d12 * d7, d18 * d7);
                if (bl2) {
                    geomBuffer.texCoord2d(d14 + d13, 1.0 - d15);
                } else {
                    geomBuffer.texCoord2d(d14 + d13, d15);
                }
                geomBuffer.vertex3d(d19 * d17, d16, d18 * d17);
                d14 += d13 * 2.0;
                for (n4 = 2; n4 <= n2; ++n4) {
                    d21 = Math.cos((double)n4 * d8 - 1.5707963267948966);
                    d20 = Math.sin((double)n4 * d8 - 1.5707963267948966);
                    geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                    if (bl2) {
                        geomBuffer.texCoord2d(d14, 1.0 - (d15 + d6));
                    } else {
                        geomBuffer.texCoord2d(d14, d15 + d6);
                    }
                    geomBuffer.vertex3d(d21 * (d17 + d9), d22, d20 * (d17 + d9));
                    geomBuffer.normal3d(d21 * d7, d12 * d7, d20 * d7);
                    if (bl2) {
                        geomBuffer.texCoord2d(d14, 1.0 - d15);
                    } else {
                        geomBuffer.texCoord2d(d14, d15);
                    }
                    geomBuffer.vertex3d(d21 * d17, d16, d20 * d17);
                    d14 += d13;
                }
            }
            d14 = 0.0;
            d15 += d6;
            d16 += d11;
            d17 += d9;
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneTop(double d2, double d3, double d4, int n2, double d5, boolean bl, boolean bl2) {
        double d6 = bl ? 1.0 : -1.0;
        double d7 = Math.PI * 2 / (double)n2;
        double d8 = d3 / d4;
        double d9 = 1.0 / (double)n2;
        double d10 = d2 + d4;
        GeomBuffer geomBuffer = new GeomBuffer(n2 + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, d8 * d6, 0.0);
        if (bl2) {
            geomBuffer.texCoord2d(0.5, 0.0);
        } else {
            geomBuffer.texCoord2d(0.5, 1.0);
        }
        geomBuffer.vertex3d(0.0, d10, 0.0);
        double d11 = 0.0;
        if (bl) {
            for (int i2 = n2; i2 >= 0; --i2) {
                double d12 = Math.cos((double)i2 * d7 - 1.5707963267948966);
                double d13 = Math.sin((double)i2 * d7 - 1.5707963267948966);
                geomBuffer.normal3d(d12 * d6, d8 * d6, d13 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d11, 1.0 - d5);
                } else {
                    geomBuffer.texCoord2d(d11, d5);
                }
                geomBuffer.vertex3d(d12 * d3, d2, d13 * d3);
                d11 += d9;
            }
        } else {
            for (int i3 = 0; i3 <= n2; ++i3) {
                double d14 = Math.cos((double)i3 * d7 - 1.5707963267948966);
                double d15 = Math.sin((double)i3 * d7 - 1.5707963267948966);
                geomBuffer.normal3d(d14 * d6, d8 * d6, d15 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d11, 1.0 - d5);
                } else {
                    geomBuffer.texCoord2d(d11, d5);
                }
                geomBuffer.vertex3d(d14 * d3, d2, d15 * d3);
                d11 += d9;
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }
}

