/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.Bridge;
import com.sun.j3d.utils.geometry.Clean;
import com.sun.j3d.utils.geometry.Desperate;
import com.sun.j3d.utils.geometry.Distance;
import com.sun.j3d.utils.geometry.EarClip;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.HeapNode;
import com.sun.j3d.utils.geometry.Left;
import com.sun.j3d.utils.geometry.ListNode;
import com.sun.j3d.utils.geometry.NoHash;
import com.sun.j3d.utils.geometry.Orientation;
import com.sun.j3d.utils.geometry.PntNode;
import com.sun.j3d.utils.geometry.Project;
import com.sun.j3d.utils.geometry.Simple;
import com.sun.j3d.utils.geometry.Triangle;
import java.util.Random;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Triangulator {
    GeometryInfo gInfo = null;
    int[] faces = null;
    int[] loops = null;
    int[] chains = null;
    Point2f[] points = null;
    Triangle[] triangles = null;
    ListNode[] list = null;
    Random randomGen = null;
    int numPoints = 0;
    int maxNumPoints = 0;
    int numList = 0;
    int maxNumList = 0;
    int numLoops = 0;
    int maxNumLoops = 0;
    int numTriangles = 0;
    int maxNumTriangles = 0;
    int numFaces = 0;
    int numTexSets = 0;
    int firstNode = 0;
    int numChains = 0;
    int maxNumChains = 0;
    Point2f[] pUnsorted = null;
    int maxNumPUnsorted = 0;
    boolean noHashingEdges = false;
    boolean noHashingPnts = false;
    int loopMin;
    int loopMax;
    PntNode[] vtxList = null;
    int numVtxList = 0;
    int numReflex = 0;
    int reflexVertices;
    Distance[] distances = null;
    int maxNumDist = 0;
    Left[] leftMost = null;
    int maxNumLeftMost = 0;
    HeapNode[] heap = null;
    int numHeap = 0;
    int maxNumHeap = 0;
    int numZero = 0;
    int maxNumPolyArea = 0;
    double[] polyArea = null;
    int[] stripCounts = null;
    int[] vertexIndices = null;
    Point3f[] vertices = null;
    Object[] colors = null;
    Vector3f[] normals = null;
    boolean ccwLoop = true;
    boolean earsRandom = true;
    boolean earsSorted = true;
    int identCntr;
    double epsilon = 1.0E-12;
    static final double ZERO = 1.0E-8;
    static final int EARS_SEQUENCE = 0;
    static final int EARS_RANDOM = 1;
    static final int EARS_SORTED = 2;
    static final int INC_LIST_BK = 100;
    static final int INC_LOOP_BK = 20;
    static final int INC_TRI_BK = 50;
    static final int INC_POINT_BK = 100;
    static final int INC_DIST_BK = 50;
    private static final int DEBUG = 0;

    public Triangulator() {
        this.earsRandom = false;
        this.earsSorted = false;
    }

    public Triangulator(int n2) {
        switch (n2) {
            case 0: {
                this.earsRandom = false;
                this.earsSorted = false;
                break;
            }
            case 1: {
                this.randomGen = new Random();
                this.earsRandom = true;
                this.earsSorted = false;
                break;
            }
            case 2: {
                this.earsRandom = false;
                this.earsSorted = true;
                break;
            }
            default: {
                this.earsRandom = false;
                this.earsSorted = false;
            }
        }
    }

    public void triangulate(GeometryInfo geometryInfo) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        if (geometryInfo.getPrimitive() != 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("Triangulator0"));
        }
        geometryInfo.indexify();
        this.vertices = geometryInfo.getCoordinates();
        this.vertexIndices = (int[])(this.vertices != null ? geometryInfo.getCoordinateIndices() : null);
        this.colors = geometryInfo.getColors();
        this.normals = geometryInfo.getNormals();
        this.gInfo = geometryInfo;
        this.stripCounts = geometryInfo.getStripCounts();
        this.faces = geometryInfo.getContourCounts();
        if (this.faces == null) {
            if (this.stripCounts == null) {
                System.out.println("StripCounts is null! Don't know what to do.");
            }
            this.faces = new int[this.stripCounts.length];
            for (n4 = 0; n4 < this.stripCounts.length; ++n4) {
                this.faces[n4] = 1;
            }
        }
        this.numFaces = this.faces.length;
        this.numTexSets = this.gInfo.getTexCoordSetCount();
        this.maxNumLoops = 0;
        this.maxNumList = 0;
        this.maxNumPoints = 0;
        this.maxNumDist = 0;
        this.maxNumLeftMost = 0;
        this.maxNumPUnsorted = 0;
        for (n4 = 0; n4 < this.faces.length; ++n4) {
            this.maxNumLoops += this.faces[n4];
            n3 = 0;
            while (n3 < this.faces[n4]) {
                this.maxNumList += this.stripCounts[n5] + 1;
                ++n3;
                ++n5;
            }
        }
        this.maxNumList += 20;
        this.loops = new int[this.maxNumLoops];
        this.list = new ListNode[this.maxNumList];
        this.numVtxList = 0;
        this.numReflex = 0;
        this.numTriangles = 0;
        this.numChains = 0;
        this.numPoints = 0;
        this.numLoops = 0;
        this.numList = 0;
        n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < this.faces.length; ++n4) {
            n3 = 0;
            while (n3 < this.faces[n4]) {
                int n7 = this.makeLoopHeader();
                int n8 = this.loops[n7];
                for (int i2 = 0; i2 < this.stripCounts[n5]; ++i2) {
                    this.list[this.numList] = new ListNode(this.vertexIndices[n6]);
                    ++this.numList;
                    this.insertAfter(n8, n2);
                    this.list[n2].setCommonIndex(n6);
                    n8 = n2;
                    ++n6;
                }
                this.deleteHook(n7);
                ++n3;
                ++n5;
            }
        }
        this.maxNumTriangles = this.maxNumList / 2;
        this.triangles = new Triangle[this.maxNumTriangles];
        this.setEpsilon(1.0E-8);
        int n9 = 0;
        int n10 = 0;
        for (n3 = 0; n3 < this.numFaces; ++n3) {
            this.ccwLoop = true;
            blArray[0] = false;
            n10 = n9 + this.faces[n3];
            boolean bl3 = this.faces[n3] > 1 ? true : !Simple.simpleFace(this, this.loops[n9]);
            if (bl3) {
                int n11;
                for (n11 = 0; n11 < this.faces[n3]; ++n11) {
                    this.preProcessList(n9 + n11);
                }
                Project.projectFace(this, n9, n10);
                n11 = Clean.cleanPolyhedralFace(this, n9, n10);
                if (this.faces[n3] == 1) {
                    Orientation.determineOrientation(this, this.loops[n9]);
                } else {
                    Orientation.adjustOrientation(this, n9, n10);
                }
                if (this.faces[n3] > 1) {
                    NoHash.prepareNoHashEdges(this, n9, n10);
                } else {
                    this.noHashingEdges = false;
                    this.noHashingPnts = false;
                }
                for (n4 = n9; n4 < n10; ++n4) {
                    EarClip.classifyAngles(this, this.loops[n4]);
                }
                if (this.faces[n3] > 1) {
                    Bridge.constructBridges(this, n9, n10);
                }
                this.resetPolyList(this.loops[n9]);
                NoHash.prepareNoHashPnts(this, n9);
                EarClip.classifyEars(this, this.loops[n9]);
                blArray[0] = false;
                while (!blArray[0]) {
                    if (!EarClip.clipEar(this, blArray)) {
                        if (bl) {
                            n2 = this.getNode();
                            this.resetPolyList(n2);
                            this.loops[n9] = n2;
                            if (Desperate.desperate(this, n2, n9, blArray)) {
                                if (!Desperate.letsHope(this, n2)) {
                                    return;
                                }
                            } else {
                                bl = false;
                            }
                        } else {
                            bl2 = true;
                            n2 = this.getNode();
                            this.resetPolyList(n2);
                            EarClip.classifyEars(this, n2);
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    if (!blArray[0]) continue;
                    n2 = this.getNextChain(blArray2);
                    if (!blArray2[0]) continue;
                    this.resetPolyList(n2);
                    this.loops[n9] = n2;
                    this.noHashingPnts = false;
                    NoHash.prepareNoHashPnts(this, n9);
                    EarClip.classifyEars(this, n2);
                    bl = false;
                    blArray[0] = false;
                }
            }
            n9 = n10;
        }
        this.writeTriangleToGeomInfo();
    }

    void printVtxList() {
        System.out.println("numReflex " + this.numReflex + " reflexVertices " + this.reflexVertices);
        for (int i2 = 0; i2 < this.numVtxList; ++i2) {
            System.out.println(i2 + " pnt " + this.vtxList[i2].pnt + ", next " + this.vtxList[i2].next);
        }
    }

    void printListData() {
        for (int i2 = 0; i2 < this.numList; ++i2) {
            System.out.println("list[" + i2 + "].index " + this.list[i2].index + ", prev " + this.list[i2].prev + ", next " + this.list[i2].next + ", convex " + this.list[i2].convex + ", vertexIndex " + this.list[i2].vcntIndex);
        }
    }

    void preProcessList(int n2) {
        int n3;
        this.resetPolyList(this.loops[n2]);
        int n4 = n3 = this.loops[n2];
        int n5 = this.list[n4].next;
        while (n5 != n3) {
            if (this.list[n4].index == this.list[n5].index) {
                if (n5 == this.loops[n2]) {
                    this.loops[n2] = this.list[n5].next;
                }
                this.deleteLinks(n5);
            }
            n4 = this.list[n4].next;
            n5 = this.list[n4].next;
        }
    }

    void writeTriangleToGeomInfo() {
        int[] nArray;
        int[] nArray2;
        int n2;
        int n3;
        this.gInfo.setPrimitive(1);
        this.gInfo.setContourCounts(null);
        this.gInfo.forgetOldPrim();
        this.gInfo.setStripCounts(null);
        int n4 = 0;
        int[] nArray3 = new int[this.numTriangles * 3];
        for (n3 = 0; n3 < this.numTriangles; ++n3) {
            n2 = this.list[this.triangles[n3].v1].getCommonIndex();
            nArray3[n4++] = this.vertexIndices[n2];
            n2 = this.list[this.triangles[n3].v2].getCommonIndex();
            nArray3[n4++] = this.vertexIndices[n2];
            n2 = this.list[this.triangles[n3].v3].getCommonIndex();
            nArray3[n4++] = this.vertexIndices[n2];
        }
        this.gInfo.setCoordinateIndices(nArray3);
        if (this.normals != null) {
            nArray2 = this.gInfo.getNormalIndices();
            nArray = new int[this.numTriangles * 3];
            n4 = 0;
            for (n3 = 0; n3 < this.numTriangles; ++n3) {
                n2 = this.list[this.triangles[n3].v1].getCommonIndex();
                nArray[n4++] = nArray2[n2];
                n2 = this.list[this.triangles[n3].v2].getCommonIndex();
                nArray[n4++] = nArray2[n2];
                n2 = this.list[this.triangles[n3].v3].getCommonIndex();
                nArray[n4++] = nArray2[n2];
            }
            this.gInfo.setNormalIndices(nArray);
        }
        if (this.colors != null) {
            n4 = 0;
            nArray2 = this.gInfo.getColorIndices();
            nArray = new int[this.numTriangles * 3];
            for (n3 = 0; n3 < this.numTriangles; ++n3) {
                n2 = this.list[this.triangles[n3].v1].getCommonIndex();
                nArray[n4++] = nArray2[n2];
                n2 = this.list[this.triangles[n3].v2].getCommonIndex();
                nArray[n4++] = nArray2[n2];
                n2 = this.list[this.triangles[n3].v3].getCommonIndex();
                nArray[n4++] = nArray2[n2];
            }
            this.gInfo.setColorIndices(nArray);
        }
        for (int i2 = 0; i2 < this.numTexSets; ++i2) {
            nArray = new int[this.numTriangles * 3];
            int[] nArray4 = this.gInfo.getTextureCoordinateIndices(i2);
            n4 = 0;
            for (n3 = 0; n3 < this.numTriangles; ++n3) {
                n2 = this.list[this.triangles[n3].v1].getCommonIndex();
                nArray[n4++] = nArray4[n2];
                n2 = this.list[this.triangles[n3].v2].getCommonIndex();
                nArray[n4++] = nArray4[n2];
                n2 = this.list[this.triangles[n3].v3].getCommonIndex();
                nArray[n4++] = nArray4[n2];
            }
            this.gInfo.setTextureCoordinateIndices(i2, nArray);
        }
    }

    void setEpsilon(double d2) {
        this.epsilon = d2;
    }

    boolean inPolyList(int n2) {
        return n2 >= 0 && n2 < this.numList && this.numList <= this.maxNumList;
    }

    void updateIndex(int n2, int n3) {
        this.list[n2].index = n3;
    }

    int getAngle(int n2) {
        return this.list[n2].convex;
    }

    void setAngle(int n2, int n3) {
        this.list[n2].convex = n3;
    }

    void resetPolyList(int n2) {
        this.firstNode = n2;
    }

    int getNode() {
        return this.firstNode;
    }

    boolean inLoopList(int n2) {
        return n2 >= 0 && n2 < this.numLoops && this.numLoops <= this.maxNumLoops;
    }

    void deleteHook(int n2) {
        if (!this.inLoopList(n2)) {
            System.out.println("Triangulator:deleteHook : Loop access out of range.");
        }
        int n3 = this.loops[n2];
        int n4 = this.list[n3].next;
        if (this.inPolyList(n3) && this.inPolyList(n4)) {
            this.deleteLinks(n3);
            this.loops[n2] = n4;
        } else {
            System.out.println("Triangulator:deleteHook : List access out of range.");
        }
    }

    void deleteLinks(int n2) {
        if (this.inPolyList(n2) && this.inPolyList(this.list[n2].prev) && this.inPolyList(this.list[n2].next)) {
            if (this.firstNode == n2) {
                this.firstNode = this.list[n2].next;
            }
            this.list[this.list[n2].next].prev = this.list[n2].prev;
            this.list[this.list[n2].prev].next = this.list[n2].next;
            this.list[n2].prev = this.list[n2].next = n2;
        } else {
            System.out.println("Triangulator:deleteLinks : Access out of range.");
        }
    }

    void rotateLinks(int n2, int n3) {
        int n4 = this.list[n2].next;
        int n5 = this.list[n3].next;
        int n6 = this.list[n2].next;
        this.list[n2].next = this.list[n3].next;
        this.list[n3].next = n6;
        this.list[n4].prev = n3;
        this.list[n5].prev = n2;
    }

    void storeChain(int n2) {
        if (this.numChains >= this.maxNumChains) {
            this.maxNumChains += 20;
            int[] nArray = this.chains;
            this.chains = new int[this.maxNumChains];
            if (nArray != null) {
                System.arraycopy(nArray, 0, this.chains, 0, nArray.length);
            }
        }
        this.chains[this.numChains] = n2;
        ++this.numChains;
    }

    int getNextChain(boolean[] blArray) {
        if (this.numChains > 0) {
            blArray[0] = true;
            --this.numChains;
            return this.chains[this.numChains];
        }
        blArray[0] = false;
        this.numChains = 0;
        return 0;
    }

    void splitSplice(int n2, int n3, int n4, int n5) {
        this.list[n2].next = n5;
        this.list[n5].prev = n2;
        this.list[n3].prev = n4;
        this.list[n4].next = n3;
    }

    int makeHook() {
        int n2 = this.numList;
        if (this.numList >= this.maxNumList) {
            this.maxNumList += 100;
            ListNode[] listNodeArray = this.list;
            this.list = new ListNode[this.maxNumList];
            System.arraycopy(listNodeArray, 0, this.list, 0, listNodeArray.length);
        }
        this.list[this.numList] = new ListNode(-1);
        this.list[this.numList].prev = n2;
        this.list[this.numList].next = n2;
        this.list[this.numList].index = -1;
        ++this.numList;
        return n2;
    }

    int makeLoopHeader() {
        int n2 = this.makeHook();
        if (this.numLoops >= this.maxNumLoops) {
            this.maxNumLoops += 20;
            int[] nArray = this.loops;
            this.loops = new int[this.maxNumLoops];
            System.arraycopy(nArray, 0, this.loops, 0, nArray.length);
        }
        this.loops[this.numLoops] = n2;
        int n3 = this.numLoops++;
        return n3;
    }

    int makeNode(int n2) {
        if (this.numList >= this.maxNumList) {
            this.maxNumList += 100;
            ListNode[] listNodeArray = this.list;
            this.list = new ListNode[this.maxNumList];
            System.arraycopy(listNodeArray, 0, this.list, 0, listNodeArray.length);
        }
        this.list[this.numList] = new ListNode(n2);
        int n3 = this.numList;
        this.list[this.numList].index = n2;
        this.list[this.numList].prev = -1;
        this.list[this.numList].next = -1;
        ++this.numList;
        return n3;
    }

    void insertAfter(int n2, int n3) {
        if (this.inPolyList(n2) && this.inPolyList(n3)) {
            this.list[n3].next = this.list[n2].next;
            this.list[n3].prev = n2;
            this.list[n2].next = n3;
            int n4 = this.list[n3].next;
            if (this.inPolyList(n4)) {
                this.list[n4].prev = n3;
            } else {
                System.out.println("Triangulator:deleteHook : List access out of range.");
            }
            return;
        }
        System.out.println("Triangulator:deleteHook : List access out of range.");
    }

    int fetchNextData(int n2) {
        return this.list[n2].next;
    }

    int fetchData(int n2) {
        return this.list[n2].index;
    }

    int fetchPrevData(int n2) {
        return this.list[n2].prev;
    }

    void swapLinks(int n2) {
        int n3 = this.list[n2].next;
        this.list[n2].next = this.list[n2].prev;
        this.list[n2].prev = n3;
        int n4 = n3;
        while (n3 != n2) {
            n4 = this.list[n3].next;
            this.list[n3].next = this.list[n3].prev;
            this.list[n3].prev = n4;
            n3 = n4;
        }
    }

    void storeTriangle(int n2, int n3, int n4) {
        if (this.numTriangles >= this.maxNumTriangles) {
            this.maxNumTriangles += 50;
            Triangle[] triangleArray = this.triangles;
            this.triangles = new Triangle[this.maxNumTriangles];
            if (triangleArray != null) {
                System.arraycopy(triangleArray, 0, this.triangles, 0, triangleArray.length);
            }
        }
        this.triangles[this.numTriangles] = this.ccwLoop ? new Triangle(n2, n3, n4) : new Triangle(n3, n2, n4);
        ++this.numTriangles;
    }

    void initPnts(int n2) {
        if (this.maxNumPoints < n2) {
            this.maxNumPoints = n2;
            this.points = new Point2f[this.maxNumPoints];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.points[i2] = new Point2f(0.0f, 0.0f);
        }
        this.numPoints = 0;
    }

    boolean inPointsList(int n2) {
        return n2 >= 0 && n2 < this.numPoints && this.numPoints <= this.maxNumPoints;
    }

    int storePoint(double d2, double d3) {
        if (this.numPoints >= this.maxNumPoints) {
            this.maxNumPoints += 100;
            Point2f[] point2fArray = this.points;
            this.points = new Point2f[this.maxNumPoints];
            if (point2fArray != null) {
                System.arraycopy(point2fArray, 0, this.points, 0, point2fArray.length);
            }
        }
        this.points[this.numPoints] = new Point2f((float)d2, (float)d3);
        int n2 = this.numPoints++;
        return n2;
    }
}

