/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.compression.GeneralizedStripFlags;

class GeneralizedStrip {
    private static final boolean debug = false;
    private static final int CW = 0;
    private static final int CCW = 1;
    private static final int RESTART_CW = 0;
    private static final int RESTART_CCW = 1;
    private static final int REPLACE_MIDDLE = 2;
    private static final int REPLACE_OLDEST = 3;

    GeneralizedStrip() {
    }

    static StripArray[] toStripsAndFans(GeneralizedStripFlags generalizedStripFlags, int n2) {
        int n3 = generalizedStripFlags.getFlagCount();
        IntList intList = new IntList(n3 * 3);
        IntList intList2 = new IntList(n3 * 3);
        IntList intList3 = new IntList(n3);
        IntList intList4 = new IntList(n3);
        GeneralizedStrip.toStripsAndFans(generalizedStripFlags, n2, intList, intList3, intList2, intList4);
        StripArray[] stripArrayArray = new StripArray[2];
        if (intList3.count > 0) {
            stripArrayArray[0] = new StripArray(intList, intList3);
        }
        if (intList4.count > 0) {
            stripArrayArray[1] = new StripArray(intList2, intList4);
        }
        return stripArrayArray;
    }

    private static void toStripsAndFans(GeneralizedStripFlags generalizedStripFlags, int n2, IntList intList, IntList intList2, IntList intList3, IntList intList4) {
        boolean bl = false;
        int n3 = 0;
        int n4 = 3;
        int n5 = generalizedStripFlags.getFlag(0);
        int n6 = n5 == 0 ? 0 : 1;
        int n7 = 3;
        int n8 = generalizedStripFlags.getFlagCount();
        if (n7 < n8) {
            n5 = generalizedStripFlags.getFlag(n7);
        }
        while (n7 < n8) {
            int n9 = generalizedStripFlags.getFlag(n7);
            if (n9 == n5 && n9 != 0 && n9 != 1) {
                ++n4;
                ++n7;
                continue;
            }
            if (n5 == 2) {
                GeneralizedStrip.addFan(intList3, intList4, n3, n4, n2, n6, bl);
            } else {
                GeneralizedStrip.addStrip(intList, intList2, n3, n4, n2, n6);
            }
            if (n9 == 0 || n9 == 1) {
                n6 = n9 == 0 ? 0 : 1;
                n3 = n7;
                n4 = 3;
                bl = false;
                if ((n7 += 3) >= n8) continue;
                n5 = generalizedStripFlags.getFlag(n7);
                continue;
            }
            if (n9 == 3) {
                n6 = n6 == 0 ? 1 : 0;
                n3 = n7 - 2;
                n4 = 3;
            } else {
                if ((n4 & 1) == 0) {
                    n6 = n6 == 0 ? 1 : 0;
                }
                n3 = n7 - 3;
                n4 = 4;
            }
            ++n7;
            bl = true;
            n5 = n9;
        }
        if (n7 == n8) {
            if (n5 == 2) {
                GeneralizedStrip.addFan(intList3, intList4, n3, n4, n2, n6, bl);
            } else {
                GeneralizedStrip.addStrip(intList, intList2, n3, n4, n2, n6);
            }
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeneralizedStrip0"));
        }
    }

    private static void addStrip(IntList intList, IntList intList2, int n2, int n3, int n4, int n5) {
        block4: {
            int n6;
            block6: {
                block5: {
                    block3: {
                        n6 = n2;
                        if (n5 != n4) break block3;
                        intList2.add(n3);
                        while (n6 < n2 + n3) {
                            intList.add(n6++);
                        }
                        break block4;
                    }
                    if ((n3 & 1) != 1) break block5;
                    intList2.add(n3);
                    n6 += n3 - 1;
                    while (n6 >= n2) {
                        intList.add(n6--);
                    }
                    break block4;
                }
                if (n3 != 4) break block6;
                intList2.add(4);
                intList.add(n6);
                intList.add(n6 + 2);
                intList.add(n6 + 1);
                intList.add(n6 + 3);
                break block4;
            }
            intList2.add(3);
            intList.add(n6);
            intList.add(n6 + 2);
            intList.add(n6 + 1);
            if (n3 <= 3) break block4;
            ++n6;
            intList2.add(n3 - 1);
            while (n6 < n2 + n3) {
                intList.add(n6++);
            }
        }
    }

    private static void addFan(IntList intList, IntList intList2, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = n2;
        intList.add(n6++);
        if (n5 == n4) {
            if (bl) {
                intList2.add(n3 - 1);
                ++n6;
            } else {
                intList2.add(n3);
                intList.add(n6++);
            }
            while (n6 < n2 + n3) {
                intList.add(n6++);
            }
        } else {
            n6 += n3 - 2;
            while (n6 > n2 + 1) {
                intList.add(n6--);
            }
            if (bl) {
                intList2.add(n3 - 1);
            } else {
                intList2.add(n3);
                intList.add(n6);
            }
        }
    }

    static StripArray toTriangleStrips(GeneralizedStripFlags generalizedStripFlags, int n2) {
        int n3 = generalizedStripFlags.getFlagCount();
        IntList intList = new IntList(n3 * 3);
        IntList intList2 = new IntList(n3 * 3);
        IntList intList3 = new IntList(n3);
        IntList intList4 = new IntList(n3);
        GeneralizedStrip.toStripsAndFans(generalizedStripFlags, n2, intList, intList3, intList2, intList4);
        if (intList4.count == 0) {
            if (intList3.count > 0) {
                return new StripArray(intList, intList3);
            }
            return null;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < intList4.count; ++i2) {
            GeneralizedStrip.fanToStrips(n4, intList4.ints[i2], intList2.ints, intList, intList3, false);
            n4 += intList4.ints[i2];
        }
        StripArray stripArray = new StripArray(intList, intList3);
        return stripArray;
    }

    private static void fanToStrips(int n2, int n3, int[] nArray, IntList intList, IntList intList2, boolean bl) {
        if (bl) {
            intList2.add(n3);
            intList.add(nArray[n2]);
            int n4 = n2 + 1;
            int n5 = n2 + (n3 - 1);
            while (n4 <= n5) {
                intList.add(nArray[n4++]);
                if (n4 <= n5) {
                    intList.add(nArray[n5--]);
                    continue;
                }
                break;
            }
        } else {
            int n6 = n2++;
            while (n2 + 4 <= n6 + n3) {
                intList.add(nArray[n2]);
                intList.add(nArray[n2 + 1]);
                intList.add(nArray[n6]);
                intList.add(nArray[n2 + 2]);
                intList.add(nArray[n2 + 3]);
                intList2.add(5);
                n2 += 3;
            }
            if (n2 + 1 < n6 + n3) {
                intList.add(nArray[n2]);
                intList.add(nArray[n2 + 1]);
                intList.add(nArray[n6]);
                if (++n2 + 1 < n6 + n3) {
                    intList.add(nArray[n2 + 1]);
                    intList2.add(4);
                } else {
                    intList2.add(3);
                }
            }
        }
    }

    static int[] toTriangles(GeneralizedStripFlags generalizedStripFlags, int n2) {
        int n3 = 0;
        StripArray[] stripArrayArray = GeneralizedStrip.toStripsAndFans(generalizedStripFlags, n2);
        if (stripArrayArray[0] != null) {
            n3 = 3 * GeneralizedStrip.getTriangleCount(stripArrayArray[0].stripCounts);
        }
        if (stripArrayArray[1] != null) {
            n3 += 3 * GeneralizedStrip.getTriangleCount(stripArrayArray[1].stripCounts);
        }
        int n4 = 0;
        int[] nArray = new int[n3];
        if (stripArrayArray[0] != null) {
            n4 = GeneralizedStrip.stripsToTriangles(n4, nArray, 0, stripArrayArray[0].vertices.ints, 0, stripArrayArray[0].stripCounts.ints, stripArrayArray[0].stripCounts.count);
        }
        if (stripArrayArray[1] != null) {
            n4 = GeneralizedStrip.fansToTriangles(n4, nArray, 0, stripArrayArray[1].vertices.ints, 0, stripArrayArray[1].stripCounts.ints, stripArrayArray[1].stripCounts.count);
        }
        return nArray;
    }

    private static int stripsToTriangles(int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        int n6 = n2;
        int n7 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < nArray3[i2 + n4] - 2; ++i3) {
                if ((i3 & 1) == 0) {
                    nArray[n6 * 3 + 0] = nArray2[n7 + 0];
                    nArray[n6 * 3 + 1] = nArray2[n7 + 1];
                    nArray[n6 * 3 + 2] = nArray2[n7 + 2];
                } else {
                    nArray[n6 * 3 + 0] = nArray2[n7 + 1];
                    nArray[n6 * 3 + 1] = nArray2[n7 + 0];
                    nArray[n6 * 3 + 2] = nArray2[n7 + 2];
                }
                ++n6;
                ++n7;
            }
            n7 += 2;
        }
        return n6;
    }

    private static int fansToTriangles(int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        int n6 = n2;
        int n7 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < nArray3[i2 + n4] - 2; ++i3) {
                nArray[n6 * 3 + 0] = nArray2[n7];
                nArray[n6 * 3 + 1] = nArray2[n7 + i3 + 1];
                nArray[n6 * 3 + 2] = nArray2[n7 + i3 + 2];
                ++n6;
            }
            n7 += nArray3[i2 + n4];
        }
        return n6;
    }

    static StripArray[] toStripsAndTriangles(GeneralizedStripFlags generalizedStripFlags, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        StripArray[] stripArrayArray = new StripArray[2];
        StripArray stripArray = GeneralizedStrip.toTriangleStrips(generalizedStripFlags, n2);
        for (n5 = 0; n5 < stripArray.stripCounts.count; ++n5) {
            if (stripArray.stripCounts.ints[n5] <= n3) {
                ++n8;
                n9 += stripArray.stripCounts.ints[n5] - 2;
                continue;
            }
            ++n6;
            n7 += stripArray.stripCounts.ints[n5];
        }
        if (n8 <= n4) {
            stripArrayArray[0] = stripArray;
            stripArrayArray[1] = null;
        } else {
            n5 = 0;
            int[] nArray = new int[n7];
            int n10 = 0;
            int[] nArray2 = new int[n6];
            int n11 = 0;
            int[] nArray3 = new int[3 * n9];
            int n12 = 0;
            for (int i2 = 0; i2 < stripArray.stripCounts.count; ++i2) {
                if (stripArray.stripCounts.ints[i2] <= n3) {
                    n11 = GeneralizedStrip.stripsToTriangles(n11, nArray3, n12, stripArray.vertices.ints, i2, stripArray.stripCounts.ints, 1);
                    n12 += stripArray.stripCounts.ints[i2];
                    continue;
                }
                nArray2[n10++] = stripArray.stripCounts.ints[i2];
                for (int i3 = 0; i3 < stripArray.stripCounts.ints[i2]; ++i3) {
                    nArray[n5++] = stripArray.vertices.ints[n12++];
                }
            }
            stripArrayArray[0] = n6 > 0 ? new StripArray(new IntList(nArray), new IntList(nArray2)) : null;
            stripArrayArray[1] = new StripArray(new IntList(nArray3), null);
        }
        return stripArrayArray;
    }

    static StripArray toLineStrips(GeneralizedStripFlags generalizedStripFlags) {
        int n2;
        int n3 = 0;
        int n4 = 2;
        int n5 = generalizedStripFlags.getFlagCount();
        IntList intList = new IntList(n5 * 2);
        IntList intList2 = new IntList(n5);
        int n6 = 2;
        while (n6 < n5) {
            int n7 = generalizedStripFlags.getFlag(n6);
            if (n7 != 0 && n7 != 1) {
                ++n4;
                ++n6;
                continue;
            }
            intList2.add(n4);
            for (n2 = n3; n2 < n3 + n4; ++n2) {
                intList.add(n2);
            }
            n3 = n6;
            n4 = 2;
            n6 += 2;
        }
        if (n6 == n5) {
            intList2.add(n4);
            for (n2 = n3; n2 < n3 + n4; ++n2) {
                intList.add(n2);
            }
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeneralizedStrip0"));
        }
        if (intList2.count > 0) {
            return new StripArray(intList, intList2);
        }
        return null;
    }

    static int getLineCount(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += nArray[i2] - 1;
        }
        return n2;
    }

    static int getTriangleCount(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += nArray[i2] - 2;
        }
        return n2;
    }

    static int getTriangleCount(IntList intList) {
        int n2 = 0;
        for (int i2 = 0; i2 < intList.count; ++i2) {
            n2 += intList.ints[i2] - 2;
        }
        return n2;
    }

    static int[] stripsToTriangles(int[] nArray) {
        int n2 = GeneralizedStrip.getTriangleCount(nArray);
        int[] nArray2 = new int[3 * n2];
        IntList intList = new IntList(n2 + 2 * nArray.length);
        intList.fillAscending();
        GeneralizedStrip.stripsToTriangles(0, nArray2, 0, intList.ints, 0, nArray, nArray.length);
        return nArray2;
    }

    static int[] fansToTriangles(int[] nArray) {
        int n2 = GeneralizedStrip.getTriangleCount(nArray);
        int[] nArray2 = new int[3 * n2];
        IntList intList = new IntList(n2 + 2 * nArray.length);
        intList.fillAscending();
        GeneralizedStrip.fansToTriangles(0, nArray2, 0, intList.ints, 0, nArray, nArray.length);
        return nArray2;
    }

    static StripArray fanToStrips(int n2, int n3, int[] nArray, boolean bl) {
        IntList intList = new IntList(n3 * 3);
        IntList intList2 = new IntList(n3);
        GeneralizedStrip.fanToStrips(n2, n3, nArray, intList, intList2, bl);
        return new StripArray(intList, intList2);
    }

    static class IntList {
        int[] ints;
        int count;

        IntList(int n2) {
            this.ints = new int[n2];
            this.count = 0;
        }

        IntList(int[] nArray) {
            this.ints = nArray;
            this.count = nArray.length;
        }

        void add(int n2) {
            if (this.count == this.ints.length) {
                int[] nArray = new int[2 * this.count];
                System.arraycopy(this.ints, 0, nArray, 0, this.count);
                this.ints = nArray;
            }
            this.ints[this.count++] = n2;
        }

        int[] trim() {
            if (this.count != this.ints.length) {
                int[] nArray = new int[this.count];
                System.arraycopy(this.ints, 0, nArray, 0, this.count);
                this.ints = nArray;
            }
            return this.ints;
        }

        void fillAscending() {
            for (int i2 = 0; i2 < this.ints.length; ++i2) {
                this.ints[i2] = i2;
            }
            this.count = this.ints.length;
        }

        public String toString() {
            String string = new String("[");
            for (int i2 = 0; i2 < this.count - 1; ++i2) {
                string = string + Integer.toString(this.ints[i2]) + ", ";
            }
            return string + Integer.toString(this.ints[this.count - 1]) + "]";
        }
    }

    static class StripArray {
        IntList vertices;
        IntList stripCounts;

        StripArray(IntList intList, IntList intList2) {
            this.vertices = intList;
            this.stripCounts = intList2;
        }
    }
}

