/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.SceneGraphObject;

public class SymbolTableData {
    public int nodeID;
    public SceneGraphObjectState nodeState;
    public SceneGraphObject j3dNode;
    public int referenceCount;
    public long filePosition;
    public boolean isNodeComponent;
    public int branchGraphID;
    public long branchGraphFilePointer;
    public boolean graphBuilt = false;

    public SymbolTableData(int n2, SceneGraphObject sceneGraphObject, SceneGraphObjectState sceneGraphObjectState, int n3) {
        this.nodeID = n2;
        this.j3dNode = sceneGraphObject;
        this.nodeState = sceneGraphObjectState;
        this.branchGraphID = n3;
        this.referenceCount = 1;
        this.isNodeComponent = false;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nodeID);
        dataOutput.writeInt(this.referenceCount);
        dataOutput.writeLong(this.filePosition);
        dataOutput.writeBoolean(this.isNodeComponent);
        dataOutput.writeInt(this.branchGraphID);
        dataOutput.writeLong(this.branchGraphFilePointer);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.nodeID = dataInput.readInt();
        this.referenceCount = dataInput.readInt();
        this.filePosition = dataInput.readLong();
        this.isNodeComponent = dataInput.readBoolean();
        this.branchGraphID = dataInput.readInt();
        this.branchGraphFilePointer = dataInput.readLong();
    }

    public final int getNodeID() {
        return this.nodeID;
    }

    public final SceneGraphObjectState getNodeState() {
        return this.nodeState;
    }

    public final void setNodeState(SceneGraphObjectState sceneGraphObjectState) {
        this.nodeState = sceneGraphObjectState;
    }

    public final SceneGraphObject getJ3dNode() {
        return this.j3dNode;
    }

    public final long getFilePosition() {
        return this.filePosition;
    }

    public final int getReferenceCount() {
        return this.referenceCount;
    }

    public final void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public final boolean isNodeComponent() {
        return this.isNodeComponent;
    }

    public String toString() {
        return new String(this.nodeID + " " + this.filePosition + "  " + this.j3dNode);
    }
}

