/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public class BackgroundState
extends LeafState {
    private int image;
    private int boundingLeaf;
    private int geometry;

    public BackgroundState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.boundingLeaf = controller.getSymbolTable().addReference(((Background)this.node).getApplicationBoundingLeaf());
            this.geometry = controller.getSymbolTable().addReference(((Background)this.node).getGeometry());
            this.image = controller.getSymbolTable().addReference(((Background)this.node).getImage());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.boundingLeaf);
        dataOutput.writeInt(this.geometry);
        dataOutput.writeInt(this.image);
        this.control.writeBounds(dataOutput, ((Background)this.node).getApplicationBounds());
        Color3f color3f = new Color3f();
        ((Background)this.node).getColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
        dataOutput.writeInt(((Background)this.node).getImageScaleMode());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.boundingLeaf = dataInput.readInt();
        this.geometry = dataInput.readInt();
        this.image = dataInput.readInt();
        ((Background)this.node).setApplicationBounds(this.control.readBounds(dataInput));
        ((Background)this.node).setColor(this.control.readColor3f(dataInput));
        ((Background)this.node).setImageScaleMode(dataInput.readInt());
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.image);
    }

    public void buildGraph() {
        ((Background)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Background)this.node).setGeometry((BranchGroup)this.control.getSymbolTable().getJ3dNode(this.geometry));
        ((Background)this.node).setImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.image));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Background();
    }
}

