/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.TextureState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Texture2D;

public class Texture2DState
extends TextureState {
    private int detailImage = 0;

    public Texture2DState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            Texture2D texture2D = (Texture2D)this.node;
            this.detailImage = controller.getSymbolTable().addReference(texture2D.getDetailImage());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.detailImage);
        dataOutput.writeInt(((Texture2D)this.node).getDetailTextureMode());
        dataOutput.writeInt(((Texture2D)this.node).getDetailTextureLevel());
        int n2 = ((Texture2D)this.node).getDetailTextureFuncPointsCount();
        dataOutput.writeInt(n2);
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        ((Texture2D)this.node).getDetailTextureFunc(fArray, fArray2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeFloat(fArray[i2]);
            dataOutput.writeFloat(fArray2[i2]);
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.detailImage = dataInput.readInt();
        ((Texture2D)this.node).setDetailTextureMode(dataInput.readInt());
        ((Texture2D)this.node).setDetailTextureLevel(dataInput.readInt());
        int n2 = dataInput.readInt();
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = dataInput.readFloat();
            fArray2[i2] = dataInput.readFloat();
        }
        ((Texture2D)this.node).setDetailTextureFunc(fArray, fArray2);
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.detailImage);
    }

    public void buildGraph() {
        Texture2D texture2D = (Texture2D)this.node;
        texture2D.setDetailImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.detailImage));
        super.buildGraph();
    }

    public SceneGraphObject createNode(Class clazz) {
        return this.createNode(clazz, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.mipMapMode), new Integer(this.format), new Integer(this.width), new Integer(this.height), new Integer(this.boundaryWidth)});
    }

    protected SceneGraphObject createNode() {
        return new Texture2D(this.mipMapMode, this.format, this.width, this.height, this.boundaryWidth);
    }
}

