/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureCubeMap;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;

public abstract class TextureState
extends NodeComponentState {
    private int[] imageComponents;
    protected int width;
    protected int height;
    protected int format;
    protected int mipMapMode;
    protected int boundaryWidth;

    public TextureState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null && !(this.node instanceof TextureCubeMap)) {
            ImageComponent[] imageComponentArray = ((Texture)this.node).getImages();
            this.imageComponents = new int[imageComponentArray.length];
            for (int i2 = 0; i2 < imageComponentArray.length; ++i2) {
                this.imageComponents[i2] = controller.getSymbolTable().addReference(imageComponentArray[i2]);
            }
        }
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeInt(((Texture)this.node).getMipMapMode());
        dataOutput.writeInt(((Texture)this.node).getWidth());
        dataOutput.writeInt(((Texture)this.node).getHeight());
        dataOutput.writeInt(((Texture)this.node).getFormat());
        dataOutput.writeInt(((Texture)this.node).getBoundaryWidth());
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.mipMapMode = dataInput.readInt();
        this.width = dataInput.readInt();
        this.height = dataInput.readInt();
        this.format = dataInput.readInt();
        this.boundaryWidth = dataInput.readInt();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        float[] fArray;
        super.writeObject(dataOutput);
        Texture texture = (Texture)this.node;
        Color4f color4f = new Color4f();
        texture.getBoundaryColor(color4f);
        this.control.writeColor4f(dataOutput, color4f);
        dataOutput.writeInt(texture.getBoundaryModeS());
        dataOutput.writeInt(texture.getBoundaryModeT());
        dataOutput.writeBoolean(texture.getEnable());
        dataOutput.writeInt(this.imageComponents.length);
        for (int i2 = 0; i2 < this.imageComponents.length; ++i2) {
            dataOutput.writeInt(this.imageComponents[i2]);
        }
        dataOutput.writeInt(texture.getMagFilter());
        dataOutput.writeInt(texture.getMinFilter());
        dataOutput.writeInt(texture.getBaseLevel());
        dataOutput.writeInt(texture.getMaximumLevel());
        dataOutput.writeFloat(texture.getMinimumLOD());
        dataOutput.writeFloat(texture.getMaximumLOD());
        Point3f point3f = new Point3f();
        texture.getLodOffset(point3f);
        this.control.writePoint3f(dataOutput, point3f);
        dataOutput.writeInt(texture.getAnisotropicFilterMode());
        dataOutput.writeFloat(texture.getAnisotropicFilterDegree());
        int n2 = texture.getSharpenTextureFuncPointsCount();
        dataOutput.writeInt(n2);
        if (n2 > 0) {
            fArray = new float[n2];
            float[] fArray2 = new float[n2];
            texture.getSharpenTextureFunc(fArray, fArray2);
            for (int i3 = 0; i3 < n2; ++i3) {
                dataOutput.writeFloat(fArray[i3]);
                dataOutput.writeFloat(fArray2[i3]);
            }
        }
        n2 = texture.getFilter4FuncPointsCount();
        dataOutput.writeInt(n2);
        if (n2 >= 4) {
            fArray = new float[n2];
            texture.getFilter4Func(fArray);
            for (int i4 = 0; i4 < n2; ++i4) {
                dataOutput.writeFloat(fArray[i4]);
            }
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        float[] fArray;
        int n2;
        super.readObject(dataInput);
        Texture texture = (Texture)this.node;
        texture.setBoundaryColor(this.control.readColor4f(dataInput));
        texture.setBoundaryModeS(dataInput.readInt());
        texture.setBoundaryModeT(dataInput.readInt());
        texture.setEnable(dataInput.readBoolean());
        this.imageComponents = new int[dataInput.readInt()];
        for (n2 = 0; n2 < this.imageComponents.length; ++n2) {
            this.imageComponents[n2] = dataInput.readInt();
        }
        n2 = dataInput.readInt();
        try {
            texture.setMagFilter(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (n2 == 5) {
                texture.setMagFilter(3);
            }
            if (n2 == 4) {
                texture.setMagFilter(2);
            }
            texture.setMagFilter(0);
        }
        texture.setMinFilter(dataInput.readInt());
        texture.setBaseLevel(dataInput.readInt());
        texture.setMaximumLevel(dataInput.readInt());
        texture.setMinimumLOD(dataInput.readFloat());
        texture.setMaximumLOD(dataInput.readFloat());
        texture.setLodOffset(this.control.readPoint3f(dataInput));
        texture.setAnisotropicFilterMode(dataInput.readInt());
        texture.setAnisotropicFilterDegree(dataInput.readFloat());
        int n3 = dataInput.readInt();
        if (n3 > 0) {
            fArray = new float[n3];
            float[] fArray2 = new float[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                fArray[i2] = dataInput.readFloat();
                fArray2[i2] = dataInput.readFloat();
            }
            texture.setSharpenTextureFunc(fArray, fArray2);
        }
        if ((n3 = dataInput.readInt()) >= 4) {
            fArray = new float[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                fArray[i3] = dataInput.readFloat();
            }
            texture.setFilter4Func(fArray);
        }
    }

    public void addSubReference() {
        if (!(this.node instanceof TextureCubeMap)) {
            for (int i2 = 0; i2 < this.imageComponents.length; ++i2) {
                this.control.getSymbolTable().incNodeComponentRefCount(this.imageComponents[i2]);
            }
        }
    }

    public void buildGraph() {
        if (!(this.node instanceof TextureCubeMap)) {
            for (int i2 = 0; i2 < this.imageComponents.length; ++i2) {
                ((Texture)this.node).setImage(i2, (ImageComponent)this.control.getSymbolTable().getJ3dNode(this.imageComponents[i2]));
            }
        }
        super.buildGraph();
    }
}

