/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigContainer;
import com.sun.j3d.utils.universe.ConfigViewPlatform;
import com.sun.j3d.utils.universe.LocaleFactory;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.HiResCoord;

public class ConfiguredUniverse
extends SimpleUniverse {
    private ConfigContainer configContainer = null;

    public ConfiguredUniverse() {
    }

    public ConfiguredUniverse(int n2) {
        super(n2);
    }

    public ConfiguredUniverse(Canvas3D canvas3D) {
        super(canvas3D);
    }

    public ConfiguredUniverse(Canvas3D canvas3D, int n2) {
        super(canvas3D, n2);
    }

    public ConfiguredUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        super(viewingPlatform, viewer, null);
    }

    public ConfiguredUniverse(ViewingPlatform viewingPlatform, Viewer viewer, LocaleFactory localeFactory) {
        super(viewingPlatform, viewer, localeFactory);
    }

    public ConfiguredUniverse(Canvas3D[] canvas3DArray) {
        this(1, canvas3DArray, null, null, null, true);
    }

    public ConfiguredUniverse(Canvas3D[] canvas3DArray, int n2) {
        this(n2, canvas3DArray, null, null, null, true);
    }

    public ConfiguredUniverse(Canvas3D[] canvas3DArray, int n2, LocaleFactory localeFactory) {
        this(n2, canvas3DArray, null, localeFactory, null, true);
    }

    public ConfiguredUniverse(URL uRL) {
        this(1, null, uRL, null, null, true);
    }

    public ConfiguredUniverse(URL uRL, int n2) {
        this(n2, null, uRL, null, null, true);
    }

    public ConfiguredUniverse(URL uRL, int n2, boolean bl) {
        this(n2, null, uRL, null, null, bl);
    }

    public ConfiguredUniverse(URL uRL, LocaleFactory localeFactory) {
        this(1, null, uRL, localeFactory, null, true);
    }

    public ConfiguredUniverse(URL uRL, LocaleFactory localeFactory, boolean bl) {
        this(1, null, uRL, localeFactory, null, bl);
    }

    public ConfiguredUniverse(URL uRL, LocaleFactory localeFactory, HiResCoord hiResCoord, int n2, boolean bl) {
        this(n2, null, uRL, localeFactory, hiResCoord, bl);
    }

    public ConfiguredUniverse(ConfigContainer configContainer) {
        this(configContainer, null, null);
    }

    public ConfiguredUniverse(ConfigContainer configContainer, LocaleFactory localeFactory, HiResCoord hiResCoord) {
        super(hiResCoord, localeFactory);
        this.configContainer = configContainer;
        Set set = this.configContainer.getViewers();
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("no views defined in configuration file");
        }
        this.viewer = set.toArray(new Viewer[1]);
        set = this.configContainer.getViewingPlatforms();
        if (set == null || set.size() == 0) {
            this.createDefaultViewingPlatform(this.configContainer.getViewPlatformTransformCount());
        } else {
            for (ViewingPlatform viewingPlatform : set) {
                viewingPlatform.setUniverse(this);
                this.locale.addBranchGraph(viewingPlatform);
            }
        }
    }

    ConfiguredUniverse(int n2, Canvas3D[] canvas3DArray, URL uRL, LocaleFactory localeFactory, HiResCoord hiResCoord, boolean bl) {
        super(hiResCoord, localeFactory);
        if (uRL == null) {
            this.viewer = new Viewer[1];
            this.viewer[0] = new Viewer(canvas3DArray, null, null, bl);
            this.createDefaultViewingPlatform(n2);
        } else {
            this.configContainer = new ConfigContainer(uRL, bl, n2, false);
            Collection collection = this.configContainer.getViewers();
            if (collection == null || collection.size() == 0) {
                throw new IllegalArgumentException("no views defined in configuration file");
            }
            this.viewer = collection.toArray(new Viewer[1]);
            collection = this.configContainer.findConfigObjects("ViewPlatform");
            if (collection == null || collection.size() == 0) {
                this.createDefaultViewingPlatform(n2);
            } else {
                for (ConfigViewPlatform configViewPlatform : collection) {
                    ViewingPlatform viewingPlatform = configViewPlatform.viewingPlatform;
                    if (viewingPlatform.getViewers() == null && this.viewer.length == 1 && collection.size() == 1) {
                        if (configViewPlatform.viewAttachPolicy == -1) {
                            this.setDerivedAttachPolicy(this.viewer[0], viewingPlatform);
                        }
                        this.viewer[0].setViewingPlatform(viewingPlatform);
                    }
                    viewingPlatform.setUniverse(this);
                    this.locale.addBranchGraph(viewingPlatform);
                    configViewPlatform.processBehavior();
                }
            }
        }
    }

    private void createDefaultViewingPlatform(int n2) {
        ViewingPlatform viewingPlatform = new ViewingPlatform(n2);
        this.setDerivedAttachPolicy(this.viewer[0], viewingPlatform);
        this.viewer[0].setViewingPlatform(viewingPlatform);
        viewingPlatform.setUniverse(this);
        this.locale.addBranchGraph(viewingPlatform);
    }

    private void setDerivedAttachPolicy(Viewer viewer, ViewingPlatform viewingPlatform) {
        if (viewer.getView().getWindowEyepointPolicy() != 2) {
            viewingPlatform.getViewPlatform().setViewAttachPolicy(2);
        }
    }

    public Viewer getViewer(int n2) {
        return this.viewer[n2];
    }

    public Viewer[] getViewers() {
        Viewer[] viewerArray = new Viewer[this.viewer.length];
        for (int i2 = 0; i2 < this.viewer.length; ++i2) {
            viewerArray[i2] = this.viewer[i2];
        }
        return viewerArray;
    }

    public void setVisible(boolean bl) {
        for (int i2 = 0; i2 < this.viewer.length; ++i2) {
            if (this.viewer[i2] == null) continue;
            this.viewer[i2].setVisible(bl);
        }
    }

    public static URL getConfigURL() {
        return ConfigContainer.getConfigURL(null);
    }

    public static URL getConfigURL(String string) {
        return ConfigContainer.getConfigURL(string);
    }

    public Map getNamedSensors() {
        if (this.configContainer == null) {
            return null;
        }
        return this.configContainer.getNamedSensors();
    }

    public Map getNamedBehaviors() {
        if (this.configContainer == null) {
            return null;
        }
        return this.configContainer.getNamedViewPlatformBehaviors();
    }

    public ConfigContainer getConfigContainer() {
        return this.configContainer;
    }

    public void cleanup() {
        if (this.viewer != null) {
            for (int i2 = 0; i2 < this.viewer.length; ++i2) {
                this.viewer[i2].getView().removeAllCanvas3Ds();
                this.viewer[i2].setViewingPlatform(null);
                this.viewer[i2] = null;
            }
        }
        this.locale = null;
        this.removeAllLocales();
        Viewer.clearViewerMap();
        this.configContainer.clear();
        this.configContainer = null;
    }
}

