/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.universe.LocaleFactory;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.Locale;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

public class SimpleUniverse
extends VirtualUniverse {
    protected Locale locale;
    protected Viewer[] viewer = null;

    public SimpleUniverse() {
        this(null, 1, null, null);
    }

    public SimpleUniverse(int n2) {
        this(null, n2, null, null);
    }

    public SimpleUniverse(Canvas3D canvas3D) {
        this(null, 1, canvas3D, null);
    }

    public SimpleUniverse(Canvas3D canvas3D, int n2) {
        this(null, n2, canvas3D, null);
    }

    public SimpleUniverse(Canvas3D canvas3D, int n2, LocaleFactory localeFactory) {
        this(null, n2, canvas3D, null, localeFactory);
    }

    public SimpleUniverse(HiResCoord hiResCoord, int n2, Canvas3D canvas3D, URL uRL) {
        this(hiResCoord, n2, canvas3D, uRL, null);
    }

    public SimpleUniverse(HiResCoord hiResCoord, int n2, Canvas3D canvas3D, URL uRL, LocaleFactory localeFactory) {
        this.createLocale(hiResCoord, localeFactory);
        ViewingPlatform viewingPlatform = new ViewingPlatform(n2);
        viewingPlatform.setUniverse(this);
        this.viewer = new Viewer[1];
        this.viewer[0] = new Viewer(canvas3D);
        this.viewer[0].setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph(viewingPlatform);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        this(viewingPlatform, viewer, null);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer, LocaleFactory localeFactory) {
        this.createLocale(null, localeFactory);
        viewingPlatform.setUniverse(this);
        this.viewer = new Viewer[1];
        this.viewer[0] = viewer;
        this.viewer[0].setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph(viewingPlatform);
    }

    SimpleUniverse(HiResCoord hiResCoord, LocaleFactory localeFactory) {
        this.createLocale(hiResCoord, localeFactory);
    }

    private void createLocale(HiResCoord hiResCoord, LocaleFactory localeFactory) {
        this.locale = localeFactory != null ? (hiResCoord != null ? localeFactory.createLocale(this, hiResCoord) : localeFactory.createLocale(this)) : (hiResCoord != null ? new Locale(this, hiResCoord) : new Locale(this));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Viewer getViewer() {
        return this.viewer[0];
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewer[0].getViewingPlatform();
    }

    public Canvas3D getCanvas() {
        return this.getCanvas(0);
    }

    public Canvas3D getCanvas(int n2) {
        return this.viewer[0].getCanvas3D(n2);
    }

    public void addBranchGraph(BranchGroup branchGroup) {
        this.locale.addBranchGraph(branchGroup);
    }

    public static GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (string != null) {
            if (string.equals("REQUIRED")) {
                graphicsConfigTemplate3D.setStereo(1);
            } else if (string.equals("PREFERRED")) {
                graphicsConfigTemplate3D.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(graphicsConfigTemplate3D);
    }

    public void cleanup() {
        View view = this.viewer[0].getView();
        for (int i2 = view.numCanvas3Ds() - 1; i2 >= 0; --i2) {
            Canvas3D canvas3D = view.getCanvas3D(i2);
            if (!canvas3D.isOffScreen()) continue;
            canvas3D.setOffScreenBuffer(null);
        }
        view.removeAllCanvas3Ds();
        this.viewer[0].setViewingPlatform(null);
        this.removeAllLocales();
        Viewer.clearViewerMap();
        Primitive.clearGeometryCache();
    }
}

