/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.theme.ContextMenuImpl;
import com.sun.webkit.Invoker;
import com.sun.webkit.PopupMenu;
import com.sun.webkit.WebPage;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCPoint;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.web.WebView;

public final class PopupMenuImpl
extends PopupMenu {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)PopupMenuImpl.class.getName());
    private final ContextMenu popupMenu = new ContextMenu();

    public PopupMenuImpl() {
        this.popupMenu.setOnHidden(windowEvent -> {
            log.finer("onHidden");
            Invoker.getInvoker().postOnEventThread(() -> {
                log.finer("onHidden: notifying");
                this.notifyPopupClosed();
            });
        });
        this.popupMenu.setOnAction(actionEvent -> {
            MenuItem menuItem = (MenuItem)actionEvent.getTarget();
            log.fine("onAction: item={0}", new Object[]{menuItem});
            this.notifySelectionCommited(this.popupMenu.getItems().indexOf((Object)menuItem));
        });
    }

    @Override
    protected void show(WebPage webPage, int n2, int n3, int n4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("show at [{0}, {1}], width={2}", new Object[]{n2, n3, n4});
        }
        this.popupMenu.setPrefWidth((double)n4);
        this.popupMenu.setPrefHeight(this.popupMenu.getHeight());
        PopupMenuImpl.doShow(this.popupMenu, webPage, n2, n3);
    }

    @Override
    protected void hide() {
        log.fine("hiding");
        this.popupMenu.hide();
    }

    @Override
    protected void appendItem(String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, WCFont wCFont) {
        ContextMenuImpl.SeparatorImpl separatorImpl;
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("itemText={0}, isLabel={1}, isSeparator={2}, isEnabled={3}, bgColor={4}, fgColor={5}, font={6}", new Object[]{string, bl, bl2, bl3, n2, n3, wCFont});
        }
        if (bl2) {
            separatorImpl = new ContextMenuImpl.SeparatorImpl(null);
        } else {
            separatorImpl = new MenuItem(string);
            separatorImpl.setDisable(!bl3);
        }
        separatorImpl.setMnemonicParsing(false);
        this.popupMenu.getItems().add((Object)separatorImpl);
    }

    @Override
    protected void setSelectedItem(int n2) {
        log.finest("index={0}", new Object[]{n2});
    }

    static void doShow(ContextMenu contextMenu, WebPage webPage, int n2, int n3) {
        WebPageClient webPageClient = webPage.getPageClient();
        assert (webPageClient != null);
        WCPoint wCPoint = webPageClient.windowToScreen(new WCPoint(n2, n3));
        contextMenu.show(((WebView)((Object)webPageClient.getContainer())).getScene().getWindow(), (double)wCPoint.getX(), (double)wCPoint.getY());
    }
}

