/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.Response;
import com.sun.mail.pop3.SharedByteArrayOutputStream;
import com.sun.mail.pop3.Status;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.PropUtil;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

class Protocol {
    private Socket socket;
    private String host;
    private Properties props;
    private String prefix;
    private DataInputStream input;
    private PrintWriter output;
    private static final int POP3_PORT = 110;
    private static final String CRLF = "\r\n";
    private boolean debug = false;
    private PrintStream out;
    private String apopChallenge = null;
    private Map capabilities = null;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Protocol(String host, int port, boolean debug, PrintStream out, Properties props, String prefix, boolean isSSL) throws IOException {
        Response r;
        this.debug = debug;
        this.out = out;
        this.host = host;
        this.props = props;
        this.prefix = prefix;
        boolean enableAPOP = PropUtil.getBooleanProperty(props, prefix + ".apop.enable", false);
        try {
            if (port == -1) {
                port = 110;
            }
            if (debug) {
                out.println("DEBUG POP3: connecting to host \"" + host + "\", port " + port + ", isSSL " + isSSL);
            }
            this.socket = SocketFetcher.getSocket(host, port, props, prefix, isSSL);
            this.initStreams();
            r = this.simpleCommand(null);
        }
        catch (IOException ioe) {
            try {
                this.socket.close();
            }
            finally {
                throw ioe;
            }
        }
        if (!r.ok) {
            try {
                this.socket.close();
            }
            finally {
                throw new IOException("Connect failed");
            }
        }
        if (enableAPOP) {
            int challStart = r.data.indexOf(60);
            int challEnd = r.data.indexOf(62, challStart);
            if (challStart != -1 && challEnd != -1) {
                this.apopChallenge = r.data.substring(challStart, challEnd + 1);
            }
            if (debug) {
                out.println("DEBUG POP3: APOP challenge: " + this.apopChallenge);
            }
        }
        this.setCapabilities(this.capa());
    }

    private void initStreams() throws IOException {
        this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "iso-8859-1")));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.quit();
        }
    }

    synchronized void setCapabilities(InputStream in) {
        if (in == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new HashMap(10);
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        try {
            String s;
            while ((s = r.readLine()) != null) {
                String cap = s;
                int i2 = cap.indexOf(32);
                if (i2 > 0) {
                    cap = cap.substring(0, i2);
                }
                this.capabilities.put(cap.toUpperCase(Locale.ENGLISH), s);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    synchronized boolean hasCapability(String c2) {
        return this.capabilities != null && this.capabilities.containsKey(c2.toUpperCase(Locale.ENGLISH));
    }

    synchronized Map getCapabilities() {
        return this.capabilities;
    }

    synchronized String login(String user, String password) throws IOException {
        Response r;
        String dpw = null;
        if (this.apopChallenge != null) {
            dpw = this.getDigest(password);
        }
        if (this.apopChallenge != null && dpw != null) {
            r = this.simpleCommand("APOP " + user + " " + dpw);
        } else {
            r = this.simpleCommand("USER " + user);
            if (!r.ok) {
                return r.data != null ? r.data : "USER command failed";
            }
            r = this.simpleCommand("PASS " + password);
        }
        if (!r.ok) {
            return r.data != null ? r.data : "login failed";
        }
        return null;
    }

    private String getDigest(String password) {
        byte[] digest;
        String key = this.apopChallenge + password;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            digest = md.digest(key.getBytes("iso-8859-1"));
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        return Protocol.toHex(digest);
    }

    private static String toHex(byte[] bytes) {
        char[] result = new char[bytes.length * 2];
        int i2 = 0;
        for (int index = 0; index < bytes.length; ++index) {
            int temp = bytes[index] & 0xFF;
            result[i2++] = digits[temp >> 4];
            result[i2++] = digits[temp & 0xF];
        }
        return new String(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean quit() throws IOException {
        boolean ok = false;
        try {
            Response r = this.simpleCommand("QUIT");
            ok = r.ok;
        }
        finally {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
                this.input = null;
                this.output = null;
            }
        }
        return ok;
    }

    synchronized Status stat() throws IOException {
        Response r = this.simpleCommand("STAT");
        Status s = new Status();
        if (!r.ok) {
            throw new IOException("STAT command failed: " + r.data);
        }
        if (r.data != null) {
            try {
                StringTokenizer st = new StringTokenizer(r.data);
                s.total = Integer.parseInt(st.nextToken());
                s.size = Integer.parseInt(st.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    synchronized int list(int msg) throws IOException {
        Response r = this.simpleCommand("LIST " + msg);
        int size = -1;
        if (r.ok && r.data != null) {
            try {
                StringTokenizer st = new StringTokenizer(r.data);
                st.nextToken();
                size = Integer.parseInt(st.nextToken());
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return size;
    }

    synchronized InputStream list() throws IOException {
        Response r = this.multilineCommand("LIST", 128);
        return r.bytes;
    }

    synchronized InputStream retr(int msg, int size) throws IOException {
        Response r = this.multilineCommand("RETR " + msg, size);
        return r.bytes;
    }

    synchronized InputStream top(int msg, int n2) throws IOException {
        Response r = this.multilineCommand("TOP " + msg + " " + n2, 0);
        return r.bytes;
    }

    synchronized boolean dele(int msg) throws IOException {
        Response r = this.simpleCommand("DELE " + msg);
        return r.ok;
    }

    synchronized String uidl(int msg) throws IOException {
        Response r = this.simpleCommand("UIDL " + msg);
        if (!r.ok) {
            return null;
        }
        int i2 = r.data.indexOf(32);
        if (i2 > 0) {
            return r.data.substring(i2 + 1);
        }
        return null;
    }

    synchronized boolean uidl(String[] uids) throws IOException {
        Response r = this.multilineCommand("UIDL", 15 * uids.length);
        if (!r.ok) {
            return false;
        }
        LineInputStream lis = new LineInputStream(r.bytes);
        String line = null;
        while ((line = lis.readLine()) != null) {
            int n2;
            int i2 = line.indexOf(32);
            if (i2 < 1 || i2 >= line.length() || (n2 = Integer.parseInt(line.substring(0, i2))) <= 0 || n2 > uids.length) continue;
            uids[n2 - 1] = line.substring(i2 + 1);
        }
        return true;
    }

    synchronized boolean noop() throws IOException {
        Response r = this.simpleCommand("NOOP");
        return r.ok;
    }

    synchronized boolean rset() throws IOException {
        Response r = this.simpleCommand("RSET");
        return r.ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean stls() throws IOException {
        Response r = this.simpleCommand("STLS");
        if (r.ok) {
            try {
                this.socket = SocketFetcher.startTLS(this.socket, this.host, this.props, this.prefix);
                this.initStreams();
            }
            catch (IOException ioex) {
                try {
                    this.socket.close();
                }
                finally {
                    this.socket = null;
                    this.input = null;
                    this.output = null;
                }
                IOException sioex = new IOException("Could not convert socket to TLS");
                sioex.initCause(ioex);
                throw sioex;
            }
        }
        return r.ok;
    }

    synchronized InputStream capa() throws IOException {
        Response r = this.multilineCommand("CAPA", 128);
        if (!r.ok) {
            return null;
        }
        return r.bytes;
    }

    private Response simpleCommand(String cmd) throws IOException {
        this.simpleCommandStart(cmd);
        if (this.socket == null) {
            throw new IOException("Folder is closed");
        }
        String line = null;
        try {
            if (cmd != null) {
                if (this.debug) {
                    this.out.println("C: " + cmd);
                }
                cmd = cmd + CRLF;
                this.output.print(cmd);
                this.output.flush();
            }
            line = this.input.readLine();
        }
        catch (InterruptedIOException iioex) {
            try {
                this.socket.close();
            }
            catch (IOException cex) {
                // empty catch block
            }
            throw iioex;
        }
        if (line == null) {
            if (this.debug) {
                this.out.println("S: EOF");
            }
            throw new EOFException("EOF on socket");
        }
        if (this.debug) {
            this.out.println("S: " + line);
        }
        Response r = new Response();
        if (line.startsWith("+OK")) {
            r.ok = true;
        } else if (line.startsWith("-ERR")) {
            r.ok = false;
        } else {
            throw new IOException("Unexpected response: " + line);
        }
        int i2 = line.indexOf(32);
        if (i2 >= 0) {
            r.data = line.substring(i2 + 1);
        }
        this.simpleCommandEnd();
        return r;
    }

    private Response multilineCommand(String cmd, int size) throws IOException {
        int b2;
        this.multilineCommandStart(cmd);
        Response r = this.simpleCommand(cmd);
        if (!r.ok) {
            this.multilineCommandEnd();
            return r;
        }
        SharedByteArrayOutputStream buf = new SharedByteArrayOutputStream(size);
        int lastb = 10;
        try {
            while ((b2 = this.input.read()) >= 0) {
                if (lastb == 10 && b2 == 46) {
                    if (this.debug) {
                        this.out.write(b2);
                    }
                    if ((b2 = this.input.read()) == 13) {
                        if (this.debug) {
                            this.out.write(b2);
                        }
                        b2 = this.input.read();
                        if (this.debug) {
                            this.out.write(b2);
                        }
                        break;
                    }
                }
                buf.write(b2);
                if (this.debug) {
                    this.out.write(b2);
                }
                lastb = b2;
            }
        }
        catch (InterruptedIOException iioex) {
            try {
                this.socket.close();
            }
            catch (IOException cex) {
                // empty catch block
            }
            throw iioex;
        }
        if (b2 < 0) {
            throw new EOFException("EOF on socket");
        }
        r.bytes = buf.toStream();
        this.multilineCommandEnd();
        return r;
    }

    private void simpleCommandStart(String command) {
    }

    private void simpleCommandEnd() {
    }

    private void multilineCommandStart(String command) {
    }

    private void multilineCommandEnd() {
    }
}

