/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.LogManagerProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class MailHandler
extends Handler {
    private static final int offValue;
    private volatile boolean sealed;
    private boolean isWriting;
    private Properties mailProps;
    private Authenticator auth;
    private Collection data;
    private int capacity;
    private Comparator comparator;
    private Formatter subjectFormatter;
    private Level pushLevel;
    private Filter pushFilter;
    private Filter[] attachmentFilters;
    private Formatter[] attachmentFormatters;
    private Formatter[] attachmentNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MailHandler() {
        this.init();
        this.sealed = true;
    }

    public MailHandler(int capacity) {
        this.init();
        this.sealed = true;
        this.setCapacity(capacity);
    }

    public MailHandler(Properties props) {
        this.init();
        this.sealed = true;
        this.setMailProperties(props);
    }

    public boolean isLoggable(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null || filter.isLoggable(record)) {
            return true;
        }
        return this.isAttachmentLoggable(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            record.getSourceMethodName();
            MailHandler mailHandler = this;
            synchronized (mailHandler) {
                this.data.add(record);
                boolean priority = this.isPushable(record);
                if (priority || this.data.size() >= this.capacity) {
                    this.push(1, priority);
                }
            }
        }
    }

    public void push() {
        this.push(2, true);
    }

    public void flush() {
        this.push(2, false);
    }

    public synchronized void close() {
        super.setLevel(Level.OFF);
        this.push(3, false);
        if (this.capacity > 0) {
            this.capacity = -this.capacity;
            if (this.data.isEmpty()) {
                this.data = this.newData(1);
            }
        }
        if (!$assertionsDisabled && this.capacity >= 0) {
            throw new AssertionError();
        }
    }

    public synchronized void setLevel(Level newLevel) {
        if (this.capacity > 0) {
            super.setLevel(newLevel);
        } else {
            if (newLevel == null) {
                throw new NullPointerException();
            }
            this.checkAccess();
        }
    }

    public final synchronized Level getPushLevel() {
        return this.pushLevel;
    }

    public final synchronized void setPushLevel(Level level) {
        this.checkAccess();
        if (level == null) {
            throw new NullPointerException();
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.pushLevel = level;
    }

    public final synchronized Filter getPushFilter() {
        return this.pushFilter;
    }

    public final synchronized void setPushFilter(Filter filter) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.pushFilter = filter;
    }

    public final synchronized Comparator getComparator() {
        return this.comparator;
    }

    public final synchronized void setComparator(Comparator c2) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.comparator = c2;
    }

    public final synchronized int getCapacity() {
        if (!$assertionsDisabled && this.capacity == Integer.MIN_VALUE) {
            throw new AssertionError();
        }
        return Math.abs(this.capacity);
    }

    public final synchronized Authenticator getAuthenticator() {
        this.checkAccess();
        return this.auth;
    }

    public final synchronized void setAuthenticator(Authenticator auth) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.auth = auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMailProperties(Properties props) {
        this.checkAccess();
        props = (Properties)props.clone();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.mailProps = props;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Properties getMailProperties() {
        Properties props;
        this.checkAccess();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            props = this.mailProps;
        }
        return (Properties)props.clone();
    }

    public final Filter[] getAttachmentFilters() {
        return (Filter[])this.readOnlyAttachmentFilters().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentFilters(Filter[] filters) {
        this.checkAccess();
        filters = (Filter[])filters.clone();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != filters.length) {
                throw MailHandler.attachmentMismatch(this.attachmentFormatters.length, filters.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentFilters = filters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Formatter[] getAttachmentFormatters() {
        Formatter[] formatters;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            formatters = this.attachmentFormatters;
        }
        return (Formatter[])formatters.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentFormatters(Formatter[] formatters) {
        this.checkAccess();
        formatters = (Formatter[])formatters.clone();
        for (int i2 = 0; i2 < formatters.length; ++i2) {
            if (formatters[i2] != null) continue;
            throw new NullPointerException(MailHandler.atIndexMsg(i2));
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentFormatters = formatters;
            this.fixUpAttachmentFilters();
            this.fixUpAttachmentNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Formatter[] getAttachmentNames() {
        Formatter[] formatters;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            formatters = this.attachmentNames;
        }
        return (Formatter[])formatters.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentNames(String[] names) {
        this.checkAccess();
        Formatter[] formatters = new Formatter[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            if (name != null) {
                if (name.length() <= 0) {
                    throw new IllegalArgumentException(MailHandler.atIndexMsg(i2));
                }
            } else {
                throw new NullPointerException(MailHandler.atIndexMsg(i2));
            }
            formatters[i2] = new TailNameFormatter(name);
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != names.length) {
                throw MailHandler.attachmentMismatch(this.attachmentFormatters.length, names.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentNames = formatters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentNames(Formatter[] formatters) {
        this.checkAccess();
        formatters = (Formatter[])formatters.clone();
        for (int i2 = 0; i2 < formatters.length; ++i2) {
            if (formatters[i2] != null) continue;
            throw new NullPointerException(MailHandler.atIndexMsg(i2));
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != formatters.length) {
                throw MailHandler.attachmentMismatch(this.attachmentFormatters.length, formatters.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentNames = formatters;
        }
    }

    public final synchronized Formatter getSubject() {
        return this.subjectFormatter;
    }

    public final void setSubject(String subject) {
        if (subject == null) {
            throw new NullPointerException();
        }
        this.setSubject(new TailNameFormatter(subject));
    }

    public final synchronized void setSubject(Formatter format) {
        this.checkAccess();
        if (format == null) {
            throw new NullPointerException();
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.subjectFormatter = format;
    }

    protected void reportError(String msg, Exception ex, int code) {
        if (msg != null) {
            super.reportError(Level.SEVERE.getName() + ": " + msg, ex, code);
        } else {
            super.reportError(null, ex, code);
        }
    }

    final void checkAccess() {
        if (this.sealed) {
            LogManagerProperties.manager.checkAccess();
        }
    }

    private String contentTypeOf(String head) {
        if (head != null) {
            Locale locale = Locale.ENGLISH;
            if (head.trim().toUpperCase(locale).indexOf("<HTML") > -1) {
                return "text/html";
            }
            if (head.trim().toUpperCase(locale).indexOf("<XML") > -1) {
                return "text/xml";
            }
        }
        return null;
    }

    private void setContent(Part part, StringBuffer buf, String type) throws MessagingException {
        if (type != null && !"text/plain".equals(type)) {
            try {
                ByteArrayDataSource source = new ByteArrayDataSource(buf.toString(), type);
                part.setDataHandler(new DataHandler((DataSource)source));
            }
            catch (IOException IOE) {
                this.reportError(IOE.getMessage(), IOE, 5);
                part.setText(buf.toString());
            }
        } else {
            part.setText(buf.toString());
        }
    }

    private final synchronized void setCapacity(int newCapacity) {
        if (newCapacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero.");
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.capacity = this.capacity < 0 ? -newCapacity : newCapacity;
    }

    private synchronized Filter[] readOnlyAttachmentFilters() {
        return this.attachmentFilters;
    }

    private boolean fixUpAttachmentNames() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int current = this.attachmentNames.length;
        int expect = this.attachmentFormatters.length;
        if (current != expect) {
            this.attachmentNames = (Formatter[])MailHandler.copyOf(this.attachmentNames, expect);
            for (int i2 = 0; i2 < expect; ++i2) {
                if (this.attachmentNames[i2] != null) continue;
                this.attachmentNames[i2] = new TailNameFormatter(String.valueOf(this.attachmentFormatters[i2]));
            }
            return current != 0;
        }
        return false;
    }

    private boolean fixUpAttachmentFilters() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int current = this.attachmentFilters.length;
        int expect = this.attachmentFormatters.length;
        if (current != expect) {
            this.attachmentFilters = (Filter[])MailHandler.copyOf(this.attachmentFilters, expect);
            return current != 0;
        }
        return false;
    }

    private static Object[] copyOf(Object[] a2, int size) {
        Object[] copy = (Object[])Array.newInstance(a2.getClass().getComponentType(), size);
        System.arraycopy(a2, 0, copy, 0, Math.min(a2.length, size));
        return copy;
    }

    private synchronized void init() {
        LogManager manager = LogManagerProperties.manager;
        String p = this.getClass().getName();
        this.mailProps = new Properties();
        ErrorManager em = (ErrorManager)this.initObject(p.concat(".errorManager"), ErrorManager.class);
        if (em != null) {
            this.setErrorManager(em);
        }
        try {
            String val = manager.getProperty(p.concat(".level"));
            if (val != null) {
                super.setLevel(Level.parse(val));
            } else {
                super.setLevel(Level.WARNING);
            }
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
            try {
                super.setLevel(Level.WARNING);
            }
            catch (RuntimeException fail) {
                this.reportError(fail.getMessage(), fail, 4);
            }
        }
        try {
            super.setFilter((Filter)this.initObject(p.concat(".filter"), Filter.class));
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        int DEFAULT_CAPACITY = 1000;
        try {
            String value = manager.getProperty(p.concat(".capacity"));
            if (value != null) {
                this.setCapacity(Integer.parseInt(value));
            } else {
                this.setCapacity(1000);
            }
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        if (this.capacity == 0) {
            this.capacity = 1000;
        }
        this.data = this.newData(10);
        this.auth = (Authenticator)this.initObject(p.concat(".authenticator"), Authenticator.class);
        try {
            super.setEncoding(manager.getProperty(p.concat(".encoding")));
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (UnsupportedEncodingException UEE) {
            this.reportError(UEE.getMessage(), UEE, 4);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        try {
            Formatter formatter = (Formatter)this.initObject(p.concat(".formatter"), Formatter.class);
            if (formatter != null) {
                super.setFormatter(formatter);
            } else {
                super.setFormatter(new SimpleFormatter());
            }
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
            try {
                super.setFormatter(new SimpleFormatter());
            }
            catch (RuntimeException fail) {
                this.reportError(fail.getMessage(), fail, 4);
            }
        }
        try {
            this.comparator = this.initComparator(p.concat(".comparator"));
        }
        catch (Exception RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        try {
            String val = manager.getProperty(p.concat(".pushLevel"));
            if (val != null) {
                this.pushLevel = Level.parse(val);
            }
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        if (this.pushLevel == null) {
            this.pushLevel = Level.OFF;
        }
        this.pushFilter = (Filter)this.initObject(p.concat(".pushFilter"), Filter.class);
        this.subjectFormatter = (Formatter)this.initObject(p.concat(".subject"), Formatter.class);
        if (this.subjectFormatter == null) {
            this.subjectFormatter = new TailNameFormatter("");
        }
        this.attachmentFormatters = (Formatter[])this.initArray(p.concat(".attachment.formatters"), Formatter.class);
        this.attachmentFilters = (Filter[])this.initArray(p.concat(".attachment.filters"), Filter.class);
        this.attachmentNames = (Formatter[])this.initArray(p.concat(".attachment.names"), Formatter.class);
        int attachments = this.attachmentFormatters.length;
        for (int i2 = 0; i2 < attachments; ++i2) {
            if (this.attachmentFormatters[i2] == null) {
                NullPointerException NPE = new NullPointerException(MailHandler.atIndexMsg(i2));
                this.attachmentFormatters[i2] = new SimpleFormatter();
                this.reportError("attachment formatter.", NPE, 4);
                continue;
            }
            if (!(this.attachmentFormatters[i2] instanceof TailNameFormatter)) continue;
            ClassNotFoundException CNFE = new ClassNotFoundException(this.attachmentFormatters[i2].toString());
            this.attachmentFormatters[i2] = new SimpleFormatter();
            this.reportError("attachment formatter.", CNFE, 4);
        }
        if (this.fixUpAttachmentFilters()) {
            this.reportError("attachment filters.", MailHandler.attachmentMismatch("length mismatch"), 4);
        }
        if (this.fixUpAttachmentNames()) {
            this.reportError("attachment names.", MailHandler.attachmentMismatch("length mismatch"), 4);
        }
    }

    private Object objectFromNew(String name, Class type) throws NoSuchMethodException {
        Object obj = null;
        try {
            try {
                try {
                    Class clazz = LogManagerProperties.findClass(name);
                    return clazz.getConstructor(null).newInstance(null);
                }
                catch (NoClassDefFoundError NCDFE) {
                    throw (ClassNotFoundException)new ClassNotFoundException(NCDFE.getMessage()).initCause(NCDFE);
                }
            }
            catch (ClassNotFoundException CNFE) {
                if (type == Formatter.class) {
                    return new TailNameFormatter(name);
                }
                throw CNFE;
            }
        }
        catch (NoSuchMethodException NSME) {
            throw NSME;
        }
        catch (Exception E) {
            this.reportError(E.getMessage(), E, 4);
            return obj;
        }
    }

    private Object initObject(String key, Class type) {
        String name = LogManagerProperties.manager.getProperty(key);
        if (name != null && name.length() > 0 && !"null".equalsIgnoreCase(name)) {
            try {
                return this.objectFromNew(name, type);
            }
            catch (NoSuchMethodException E) {
                this.reportError(E.getMessage(), E, 4);
            }
        }
        return null;
    }

    private Object[] initArray(String key, Class type) {
        String list = LogManagerProperties.manager.getProperty(key);
        if (list != null && list.length() > 0) {
            String[] names = list.split(",");
            Object[] a2 = (Object[])Array.newInstance(type, names.length);
            for (int i2 = 0; i2 < a2.length; ++i2) {
                names[i2] = names[i2].trim();
                if ("null".equalsIgnoreCase(names[i2])) continue;
                try {
                    a2[i2] = this.objectFromNew(names[i2], type);
                    continue;
                }
                catch (NoSuchMethodException E) {
                    this.reportError(E.getMessage(), E, 4);
                }
            }
            return a2;
        }
        return (Object[])Array.newInstance(type, 0);
    }

    private Comparator initComparator(String key) throws Exception {
        return (Comparator)this.initObject(key, Comparator.class);
    }

    private boolean isAttachmentLoggable(LogRecord record) {
        Filter[] filters = this.readOnlyAttachmentFilters();
        for (int i2 = 0; i2 < filters.length; ++i2) {
            Filter f2 = filters[i2];
            if (f2 != null && !f2.isLoggable(record)) continue;
            return true;
        }
        return false;
    }

    private boolean isPushable(LogRecord record) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int value = this.getPushLevel().intValue();
        if (value == offValue || record.getLevel().intValue() < value) {
            return false;
        }
        Filter filter = this.getPushFilter();
        return filter == null || filter.isLoggable(record);
    }

    private void push(int code, boolean priority) {
        Message msg = null;
        try {
            msg = this.writeLogRecords(priority);
            if (msg != null) {
                Transport.send(msg);
            }
        }
        catch (Exception E) {
            try {
                super.reportError(this.toRawString(msg), E, code);
            }
            catch (MessagingException rawMe) {
                this.reportError(rawMe.toString(), E, code);
            }
            catch (IOException rawIo) {
                this.reportError(rawIo.toString(), E, code);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Message writeLogRecords(boolean priority) throws IOException, MessagingException {
        Message msg;
        if (this.data.isEmpty()) {
            return null;
        }
        if (this.isWriting) {
            return null;
        }
        this.isWriting = true;
        try {
            msg = this.createMessage();
            this.setPriority(msg, priority);
            Collection records = this.sortAsReadOnlyData();
            BodyPart[] parts = new BodyPart[this.attachmentFormatters.length];
            StringBuffer[] buffers = new StringBuffer[parts.length];
            String contentType = null;
            StringBuffer buf = null;
            this.appendSubject(msg, this.head(this.subjectFormatter));
            Formatter bodyFormat = this.getFormatter();
            Filter bodyFilter = this.getFilter();
            Iterator it = records.iterator();
            while (it.hasNext()) {
                LogRecord r = (LogRecord)it.next();
                this.appendSubject(msg, this.format(this.subjectFormatter, r));
                if (bodyFilter == null || bodyFilter.isLoggable(r)) {
                    if (buf == null) {
                        buf = new StringBuffer();
                        String head = this.head(bodyFormat);
                        buf.append(head);
                        contentType = this.contentTypeOf(head);
                    }
                    buf.append(this.format(bodyFormat, r));
                }
                for (int i2 = 0; i2 < parts.length; ++i2) {
                    if (this.attachmentFilters[i2] != null && !this.attachmentFilters[i2].isLoggable(r)) continue;
                    if (parts[i2] == null) {
                        parts[i2] = this.createBodyPart(i2);
                        buffers[i2] = new StringBuffer();
                        buffers[i2].append(this.head(this.attachmentFormatters[i2]));
                        this.appendFileName(parts[i2], this.head(this.attachmentNames[i2]));
                    }
                    this.appendFileName(parts[i2], this.format(this.attachmentNames[i2], r));
                    buffers[i2].append(this.format(this.attachmentFormatters[i2], r));
                }
            }
            for (int i3 = parts.length - 1; i3 >= 0; --i3) {
                if (parts[i3] == null) continue;
                this.appendFileName(parts[i3], this.tail(this.attachmentNames[i3], "err"));
                buffers[i3].append(this.tail(this.attachmentFormatters[i3], ""));
                String content = buffers[i3].toString();
                if (content.length() > 0) {
                    String name = parts[i3].getFileName();
                    if (name == null || name.length() == 0) {
                        parts[i3].setFileName(this.attachmentFormatters[i3].toString());
                    }
                    parts[i3].setText(content);
                } else {
                    parts[i3] = null;
                }
                buffers[i3] = null;
            }
            if (buf != null) {
                buf.append(this.tail(bodyFormat, ""));
            } else {
                buf = new StringBuffer(0);
            }
            this.appendSubject(msg, this.tail(this.subjectFormatter, ""));
            records = null;
            this.data.clear();
            if (parts.length > 0) {
                MimeMultipart multipart = new MimeMultipart();
                if (buf.length() > 0) {
                    BodyPart body = this.createBodyPart();
                    this.setContent(body, buf, contentType);
                    ((Multipart)multipart).addBodyPart(body);
                }
                buf = null;
                for (int i4 = 0; i4 < parts.length; ++i4) {
                    if (parts[i4] == null) continue;
                    ((Multipart)multipart).addBodyPart(parts[i4]);
                }
                parts = null;
                msg.setContent(multipart);
            } else {
                this.setContent(msg, buf, contentType);
                buf = null;
            }
            Object var14_18 = null;
            this.isWriting = false;
            if (!this.data.isEmpty()) {
                this.data.clear();
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.isWriting = false;
            if (!this.data.isEmpty()) {
                this.data.clear();
            }
            throw throwable;
        }
        msg.setSentDate(new Date());
        msg.saveChanges();
        return msg;
    }

    private Message createMessage() throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        LogManagerProperties proxyProps = new LogManagerProperties(this.mailProps, this.getClass().getName());
        Session session = Session.getInstance(proxyProps, this.auth);
        MimeMessage msg = new MimeMessage(session);
        this.setFrom(msg, proxyProps);
        this.setRecipient(msg, proxyProps, "mail.to", Message.RecipientType.TO);
        this.setRecipient(msg, proxyProps, "mail.cc", Message.RecipientType.CC);
        this.setRecipient(msg, proxyProps, "mail.bcc", Message.RecipientType.BCC);
        this.setReplyTo(msg, proxyProps);
        this.setSender(msg, proxyProps);
        this.setMailer(msg);
        return msg;
    }

    private BodyPart createBodyPart() throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDisposition("inline");
        part.setDescription(this.descriptionFrom(this.getFormatter(), this.getFilter()));
        return part;
    }

    private BodyPart createBodyPart(int index) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        MimeBodyPart part = new MimeBodyPart();
        part.setDisposition("attachment");
        part.setDescription(this.descriptionFrom(this.attachmentFormatters[index], this.attachmentFilters[index]));
        return part;
    }

    private String descriptionFrom(Formatter formatter, Filter filter) {
        return "Formatted using " + formatter.getClass().getName() + " and filtered with " + (filter == null ? "no filter" : filter.getClass().getName()) + '.';
    }

    private Collection newData(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    private void appendFileName(Part part, String chunk) {
        if (chunk != null) {
            if (chunk.length() > 0) {
                try {
                    String old = part.getFileName();
                    part.setFileName(old != null ? old.concat(chunk) : chunk);
                }
                catch (MessagingException ME) {
                    this.reportError(ME.getMessage(), ME, 5);
                }
            }
        } else {
            this.reportError("null", new NullPointerException(), 5);
        }
    }

    private void appendSubject(Message msg, String chunk) {
        if (chunk != null) {
            if (chunk.length() > 0) {
                try {
                    String old = msg.getSubject();
                    msg.setSubject(old != null ? old.concat(chunk) : chunk);
                }
                catch (MessagingException ME) {
                    this.reportError(ME.getMessage(), ME, 5);
                }
            }
        } else {
            this.reportError("null", new NullPointerException(), 5);
        }
    }

    private String head(Formatter f2) {
        try {
            return f2.getHead(this);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 5);
            return "";
        }
    }

    private String format(Formatter f2, LogRecord r) {
        try {
            return f2.format(r);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 5);
            return "";
        }
    }

    private String tail(Formatter f2, String def) {
        try {
            return f2.getTail(this);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 5);
            return def;
        }
    }

    private Collection sortAsReadOnlyData() {
        Collection<LogRecord> records;
        if (this.comparator != null) {
            LogRecord[] a2 = this.data.toArray(new LogRecord[this.data.size()]);
            try {
                Arrays.sort(a2, this.comparator);
                records = Arrays.asList(a2);
            }
            catch (RuntimeException RE) {
                this.reportError(RE.getMessage(), RE, 5);
                records = this.data;
            }
        } else {
            records = this.data;
        }
        return records;
    }

    private void setMailer(Message msg) {
        try {
            Class mail = MailHandler.class;
            Class<?> k2 = this.getClass();
            String value = k2 == mail ? mail.getName() : mail.getName() + " using the " + k2.getName() + " extension.";
            msg.setHeader("X-Mailer", value);
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private void setPriority(Message msg, boolean priority) {
        if (priority) {
            try {
                msg.setHeader("X-Priority", "2");
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private void setFrom(Message msg, Properties props) {
        block6: {
            String from = props.getProperty("mail.from");
            if (from != null && from.length() > 0) {
                try {
                    Address[] address = InternetAddress.parse(from, false);
                    if (address == null || address.length == 0) {
                        this.setDefaultFrom(msg);
                        break block6;
                    }
                    if (address.length == 1) {
                        msg.setFrom(address[0]);
                        break block6;
                    }
                    msg.addFrom(address);
                }
                catch (MessagingException ME) {
                    this.reportError(ME.getMessage(), ME, 5);
                    this.setDefaultFrom(msg);
                }
            } else {
                this.setDefaultFrom(msg);
            }
        }
    }

    private void setDefaultFrom(Message msg) {
        try {
            msg.setFrom();
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private void setReplyTo(Message msg, Properties props) {
        String reply = props.getProperty("mail.reply.to");
        if (reply != null && reply.length() > 0) {
            try {
                Address[] address = InternetAddress.parse(reply, false);
                if (address != null && address.length > 0) {
                    msg.setReplyTo(address);
                }
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private void setSender(MimeMessage msg, Properties props) {
        String sender = props.getProperty("mail.sender");
        if (sender != null && sender.length() > 0) {
            try {
                InternetAddress[] address = InternetAddress.parse(sender, false);
                if (address != null && address.length > 0) {
                    msg.setSender(address[0]);
                    if (address.length > 1) {
                        this.reportError("Ignoring other senders.", new AddressException(Arrays.asList(address).subList(1, address.length).toString()), 5);
                    }
                }
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private void setRecipient(Message msg, Properties props, String key, Message.RecipientType type) {
        String value = props.getProperty(key);
        if (value != null && value.length() > 0) {
            try {
                Address[] address = InternetAddress.parse(value, false);
                if (address != null && address.length > 0) {
                    msg.setRecipients(type, address);
                }
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private String toRawString(Message msg) throws MessagingException, IOException {
        if (msg != null) {
            int size = Math.max(msg.getSize() + 1024, 1024);
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            msg.writeTo(out);
            return out.toString("US-ASCII");
        }
        return null;
    }

    private static RuntimeException attachmentMismatch(String msg) {
        return new IndexOutOfBoundsException(msg);
    }

    private static RuntimeException attachmentMismatch(int expected, int found) {
        return MailHandler.attachmentMismatch("Attachments mismatched, expected " + expected + " but given " + found + '.');
    }

    private static String atIndexMsg(int i2) {
        return "At index: " + i2 + '.';
    }

    static {
        $assertionsDisabled = !MailHandler.class.desiredAssertionStatus();
        offValue = Level.OFF.intValue();
    }

    private static final class TailNameFormatter
    extends Formatter {
        private final String name;
        static final /* synthetic */ boolean $assertionsDisabled;

        TailNameFormatter(String name) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            this.name = name;
        }

        public String format(LogRecord record) {
            return "";
        }

        public String getTail(Handler h2) {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            $assertionsDisabled = !(class$com$sun$mail$util$logging$MailHandler == null ? (class$com$sun$mail$util$logging$MailHandler = MailHandler.class$("com.sun.mail.util.logging.MailHandler")) : class$com$sun$mail$util$logging$MailHandler).desiredAssertionStatus();
        }
    }
}

