/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.util.JavaVersion;
import de.javasoft.util.OS;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.plaf.synth.SynthIcon;

public class SyntheticaMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthConstants {
    private static boolean paintDebugRects = UIManager.getBoolean("Synthetica.menuItem.paintDebugRectangles");
    private static WeakHashMap<JPopupMenu, MaxWidth> maxWidths = new WeakHashMap();
    private String acceleratorDelimiter;
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle acceleratorRect = new Rectangle();
    private static Rectangle checkIconRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaMenuItemUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem jMenuItem) {
        String string = this.getPropertyPrefix();
        SynthContext synthContext = SyntheticaMenuItemUI.getContext((JComponent)jMenuItem, 1);
        SynthStyle synthStyle = SyntheticaMenuItemUI.getStyle(jMenuItem);
        synthStyle.installDefaults(synthContext);
        Object object = synthStyle.get(synthContext, "MenuItem.textIconGap");
        if (object != null) {
            LookAndFeel.installProperty(jMenuItem, "iconTextGap", object);
        }
        this.defaultTextIconGap = jMenuItem.getIconTextGap();
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            Insets insets = (Insets)synthStyle.get(synthContext, String.valueOf(string) + ".margin");
            if (insets == null) {
                insets = new InsetsUIResource(0, 0, 0, 0);
            }
            this.menuItem.setMargin(insets);
        }
        this.acceleratorDelimiter = synthStyle.getString(synthContext, String.valueOf(string) + ".acceleratorDelimiter", SyntheticaMenuItemUI.getAcceleratorDelimiter());
        this.arrowIcon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".arrowIcon");
        this.arrowIcon = SyntheticaLookAndFeel.getClientProperty("Synthetica.menuItem.arrowIcon", this.menuItem, this.arrowIcon);
        this.checkIcon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".checkIcon");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        SynthContext synthContext = SyntheticaMenuItemUI.getMenuItemContext(jComponent);
        SynthContext synthContext2 = SyntheticaMenuItemUI.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Dimension dimension = SyntheticaMenuItemUI.getPreferredMenuItemSize(synthContext, synthContext2, false, jComponent, icon, icon2, n2, this.acceleratorDelimiter);
        return dimension;
    }

    static Dimension getPreferredMenuItemSize(SynthContext synthContext, SynthContext synthContext2, boolean bl, JComponent jComponent, Icon icon, Icon icon2, int n2, String string) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string2 = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string3 = "";
        JPopupMenu jPopupMenu = SyntheticaMenuItemUI.findPopup(jMenuItem);
        int n3 = synthContext.getStyle().getInt(synthContext, "MenuItem.textIconGap", n2);
        int n4 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.textIconGap", jPopupMenu, n3);
        int n5 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.acceleratorGap", jPopupMenu, n3 * 4);
        int n6 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", jPopupMenu, 0);
        if (keyStroke != null) {
            int n7;
            int n8 = keyStroke.getModifiers();
            if (n8 > 0) {
                string3 = SyntheticaMenuItemUI.modifiersAsText(n8);
                string3 = String.valueOf(string3) + string;
            }
            string3 = (n7 = keyStroke.getKeyCode()) != 0 ? String.valueOf(string3) + KeyEvent.getKeyText(n7) : String.valueOf(string3) + keyStroke.getKeyChar();
        }
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(synthContext2.getStyle().getFont(synthContext2));
        SyntheticaMenuItemUI.resetRects();
        SyntheticaMenuItemUI.layoutMenuItem(synthContext, fontMetrics, synthContext2, string2, fontMetrics2, string3, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string2 == null ? 0 : n2, n2, bl);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(bl ? SyntheticaMenuItemUI.iconRect.x : SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.iconRect.y, bl ? SyntheticaMenuItemUI.iconRect.width : 0, SyntheticaMenuItemUI.iconRect.height, r);
        if (jPopupMenu != null) {
            MaxWidth maxWidth = maxWidths.get(jPopupMenu);
            if (maxWidth == null) {
                maxWidths.put(jPopupMenu, new MaxWidth());
                maxWidth = maxWidths.get(jPopupMenu);
            } else if (SyntheticaMenuItemUI.isHorizontalLayout(jPopupMenu)) {
                maxWidth.clear();
            }
            SyntheticaMenuItemUI.r.width = maxWidth.maxTextWidth = Math.max(maxWidth.maxTextWidth, SyntheticaMenuItemUI.r.width);
            maxWidth.maxAcceleratorWidth = Math.max(maxWidth.maxAcceleratorWidth, SyntheticaMenuItemUI.acceleratorRect.width);
            SyntheticaMenuItemUI.r.width += maxWidth.maxAcceleratorWidth;
            if (maxWidth.maxAcceleratorWidth > 0) {
                SyntheticaMenuItemUI.r.width += n5;
            }
            SyntheticaMenuItemUI.r.width += maxWidth.maxIconWidth;
            if (maxWidth.maxIconWidth > 0) {
                SyntheticaMenuItemUI.r.width += n4;
            }
            if (!bl) {
                if (SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu)) {
                    SyntheticaMenuItemUI.r.width += maxWidth.maxCheckIconWidth;
                    if (maxWidth.maxCheckIconWidth > 0) {
                        SyntheticaMenuItemUI.r.width += n3;
                    }
                } else if (SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu)) {
                    SyntheticaMenuItemUI.r.width -= maxWidth.maxIconWidth;
                    SyntheticaMenuItemUI.r.width += Math.max(maxWidth.maxIconWidth, maxWidth.maxCheckIconWidth);
                    if (maxWidth.maxIconWidth > 0) {
                        SyntheticaMenuItemUI.r.width -= n4;
                    }
                    SyntheticaMenuItemUI.r.width += n3;
                }
                if (maxWidth.maxAcceleratorWidth == 0) {
                    SyntheticaMenuItemUI.r.width += maxWidth.maxArrowIconWidth;
                    if (maxWidth.maxArrowIconWidth > 0) {
                        SyntheticaMenuItemUI.r.width += n3;
                    }
                }
            }
        } else if (!bl) {
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.acceleratorRect.width;
            if (SyntheticaMenuItemUI.acceleratorRect.width > 0) {
                SyntheticaMenuItemUI.r.width += n5;
            }
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.iconRect.width;
            if (SyntheticaMenuItemUI.iconRect.width > 0) {
                SyntheticaMenuItemUI.r.width += n4;
            }
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.checkIconRect.width;
            if (SyntheticaMenuItemUI.checkIconRect.width > 0) {
                SyntheticaMenuItemUI.r.width += n3;
            }
            int n9 = icon2 == null ? 0 : SyntheticaLookAndFeel.getInt("Synthetica.menuItem.arrowIconGap", jComponent, n3);
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.arrowIconRect.width + n9;
        }
        SyntheticaMenuItemUI.r.width = SyntheticaMenuItemUI.r.width + (bl ? n3 : n3 * 2);
        if (!bl && jPopupMenu != null && (SyntheticaLookAndFeel.preservePopupIconSpace(jPopupMenu) || SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu))) {
            SyntheticaMenuItemUI.r.width += n6;
        }
        Insets insets = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets2 = jMenuItem.getMargin();
        if (insets2 != null) {
            insets = new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
        }
        SyntheticaMenuItemUI.r.width = (SyntheticaMenuItemUI.r.width = SyntheticaMenuItemUI.r.width + ((bl ? 0 : insets.left) + insets.right)) + (bl && icon3 != null ? insets.left + n4 : 0);
        SyntheticaMenuItemUI.r.height += insets.top + insets.bottom;
        int n10 = SyntheticaLookAndFeel.getInt("Menu.menuPopupOffsetX", null, 0);
        boolean bl2 = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.respectTopLevelMenuWidth", jPopupMenu, true);
        if (bl2 && jPopupMenu != null && SyntheticaLookAndFeel.isToplevelPopupMenu(jPopupMenu) && SyntheticaMenuItemUI.r.width + n10 < jPopupMenu.getInvoker().getWidth()) {
            SyntheticaMenuItemUI.r.width = jPopupMenu.getInvoker().getWidth() - n10;
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuItem.justifySize", jPopupMenu, true)) {
            if (SyntheticaMenuItemUI.r.width % 2 == 0) {
                ++SyntheticaMenuItemUI.r.width;
            }
            if (SyntheticaMenuItemUI.r.height % 2 == 0) {
                ++SyntheticaMenuItemUI.r.height;
            }
        }
        return r.getSize();
    }

    private static boolean isHorizontalLayout(JPopupMenu jPopupMenu) {
        if (JavaVersion.JAVA5 || !(jPopupMenu.getLayout() instanceof BoxLayout)) {
            return false;
        }
        int n2 = ((BoxLayout)jPopupMenu.getLayout()).getAxis();
        return n2 == 0 || n2 == 2;
    }

    private static String layoutMenuItem(SynthContext synthContext, FontMetrics fontMetrics, SynthContext synthContext2, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n6, int n7, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3;
        int n8;
        JComponent jComponent = synthContext.getComponent();
        JPopupMenu jPopupMenu = SyntheticaMenuItemUI.findPopup(jComponent);
        boolean bl4 = jComponent.getComponentOrientation().isLeftToRight();
        int n9 = synthContext.getStyle().getInt(synthContext, "MenuItem.textIconGap", n7);
        int n10 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.textIconGap", jPopupMenu, n9);
        int n11 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.acceleratorGap", jPopupMenu, n9 * 4);
        int n12 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", jPopupMenu, 0);
        boolean bl5 = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.centerText", jPopupMenu, false);
        boolean bl6 = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.forceIconSpace", jPopupMenu, false);
        int n13 = icon == null ? (bl6 ? SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.defaultIconWidth", jPopupMenu, 16) : 0) : icon.getIconWidth();
        int n14 = icon2 == null ? 0 : icon2.getIconWidth();
        int n15 = n8 = icon3 == null ? 0 : icon3.getIconWidth();
        if (jPopupMenu != null) {
            MaxWidth maxWidth = maxWidths.get(jPopupMenu);
            if (maxWidth == null) {
                maxWidths.put(jPopupMenu, new MaxWidth());
                maxWidth = maxWidths.get(jPopupMenu);
            }
            n13 = maxWidth.maxIconWidth = Math.max(maxWidth.maxIconWidth, n13);
            n14 = maxWidth.maxCheckIconWidth = Math.max(maxWidth.maxCheckIconWidth, n14);
            n8 = maxWidth.maxArrowIconWidth = Math.max(maxWidth.maxArrowIconWidth, n8);
            jPopupMenu.putClientProperty("Synthetica.menuItem.maxIconWidth", n13);
        }
        boolean bl7 = jPopupMenu == null ? icon != null : (bl3 = SyntheticaLookAndFeel.preservePopupIconSpace(jPopupMenu));
        boolean bl8 = jPopupMenu == null ? icon2 != null : (bl2 = SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu));
        boolean bl9 = jPopupMenu == null ? bl2 && bl3 : SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu);
        synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, icon, n3, n2, n5, n4, rectangle, rectangle2, rectangle3, n10);
        if (!bl) {
            if (icon2 != null) {
                rectangle5.width = SynthIcon.getIconWidth((Icon)icon2, (SynthContext)synthContext);
                rectangle5.height = SynthIcon.getIconHeight((Icon)icon2, (SynthContext)synthContext);
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = SynthIcon.getIconWidth((Icon)icon3, (SynthContext)synthContext);
                rectangle6.height = SynthIcon.getIconHeight((Icon)icon3, (SynthContext)synthContext);
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        if (bl) {
            object = synthContext.getStyle().getInsets(synthContext, null);
            rectangle3.x = bl4 ? (rectangle3.x += n9 + ((Insets)object).left) : (rectangle3.x -= n9 + ((Insets)object).left);
            if (rectangle2.width > 0) {
                rectangle2.x = rectangle2.x + (((Insets)object).left + n10) * (bl4 ? 1 : -1);
            }
        } else if (bl9) {
            if (bl4) {
                rectangle5.x = rectangle.x + n9;
                rectangle2.x = rectangle.x + n9 + n14 + n9;
                rectangle3.x = rectangle.x + n9 + n14 + n9 + n13 + n10 + n12;
            } else {
                rectangle5.x = rectangle.x + rectangle.width - n9 - n14;
                rectangle2.x = rectangle5.x - n9 - n13;
                rectangle3.x = rectangle2.x - n10 - n12 - rectangle3.width;
            }
        } else if (bl3 && bl2) {
            int n16 = Math.max(n14, n13);
            if (bl4) {
                rectangle5.x = rectangle.x + n9 + (n16 - rectangle5.width) / 2;
                rectangle2.x = rectangle.x + n9 + (n16 - rectangle2.width) / 2;
                rectangle3.x = rectangle.x + n9 + n16 + n9 + n12;
            } else {
                rectangle5.x = rectangle.x + rectangle.width - n9 - n14 - (n16 - rectangle5.width) / 2;
                rectangle2.x = rectangle.x + rectangle.width - n9 - n13 - (n16 - rectangle2.width) / 2;
                rectangle3.x = rectangle.x + rectangle.width - n9 - n16 - n9 - n12 - rectangle3.width;
            }
        } else if (bl3 && !bl2) {
            if (bl4) {
                rectangle2.x = rectangle.x + n9;
                rectangle3.x = rectangle.x + n9 + n13 + n10 + (jPopupMenu == null ? 0 : n12);
            } else {
                rectangle2.x = rectangle.x + rectangle.width - n9 - n13;
                rectangle3.x = rectangle2.x - n10 - (jPopupMenu == null ? 0 : n12) - rectangle3.width;
            }
        } else if (!bl3 && bl2) {
            if (bl4) {
                rectangle5.x = rectangle.x + n9;
                rectangle3.x = rectangle.x + n9 + n14 + n9 + n12;
            } else {
                rectangle5.x = rectangle.x + rectangle.width - n9 - n14;
                rectangle3.x = rectangle5.x - n9 - n12 - rectangle3.width;
            }
        } else if (bl4) {
            rectangle3.x = rectangle.x + n9;
        } else if (rectangle.width < Short.MAX_VALUE) {
            rectangle3.x = rectangle.x + rectangle.width - rectangle3.width - n9;
            rectangle2.x = 0;
        }
        if (!bl) {
            rectangle6.x = bl4 ? rectangle.x + rectangle.width - n9 - rectangle6.width : rectangle.x + n9;
        }
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            object = synthContext2.getStyle();
            rectangle4.width = ((SynthStyle)object).getGraphicsUtils(synthContext2).computeStringWidth(synthContext2, fontMetrics2.getFont(), fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        object = rectangle2.union(rectangle3);
        int n17 = maxWidths.get(jPopupMenu) == null ? rectangle4.width : SyntheticaMenuItemUI.maxWidths.get((Object)jPopupMenu).maxAcceleratorWidth;
        rectangle4.x = bl4 ? rectangle.x + rectangle.width - rectangle6.width - n9 - n17 : rectangle.x + rectangle6.width + n9 + n17 - rectangle4.width;
        rectangle4.y = ((Rectangle)object).y + (((Rectangle)object).height / 2 - rectangle4.height / 2);
        if (!bl) {
            rectangle6.y = ((Rectangle)object).y + (((Rectangle)object).height / 2 - rectangle6.height / 2);
            rectangle5.y = ((Rectangle)object).y + (((Rectangle)object).height / 2 - rectangle5.height / 2);
        }
        if (!bl && bl5) {
            int n18 = rectangle.width - Math.max(n17, n8) - n9 * 2;
            if (bl9) {
                n18 -= n13 + n9 + n14 + n10 + n12;
            } else if (bl3 && bl2) {
                n18 -= Math.max(n13, n14) + n9 + n12;
            } else if (bl3 && !bl2) {
                n18 -= n13 + n10 + n12;
            } else if (!bl3 && bl2) {
                n18 -= n14 + n9 + n12;
            }
            if (n17 > 0) {
                n18 -= n11;
            } else if (n8 > 0) {
                n18 -= n9;
            }
            rectangle3.x = rectangle3.x + (bl4 ? (n18 - rectangle3.width) / 2 : -(n18 - rectangle3.width) / 2);
        }
        return string;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = SyntheticaMenuItemUI.getContext(jComponent);
        this.paintBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        this.paintBorder(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        MenuPainter.getInstance(synthContext).paintMenuItemBackground(synthContext, graphics, n2, n3, n4, n5);
    }

    void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        MenuPainter.getInstance(synthContext).paintMenuItemBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paint(SyntheticaMenuItemUI.getMenuItemContext(jComponent), graphics);
    }

    private void paint(SynthContext synthContext, Graphics graphics) {
        JComponent jComponent = synthContext.getComponent();
        SynthStyle synthStyle = SyntheticaMenuItemUI.getStyle(jComponent);
        SynthContext synthContext2 = SyntheticaMenuItemUI.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String string = this.getPropertyPrefix();
        Icon icon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".arrowIcon");
        icon = SyntheticaLookAndFeel.getClientProperty("Synthetica.menuItem.arrowIcon", jComponent, icon);
        if ((synthContext.getComponentState() & 2) > 0) {
            icon = SyntheticaLookAndFeel.getClientProperty("Synthetica.menuItem.hover.arrowIcon", jComponent, icon);
        }
        SyntheticaMenuItemUI.paint(synthContext, synthContext2, graphics, synthStyle.getIcon(synthContext, String.valueOf(string) + ".checkIcon"), icon, false, this.acceleratorDelimiter, this.defaultTextIconGap);
    }

    static void paint(SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Icon icon, Icon icon2, boolean bl, String string, int n2) {
        int n3;
        FontMetrics fontMetrics;
        JComponent jComponent = synthContext.getComponent();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        SynthStyle synthStyle = synthContext.getStyle();
        ButtonModel buttonModel = jMenuItem.getModel();
        Insets insets = synthStyle.getInsets(synthContext, null);
        Insets insets2 = jMenuItem.getMargin();
        if (insets2 != null) {
            insets = new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
        }
        boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
        SyntheticaMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        SyntheticaMenuItemUI.viewRect.y += insets.top;
        SyntheticaMenuItemUI.viewRect.height += -insets.bottom - insets.top;
        if (!bl) {
            SyntheticaMenuItemUI.viewRect.x = SyntheticaMenuItemUI.viewRect.x + (bl2 ? insets.left : insets.right);
            SyntheticaMenuItemUI.viewRect.width += -insets.right - insets.left;
        }
        Font font = synthStyle.getFont(synthContext);
        graphics.setFont(font);
        FontMetrics fontMetrics2 = fontMetrics = graphics.getFontMetrics();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string2 = SyntheticaMenuItemUI.modifiersAsText(n4);
                string2 = String.valueOf(string2) + string;
            }
            string2 = (n3 = keyStroke.getKeyCode()) != 0 ? String.valueOf(string2) + KeyEvent.getKeyText(n3) : String.valueOf(string2) + keyStroke.getKeyChar();
        }
        String string3 = SyntheticaMenuItemUI.layoutMenuItem(synthContext, fontMetrics, synthContext2, jMenuItem.getText(), fontMetrics2, string2, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n2, n2, bl);
        if (icon != null && !bl) {
            SynthIcon.paintIcon((Icon)icon, (SynthContext)synthContext, (Graphics)graphics, (int)SyntheticaMenuItemUI.checkIconRect.x, (int)SyntheticaMenuItemUI.checkIconRect.y, (int)SyntheticaMenuItemUI.checkIconRect.width, (int)SyntheticaMenuItemUI.checkIconRect.height);
        }
        if (jComponent instanceof JMenu && synthContext.getRegion() != Region.MENU) {
            synthContext = SyntheticaMenuItemUI.getContext(jComponent, Region.MENU);
            synthStyle = synthContext.getStyle();
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3 = null;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
            } else if (buttonModel.isRollover() && buttonModel.isSelected()) {
                icon3 = jMenuItem.getRolloverSelectedIcon();
            } else if (buttonModel.isRollover()) {
                icon3 = jMenuItem.getRolloverIcon();
            } else if (buttonModel.isSelected()) {
                icon3 = jMenuItem.getSelectedIcon();
            }
            if (icon3 == null) {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                SynthIcon.paintIcon((Icon)icon3, (SynthContext)synthContext, (Graphics)graphics, (int)SyntheticaMenuItemUI.iconRect.x, (int)SyntheticaMenuItemUI.iconRect.y, (int)SyntheticaMenuItemUI.iconRect.width, (int)SyntheticaMenuItemUI.iconRect.height);
            }
        }
        if (string3 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                graphics.setFont(synthStyle.getFont(synthContext));
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string3, SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.textRect.y, jMenuItem.getDisplayedMnemonicIndex());
            }
        }
        if (string2 != null && !string2.equals("")) {
            n3 = 0;
            SynthStyle synthStyle2 = synthContext2.getStyle();
            graphics.setColor(synthStyle2.getColor(synthContext2, ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthStyle2.getFont(synthContext2));
            synthStyle2.getGraphicsUtils(synthContext2).paintText(synthContext2, graphics, string2, SyntheticaMenuItemUI.acceleratorRect.x - n3, SyntheticaMenuItemUI.acceleratorRect.y, -1);
        }
        if (icon2 != null && !bl) {
            SynthIcon.paintIcon((Icon)icon2, (SynthContext)synthContext, (Graphics)graphics, (int)SyntheticaMenuItemUI.arrowIconRect.x, (int)SyntheticaMenuItemUI.arrowIconRect.y, (int)SyntheticaMenuItemUI.arrowIconRect.width, (int)SyntheticaMenuItemUI.arrowIconRect.height);
        }
        if (paintDebugRects) {
            graphics.setColor(Color.ORANGE);
            graphics.drawRect(SyntheticaMenuItemUI.viewRect.x, SyntheticaMenuItemUI.viewRect.y, SyntheticaMenuItemUI.viewRect.width - 1, SyntheticaMenuItemUI.viewRect.height - 1);
            graphics.setColor(Color.RED);
            graphics.drawRect(SyntheticaMenuItemUI.checkIconRect.x, SyntheticaMenuItemUI.checkIconRect.y, SyntheticaMenuItemUI.checkIconRect.width - 1, SyntheticaMenuItemUI.checkIconRect.height - 1);
            graphics.setColor(Color.YELLOW);
            graphics.drawRect(SyntheticaMenuItemUI.iconRect.x, SyntheticaMenuItemUI.iconRect.y, SyntheticaMenuItemUI.iconRect.width - 1, SyntheticaMenuItemUI.iconRect.height - 1);
            graphics.setColor(Color.GREEN);
            graphics.drawRect(SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.textRect.y, SyntheticaMenuItemUI.textRect.width - 1, SyntheticaMenuItemUI.textRect.height - 1);
            graphics.setColor(Color.CYAN);
            graphics.drawRect(SyntheticaMenuItemUI.acceleratorRect.x, SyntheticaMenuItemUI.acceleratorRect.y, SyntheticaMenuItemUI.acceleratorRect.width - 1, SyntheticaMenuItemUI.acceleratorRect.height - 1);
            graphics.setColor(Color.BLUE);
            graphics.drawRect(SyntheticaMenuItemUI.arrowIconRect.x, SyntheticaMenuItemUI.arrowIconRect.y, SyntheticaMenuItemUI.arrowIconRect.width - 1, SyntheticaMenuItemUI.arrowIconRect.height - 1);
        }
    }

    private static String modifiersAsText(int n2) {
        if (OS.getCurrentOS() == OS.Mac && SyntheticaLookAndFeel.getBoolean("Synthetica.menuItem.useMacAcceleratorChars", null, false)) {
            return SyntheticaMenuItemUI.getMacKeyModifiersText(n2);
        }
        return SyntheticaMenuItemUI.getKeyModifiersText(n2);
    }

    private static String getAcceleratorDelimiter() {
        String string = UIManager.getString("MenuItem.acceleratorDelimiter");
        return string == null ? "+" : string;
    }

    private static String getKeyModifiersText(int n2) {
        String string = SyntheticaMenuItemUI.getAcceleratorDelimiter();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 4) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.meta", "Meta")) + string);
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.control", "Ctrl")) + string);
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.alt", "Alt")) + string);
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.shift", "Shift")) + string);
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.altGraph", "Alt Graph")) + string);
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.button1", "Button1")) + string);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - string.length());
        }
        return stringBuffer.toString();
    }

    private static String getMacKeyModifiersText(int n2) {
        String string = SyntheticaMenuItemUI.getAcceleratorDelimiter();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 2) != 0) {
            stringBuffer.append("\u2303" + string);
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("\u21e7" + string);
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("\u2325" + string);
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.altGraph", "Alt Graph")) + string);
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("\u2318" + string);
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append(String.valueOf(Toolkit.getProperty("AWT.button1", "Button1")) + string);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - string.length());
        }
        return stringBuffer.toString();
    }

    public static void resetPopupMenu(JPopupMenu jPopupMenu) {
        maxWidths.remove(jPopupMenu);
    }

    static SynthContext getMenuItemContext(JComponent jComponent) {
        boolean bl = jComponent instanceof JMenu && ((JMenu)jComponent).isTopLevelMenu();
        Region region = bl ? Region.MENU : Region.MENU_ITEM;
        return SyntheticaMenuItemUI.getContext(jComponent, region);
    }

    static SynthStyle getStyle(JComponent jComponent) {
        return SynthLookAndFeel.getStyle(jComponent, SyntheticaMenuItemUI.getRegion(jComponent));
    }

    static SynthContext getContext(JComponent jComponent) {
        return SyntheticaMenuItemUI.getContext(jComponent, SyntheticaMenuItemUI.getComponentState(jComponent));
    }

    static SynthContext getContext(JComponent jComponent, int n2) {
        return SyntheticaMenuItemUI.getContext(jComponent, SyntheticaMenuItemUI.getRegion(jComponent), n2);
    }

    static SynthContext getContext(JComponent jComponent, Region region) {
        return SyntheticaMenuItemUI.getContext(jComponent, region, SyntheticaMenuItemUI.getComponentState(jComponent));
    }

    private static SynthContext getContext(JComponent jComponent, Region region, int n2) {
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(jComponent, region);
        SynthContext synthContext = new SynthContext(jComponent, region, synthStyle, n2);
        return synthContext;
    }

    private static Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private static int getComponentState(JComponent jComponent) {
        int n2 = 0;
        n2 = !jComponent.isEnabled() ? 8 : (((JMenuItem)jComponent).isArmed() ? 2 : (jComponent.isEnabled() ? (jComponent.isFocusOwner() ? 257 : 1) : 8));
        if (((JMenuItem)jComponent).isSelected()) {
            n2 |= 0x200;
        }
        return n2;
    }

    private static JPopupMenu findPopup(Container container) {
        return (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, container);
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SyntheticaLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenuItem)propertyChangeEvent.getSource());
        } else if ("Synthetica.menuItem.arrowIcon".equals(string)) {
            this.menuItem.updateUI();
        } else if (("text".equals(string) || "icon".equals(string)) && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.dynamicItemSupport", null)) {
            SyntheticaMenuItemUI.resetPopupMenu(SyntheticaMenuItemUI.findPopup((JMenuItem)propertyChangeEvent.getSource()));
        }
    }

    private static class MaxWidth {
        int maxTextWidth;
        int maxAcceleratorWidth;
        int maxIconWidth;
        int maxCheckIconWidth;
        int maxArrowIconWidth;

        private MaxWidth() {
        }

        public void clear() {
            this.maxTextWidth = 0;
            this.maxAcceleratorWidth = 0;
            this.maxIconWidth = 0;
            this.maxCheckIconWidth = 0;
            this.maxArrowIconWidth = 0;
        }
    }
}

