/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;

public class SeparatorPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SeparatorPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected SeparatorPainter() {
    }

    public static SeparatorPainter getInstance() {
        return SeparatorPainter.getInstance(null);
    }

    public static SeparatorPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(SeparatorPainter.getPainterClassName(synthContext, SeparatorPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = SeparatorPainter.getInstance(synthContext, SeparatorPainter.class, UI_KEY);
        }
        return (SeparatorPainter)syntheticaComponentPainter;
    }

    public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.getParent() instanceof JPopupMenu || jComponent instanceof JPopupMenu.Separator) {
            Insets insets;
            int n6;
            JPopupMenu jPopupMenu = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, jComponent);
            Insets insets2 = jPopupMenu.getInsets();
            String string = "Synthetica.popupMenuSeparator";
            string = SyntheticaLookAndFeel.getString(string, jPopupMenu);
            boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.iconSeparator.clip", jPopupMenu, true);
            if (bl && (SyntheticaLookAndFeel.preservePopupIconSpace(jPopupMenu) || SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu)) {
                boolean bl2 = jPopupMenu.getComponentOrientation().isLeftToRight();
                int n7 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenuSeparator.iconSeparatorGap", jPopupMenu);
                n6 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", jPopupMenu, 24);
                Integer n8 = (Integer)jPopupMenu.getClientProperty("Synthetica.menuItem.maxIconWidth");
                if (n8 != null && n8 > 16) {
                    n6 += n8 - 16;
                }
                int n9 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", jPopupMenu, 1);
                int n10 = n6 + n9 + n7 - insets2.left;
                n2 += bl2 ? n10 : 0;
                n4 -= n10;
            }
            Insets insets3 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenuSeparator.insets", (Component)jPopupMenu, false);
            n6 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.horizontalTiled", jPopupMenu)) {
                n6 = 1;
            }
            int n11 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.verticalTiled", jPopupMenu)) {
                n11 = 1;
            }
            ImagePainter imagePainter = new ImagePainter(graphics, n2, n3, n4, n5, string, insets, insets3, n6, n11);
            imagePainter.draw();
        }
    }

    public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        Insets insets;
        String string = "Synthetica.separator";
        JComponent jComponent = synthContext.getComponent();
        Insets insets2 = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets3 = jComponent.getInsets();
        n4 -= insets3.left + insets3.right - insets2.left - insets2.right;
        n5 -= insets3.top + insets3.bottom - insets2.top - insets2.bottom;
        n2 += insets3.left - insets2.left;
        n3 += insets3.top - insets2.top;
        boolean bl = jComponent instanceof JToolBar.Separator;
        if (bl) {
            string = String.valueOf(string) + ".toolBar";
        } else if (jComponent.getParent() instanceof JComponent && (((JComponent)jComponent.getParent()).getUIClassID().equals("StatusBarUI") || "StatusBar".equals(SyntheticaLookAndFeel.getStyleName(jComponent.getParent())))) {
            string = String.valueOf(string) + ".statusBar";
        }
        string = String.valueOf(string) + ".image";
        string = n6 == 0 ? String.valueOf(string) + ".x" : String.valueOf(string) + ".y";
        UIKey uIKey = new UIKey(string, new SyntheticaState(0), "");
        Insets insets4 = insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 1);
        string = SyntheticaLookAndFeel.getString(string, jComponent);
        if (bl) {
            if (string == null) {
                return;
            }
            Image image = imgCache.get(string);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
                imgCache.put(string, image);
            }
            this.adjustToolBarSeparatorSize((JToolBar.Separator)jComponent, image.getWidth(null), image.getHeight(null));
        }
        int n8 = bl ? 0 : (Integer)synthContext.getStyle().get(synthContext, "Separator.thickness");
        int n9 = n6 == 0 || bl ? n4 : n8;
        int n10 = n7 = n6 == 1 || bl ? n5 : n8;
        if (string == null) {
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(n2, n3, n9, n7);
        } else {
            ImagePainter imagePainter = new ImagePainter(jComponent, 1, 50, 0, 0, graphics, n2, n3, n4, n5, string, insets, insets4, 0, 0);
            imagePainter.draw();
        }
    }

    protected void adjustToolBarSeparatorSize(JToolBar.Separator separator, int n2, int n3) {
        if (SyntheticaLookAndFeel.getToolbarSeparatorDimension() == null) {
            Serializable serializable;
            int n4 = 0;
            int n5 = 0;
            Component[] componentArray = separator.getParent().getComponents();
            int n6 = componentArray.length;
            int n7 = 0;
            while (n7 < n6) {
                serializable = componentArray[n7];
                if (!(serializable instanceof JToolBar.Separator)) {
                    if (((Component)serializable).getMinimumSize().width > n4) {
                        n4 = ((Component)serializable).getMinimumSize().width;
                    }
                    if (((Component)serializable).getMinimumSize().height > n5) {
                        n5 = ((Component)serializable).getMinimumSize().height;
                    }
                }
                ++n7;
            }
            serializable = null;
            serializable = separator.getOrientation() == 1 ? new DimensionUIResource(n2, n5) : new DimensionUIResource(n4, n3);
            if (!((Dimension)serializable).equals(separator.getSize())) {
                separator.setSeparatorSize((Dimension)serializable);
                separator.revalidate();
            }
        }
    }
}

