/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.VirtualUniverse;

public class Alpha
extends NodeComponent {
    private int loopCount;
    public static final int INCREASING_ENABLE = 1;
    public static final int DECREASING_ENABLE = 2;
    private int mode;
    private float triggerTime;
    private float phaseDelay;
    private float increasingAlpha;
    private long increasingAlphaRamp;
    private float incAlphaRampInternal;
    private float alphaAtOne;
    private float decreasingAlpha;
    private long decreasingAlphaRamp;
    private float decAlphaRampInternal;
    private float alphaAtZero;
    private long pauseTime = 0L;
    private boolean paused = false;
    private float stopTime;
    private long startTime = MasterControl.systemStartTime;

    public Alpha() {
        this.loopCount = -1;
        this.mode = 1;
        this.increasingAlpha = 1.0f;
    }

    public Alpha(int n2, int n3, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        this.loopCount = n2;
        this.mode = n3;
        this.triggerTime = (float)l2 * 0.001f;
        this.phaseDelay = (float)l3 * 0.001f;
        this.increasingAlpha = (float)l4 * 0.001f;
        this.alphaAtOne = (float)l6 * 0.001f;
        this.increasingAlphaRamp = l5;
        this.incAlphaRampInternal = (float)l5 * 0.001f;
        if (this.incAlphaRampInternal > 0.5f * this.increasingAlpha) {
            this.incAlphaRampInternal = 0.5f * this.increasingAlpha;
        }
        this.decreasingAlpha = (float)l7 * 0.001f;
        this.alphaAtZero = (float)l9 * 0.001f;
        this.decreasingAlphaRamp = l8;
        this.decAlphaRampInternal = (float)l8 * 0.001f;
        if (this.decAlphaRampInternal > 0.5f * this.decreasingAlpha) {
            this.decAlphaRampInternal = 0.5f * this.decreasingAlpha;
        }
        this.computeStopTime();
    }

    public Alpha(int n2, long l2, long l3, long l4, long l5, long l6) {
        this(n2, 1, l2, l3, l4, l5, l6, 0L, 0L, 0L);
    }

    public Alpha(int n2, long l2) {
        this.mode = 1;
        this.increasingAlpha = (float)l2 * 0.001f;
        this.loopCount = n2;
        if (n2 >= 0) {
            this.stopTime = (float)n2 * this.increasingAlpha;
        }
    }

    public void pause() {
        this.pause(J3dClock.currentTimeMillis());
    }

    public void pause(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Alpha0"));
        }
        this.paused = true;
        this.pauseTime = l2;
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public void resume() {
        this.resume(J3dClock.currentTimeMillis());
    }

    public void resume(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Alpha0"));
        }
        if (this.paused) {
            long l3 = this.startTime + l2 - this.pauseTime;
            this.paused = false;
            this.pauseTime = 0L;
            this.setStartTime(l3);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public float value() {
        long l2 = this.paused ? this.pauseTime : J3dClock.currentTimeMillis();
        return this.value(l2);
    }

    public float value(long l2) {
        float f2 = (float)(l2 - this.startTime) * 0.001f;
        if ((this.mode & 1) != 0 && (this.mode & 2) == 0) {
            if (f2 <= this.triggerTime + this.phaseDelay) {
                return 0.0f;
            }
            if (this.loopCount != -1 && f2 >= this.stopTime) {
                return 1.0f;
            }
            if (this.incAlphaRampInternal == 0.0f) {
                float f3 = this.mfmod(f2 - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne), this.increasingAlpha + this.alphaAtOne) / this.increasingAlpha;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                return f3;
            }
            float f4 = this.incAlphaRampInternal;
            float f5 = this.mfmod(f2 - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne), this.increasingAlpha + this.alphaAtOne);
            if (f5 >= this.increasingAlpha) {
                float f6 = 1.0f;
                return f6;
            }
            float f7 = 1.0f / (this.increasingAlpha * f4 - f4 * f4);
            float f8 = f5 < f4 ? 0.5f * f7 * f5 * f5 : (f5 < this.increasingAlpha - f4 ? 0.5f * f7 * f4 * f4 + (f5 - f4) * f7 * f4 : f7 * f4 * f4 + (this.increasingAlpha - 2.0f * f4) * f7 * f4 - 0.5f * f7 * (this.increasingAlpha - f5) * (this.increasingAlpha - f5));
            return f8;
        }
        if ((this.mode & 1) == 0 && (this.mode & 2) != 0) {
            if (f2 <= this.triggerTime + this.phaseDelay) {
                return 1.0f;
            }
            if (this.loopCount != -1 && f2 >= this.stopTime) {
                return 0.0f;
            }
            if (this.decAlphaRampInternal == 0.0f) {
                float f9 = this.mfmod(f2 - this.triggerTime - this.phaseDelay + 6.0f * (this.decreasingAlpha + this.alphaAtZero), this.decreasingAlpha + this.alphaAtZero) / this.decreasingAlpha;
                if (f9 > 1.0f) {
                    f9 = 0.0f;
                    return f9;
                }
                f9 = 1.0f - f9;
                return f9;
            }
            float f10 = this.decAlphaRampInternal;
            float f11 = this.mfmod(f2 - this.triggerTime - this.phaseDelay + 6.0f * (this.decreasingAlpha + this.alphaAtZero), this.decreasingAlpha + this.alphaAtZero);
            if (f11 >= this.decreasingAlpha) {
                float f12 = 0.0f;
                return f12;
            }
            float f13 = 1.0f / (this.decreasingAlpha * f10 - f10 * f10);
            float f14 = f11 < f10 ? 0.5f * f13 * f11 * f11 : (f11 < this.decreasingAlpha - f10 ? 0.5f * f13 * f10 * f10 + (f11 - f10) * f13 * f10 : f13 * f10 * f10 + (this.decreasingAlpha - 2.0f * f10) * f13 * f10 - 0.5f * f13 * (this.decreasingAlpha - f11) * (this.decreasingAlpha - f11));
            f14 = 1.0f - f14;
            return f14;
        }
        if ((this.mode & 1) != 0 && (this.mode & 2) != 0) {
            float f15;
            if (f2 <= this.triggerTime + this.phaseDelay) {
                return 0.0f;
            }
            if (this.loopCount != -1 && f2 >= this.stopTime) {
                return 0.0f;
            }
            if (this.incAlphaRampInternal == 0.0f && this.decAlphaRampInternal == 0.0f) {
                float f16 = this.mfmod(f2 - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero), this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero);
                float f17 = f16 / this.increasingAlpha;
                if (f17 < 1.0f) {
                    return f17;
                }
                if ((f16 -= this.increasingAlpha) < this.alphaAtOne) {
                    f17 = 1.0f;
                    return f17;
                }
                f17 = (f16 -= this.alphaAtOne) / this.decreasingAlpha;
                f17 = f17 < 1.0f ? 1.0f - f17 : 0.0f;
                return f17;
            }
            float f18 = this.incAlphaRampInternal;
            if (f18 == 0.0f) {
                f18 = 1.0E-5f;
            }
            if ((f15 = this.mfmod(f2 - this.triggerTime - this.phaseDelay + 6.0f * (this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero), this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha + this.alphaAtZero)) <= this.increasingAlpha) {
                float f19 = 1.0f / (this.increasingAlpha * f18 - f18 * f18);
                float f20 = f15 < f18 ? 0.5f * f19 * f15 * f15 : (f15 < this.increasingAlpha - f18 ? 0.5f * f19 * f18 * f18 + (f15 - f18) * f19 * f18 : f19 * f18 * f18 + (this.increasingAlpha - 2.0f * f18) * f19 * f18 - 0.5f * f19 * (this.increasingAlpha - f15) * (this.increasingAlpha - f15));
                return f20;
            }
            if (f15 <= this.increasingAlpha + this.alphaAtOne) {
                float f21 = 1.0f;
                return f21;
            }
            if (f15 >= this.increasingAlpha + this.alphaAtOne + this.decreasingAlpha) {
                float f22 = 0.0f;
                return f22;
            }
            f15 -= this.increasingAlpha + this.alphaAtOne;
            f18 = this.decAlphaRampInternal;
            if (f18 == 0.0f) {
                f18 = 1.0E-5f;
            }
            float f23 = 1.0f / (this.decreasingAlpha * f18 - f18 * f18);
            float f24 = f15 < f18 ? 0.5f * f23 * f15 * f15 : (f15 < this.decreasingAlpha - f18 ? 0.5f * f23 * f18 * f18 + (f15 - f18) * f23 * f18 : f23 * f18 * f18 + (this.decreasingAlpha - 2.0f * f18) * f23 * f18 - 0.5f * f23 * (this.decreasingAlpha - f15) * (this.decreasingAlpha - f15));
            f24 = 1.0f - f24;
            return f24;
        }
        return 0.0f;
    }

    float mfmod(float f2, float f3) {
        float f4 = f2;
        float f5 = f3;
        if (f5 < 0.0f) {
            f5 = -f5;
        }
        if (f4 < 0.0f) {
            f4 = -f4;
        }
        int n2 = (int)(f4 / f5);
        float f6 = f4 - (float)n2 * f5;
        if (f2 < 0.0f) {
            return f3 - f6;
        }
        return f6;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l2) {
        this.startTime = l2;
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int n2) {
        this.loopCount = n2;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n2) {
        this.mode = n2;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getTriggerTime() {
        return (long)(this.triggerTime * 1000.0f);
    }

    public void setTriggerTime(long l2) {
        this.triggerTime = (float)l2 * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getPhaseDelayDuration() {
        return (long)(this.phaseDelay * 1000.0f);
    }

    public void setPhaseDelayDuration(long l2) {
        this.phaseDelay = (float)l2 * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getIncreasingAlphaDuration() {
        return (long)(this.increasingAlpha * 1000.0f);
    }

    public void setIncreasingAlphaDuration(long l2) {
        this.increasingAlpha = (float)l2 * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getIncreasingAlphaRampDuration() {
        return this.increasingAlphaRamp;
    }

    public void setIncreasingAlphaRampDuration(long l2) {
        this.increasingAlphaRamp = l2;
        this.incAlphaRampInternal = (float)l2 * 0.001f;
        if (this.incAlphaRampInternal > 0.5f * this.increasingAlpha) {
            this.incAlphaRampInternal = 0.5f * this.increasingAlpha;
        }
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getAlphaAtOneDuration() {
        return (long)(this.alphaAtOne * 1000.0f);
    }

    public void setAlphaAtOneDuration(long l2) {
        this.alphaAtOne = (float)l2 * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getDecreasingAlphaDuration() {
        return (long)(this.decreasingAlpha * 1000.0f);
    }

    public void setDecreasingAlphaDuration(long l2) {
        this.decreasingAlpha = (float)l2 * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getDecreasingAlphaRampDuration() {
        return this.decreasingAlphaRamp;
    }

    public void setDecreasingAlphaRampDuration(long l2) {
        this.decreasingAlphaRamp = l2;
        this.decAlphaRampInternal = (float)l2 * 0.001f;
        if (this.decAlphaRampInternal > 0.5f * this.decreasingAlpha) {
            this.decAlphaRampInternal = 0.5f * this.decreasingAlpha;
        }
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public long getAlphaAtZeroDuration() {
        return (long)(this.alphaAtZero * 1000.0f);
    }

    public void setAlphaAtZeroDuration(long l2) {
        this.alphaAtZero = (float)l2 * 0.001f;
        this.computeStopTime();
        VirtualUniverse.mc.sendRunMessage(16);
    }

    public boolean finished() {
        long l2 = this.paused ? this.pauseTime : J3dClock.currentTimeMillis();
        return this.loopCount != -1 && (float)(l2 - this.startTime) * 0.001f > this.stopTime;
    }

    private final void computeStopTime() {
        if (this.loopCount >= 0) {
            float f2 = 0.0f;
            if ((this.mode & 1) != 0) {
                f2 = this.increasingAlpha + this.alphaAtOne;
            }
            if ((this.mode & 2) != 0) {
                f2 += this.decreasingAlpha + this.alphaAtZero;
            }
            this.stopTime = this.triggerTime + this.phaseDelay + (float)this.loopCount * f2;
        } else {
            this.stopTime = 0.0f;
        }
    }

    Alpha cloneAlpha() {
        Alpha alpha = new Alpha();
        alpha.setStartTime(this.getStartTime());
        alpha.setLoopCount(this.getLoopCount());
        alpha.setMode(this.getMode());
        alpha.setTriggerTime(this.getTriggerTime());
        alpha.setPhaseDelayDuration(this.getPhaseDelayDuration());
        alpha.setIncreasingAlphaDuration(this.getIncreasingAlphaDuration());
        alpha.setIncreasingAlphaRampDuration(this.getIncreasingAlphaRampDuration());
        alpha.setAlphaAtOneDuration(this.getAlphaAtOneDuration());
        alpha.setDecreasingAlphaDuration(this.getDecreasingAlphaDuration());
        alpha.setDecreasingAlphaRampDuration(this.getDecreasingAlphaRampDuration());
        alpha.setAlphaAtZeroDuration(this.getAlphaAtZeroDuration());
        return alpha;
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

