/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BHInsertStructure;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderBin;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.UnorderList;
import javax.vecmath.Point4d;

class BHTree {
    Locale locale;
    private BHNode root;
    private BHInsertStructure insertStructure = null;
    Point4d tPoint4d = new Point4d();
    private boolean stable = false;
    int estMaxDepth;
    static final double LOG_OF_2 = Math.log(2.0);
    static final int DEPTH_UPPER_BOUND = 56;
    static final int INCR_DEPTH_BOUND = 5;
    int depthUpperBound = 56;

    BHTree() {
        this.locale = null;
        this.root = null;
    }

    BHTree(Locale locale) {
        this.locale = locale;
        this.root = null;
    }

    BHTree(BHNode[] bHNodeArray) {
        this.locale = null;
        this.root = null;
        this.create(bHNodeArray);
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    void cluster(BHInternalNode bHInternalNode, BHNode[] bHNodeArray) {
        if (bHNodeArray == null || bHNodeArray.length < 2 || bHInternalNode == null) {
            return;
        }
        int[] nArray = new int[bHNodeArray.length];
        float[][] fArray = this.computeCenterValues(bHNodeArray, nArray);
        this.constructTree(bHInternalNode, bHNodeArray, fArray, nArray);
    }

    void boundsChanged(BHNode[] bHNodeArray, int n2) {
        this.markParentChain(bHNodeArray, n2);
        this.root.updateMarkedBoundingHull();
    }

    boolean getVisibleBHTrees(RenderBin renderBin, ArrayList arrayList, BoundingBox boundingBox, long l2, boolean bl, int n2, boolean bl2) {
        if (boundingBox != null && this.root != null) {
            boolean bl3 = BHTree.aEncompassB(boundingBox, this.root.bHull);
            if (bl2 && !bl && bl3 && this.stable) {
                arrayList.add(this.root);
                return true;
            }
            if (!bl && bl3) {
                this.select(renderBin, arrayList, boundingBox, this.root, l2, n2, true);
                arrayList.add(this.root);
                this.stable = true;
            } else {
                this.select(renderBin, arrayList, boundingBox, this.root, l2, n2, false);
                this.stable = false;
            }
        }
        return false;
    }

    private void select(RenderBin renderBin, ArrayList arrayList, BoundingBox boundingBox, BHNode bHNode, long l2, int n2, boolean bl) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return;
        }
        switch (bHNode.nodeType) {
            case 2: {
                if (!(((BHLeafNode)bHNode).leafIF instanceof GeometryAtom) || !((BHLeafNode)bHNode).isEnable(n2) || !bl && !boundingBox.intersect(bHNode.bHull)) break;
                renderBin.processGeometryAtom((GeometryAtom)((BHLeafNode)bHNode).leafIF, l2);
                if (bl) break;
                arrayList.add(bHNode);
                break;
            }
            case 1: {
                if (bl) {
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getRightChild(), l2, n2, true);
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getLeftChild(), l2, n2, true);
                    break;
                }
                if (BHTree.aEncompassB(boundingBox, bHNode.bHull)) {
                    arrayList.add(bHNode);
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getRightChild(), l2, n2, true);
                    this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getLeftChild(), l2, n2, true);
                    break;
                }
                if (!boundingBox.intersect(bHNode.bHull)) break;
                this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getRightChild(), l2, n2, false);
                this.select(renderBin, arrayList, boundingBox, ((BHInternalNode)bHNode).getLeftChild(), l2, n2, false);
            }
        }
    }

    static boolean aEncompassB(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return boundingBox.upper.x >= boundingBox2.upper.x && boundingBox.upper.y >= boundingBox2.upper.y && boundingBox.upper.z >= boundingBox2.upper.z && boundingBox.lower.x <= boundingBox2.lower.x && boundingBox.lower.y <= boundingBox2.lower.y && boundingBox.lower.z <= boundingBox2.lower.z;
    }

    BHLeafInterface selectAny(GeometryAtom geometryAtom, int n2) {
        if (geometryAtom.source.geometryList == null) {
            return null;
        }
        BHNode bHNode = this.doSelectAny(geometryAtom, this.root, n2);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    BHLeafInterface selectAny(GeometryAtom[] geometryAtomArray, int n2, int n3) {
        BHNode bHNode = this.doSelectAny(geometryAtomArray, n2, this.root, n3);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    private BHNode doSelectAny(GeometryAtom[] geometryAtomArray, int n2, BHNode bHNode, int n3) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && geometryAtom.source.isCollidable) {
                        int n4;
                        for (n4 = n2 - 1; n4 >= 0; --n4) {
                            if (geometryAtomArray[n4] != geometryAtom) continue;
                            return null;
                        }
                        for (n4 = n2 - 1; n4 >= 0; --n4) {
                            GeometryAtom geometryAtom2 = geometryAtomArray[n4];
                            if (geometryAtom2.source.sourceNode == geometryAtom.source.sourceNode || !geometryAtom2.source.collisionVwcBound.intersect(geometryAtom.source.collisionVwcBound) || n3 != 11 && (geometryAtom.source.geometryList == null || !geometryAtom2.source.intersectGeometryList(geometryAtom.source))) continue;
                            return bHNode;
                        }
                    }
                } else if (bHLeafInterface instanceof GroupRetained && ((BHLeafNode)bHNode).isEnable() && ((GroupRetained)bHLeafInterface).sourceNode.collidable) {
                    for (int i2 = n2 - 1; i2 >= 0; --i2) {
                        GeometryAtom geometryAtom = geometryAtomArray[i2];
                        if (!geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull) || n3 != 11 && !geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bHNode.bHull)) continue;
                        return bHNode;
                    }
                }
                return null;
            }
            case 1: {
                for (int i3 = n2 - 1; i3 >= 0; --i3) {
                    GeometryAtom geometryAtom = geometryAtomArray[i3];
                    if (!geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull)) continue;
                    BHNode bHNode2 = this.doSelectAny(geometryAtomArray, n2, ((BHInternalNode)bHNode).getRightChild(), n3);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(geometryAtomArray, n2, ((BHInternalNode)bHNode).getLeftChild(), n3);
                }
                return null;
            }
        }
        return null;
    }

    private BHNode doSelectAny(GeometryAtom geometryAtom, BHNode bHNode, int n2) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom2 = (GeometryAtom)bHLeafInterface;
                    if (geometryAtom.source.sourceNode != geometryAtom2.source.sourceNode && ((BHLeafNode)bHNode).isEnable() && geometryAtom2.source.isCollidable && geometryAtom.source.collisionVwcBound.intersect(geometryAtom2.source.collisionVwcBound) && (n2 == 11 || geometryAtom2.source.geometryList != null && geometryAtom.source.intersectGeometryList(geometryAtom2.source))) {
                        return bHNode;
                    }
                } else if (bHLeafInterface instanceof GroupRetained && ((BHLeafNode)bHNode).isEnable() && ((GroupRetained)bHLeafInterface).sourceNode.collidable && geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull) && (n2 == 11 || geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bHNode.bHull))) {
                    return bHNode;
                }
                return null;
            }
            case 1: {
                if (geometryAtom.source.collisionVwcBound.intersect(bHNode.bHull)) {
                    BHNode bHNode2 = this.doSelectAny(geometryAtom, ((BHInternalNode)bHNode).getRightChild(), n2);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(geometryAtom, ((BHInternalNode)bHNode).getLeftChild(), n2);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bounds, int n2, NodeRetained nodeRetained) {
        if (bounds == null) {
            return null;
        }
        BHNode bHNode = this.doSelectAny(bounds, this.root, n2, nodeRetained);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bounds, BHNode bHNode, int n2, NodeRetained nodeRetained) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && geometryAtom.source.isCollidable && bounds.intersect(geometryAtom.source.collisionVwcBound) && (n2 == 11 || geometryAtom.source.geometryList != null && geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bounds))) {
                        return bHNode;
                    }
                } else if (bHLeafInterface instanceof GroupRetained && bHLeafInterface != nodeRetained && ((BHLeafNode)bHNode).isEnable() && ((GroupRetained)bHLeafInterface).sourceNode.collidable && bounds.intersect(bHNode.bHull)) {
                    return bHNode;
                }
                return null;
            }
            case 1: {
                if (bounds.intersect(bHNode.bHull)) {
                    BHNode bHNode2 = this.doSelectAny(bounds, ((BHInternalNode)bHNode).getRightChild(), n2, nodeRetained);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(bounds, ((BHInternalNode)bHNode).getLeftChild(), n2, nodeRetained);
                }
                return null;
            }
        }
        return null;
    }

    BHLeafInterface selectAny(Bounds bounds, int n2, GroupRetained groupRetained) {
        if (bounds == null) {
            return null;
        }
        BHNode bHNode = this.doSelectAny(bounds, this.root, n2, groupRetained);
        if (bHNode == null) {
            return null;
        }
        return ((BHLeafNode)bHNode).leafIF;
    }

    private BHNode doSelectAny(Bounds bounds, BHNode bHNode, int n2, GroupRetained groupRetained) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                BHLeafInterface bHLeafInterface = ((BHLeafNode)bHNode).leafIF;
                if (bHLeafInterface instanceof GeometryAtom) {
                    GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && geometryAtom.source.isCollidable && bounds.intersect(geometryAtom.source.collisionVwcBound) && !this.isDescendent(geometryAtom.source.sourceNode, groupRetained, geometryAtom.source.key) && (n2 == 11 || geometryAtom.source.geometryList != null && geometryAtom.source.intersectGeometryList(geometryAtom.source.getCurrentLocalToVworld(0), bounds))) {
                        return bHNode;
                    }
                } else if (bHLeafInterface instanceof GroupRetained) {
                    GroupRetained groupRetained2 = (GroupRetained)bHLeafInterface;
                    if (((BHLeafNode)bHNode).isEnable() && groupRetained2.sourceNode.collidable && bounds.intersect(bHNode.bHull) && !this.isDescendent(groupRetained2.sourceNode, groupRetained, groupRetained2.key)) {
                        return bHNode;
                    }
                }
                return null;
            }
            case 1: {
                if (bounds.intersect(bHNode.bHull)) {
                    BHNode bHNode2 = this.doSelectAny(bounds, ((BHInternalNode)bHNode).getRightChild(), n2, groupRetained);
                    if (bHNode2 != null) {
                        return bHNode2;
                    }
                    return this.doSelectAny(bounds, ((BHInternalNode)bHNode).getLeftChild(), n2, groupRetained);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDescendent(NodeRetained nodeRetained, GroupRetained groupRetained, HashKey hashKey) {
        Object object = groupRetained.universe.sceneGraphLock;
        synchronized (object) {
            if (nodeRetained.inSharedGroup && hashKey != null) {
                hashKey = new HashKey(hashKey);
            }
            do {
                if (nodeRetained == groupRetained) {
                    return true;
                }
                if (!(nodeRetained instanceof SharedGroupRetained)) continue;
                String string = hashKey.getLastNodeId();
                NodeRetained nodeRetained2 = nodeRetained;
                Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
                    NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(i2);
                    if (!nodeRetained3.nodeId.equals(string)) continue;
                    nodeRetained = nodeRetained3;
                    break;
                }
                if (nodeRetained2 != nodeRetained) continue;
                return true;
            } while ((nodeRetained = nodeRetained.parent) != null);
        }
        return false;
    }

    void select(PickShape pickShape, UnorderList unorderList) {
        if (pickShape == null || this.root == null) {
            return;
        }
        this.doSelect(pickShape, unorderList, this.root, this.tPoint4d);
    }

    private void doSelect(PickShape pickShape, UnorderList unorderList, BHNode bHNode, Point4d point4d) {
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return;
        }
        switch (bHNode.nodeType) {
            case 2: {
                if (!((BHLeafNode)bHNode).isEnable() || !(((BHLeafNode)bHNode).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bHNode).leafIF).source.isPickable || !pickShape.intersect(bHNode.bHull, point4d)) break;
                unorderList.add(bHNode);
                break;
            }
            case 1: {
                if (!pickShape.intersect(bHNode.bHull, point4d)) break;
                this.doSelect(pickShape, unorderList, ((BHInternalNode)bHNode).getRightChild(), point4d);
                this.doSelect(pickShape, unorderList, ((BHInternalNode)bHNode).getLeftChild(), point4d);
            }
        }
    }

    BHNode selectAny(PickShape pickShape) {
        if (pickShape == null || this.root == null) {
            return null;
        }
        return this.doSelectAny(pickShape, this.root, this.tPoint4d);
    }

    private BHNode doSelectAny(PickShape pickShape, BHNode bHNode, Point4d point4d) {
        BHNode bHNode2 = null;
        if (bHNode == null || bHNode.bHull.isEmpty()) {
            return null;
        }
        switch (bHNode.nodeType) {
            case 2: {
                if (!((BHLeafNode)bHNode).isEnable() || !(((BHLeafNode)bHNode).leafIF instanceof GeometryAtom) || !((GeometryAtom)((BHLeafNode)bHNode).leafIF).source.isPickable || !pickShape.intersect(bHNode.bHull, point4d)) break;
                return bHNode;
            }
            case 1: {
                if (!pickShape.intersect(bHNode.bHull, point4d)) break;
                bHNode2 = this.doSelectAny(pickShape, ((BHInternalNode)bHNode).getRightChild(), point4d);
                if (bHNode2 != null) {
                    return bHNode2;
                }
                return this.doSelectAny(pickShape, ((BHInternalNode)bHNode).getLeftChild(), point4d);
            }
        }
        return null;
    }

    private void create(BHNode[] bHNodeArray) {
        if (bHNodeArray == null) {
            this.root = null;
            return;
        }
        if (bHNodeArray.length == 1) {
            bHNodeArray[0].computeBoundingHull();
            this.root = bHNodeArray[0];
            return;
        }
        int[] nArray = new int[bHNodeArray.length];
        float[][] fArray = this.computeCenterValues(bHNodeArray, nArray);
        this.root = new BHInternalNode();
        this.constructTree((BHInternalNode)this.root, bHNodeArray, fArray, nArray);
    }

    void insert(BHNode[] bHNodeArray, int n2) {
        int n3;
        if (bHNodeArray == null || n2 < 1 || bHNodeArray.length < 1) {
            return;
        }
        if (this.root == null) {
            BHNode[] bHNodeArray2 = new BHNode[n2];
            System.arraycopy(bHNodeArray, 0, bHNodeArray2, 0, n2);
            this.create(bHNodeArray2);
            return;
        }
        if (this.root.nodeType == 2) {
            BHNode[] bHNodeArray3 = bHNodeArray;
            bHNodeArray = new BHNode[n2 + 1];
            System.arraycopy(bHNodeArray3, 0, bHNodeArray, 0, n2);
            bHNodeArray[n2] = this.root;
            this.create(bHNodeArray);
            return;
        }
        if (this.insertStructure == null) {
            this.insertStructure = new BHInsertStructure(n2);
        } else {
            this.insertStructure.clear();
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.root.isInside(bHNodeArray[n3].bHull)) {
                ((BHInternalNode)this.root).insert(bHNodeArray[n3], this.insertStructure);
                continue;
            }
            this.root.bHull.combine(bHNodeArray[n3].bHull);
            this.insertStructure.lookupAndInsert(this.root, bHNodeArray[n3]);
        }
        this.insertStructure.updateBoundingTree(this);
        this.insertStructure.clear();
        this.estMaxDepth += (int)(Math.log(n2) / LOG_OF_2) + 1;
        if (this.estMaxDepth > this.depthUpperBound) {
            n3 = this.root.computeMaxDepth(0);
            int n4 = this.root.countNumberOfLeaves();
            double d2 = Math.log(n4) / LOG_OF_2;
            if (n3 > this.depthUpperBound) {
                this.reConstructTree(n4);
                n3 = this.root.computeMaxDepth(0);
            }
            if (n3 > this.depthUpperBound) {
                this.depthUpperBound += 5;
            } else if (this.depthUpperBound != 56 && (double)n3 * 1.5 < (double)this.depthUpperBound) {
                this.depthUpperBound -= 5;
                if (this.depthUpperBound < 56) {
                    this.depthUpperBound = 56;
                }
            }
            this.estMaxDepth = n3;
        }
    }

    private void markParentChain(BHNode[] bHNodeArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            BHNode bHNode = bHNodeArray[i2];
            bHNode.mark = true;
            while (bHNode.parent != null && !bHNode.parent.mark) {
                bHNode = bHNode.parent;
                bHNode.mark = true;
            }
        }
    }

    private void markParentChain(BHNode bHNode) {
        bHNode.mark = true;
        while (bHNode.parent != null && !bHNode.parent.mark) {
            bHNode = bHNode.parent;
            bHNode.mark = true;
        }
    }

    void delete(BHNode[] bHNodeArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bHNodeArray[i2] == null || bHNodeArray[i2].nodeType != 2) continue;
            this.markParentChain(bHNodeArray[i2]);
        }
        this.root = this.root.deleteAndUpdateMarkedNodes();
    }

    float[][] computeCenterValues(BHNode[] bHNodeArray, int[] nArray) {
        float[][] fArray = new float[bHNodeArray.length][3];
        for (int i2 = 0; i2 < bHNodeArray.length; ++i2) {
            nArray[i2] = i2;
            bHNodeArray[i2].computeBoundingHull();
            fArray[i2][0] = (float)(bHNodeArray[i2].bHull.upper.x + bHNodeArray[i2].bHull.lower.x) / 2.0f;
            fArray[i2][1] = (float)(bHNodeArray[i2].bHull.upper.y + bHNodeArray[i2].bHull.lower.y) / 2.0f;
            fArray[i2][2] = (float)(bHNodeArray[i2].bHull.upper.z + bHNodeArray[i2].bHull.lower.z) / 2.0f;
        }
        return fArray;
    }

    void computeMeansAndSumSquares(float[][] fArray, int[] nArray, float[] fArray2, float[] fArray3) {
        int n2;
        float[] fArray4 = new float[3];
        float f2 = 0.0f;
        int n3 = nArray.length;
        for (n2 = 2; n2 >= 0; --n2) {
            fArray4[n2] = 0.0f;
            fArray3[n2] = 0.0f;
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            fArray4[0] = fArray4[0] + fArray[nArray[n2]][0];
            fArray4[1] = fArray4[1] + fArray[nArray[n2]][1];
            fArray4[2] = fArray4[2] + fArray[nArray[n2]][2];
        }
        fArray2[0] = fArray4[0] / (float)n3;
        fArray2[1] = fArray4[1] / (float)n3;
        fArray2[2] = fArray4[2] / (float)n3;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            f2 = fArray[nArray[n2]][0] - fArray2[0];
            fArray3[0] = fArray3[0] + f2 * f2;
            f2 = fArray[nArray[n2]][1] - fArray2[1];
            fArray3[1] = fArray3[1] + f2 * f2;
            f2 = fArray[nArray[n2]][2] - fArray2[2];
            fArray3[2] = fArray3[2] + f2 * f2;
        }
    }

    int findSplitAxis(float[] fArray) {
        int n2 = -1;
        float f2 = 0.0f;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            f2 = fArray[i2];
            n2 = i2;
        }
        return n2;
    }

    void constructTree(BHInternalNode bHInternalNode, BHNode[] bHNodeArray, float[][] fArray, int[] nArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        this.computeMeansAndSumSquares(fArray, nArray, fArray2, fArray3);
        int n5 = this.findSplitAxis(fArray3);
        boolean[] blArray = new boolean[bHNodeArray.length];
        if (n5 == -1) {
            for (n2 = 0; n2 < bHNodeArray.length; ++n2) {
                if (n4 > n3) {
                    ++n3;
                    blArray[n2] = false;
                    continue;
                }
                ++n4;
                blArray[n2] = true;
            }
        } else {
            for (n2 = 0; n2 < bHNodeArray.length; ++n2) {
                if (fArray[nArray[n2]][n5] < fArray2[n5]) {
                    ++n4;
                    blArray[n2] = true;
                    continue;
                }
                if (fArray[nArray[n2]][n5] > fArray2[n5]) {
                    ++n3;
                    blArray[n2] = false;
                    continue;
                }
                if (n4 > n3) {
                    ++n3;
                    blArray[n2] = false;
                    continue;
                }
                ++n4;
                blArray[n2] = true;
            }
        }
        if (n4 == bHNodeArray.length) {
            n3 = 0;
            n4 = 0;
            for (n2 = 0; n2 < bHNodeArray.length; ++n2) {
                if (n4 > n3) {
                    ++n3;
                    blArray[n2] = false;
                    continue;
                }
                ++n4;
                blArray[n2] = true;
            }
        } else if (n3 == bHNodeArray.length) {
            n3 = 0;
            n4 = 0;
            for (n2 = 0; n2 < bHNodeArray.length; ++n2) {
                if (n4 > n3) {
                    ++n3;
                    blArray[n2] = false;
                    continue;
                }
                ++n4;
                blArray[n2] = true;
            }
        }
        BHNode[] bHNodeArray2 = new BHNode[n3];
        BHNode[] bHNodeArray3 = new BHNode[n4];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n4];
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < bHNodeArray.length; ++n2) {
            if (blArray[n2]) {
                bHNodeArray3[n4] = bHNodeArray[n2];
                nArray3[n4] = nArray[n2];
                ++n4;
                continue;
            }
            bHNodeArray2[n3] = bHNodeArray[n2];
            nArray2[n3] = nArray[n2];
            ++n3;
        }
        if (bHNodeArray2.length != 1) {
            bHInternalNode.rChild = new BHInternalNode();
            bHInternalNode.rChild.setParent(bHInternalNode);
            this.constructTree((BHInternalNode)bHInternalNode.rChild, bHNodeArray2, fArray, nArray2);
        } else {
            bHInternalNode.rChild = bHNodeArray2[0];
            bHInternalNode.rChild.setParent(bHInternalNode);
        }
        if (bHNodeArray3.length != 1) {
            bHInternalNode.lChild = new BHInternalNode();
            bHInternalNode.lChild.setParent(bHInternalNode);
            this.constructTree((BHInternalNode)bHInternalNode.lChild, bHNodeArray3, fArray, nArray3);
        } else {
            bHInternalNode.lChild = bHNodeArray3[0];
            bHInternalNode.lChild.setParent(bHInternalNode);
        }
        bHInternalNode.combineBHull(bHInternalNode.rChild, bHInternalNode.lChild);
    }

    void reConstructTree(int n2) {
        if (this.root == null) {
            return;
        }
        BHNode[] bHNodeArray = new BHNode[n2];
        int[] nArray = new int[]{0};
        this.root.destroyTree(bHNodeArray, nArray);
        this.create(bHNodeArray);
    }

    void gatherTreeStatistics() {
        int n2 = this.root.countNumberOfLeaves();
        int n3 = this.root.countNumberOfInternals();
        int n4 = this.root.computeMaxDepth(0);
        float f2 = this.root.computeAverageLeafDepth(n2, 0);
        System.err.println("Statistics for tree = " + this);
        System.err.println("Total Number of nodes in tree = " + (n2 + n3));
        System.err.println("Number of Leaf Nodes = " + n2);
        System.err.println("Number of Internal Nodes = " + n3);
        System.err.println("Maximum Leaf depth = " + n4);
        System.err.println("Average Leaf depth = " + f2);
        System.err.println("root.bHull = " + this.root.bHull);
    }

    void printTree(BHNode bHNode) {
        if (bHNode != null) {
            if (bHNode.nodeType == 1) {
                System.err.println("BH_TYPE_INTERNAL - bHull : " + bHNode);
                System.err.println(bHNode.bHull);
                System.err.println("rChild : " + ((BHInternalNode)bHNode).rChild + " lChild : " + ((BHInternalNode)bHNode).lChild);
                this.printTree(((BHInternalNode)bHNode).rChild);
                this.printTree(((BHInternalNode)bHNode).lChild);
            } else if (bHNode.nodeType == 2) {
                System.err.println("BH_TYPE_LEAF - bHull : " + bHNode);
                System.err.println(bHNode.bHull);
            }
        }
    }
}

