/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TransformGroupRetained;

class CompileState {
    HashMap knownAppearances = new HashMap();
    int numAppearances = 0;
    int numShared = 0;
    int numShapes = 0;
    HashMap shapeLists = null;
    int numMergeSets = 0;
    int numMergeShapes = 0;
    boolean compileVerbose = false;
    static final int BOUNDS_READ = 1;
    static final int GEOMETRY_READ = 2;
    boolean keepTG = false;
    boolean needNormalsTransform = false;
    TransformGroupRetained staticTransform = null;
    GroupRetained parentGroup = null;
    ArrayList transformGroupChildrenList = null;
    ArrayList staticTransformObjects = new ArrayList(1);
    int numTransformGroups = 0;
    int numStaticTransformGroups = 0;
    int numMergedTransformGroups = 0;
    int numGroups = 0;
    int numMergedGroups = 0;
    int numShapesWSharedGeom = 0;
    int numShapesWStaticTG = 0;
    int numLinks = 0;
    int numSwitches = 0;
    int numOrderedGroups = 0;
    int numMorphs = 0;

    CompileState() {
        try {
            this.compileVerbose = Boolean.getBoolean("javax.media.j3d.compileVerbose");
        }
        catch (AccessControlException accessControlException) {
            this.compileVerbose = false;
        }
        this.initShapeMerge();
    }

    AppearanceRetained getAppearance(AppearanceRetained appearanceRetained) {
        if (appearanceRetained.map == this && appearanceRetained.mapAppearance != null) {
            ++this.numShared;
            return appearanceRetained.mapAppearance;
        }
        AppearanceRetained appearanceRetained2 = (AppearanceRetained)this.knownAppearances.get(appearanceRetained);
        if (appearanceRetained2 != null) {
            ++this.numShared;
        } else {
            this.knownAppearances.put(appearanceRetained, appearanceRetained);
            ++this.numAppearances;
            ++this.numShared;
            appearanceRetained2 = appearanceRetained;
        }
        appearanceRetained.map = this;
        appearanceRetained.mapAppearance = appearanceRetained2;
        return appearanceRetained2;
    }

    private void initShapeMerge() {
        this.shapeLists = new HashMap();
    }

    void addShape(Shape3DRetained shape3DRetained) {
        if (this.parentGroup != null) {
            Vector<Shape3DRetained> vector = (Vector<Shape3DRetained>)this.shapeLists.get(shape3DRetained.appearance);
            if (vector == null) {
                vector = new Vector<Shape3DRetained>();
                this.shapeLists.put(shape3DRetained.appearance, vector);
            }
            GeometryRetained geometryRetained = null;
            for (int i2 = 0; geometryRetained == null && i2 < shape3DRetained.geometryList.size(); ++i2) {
                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(i2);
            }
            if (shape3DRetained.parent instanceof GroupRetained && ((GroupRetained)shape3DRetained.parent).isStaticChildren() && geometryRetained.geoType < 15) {
                vector.add(shape3DRetained);
            }
        }
    }

    void printStats() {
        System.err.println("numTransformGroups= " + this.numTransformGroups);
        System.err.println("numStaticTransformGroups= " + this.numStaticTransformGroups);
        System.err.println("numMergedTransformGroups= " + this.numMergedTransformGroups);
        System.err.println("numGroups= " + this.numGroups);
        System.err.println("numMergedGroups= " + this.numMergedGroups);
        System.err.println("numShapes= " + this.numShapes);
        System.err.println("numShapesWStaticTG= " + this.numShapesWStaticTG);
        System.err.println("numMergeShapes= " + this.numMergeShapes);
        System.err.println("numMergeSets= " + this.numMergeSets);
        System.err.println("numLinks= " + this.numLinks);
        System.err.println("numSwitches= " + this.numSwitches);
        System.err.println("numOrderedGroups= " + this.numOrderedGroups);
        System.err.println("numMorphs= " + this.numMorphs);
    }

    void doShapeMerge() {
        if (this.shapeLists != null) {
            Collection collection = this.shapeLists.values();
            Iterator iterator = collection.iterator();
            int n2 = 0;
            int n3 = 0;
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                int n4 = vector.size();
                Object[] objectArray = new Shape3DRetained[n4];
                vector.copyInto(objectArray);
                Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (objectArray[i2] == null) continue;
                    GeometryRetained geometryRetained = null;
                    for (n2 = 0; geometryRetained == null && n2 < ((Shape3DRetained)objectArray[i2]).geometryList.size(); ++n2) {
                        geometryRetained = (GeometryRetained)((Shape3DRetained)objectArray[i2]).geometryList.get(n2);
                    }
                    if (geometryRetained == null || !(geometryRetained instanceof GeometryArrayRetained)) continue;
                    int n5 = 0;
                    Object object = objectArray[i2];
                    GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
                    shape3DRetainedArray[n5++] = object;
                    n3 = this.getCompileFlags((Shape3DRetained)object);
                    for (int i3 = i2 + 1; i3 < n4; ++i3) {
                        if (objectArray[i3] == null) continue;
                        geometryRetained = null;
                        for (n2 = 0; geometryRetained == null && n2 < ((Shape3DRetained)objectArray[i3]).geometryList.size(); ++n2) {
                            geometryRetained = (GeometryRetained)((Shape3DRetained)objectArray[i3]).geometryList.get(n2);
                        }
                        if (geometryRetained == null || !((Shape3DRetained)objectArray[i3]).isEquivalent((Shape3DRetained)object) || !geometryRetained.isEquivalenceClass(geometryArrayRetained) || ((GeometryArrayRetained)geometryRetained).vertexFormat != geometryArrayRetained.vertexFormat) continue;
                        shape3DRetainedArray[n5++] = objectArray[i3];
                        n3 |= this.getCompileFlags((Shape3DRetained)objectArray[i3]);
                        objectArray[i3] = null;
                    }
                    if (n5 <= 1) continue;
                    GroupRetained groupRetained = (GroupRetained)shape3DRetainedArray[0].parent;
                    for (int i4 = 0; i4 < n5; ++i4) {
                        Shape3DRetained shape3DRetained = shape3DRetainedArray[i4];
                        boolean bl = false;
                        int n6 = groupRetained.numChildren();
                        for (int i5 = 0; i5 < n6 && !bl; ++i5) {
                            if (groupRetained.getChild((int)i5).retained != shape3DRetained) continue;
                            bl = true;
                            groupRetained.removeChild(i5);
                        }
                        if (bl) continue;
                        System.err.println("ShapeSet.add(): Can't remove shape from parent, can't find shape!");
                    }
                    object = new Shape3DCompileRetained(shape3DRetainedArray, n5, n3);
                    ((SceneGraphObjectRetained)object).setSource(shape3DRetainedArray[0].source);
                    ++this.numMergeSets;
                    this.numMergeShapes += n5;
                    this.parentGroup.addChild((Node)((Shape3DRetained)object).source);
                }
            }
        }
        this.shapeLists.clear();
    }

    int getCompileFlags(Shape3DRetained shape3DRetained) {
        int n2 = 0;
        if (shape3DRetained.allowIntersect() || shape3DRetained.source.getCapability(12) || shape3DRetained.boundsAutoCompute && shape3DRetained.source.getCapability(3)) {
            n2 |= 2;
        }
        return n2;
    }
}

