/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class GeometryStripArrayRetained
extends GeometryArrayRetained {
    int[] stripVertexCounts;
    int[] stripStartVertexIndices;
    int[] stripStartOffsetIndices;
    int[] compileNumStrips;
    int[] compileStripCountOffset;

    GeometryStripArrayRetained() {
    }

    void setStripVertexCounts(int[] nArray) {
        int n2;
        boolean bl = false;
        int n3 = nArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
            if (this instanceof LineStripArrayRetained) {
                if (nArray[n2] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained1"));
            }
            if (this instanceof TriangleStripArrayRetained) {
                if (nArray[n2] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("TriangleStripArrayRetained1"));
            }
            if (!(this instanceof TriangleFanArrayRetained) || nArray[n2] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained1"));
        }
        if (this.initialVertexIndex + n4 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray3"));
        }
        if (this.initialCoordIndex + n4 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray7"));
        }
        if (this.initialColorIndex + n4 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray4"));
        }
        if (this.initialNormalIndex + n4 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray5"));
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                if (this.initialTexCoordIndex[n2] + n4 <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray6"));
            }
        }
        if ((this.vertexFormat & 0x1000) != 0 && (this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                if (this.initialVertexAttrIndex[n2] + n4 <= this.vertexCount) continue;
                throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArray8"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x40;
        this.validVertexCount = n4;
        this.stripVertexCounts = new int[n3];
        this.stripStartVertexIndices = new int[n3];
        this.stripStartOffsetIndices = new int[n3];
        this.stripStartOffsetIndices[0] = 0;
        if ((this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128) {
            this.stripStartVertexIndices[0] = this.initialCoordIndex;
            bl = (this.vertexType & 0xF) == 0;
        } else {
            this.stripStartVertexIndices[0] = this.initialVertexIndex;
            if ((this.vertexFormat & 0x100) != 0) {
                bl = (this.vertexFormat & 0x800) != 0 ? this.interLeavedVertexData == null : this.interleavedFloatBufferImpl == null;
            }
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            this.stripVertexCounts[n2] = nArray[n2];
            this.stripStartVertexIndices[n2 + 1] = this.stripStartVertexIndices[n2] + nArray[n2];
            this.stripStartOffsetIndices[n2 + 1] = this.stripStartOffsetIndices[n2] + nArray[n2];
        }
        this.stripVertexCounts[n3 - 1] = nArray[n3 - 1];
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    void unIndexify(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(indexedGeometryStripArrayRetained);
        } else {
            this.unIndexifyNIOBuffer(indexedGeometryStripArrayRetained);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n2 = 0;
        int n3 = 0;
        int n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
        int n5 = 0;
        float[] fArray = null;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryStripArrayRetained.vertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n5 = 4;
                }
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryStripArrayRetained.interLeavedVertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n5 = 4;
                } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n5 = 3;
                }
            }
            for (int i2 = 0; i2 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++i2) {
                for (int i3 = 0; i3 < indexedGeometryStripArrayRetained.stripIndexCounts[i2]; ++i3) {
                    int n6;
                    int n7 = i3 + n4;
                    if ((this.vertexFormat & 2) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexNormal[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset, this.vertexData, n2 + this.normalOffset, 3);
                    }
                    if (n5 == 4) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n2 + this.colorOffset, n5);
                    } else if (n5 == 3) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n2 + this.colorOffset, n5);
                        this.vertexData[n2 + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (n6 = 0; n6 < this.texCoordSetCount; ++n6) {
                            System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexTexCoord[n6][n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[n6], this.vertexData, n2 + this.textureOffset + this.texCoordSetMapOffset[n6], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 0x1000) != 0) {
                        for (n6 = 0; n6 < this.vertexAttrCount; ++n6) {
                            System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexVertexAttr[n6][n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.vertexAttrOffsets[n6], this.vertexData, n2 + this.vertexAttrOffsets[n6], this.vertexAttrSizes[n6]);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexCoord[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset, this.vertexData, n2 + this.coordinateOffset, 3);
                    }
                    n2 += this.stride;
                }
                n4 += indexedGeometryStripArrayRetained.stripIndexCounts[i2];
            }
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            if ((this.vertexFormat & 2) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = this.normalOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefNormals, indexedGeometryStripArrayRetained.indexNormal[n9] * 3, this.vertexData, n2, 3);
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 2048: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexNormal[n10 + n4];
                                this.vertexData[n2] = indexedGeometryStripArrayRetained.v3fRefNormals[n9].x;
                                this.vertexData[n2 + 1] = indexedGeometryStripArrayRetained.v3fRefNormals[n9].y;
                                this.vertexData[n2 + 2] = indexedGeometryStripArrayRetained.v3fRefNormals[n9].z;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = this.colorOffset;
                int n12 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n12 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n9] * n12, this.vertexData, n2, 4);
                                } else {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n9] * n12, this.vertexData, n2, 3);
                                    this.vertexData[n2 + 3] = 1.0f;
                                }
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 32: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n4] * n12;
                                this.vertexData[n2] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n9] & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 1] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n9 + 1] & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 2] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n9 + 2] & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteRefColors[n9 + 3] & 0xFF) * 0.003921569f : 1.0f;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 64: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n4];
                                this.vertexData[n2] = indexedGeometryStripArrayRetained.c3fRefColors[n9].x;
                                this.vertexData[n2 + 1] = indexedGeometryStripArrayRetained.c3fRefColors[n9].y;
                                this.vertexData[n2 + 2] = indexedGeometryStripArrayRetained.c3fRefColors[n9].z;
                                this.vertexData[n2 + 3] = 1.0f;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 128: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n4];
                                this.vertexData[n2] = indexedGeometryStripArrayRetained.c4fRefColors[n9].x;
                                this.vertexData[n2 + 1] = indexedGeometryStripArrayRetained.c4fRefColors[n9].y;
                                this.vertexData[n2 + 2] = indexedGeometryStripArrayRetained.c4fRefColors[n9].z;
                                this.vertexData[n2 + 3] = indexedGeometryStripArrayRetained.c4fRefColors[n9].w;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 256: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n4];
                                this.vertexData[n2] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n9].x & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 1] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n9].y & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 2] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n9].z & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 3] = 1.0f;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 512: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n4];
                                this.vertexData[n2] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].x & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 1] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].y & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 2] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].z & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 3] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].w & 0xFF) * 0.003921569f;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = this.textureOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                n3 = n2;
                                for (n8 = 0; n8 < this.texCoordSetCount; ++n8) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.refTexCoords[n8], indexedGeometryStripArrayRetained.indexTexCoord[n8][n9] * this.texCoordStride, this.vertexData, n3, this.texCoordStride);
                                    n3 += this.texCoordStride;
                                }
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 8192: {
                        int n13;
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                n3 = n2;
                                for (n8 = 0; n8 < this.texCoordSetCount; ++n8) {
                                    n13 = indexedGeometryStripArrayRetained.indexTexCoord[n8][n9];
                                    this.vertexData[n3] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n8])[n13].x;
                                    this.vertexData[n3 + 1] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n8])[n13].y;
                                    n3 += this.texCoordStride;
                                }
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 16384: {
                        int n13;
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                n3 = n2;
                                for (n8 = 0; n8 < this.texCoordSetCount; ++n8) {
                                    n13 = indexedGeometryStripArrayRetained.indexTexCoord[n8][n9];
                                    this.vertexData[n3] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n8])[n13].x;
                                    this.vertexData[n3 + 1] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n8])[n13].y;
                                    this.vertexData[n3 + 2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n8])[n13].z;
                                    n3 += this.texCoordStride;
                                }
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = 0;
                switch (indexedGeometryStripArrayRetained.vertexType & 0x8000) {
                    case 32768: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                for (n8 = 0; n8 < this.vertexAttrCount; ++n8) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefVertexAttrs[n8], indexedGeometryStripArrayRetained.indexVertexAttr[n8][n9] * this.vertexAttrSizes[n8], this.vertexData, n2 + this.vertexAttrOffsets[n8], this.vertexAttrSizes[n8]);
                                }
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n2 = this.coordinateOffset;
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefCoords, indexedGeometryStripArrayRetained.indexCoord[n9] * 3, this.vertexData, n2, 3);
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 2: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n4] * 3;
                                this.vertexData[n2] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n9];
                                this.vertexData[n2 + 1] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n9 + 1];
                                this.vertexData[n2 + 2] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n9 + 2];
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 4: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n4];
                                this.vertexData[n2] = indexedGeometryStripArrayRetained.p3fRefCoords[n9].x;
                                this.vertexData[n2 + 1] = indexedGeometryStripArrayRetained.p3fRefCoords[n9].y;
                                this.vertexData[n2 + 2] = indexedGeometryStripArrayRetained.p3fRefCoords[n9].z;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 8: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n4];
                                this.vertexData[n2] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n9].x;
                                this.vertexData[n2 + 1] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n9].y;
                                this.vertexData[n2 + 2] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n9].z;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n2 = 0;
        int n3 = 0;
        int n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
        int n5 = 0;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                n5 = 4;
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                n5 = 3;
            }
            for (int i2 = 0; i2 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++i2) {
                for (int i3 = 0; i3 < indexedGeometryStripArrayRetained.stripIndexCounts[i2]; ++i3) {
                    int n6 = i3 + n4;
                    if ((this.vertexFormat & 2) != 0) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexNormal[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.normalOffset, 3);
                    }
                    if (n5 == 4) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexColor[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.colorOffset, n5);
                    } else if (n5 == 3) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexColor[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.colorOffset, n5);
                        this.vertexData[n2 + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x460) != 0) {
                        for (int i4 = 0; i4 < this.texCoordSetCount; ++i4) {
                            indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexTexCoord[i4][n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[i4]);
                            indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.textureOffset + this.texCoordSetMapOffset[i4], this.texCoordStride);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryStripArrayRetained.indexCoord[n6] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset);
                        indexedGeometryStripArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.coordinateOffset, 3);
                    }
                    n2 += this.stride;
                }
                n4 += indexedGeometryStripArrayRetained.stripIndexCounts[i2];
            }
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            if ((this.vertexFormat & 2) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = this.normalOffset;
                if ((indexedGeometryStripArrayRetained.vertexType & 0xC00) != 0) {
                    for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                            n9 = n10 + n4;
                            indexedGeometryStripArrayRetained.floatBufferRefNormals.position(indexedGeometryStripArrayRetained.indexNormal[n9] * 3);
                            indexedGeometryStripArrayRetained.floatBufferRefNormals.get(this.vertexData, n2, 3);
                            n2 += this.stride;
                        }
                        n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = this.colorOffset;
                n8 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n8 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.position(indexedGeometryStripArrayRetained.indexColor[n9] * n8);
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.get(this.vertexData, n2, 4);
                                } else {
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.position(indexedGeometryStripArrayRetained.indexColor[n9] * n8);
                                    indexedGeometryStripArrayRetained.floatBufferRefColors.get(this.vertexData, n2, 3);
                                    this.vertexData[n2 + 3] = 1.0f;
                                }
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 32: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n4] * n8;
                                this.vertexData[n2] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n9) & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 1] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n9 + 1) & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 2] = (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n9 + 2) & 0xFF) * 0.003921569f;
                                this.vertexData[n2 + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteBufferRefColors.get(n9 + 3) & 0xFF) * 0.003921569f : 1.0f;
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = this.textureOffset;
                if ((indexedGeometryStripArrayRetained.vertexType & 0x7000) != 0) {
                    for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                            n9 = n10 + n4;
                            n3 = n2;
                            for (n7 = 0; n7 < this.texCoordSetCount; ++n7) {
                                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)indexedGeometryStripArrayRetained.refTexCoordsBuffer[n7]).getBufferImpl();
                                floatBufferWrapper.position(indexedGeometryStripArrayRetained.indexTexCoord[n7][n9] * this.texCoordStride);
                                floatBufferWrapper.get(this.vertexData, n3, this.texCoordStride);
                                n3 += this.texCoordStride;
                            }
                            n2 += this.stride;
                        }
                        n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                n2 = 0;
                if ((indexedGeometryStripArrayRetained.vertexType & 0x8000) == 32768) {
                    for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                        for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                            n9 = n10 + n4;
                            for (n7 = 0; n7 < this.vertexAttrCount; ++n7) {
                                n8 = n2 + this.vertexAttrOffsets[n7];
                                FloatBufferWrapper floatBufferWrapper = indexedGeometryStripArrayRetained.floatBufferRefVertexAttrs[n7];
                                floatBufferWrapper.position(indexedGeometryStripArrayRetained.indexVertexAttr[n7][n9] * this.vertexAttrSizes[n7]);
                                floatBufferWrapper.get(this.vertexData, n8, this.vertexAttrSizes[n7]);
                            }
                            n2 += this.stride;
                        }
                        n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n2 = this.coordinateOffset;
                n4 = indexedGeometryStripArrayRetained.initialIndexIndex;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = n10 + n4;
                                indexedGeometryStripArrayRetained.floatBufferRefCoords.position(indexedGeometryStripArrayRetained.indexCoord[n9] * 3);
                                indexedGeometryStripArrayRetained.floatBufferRefCoords.get(this.vertexData, n2, 3);
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                    case 2: {
                        for (n11 = 0; n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length; ++n11) {
                            for (n10 = 0; n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]; ++n10) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n4] * 3;
                                this.vertexData[n2] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n9);
                                this.vertexData[n2 + 1] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n9 + 1);
                                this.vertexData[n2 + 2] = (float)indexedGeometryStripArrayRetained.doubleBufferRefCoords.get(n9 + 2);
                                n2 += this.stride;
                            }
                            n4 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                        }
                        break;
                    }
                }
            }
        }
    }

    int getNumStrips() {
        return this.stripVertexCounts.length;
    }

    void getStripVertexCounts(int[] nArray) {
        for (int nArray[var2_3] : this.stripVertexCounts) {
        }
    }

    void getStripVertexCounts(int n2, int[] nArray) {
        int n3 = this.compileStripCountOffset[n2];
        int n4 = this.compileNumStrips[n2];
        System.arraycopy(this.stripVertexCounts, n3, nArray, 0, n4);
    }

    int getNumStrips(int n2) {
        return this.compileNumStrips[n2];
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n2;
        int n3 = arrayList.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += ((GeometryStripArrayRetained)arrayList.get((int)n2)).stripVertexCounts.length;
        }
        this.stripVertexCounts = new int[n4];
        this.stripStartVertexIndices = new int[n4];
        this.stripStartOffsetIndices = new int[n4];
        n2 = 0;
        int n5 = 0;
        this.compileNumStrips = new int[n3];
        this.compileStripCountOffset = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6;
            GeometryStripArrayRetained geometryStripArrayRetained = (GeometryStripArrayRetained)arrayList.get(i2);
            int[] nArray = geometryStripArrayRetained.stripVertexCounts;
            int[] nArray2 = geometryStripArrayRetained.stripStartVertexIndices;
            int[] nArray3 = geometryStripArrayRetained.stripStartOffsetIndices;
            this.compileNumStrips[i2] = n6 = nArray.length;
            this.compileStripCountOffset[i2] = n2;
            System.arraycopy(nArray, 0, this.stripVertexCounts, n2, n6);
            for (int i3 = 0; i3 < n6; ++i3) {
                this.stripStartVertexIndices[i3 + n2] = nArray2[i3] + n5;
                this.stripStartOffsetIndices[i3 + n2] = nArray3[i3] + n5;
            }
            n2 += n6;
            n5 += geometryStripArrayRetained.validVertexCount;
        }
        this.validVertexCount = n5;
        super.mergeGeometryArrays(arrayList);
    }
}

