/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class IndexedPointArrayRetained
extends IndexedGeometryArrayRetained {
    IndexedPointArrayRetained() {
        this.geoType = 10;
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n2, Point3d point3d, GeometryRetained geometryRetained, int n3) {
        double[] dArray = new double[1];
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Point3d point3d2 = new Point3d();
        int[] nArray = new int[1];
        int n4 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n4 < this.validVertexCount) {
                    nArray[0] = this.indexCoord[n4];
                    this.getVertexData(this.indexCoord[n4++], point3d2);
                    if (!this.intersectPntAndRay(point3d2, pickRay.origin, pickRay.direction, dArray)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d2.x;
                        d4 = point3d2.y;
                        d5 = point3d2.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d vector3d = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (n4 < this.validVertexCount) {
                    nArray[0] = this.indexCoord[n4];
                    this.getVertexData(this.indexCoord[n4++], point3d2);
                    if (!this.intersectPntAndRay(point3d2, pickSegment.start, vector3d, dArray) || !(dArray[0] <= 1.0)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d2.x;
                        d4 = point3d2.y;
                        d5 = point3d2.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Bounds bounds = ((PickBounds)pickShape).bounds;
                while (n4 < this.validVertexCount) {
                    nArray[0] = this.indexCoord[n4];
                    this.getVertexData(this.indexCoord[n4++], point3d2);
                    if (!bounds.intersect(point3d2)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    dArray[0] = pickShape.distance(point3d2);
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d2.x;
                        d4 = point3d2.y;
                        d5 = point3d2.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n4 < this.validVertexCount) {
                    nArray[0] = this.indexCoord[n4];
                    this.getVertexData(this.indexCoord[n4++], point3d2);
                    if (!this.intersectCylinder(point3d2, pickCylinder, dArray)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d2.x;
                        d4 = point3d2.y;
                        d5 = point3d2.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n4 < this.validVertexCount) {
                    nArray[0] = this.indexCoord[n4];
                    this.getVertexData(this.indexCoord[n4++], point3d2);
                    if (!this.intersectCone(point3d2, pickCone, dArray)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d2.x;
                        d4 = point3d2.y;
                        d5 = point3d2.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedPointArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (d2 < Double.MAX_VALUE) {
            point3d.x = d3;
            point3d.y = d4;
            point3d.z = d5;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        Point3d point3d = new Point3d();
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        switch (point3dArray.length) {
            case 3: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[n2++], point3d);
                    if (!this.intersectTriPnt(point3dArray[0], point3dArray[1], point3dArray[2], point3d)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[n2++], point3d);
                    if (!this.intersectTriPnt(point3dArray[0], point3dArray[1], point3dArray[2], point3d) && !this.intersectTriPnt(point3dArray[0], point3dArray[2], point3dArray[3], point3d)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                double[] dArray = new double[1];
                Vector3d vector3d = new Vector3d();
                while (n2 < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[n2++], point3d);
                    vector3d.x = point3dArray[1].x - point3dArray[0].x;
                    vector3d.y = point3dArray[1].y - point3dArray[0].y;
                    vector3d.z = point3dArray[1].z - point3dArray[0].z;
                    if (!this.intersectPntAndRay(point3d, point3dArray[0], vector3d, dArray) || !(dArray[0] <= 1.0)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[n2++], point3d);
                    if (point3dArray[0].x != point3d.x || point3dArray[0].y != point3d.y || point3dArray[0].z != point3d.z) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[1];
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        while (n2 < this.validVertexCount) {
            this.getVertexData(this.indexCoord[n2++], point3dArray[0]);
            transform3D.transform(point3dArray[0]);
            if (!geometryRetained.intersect(point3dArray)) continue;
            return true;
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        Point3d point3d = new Point3d();
        while (n2 < this.validVertexCount) {
            this.getVertexData(this.indexCoord[n2++], point3d);
            if (!bounds.intersect(point3d)) continue;
            return true;
        }
        return false;
    }

    int getClassType() {
        return 1;
    }
}

