/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import javax.media.j3d.IndexedObject;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.VirtualUniverse;

class IndexedUnorderSet
implements Cloneable,
Serializable {
    static final boolean debug = false;
    transient IndexedObject[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;
    int listType;
    VirtualUniverse univ;

    IndexedUnorderSet(int n2, Class clazz, int n3, VirtualUniverse virtualUniverse) {
        this.componentType = clazz;
        this.elementData = (IndexedObject[])Array.newInstance(clazz, n2);
        this.listType = n3;
        this.univ = virtualUniverse;
    }

    IndexedUnorderSet(Class clazz, int n2, VirtualUniverse virtualUniverse) {
        this(10, clazz, n2, virtualUniverse);
    }

    IndexedUnorderSet(int n2, int n3, VirtualUniverse virtualUniverse) {
        this(n2, IndexedObject.class, n3, virtualUniverse);
    }

    IndexedUnorderSet(int n2, VirtualUniverse virtualUniverse) {
        this(10, IndexedObject.class, n2, virtualUniverse);
    }

    static final void init(IndexedObject indexedObject, int n2) {
        indexedObject.listIdx = new int[3][];
        indexedObject.listIdx[0] = new int[n2];
        indexedObject.listIdx[1] = new int[n2];
        indexedObject.listIdx[2] = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexedObject.listIdx[0][i2] = -1;
            indexedObject.listIdx[1][i2] = -1;
        }
        indexedObject.listIdx[2][0] = indexedObject instanceof SceneGraphObjectRetained ? 1 : 0;
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(IndexedObject indexedObject) {
        return indexedObject.listIdx[indexedObject.getIdxUsed(this.univ)][this.listType] >= 0;
    }

    final synchronized int indexOf(IndexedObject indexedObject) {
        return indexedObject.listIdx[indexedObject.getIdxUsed(this.univ)][this.listType];
    }

    protected final synchronized Object clone() {
        try {
            IndexedUnorderSet indexedUnorderSet = (IndexedUnorderSet)super.clone();
            indexedUnorderSet.elementData = (IndexedObject[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, indexedUnorderSet.elementData, 0, this.size);
            this.isDirty = true;
            return indexedUnorderSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean bl) {
        if (bl) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final synchronized Object[] toArray(IndexedObject indexedObject) {
        int n2 = this.indexOf(indexedObject);
        if (n2 < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int n3 = this.size - n2;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n3);
        System.arraycopy(this.elementData, n2, objectArray, 0, n3);
        return objectArray;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            IndexedObject[] indexedObjectArray = this.elementData;
            this.elementData = (IndexedObject[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(indexedObjectArray, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int n2) {
        return this.elementData[n2];
    }

    final synchronized void set(int n2, IndexedObject indexedObject) {
        IndexedObject indexedObject2 = this.elementData[n2];
        if (indexedObject2 != null) {
            indexedObject2.listIdx[indexedObject2.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        }
        this.elementData[n2] = indexedObject;
        int n3 = indexedObject.getIdxUsed(this.univ);
        indexedObject.listIdx[n3][this.listType] = n2;
        this.isDirty = true;
    }

    final synchronized void add(IndexedObject indexedObject) {
        if (this.elementData.length == this.size) {
            IndexedObject[] indexedObjectArray = this.elementData;
            this.elementData = (IndexedObject[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(indexedObjectArray, 0, this.elementData, 0, this.size);
        }
        int n2 = indexedObject.getIdxUsed(this.univ);
        int n3 = this.size++;
        this.elementData[n3] = indexedObject;
        indexedObject.listIdx[n2][this.listType] = n3;
        this.isDirty = true;
    }

    final synchronized void remove(int n2) {
        IndexedObject indexedObject = this.elementData[n2];
        int n3 = indexedObject.getIdxUsed(this.univ);
        indexedObject.listIdx[n3][this.listType] = -1;
        --this.size;
        if (n2 != this.size) {
            indexedObject = this.elementData[this.size];
            indexedObject.listIdx[n3][this.listType] = n2;
            this.elementData[n2] = indexedObject;
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        IndexedObject indexedObject = this.elementData[--this.size];
        this.elementData[this.size] = null;
        indexedObject.listIdx[indexedObject.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        this.isDirty = true;
        return indexedObject;
    }

    final synchronized boolean remove(IndexedObject indexedObject) {
        int n2 = indexedObject.getIdxUsed(this.univ);
        int n3 = indexedObject.listIdx[n2][this.listType];
        if (n3 >= 0) {
            --this.size;
            if (n3 != this.size) {
                IndexedObject indexedObject2;
                this.elementData[n3] = indexedObject2 = this.elementData[this.size];
                indexedObject2.listIdx[indexedObject2.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = n3;
            }
            this.elementData[this.size] = null;
            indexedObject.listIdx[n2][this.listType] = -1;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    final synchronized void clear() {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            IndexedObject indexedObject = this.elementData[i2];
            indexedObject.listIdx[indexedObject.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
            this.elementData[i2] = null;
        }
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            for (int i2 = this.cloneData.length - 1; i2 >= 0; --i2) {
                this.cloneData[i2] = null;
            }
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeObject(this.elementData[i2]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = (IndexedObject[])Array.newInstance(this.componentType, n2);
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elementData[i2] = (IndexedObject)objectInputStream.readObject();
        }
    }
}

