/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.Context;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;

abstract class LightRetained
extends LeafRetained {
    static final int ENABLE_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int COLOR_CHANGED = 8;
    static final int BOUNDINGLEAF_CHANGED = 16;
    static final int INIT_MIRROR = 32;
    static final int CLEAR_MIRROR = 64;
    static final int LAST_DEFINED_BIT = 64;
    boolean lightOn = true;
    Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    Vector scopes = new Vector();
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds region = null;
    int lightDirty = 65535;
    int sgLightDirty = 65535;
    int lightType = -1;
    boolean isNeeded = false;
    boolean inImmCtx = false;
    LightRetained sgLight = null;
    HashKey key = null;
    LightRetained[] mirrorLights = new LightRetained[1];
    int numMirrorLights = 0;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    UnorderList environmentSets = new UnorderList(1, EnvironmentSet.class);
    boolean isViewScoped = false;
    ArrayList newlyAddedMirrorLights = new ArrayList();
    static final int targetThreads = 4224;

    LightRetained() {
    }

    void initEnable(boolean bl) {
        this.lightOn = bl;
    }

    void setEnable(boolean bl) {
        this.initEnable(bl);
        this.sendMessage(1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    boolean getEnable() {
        return this.lightOn;
    }

    void initColor(Color3f color3f) {
        this.color.set(color3f);
    }

    void setColor(Color3f color3f) {
        this.initColor(color3f);
        this.sendMessage(8, new Color3f(color3f));
    }

    void getColor(Color3f color3f) {
        color3f.set(this.color);
    }

    void initScope(Group group, int n2) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.setElementAt(groupRetained, n2);
    }

    void setScope(Group group, int n2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = (GroupRetained)this.scopes.get(n2);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, arrayList2, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, arrayList, this.tempKey);
        this.initScope(group, n2);
        J3dMessage j3dMessage = new J3dMessage();
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initInsertScope(Group group, int n2) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.insertElementAt(groupRetained, n2);
        groupRetained.setLightScope();
    }

    void insertScope(Group group, int n2) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, arrayList, this.tempKey);
        this.initInsertScope(group, n2);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initRemoveScope(int n2) {
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n2);
        this.scopes.removeElementAt(n2);
        groupRetained.removeLightScope();
    }

    void removeScope(int n2) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n2);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, arrayList, this.tempKey);
        this.initRemoveScope(n2);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void removeScope(Group group) {
        int n2 = this.indexOfScope(group);
        if (n2 >= 0) {
            this.removeScope(n2);
        }
    }

    void initRemoveScope(Group group) {
        int n2 = this.indexOfScope(group);
        if (n2 >= 0) {
            this.initRemoveScope(n2);
        }
    }

    void removeAllScopes() {
        int n2 = this.scopes.size();
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(i2);
            this.tempKey.reset();
            groupRetained.removeAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, arrayList, this.tempKey);
            this.initRemoveScope(i2);
        }
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initRemoveAllScopes() {
        int n2 = this.scopes.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.initRemoveScope(i2);
        }
    }

    Group getScope(int n2) {
        return (Group)((GroupRetained)this.scopes.elementAt((int)n2)).source;
    }

    Enumeration getAllScopes() {
        Enumeration enumeration = this.scopes.elements();
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add(((GroupRetained)enumeration.nextElement()).source);
        }
        return vector.elements();
    }

    void initAddScope(Group group) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.addElement(groupRetained);
        groupRetained.setLightScope();
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    int numScopes() {
        return this.scopes.size();
    }

    int indexOfScope(Group group) {
        if (group != null) {
            return this.scopes.indexOf((GroupRetained)group.retained);
        }
        return this.scopes.indexOf(null);
    }

    void initInfluencingBounds(Bounds bounds) {
        if (bounds != null) {
            this.regionOfInfluence = (Bounds)bounds.clone();
            if (this.staticTransform != null) {
                this.regionOfInfluence.transform(this.staticTransform.transform);
            }
        } else {
            this.regionOfInfluence = null;
        }
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(4, bounds != null ? bounds.clone() : null);
    }

    Bounds getInfluencingBounds() {
        Bounds bounds = null;
        if (this.regionOfInfluence != null) {
            bounds = (Bounds)this.regionOfInfluence.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        int n2;
        int n3 = this.numMirrorLights;
        if (this.numMirrorLights == 0) {
            n3 = 1;
        }
        if (this.boundingLeaf != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorLights[n2]);
            }
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            for (n2 = 0; n2 < n3; ++n2) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorLights[n2]);
            }
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(16, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void initMirrorObject(Object[] objectArray) {
        int n2;
        Object[] objectArray2 = (Object[])((Object[])objectArray[4])[5];
        ArrayList arrayList = (ArrayList)objectArray2[1];
        Boolean bl = (Boolean)objectArray2[0];
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)((Object[])objectArray[4])[0];
        Bounds bounds = (Bounds)((Object[])objectArray[4])[1];
        int n3 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Shape3DRetained shape3DRetained = ((GeometryAtom)arrayList.get((int)i2)).source;
                shape3DRetained.addLight(lightRetainedArray[n2]);
            }
            lightRetainedArray[n2].isScoped = bl;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            lightRetainedArray[n2].inBackgroundGroup = (Boolean)((Object[])objectArray[4])[2];
            lightRetainedArray[n2].geometryBackground = (BackgroundRetained)((Object[])objectArray[4])[3];
            if (boundingLeafRetained != null) {
                lightRetainedArray[n2].boundingLeaf = boundingLeafRetained.mirrorBoundingLeaf;
                lightRetainedArray[n2].region = lightRetainedArray[n2].boundingLeaf.transformedRegion;
            } else {
                lightRetainedArray[n2].boundingLeaf = null;
                lightRetainedArray[n2].region = null;
            }
            if (bounds != null) {
                lightRetainedArray[n2].regionOfInfluence = bounds;
                if (lightRetainedArray[n2].region == null) {
                    lightRetainedArray[n2].region = (Bounds)this.regionOfInfluence.clone();
                    lightRetainedArray[n2].region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
                }
            } else {
                lightRetainedArray[n2].regionOfInfluence = null;
            }
            lightRetainedArray[n2].lightOn = (Boolean)((Object[])objectArray[4])[4];
        }
        if (this instanceof AmbientLightRetained) {
            Color3f color3f = (Color3f)((Object[])objectArray[4])[6];
            for (int i3 = 0; i3 < n3; ++i3) {
                lightRetainedArray[i3].color.set(color3f);
            }
        }
    }

    abstract void update(Context var1, int var2, double var3);

    void updateImmediateMirrorObject(Object[] objectArray) {
        block14: {
            Shape3DRetained shape3DRetained;
            int n2;
            int n3;
            LightRetained[] lightRetainedArray;
            int n4;
            int n5;
            block17: {
                block16: {
                    block15: {
                        block13: {
                            Object var2_2 = null;
                            n5 = (Integer)objectArray[1];
                            n4 = (Integer)objectArray[2];
                            lightRetainedArray = (LightRetained[])objectArray[3];
                            if ((n5 & 8) == 0) break block13;
                            for (int i2 = 0; i2 < n4; ++i2) {
                                lightRetainedArray[i2].color.set((Color3f)objectArray[4]);
                            }
                            break block14;
                        }
                        if ((n5 & 1) == 0) break block15;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            lightRetainedArray[i3].lightOn = (Boolean)objectArray[4];
                        }
                        break block14;
                    }
                    if ((n5 & 4) == 0) break block16;
                    for (int i4 = 0; i4 < n4; ++i4) {
                        lightRetainedArray[i4].regionOfInfluence = (Bounds)objectArray[4];
                        if (lightRetainedArray[i4].boundingLeaf != null) continue;
                        if (objectArray[4] != null) {
                            lightRetainedArray[i4].region = lightRetainedArray[i4].regionOfInfluence.copy(lightRetainedArray[i4].region);
                            lightRetainedArray[i4].region.transform(lightRetainedArray[i4].regionOfInfluence, lightRetainedArray[i4].getCurrentLocalToVworld());
                            continue;
                        }
                        lightRetainedArray[i4].region = null;
                    }
                    break block14;
                }
                if ((n5 & 0x10) == 0) break block17;
                for (int i5 = 0; i5 < n4; ++i5) {
                    lightRetainedArray[i5].boundingLeaf = (BoundingLeafRetained)objectArray[4];
                    if (objectArray[4] != null) {
                        lightRetainedArray[i5].region = lightRetainedArray[i5].boundingLeaf.transformedRegion;
                        continue;
                    }
                    if (lightRetainedArray[i5].regionOfInfluence != null) {
                        lightRetainedArray[i5].region = lightRetainedArray[i5].regionOfInfluence.copy(lightRetainedArray[i5].region);
                        lightRetainedArray[i5].region.transform(lightRetainedArray[i5].regionOfInfluence, lightRetainedArray[i5].getCurrentLocalToVworld());
                        continue;
                    }
                    lightRetainedArray[i5].region = null;
                }
                break block14;
            }
            if ((n5 & 2) == 0) break block14;
            Object[] objectArray2 = (Object[])objectArray[4];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                for (n3 = 0; n3 < n4; ++n3) {
                    lightRetainedArray[n3].isScoped = bl;
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        shape3DRetained = ((GeometryAtom)arrayList.get((int)n2)).source;
                        shape3DRetained.addLight(lightRetainedArray[n3]);
                    }
                }
            }
            if (arrayList2 != null) {
                for (n3 = 0; n3 < n4; ++n3) {
                    lightRetainedArray[n3].isScoped = bl;
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        shape3DRetained = ((GeometryAtom)arrayList2.get((int)n2)).source;
                        shape3DRetained.removeLight(lightRetainedArray[n3]);
                    }
                }
            }
        }
    }

    void updateMirrorObject(Object[] objectArray) {
        int n2;
        Object var2_2 = null;
        int n3 = (Integer)objectArray[1];
        int n4 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n3 & 8) != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                lightRetainedArray[n2].color.set((Color3f)objectArray[4]);
            }
        }
        if ((n3 & 0x20) != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                Color3f color3f = (Color3f)((Object[])objectArray[4])[6];
                lightRetainedArray[n2].color.set(color3f);
            }
        }
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        if (!this.inSharedGroup) {
            arrayList.add(this.mirrorLights[0]);
        } else {
            for (int i2 = 0; i2 < this.numMirrorLights; ++i2) {
                if (!this.mirrorLights[i2].key.equals((Object)hashKey)) continue;
                arrayList.add(this.mirrorLights[i2]);
                break;
            }
        }
    }

    LightRetained getMirrorLight(HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2;
            for (n2 = 0; n2 < this.numMirrorLights; ++n2) {
                if (!this.mirrorLights[n2].key.equals((Object)hashKey)) continue;
                return this.mirrorLights[n2];
            }
            if (this.numMirrorLights == this.mirrorLights.length) {
                LightRetained[] lightRetainedArray = new LightRetained[this.numMirrorLights * 2];
                for (n2 = 0; n2 < this.numMirrorLights; ++n2) {
                    lightRetainedArray[n2] = this.mirrorLights[n2];
                }
                this.mirrorLights = lightRetainedArray;
            }
            this.mirrorLights[this.numMirrorLights] = (LightRetained)this.clone();
            if (this.boundingLeaf != null) {
                this.mirrorLights[this.numMirrorLights].boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
                if (this.mirrorLights[this.numMirrorLights].boundingLeaf != null) {
                    this.mirrorLights[this.numMirrorLights].boundingLeaf.addUser(this.mirrorLights[this.numMirrorLights]);
                }
            }
            this.mirrorLights[this.numMirrorLights].key = hashKey;
            this.mirrorLights[this.numMirrorLights].sgLight = this;
            return this.mirrorLights[this.numMirrorLights++];
        }
        if (this.mirrorLights[0] == null) {
            this.mirrorLights[0] = (LightRetained)this.clone();
            if (this.boundingLeaf != null) {
                this.mirrorLights[0].boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
                if (this.mirrorLights[0].boundingLeaf != null) {
                    this.mirrorLights[0].boundingLeaf.addUser(this.mirrorLights[0]);
                }
            }
            this.mirrorLights[0].sgLight = this;
        }
        return this.mirrorLights[0];
    }

    void setLive(SetLiveState setLiveState) {
        this.newlyAddedMirrorLights.clear();
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("LightRetained0"));
        }
        super.doSetLive(setLiveState);
        if (setLiveState.inSharedGroup) {
            for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                LightRetained lightRetained = this.getMirrorLight(setLiveState.keys[i2]);
                lightRetained.localToVworld = new Transform3D[1][];
                lightRetained.localToVworldIndex = new int[1][];
                int n2 = setLiveState.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) {
                    System.err.println("LightRetained : Can't find hashKey");
                }
                lightRetained.localToVworld[0] = this.localToVworld[n2];
                lightRetained.localToVworldIndex[0] = this.localToVworldIndex[n2];
                if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                    setLiveState.viewScopedNodeList.add(lightRetained);
                    setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(i2));
                } else {
                    setLiveState.nodeList.add(lightRetained);
                }
                this.newlyAddedMirrorLights.add(lightRetained);
                if (this.boundingLeaf != null) {
                    this.boundingLeaf.mirrorBoundingLeaf.addUser(lightRetained);
                }
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[i2] != null) {
                    setLiveState.transformTargets[i2].addNode(lightRetained, 1);
                    setLiveState.notifyThreads |= 0x2000;
                }
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[i2] != null) {
                    setLiveState.switchTargets[i2].addNode(lightRetained, 1);
                }
                lightRetained.switchState = (SwitchState)setLiveState.switchStates.get(n2);
            }
        } else {
            LightRetained lightRetained = this.getMirrorLight(null);
            lightRetained.localToVworld = new Transform3D[1][];
            lightRetained.localToVworldIndex = new int[1][];
            lightRetained.localToVworld[0] = this.localToVworld[0];
            lightRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                setLiveState.viewScopedNodeList.add(lightRetained);
                setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
            } else {
                setLiveState.nodeList.add(lightRetained);
            }
            this.newlyAddedMirrorLights.add(lightRetained);
            if (this.boundingLeaf != null) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(lightRetained);
            }
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(lightRetained, 1);
                setLiveState.notifyThreads |= 0x2000;
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(lightRetained, 1);
            }
            lightRetained.switchState = (SwitchState)setLiveState.switchStates.get(0);
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    J3dMessage initMessage(int n2) {
        Cloneable cloneable;
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4096;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 19;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(32);
        LightRetained[] lightRetainedArray = new LightRetained[this.newlyAddedMirrorLights.size()];
        for (int i2 = 0; i2 < lightRetainedArray.length; ++i2) {
            lightRetainedArray[i2] = (LightRetained)this.newlyAddedMirrorLights.get(i2);
        }
        j3dMessage.args[2] = new Integer(lightRetainedArray.length);
        j3dMessage.args[3] = lightRetainedArray;
        Object[] objectArray = new Object[n2];
        objectArray[0] = this.boundingLeaf;
        objectArray[1] = this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null;
        objectArray[2] = this.inBackgroundGroup ? Boolean.TRUE : Boolean.FALSE;
        objectArray[3] = this.geometryBackground;
        objectArray[4] = this.lightOn ? Boolean.TRUE : Boolean.FALSE;
        ArrayList arrayList = new ArrayList();
        for (int i3 = 0; i3 < this.scopes.size(); ++i3) {
            cloneable = (GroupRetained)this.scopes.get(i3);
            this.tempKey.reset();
            cloneable.addAllNodesForScopedLight(lightRetainedArray.length, lightRetainedArray, arrayList, this.tempKey);
        }
        Object[] objectArray2 = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, arrayList};
        objectArray[5] = objectArray2;
        cloneable = new Color3f(this.color);
        objectArray[6] = cloneable;
        j3dMessage.args[4] = objectArray;
        return j3dMessage;
    }

    void clearLive(SetLiveState setLiveState) {
        LightRetained lightRetained;
        this.newlyAddedMirrorLights.clear();
        super.clearLive(setLiveState);
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                lightRetained = this.getMirrorLight(setLiveState.keys[i2]);
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[i2] != null) {
                    setLiveState.transformTargets[i2].addNode(lightRetained, 1);
                    setLiveState.notifyThreads |= 0x2000;
                }
                this.newlyAddedMirrorLights.add(lightRetained);
                if (lightRetained.boundingLeaf != null) {
                    lightRetained.boundingLeaf.removeUser(lightRetained);
                    lightRetained.boundingLeaf = null;
                }
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[i2] != null) {
                    setLiveState.switchTargets[i2].addNode(lightRetained, 1);
                }
                if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                    setLiveState.viewScopedNodeList.add(lightRetained);
                    setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(i2));
                    continue;
                }
                setLiveState.nodeList.add(lightRetained);
            }
        } else {
            lightRetained = this.getMirrorLight(null);
            if (lightRetained.boundingLeaf != null) {
                lightRetained.boundingLeaf.removeUser(lightRetained);
                lightRetained.boundingLeaf = null;
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(lightRetained, 1);
            }
            if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
                setLiveState.viewScopedNodeList.add(lightRetained);
                setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
            } else {
                setLiveState.nodeList.add(lightRetained);
            }
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(lightRetained, 1);
                setLiveState.notifyThreads |= 0x2000;
            }
            this.newlyAddedMirrorLights.add(lightRetained);
        }
        setLiveState.notifyThreads |= 0x1080;
        if (this.scopes.size() > 0) {
            J3dMessage j3dMessage = new J3dMessage();
            LightRetained[] lightRetainedArray = new LightRetained[this.newlyAddedMirrorLights.size()];
            for (int i3 = 0; i3 < lightRetainedArray.length; ++i3) {
                lightRetainedArray[i3] = (LightRetained)this.newlyAddedMirrorLights.get(i3);
            }
            j3dMessage.threads = 4096;
            j3dMessage.universe = this.universe;
            j3dMessage.type = 19;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(64);
            ArrayList arrayList = new ArrayList();
            for (int i4 = 0; i4 < this.scopes.size(); ++i4) {
                GroupRetained groupRetained = (GroupRetained)this.scopes.get(i4);
                this.tempKey.reset();
                groupRetained.removeAllNodesForScopedLight(lightRetainedArray.length, lightRetainedArray, arrayList, this.tempKey);
            }
            j3dMessage.args[2] = arrayList;
            j3dMessage.args[3] = new Integer(lightRetainedArray.length);
            j3dMessage.args[4] = lightRetainedArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void clearMirrorObject(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[2];
        ArrayList arrayList2 = new ArrayList();
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[4];
        int n2 = (Integer)objectArray[3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Shape3DRetained shape3DRetained = ((GeometryAtom)arrayList.get((int)i3)).source;
                shape3DRetained.removeLight(lightRetainedArray[i2]);
            }
            lightRetainedArray[i2].isScoped = false;
        }
    }

    protected Object clone() {
        LightRetained lightRetained = (LightRetained)super.clone();
        lightRetained.color = new Color3f(this.color);
        lightRetained.scopes = (Vector)this.scopes.clone();
        lightRetained.initInfluencingBoundingLeaf(this.getInfluencingBoundingLeaf());
        lightRetained.region = null;
        lightRetained.lightDirty = 65535;
        lightRetained.sgLightDirty = 65535;
        lightRetained.universe = null;
        lightRetained.isNeeded = false;
        lightRetained.inImmCtx = false;
        lightRetained.sgLight = null;
        lightRetained.key = null;
        lightRetained.mirrorLights = new LightRetained[1];
        lightRetained.numMirrorLights = 0;
        lightRetained.environmentSets = new UnorderList(1, EnvironmentSet.class);
        return lightRetained;
    }

    void updateTransformChange() {
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        }
    }

    void sendMessage(int n2, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 19;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.regionOfInfluence != null) {
            this.regionOfInfluence.transform(transformGroupRetained.transform);
        }
    }
}

