/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class LineStripArrayRetained
extends GeometryStripArrayRetained {
    LineStripArrayRetained() {
        this.geoType = 7;
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n2, Point3d point3d, GeometryRetained geometryRetained, int n3) {
        Point3d[] point3dArray = new Point3d[2];
        double[] dArray = new double[1];
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        int[] nArray = new int[2];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n4 < this.stripVertexCounts.length) {
                    int n5 = this.stripStartVertexIndices[n4];
                    int n6 = n5 + this.stripVertexCounts[n4++];
                    nArray[0] = n5;
                    this.getVertexData(n5++, point3dArray[0]);
                    while (n5 < n6) {
                        nArray[1] = n5;
                        this.getVertexData(n5++, point3dArray[1]);
                        if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], pickRay.origin, pickRay.direction, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d vector3d = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (n4 < this.stripVertexCounts.length) {
                    int n7 = this.stripStartVertexIndices[n4];
                    int n8 = n7 + this.stripVertexCounts[n4++];
                    nArray[0] = n7;
                    this.getVertexData(n7++, point3dArray[0]);
                    while (n7 < n8) {
                        nArray[1] = n7;
                        this.getVertexData(n7++, point3dArray[1]);
                        if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], pickSegment.start, vector3d, dArray, point3d) && dArray[0] <= 1.0) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox boundingBox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (n4 < this.stripVertexCounts.length) {
                    int n9 = this.stripStartVertexIndices[n4];
                    int n10 = n9 + this.stripVertexCounts[n4++];
                    nArray[0] = n9;
                    this.getVertexData(n9++, point3dArray[0]);
                    while (n9 < n10) {
                        nArray[1] = n9;
                        this.getVertexData(n9++, point3dArray[1]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (n4 < this.stripVertexCounts.length) {
                    int n11 = this.stripStartVertexIndices[n4];
                    int n12 = n11 + this.stripVertexCounts[n4++];
                    nArray[0] = n11;
                    this.getVertexData(n11++, point3dArray[0]);
                    while (n11 < n12) {
                        nArray[1] = n11;
                        this.getVertexData(n11++, point3dArray[1]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (n4 < this.stripVertexCounts.length) {
                    int n13 = this.stripStartVertexIndices[n4];
                    int n14 = n13 + this.stripVertexCounts[n4++];
                    nArray[0] = n13;
                    this.getVertexData(n13++, point3dArray[0]);
                    while (n13 < n14) {
                        nArray[1] = n13;
                        this.getVertexData(n13++, point3dArray[1]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n4 < this.stripVertexCounts.length) {
                    int n15 = this.stripStartVertexIndices[n4];
                    int n16 = n15 + this.stripVertexCounts[n4++];
                    nArray[0] = n15;
                    this.getVertexData(n15++, point3dArray[0]);
                    while (n15 < n16) {
                        nArray[1] = n15;
                        this.getVertexData(n15++, point3dArray[1]);
                        if (this.intersectCylinder(point3dArray, pickCylinder, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n4 < this.stripVertexCounts.length) {
                    int n17 = this.stripStartVertexIndices[n4];
                    int n18 = n17 + this.stripVertexCounts[n4++];
                    nArray[0] = n17;
                    this.getVertexData(n17++, point3dArray[0]);
                    while (n17 < n18) {
                        nArray[1] = n17;
                        this.getVertexData(n17++, point3dArray[1]);
                        if (this.intersectCone(point3dArray, pickCone, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("LineStripArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (d2 < Double.MAX_VALUE) {
            point3d.x = d3;
            point3d.y = d4;
            point3d.z = d5;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[2];
        double[] dArray = new double[1];
        int n2 = 0;
        point3dArray2[0] = new Point3d();
        point3dArray2[1] = new Point3d();
        switch (point3dArray.length) {
            case 3: 
            case 4: {
                while (n2 < this.stripVertexCounts.length) {
                    int n3 = this.stripStartVertexIndices[n2];
                    int n4 = n3 + this.stripVertexCounts[n2++];
                    this.getVertexData(n3++, point3dArray2[0]);
                    while (n3 < n4) {
                        this.getVertexData(n3++, point3dArray2[1]);
                        if (this.intersectSegment(point3dArray, point3dArray2[0], point3dArray2[1], dArray, null)) {
                            return true;
                        }
                        point3dArray2[0].set(point3dArray2[1]);
                    }
                }
                break;
            }
            case 2: {
                Vector3d vector3d = new Vector3d();
                while (n2 < this.stripVertexCounts.length) {
                    int n5 = this.stripStartVertexIndices[n2];
                    int n6 = n5 + this.stripVertexCounts[n2++];
                    this.getVertexData(n5++, point3dArray2[0]);
                    while (n5 < n6) {
                        this.getVertexData(n5++, point3dArray2[1]);
                        vector3d.x = point3dArray2[1].x - point3dArray2[0].x;
                        vector3d.y = point3dArray2[1].y - point3dArray2[0].y;
                        vector3d.z = point3dArray2[1].z - point3dArray2[0].z;
                        if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], point3dArray2[0], vector3d, dArray, null) && dArray[0] <= 1.0) {
                            return true;
                        }
                        point3dArray2[0].set(point3dArray2[1]);
                    }
                }
                break;
            }
            case 1: {
                Vector3d vector3d = new Vector3d();
                while (n2 < this.stripVertexCounts.length) {
                    int n7 = this.stripStartVertexIndices[n2];
                    int n8 = n7 + this.stripVertexCounts[n2++];
                    this.getVertexData(n7++, point3dArray2[0]);
                    while (n7 < n8) {
                        this.getVertexData(n7++, point3dArray2[1]);
                        vector3d.x = point3dArray2[1].x - point3dArray2[0].x;
                        vector3d.y = point3dArray2[1].y - point3dArray2[0].y;
                        vector3d.z = point3dArray2[1].z - point3dArray2[0].z;
                        if (this.intersectPntAndRay(point3dArray[0], point3dArray2[0], vector3d, dArray) && dArray[0] <= 1.0) {
                            return true;
                        }
                        point3dArray2[0].set(point3dArray2[1]);
                    }
                }
                break;
            }
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        int n2 = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d()};
        while (n2 < this.stripVertexCounts.length) {
            int n3 = this.stripStartVertexIndices[n2];
            int n4 = n3 + this.stripVertexCounts[n2++];
            this.getVertexData(n3++, point3dArray[0]);
            transform3D.transform(point3dArray[0]);
            while (n3 < n4) {
                this.getVertexData(n3++, point3dArray[1]);
                transform3D.transform(point3dArray[1]);
                if (geometryRetained.intersect(point3dArray)) {
                    return true;
                }
                point3dArray[0].set(point3dArray[1]);
            }
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        int n2 = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d()};
        switch (bounds.getPickType()) {
            case 6: {
                BoundingBox boundingBox = (BoundingBox)bounds;
                while (n2 < this.stripVertexCounts.length) {
                    int n3 = this.stripStartVertexIndices[n2];
                    int n4 = n3 + this.stripVertexCounts[n2++];
                    this.getVertexData(n3++, point3dArray[0]);
                    while (n3 < n4) {
                        this.getVertexData(n3++, point3dArray[1]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, null, null)) {
                            return true;
                        }
                        point3dArray[0].set(point3dArray[1]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)bounds;
                while (n2 < this.stripVertexCounts.length) {
                    int n5 = this.stripStartVertexIndices[n2];
                    int n6 = n5 + this.stripVertexCounts[n2++];
                    this.getVertexData(n5++, point3dArray[0]);
                    while (n5 < n6) {
                        this.getVertexData(n5++, point3dArray[1]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, null, null)) {
                            return true;
                        }
                        point3dArray[0].set(point3dArray[1]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
                while (n2 < this.stripVertexCounts.length) {
                    int n7 = this.stripStartVertexIndices[n2];
                    int n8 = n7 + this.stripVertexCounts[n2++];
                    this.getVertexData(n7++, point3dArray[0]);
                    while (n7 < n8) {
                        this.getVertexData(n7++, point3dArray[1]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, null, null)) {
                            return true;
                        }
                        point3dArray[0].set(point3dArray[1]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + bounds);
            }
        }
        return false;
    }

    void computeCentroid() {
        double d2;
        int n2 = 0;
        double d3 = 0.0;
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (n2 < this.stripVertexCounts.length) {
            int n3 = this.stripStartVertexIndices[n2];
            int n4 = n3 + this.stripVertexCounts[n2++];
            this.getVertexData(n3++, point3d);
            boolean bl = true;
            while (n3 < n4) {
                if (bl) {
                    this.getVertexData(n3++, point3d2);
                    bl = false;
                } else {
                    this.getVertexData(n3++, point3d);
                    bl = true;
                }
                d2 = point3d.distance(point3d2);
                this.centroid.x += (point3d.x + point3d2.x) * d2;
                this.centroid.y += (point3d.y + point3d2.y) * d2;
                this.centroid.z += (point3d.z + point3d2.z) * d2;
                d3 += d2;
            }
        }
        if (d3 != 0.0) {
            d2 = 1.0 / (2.0 * d3);
            this.centroid.x *= d2;
            this.centroid.y *= d2;
            this.centroid.z *= d2;
        }
    }

    int getClassType() {
        return 2;
    }
}

