/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;

public class PhysicalEnvironment {
    int HeadIndex = 0;
    int RightHandIndex = 1;
    int LeftHandIndex = 2;
    int DominantHandIndex = 1;
    int NonDominantHandIndex = 2;
    Transform3D coexistenceToTrackerBase = new Transform3D();
    boolean trackingAvailable = false;
    int coexistenceCenterInPworldPolicy = 2;
    int peDirtyMask = 0x700000;
    int sensorCount;
    Sensor[] sensors;
    AudioDevice audioDevice = null;
    boolean sensorListChanged = false;
    Sensor[] sensorList = null;
    ArrayList users = new ArrayList();
    InputDeviceScheduler inputsched;
    Vector devices = new Vector(1);
    int activeViewRef = 0;
    static Hashtable physicalEnvMap = new Hashtable();

    public PhysicalEnvironment() {
        this(3);
    }

    synchronized void removeUser(View view) {
        int n2 = this.users.indexOf(view);
        if (n2 >= 0) {
            this.users.remove(n2);
        }
    }

    synchronized void addUser(View view) {
        int n2 = this.users.indexOf(view);
        if (n2 < 0) {
            this.users.add(view);
        }
    }

    synchronized void notifyUsers() {
        for (int i2 = this.users.size() - 1; i2 >= 0; --i2) {
            View view = (View)this.users.get(i2);
            view.repaint();
        }
    }

    public PhysicalEnvironment(int n2) {
        this.sensorCount = n2;
        this.sensors = new Sensor[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.sensors[i2] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Sensor[] getSensorList() {
        Sensor[] sensorArray = this.sensors;
        synchronized (this.sensors) {
            if (this.sensorListChanged) {
                this.sensorList = new Sensor[this.sensors.length];
                for (int i2 = 0; i2 < this.sensors.length; ++i2) {
                    this.sensorList[i2] = this.sensors[i2];
                }
                this.sensorListChanged = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sensorList;
        }
    }

    public void setAudioDevice(AudioDevice audioDevice) {
        this.audioDevice = audioDevice;
    }

    public AudioDevice getAudioDevice() {
        return this.audioDevice;
    }

    public Enumeration getAllInputDevices() {
        return this.devices.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputDevice(InputDevice inputDevice) {
        int n2 = inputDevice.getProcessingMode();
        if (n2 == 3 || n2 == 4 || n2 == 5) {
            Vector vector = this.devices;
            synchronized (vector) {
                this.devices.add(inputDevice);
                if (this.inputsched != null) {
                    this.inputsched.addInputDevice(inputDevice);
                }
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("PhysicalEnvironment0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputDevice(InputDevice inputDevice) {
        this.devices.remove(inputDevice);
        Vector vector = this.devices;
        synchronized (vector) {
            if (this.inputsched != null) {
                this.inputsched.removeInputDevice(inputDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadIndex(int n2) {
        this.HeadIndex = n2;
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.computeTrackingAvailable();
            this.peDirtyMask |= 0x200000;
        }
        this.notifyUsers();
    }

    public int getHeadIndex() {
        return this.HeadIndex;
    }

    public void setRightHandIndex(int n2) {
        this.RightHandIndex = n2;
        this.notifyUsers();
    }

    public int getRightHandIndex() {
        return this.RightHandIndex;
    }

    public void setLeftHandIndex(int n2) {
        this.LeftHandIndex = n2;
        this.notifyUsers();
    }

    public int getLeftHandIndex() {
        return this.LeftHandIndex;
    }

    public void setDominantHandIndex(int n2) {
        this.DominantHandIndex = n2;
        this.notifyUsers();
    }

    public int getDominantHandIndex() {
        return this.DominantHandIndex;
    }

    public void setNonDominantHandIndex(int n2) {
        this.NonDominantHandIndex = n2;
        this.notifyUsers();
    }

    public int getNonDominantHandIndex() {
        return this.NonDominantHandIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSensor(int n2, Sensor sensor) {
        Object object = this.sensors;
        synchronized (this.sensors) {
            this.sensors[n2] = sensor;
            this.sensorListChanged = true;
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            object = this;
            synchronized (object) {
                this.computeTrackingAvailable();
                this.peDirtyMask |= 0x200000;
            }
            this.notifyUsers();
            return;
        }
    }

    public Sensor getSensor(int n2) {
        return this.sensors[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoexistenceToTrackerBase(Transform3D transform3D) {
        if (!transform3D.isRigid()) {
            throw new BadTransformException(J3dI18N.getString("PhysicalEnvironment1"));
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.coexistenceToTrackerBase.setWithLock(transform3D);
            this.peDirtyMask |= 0x100000;
        }
        this.notifyUsers();
    }

    public void getCoexistenceToTrackerBase(Transform3D transform3D) {
        transform3D.set(this.coexistenceToTrackerBase);
    }

    public boolean getTrackingAvailable() {
        return this.trackingAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoexistenceCenterInPworldPolicy(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("PhysicalEnvironment2"));
            }
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.coexistenceCenterInPworldPolicy = n2;
            this.peDirtyMask |= 0x400000;
        }
        this.notifyUsers();
    }

    public int getCoexistenceCenterInPworldPolicy() {
        return this.coexistenceCenterInPworldPolicy;
    }

    public int getSensorCount() {
        return this.sensorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSensorCount(int n2) {
        Sensor[] sensorArray = new Sensor[n2];
        int n3 = 0;
        Sensor[] sensorArray2 = this.sensors;
        synchronized (this.sensors) {
            int n4 = Math.min(n2, this.sensorCount);
            while (n3 < n4) {
                sensorArray[n3] = this.sensors[n3++];
            }
            while (n3 < n2) {
                sensorArray[n3++] = null;
            }
            this.sensorCount = n2;
            this.sensorListChanged = true;
            this.sensors = sensorArray;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.notifyUsers();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTrackingAvailable() {
        Sensor[] sensorArray = this.sensors;
        synchronized (this.sensors) {
            this.trackingAvailable = this.HeadIndex < this.sensors.length && this.sensors[this.HeadIndex] != null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

