/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.Context;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3f;

class PointLightRetained
extends LightRetained {
    static final int POSITION_CHANGED = 128;
    static final int ATTENUATION_CHANGED = 256;
    static final int LAST_POINTLIGHT_DEFINED_BIT = 256;
    Point3f attenuation = new Point3f(1.0f, 0.0f, 0.0f);
    Point3f position = new Point3f();
    Point3f xformPosition = new Point3f();
    double localToVworldScale;
    float linearAttenuationInEc;
    float quadraticAttenuationInEc;

    PointLightRetained() {
        this.nodeType = 7;
        this.lightType = 3;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void initPosition(Point3f point3f) {
        this.position.set(point3f);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position, this.position);
        }
    }

    void setPosition(Point3f point3f) {
        this.initPosition(point3f);
        this.sendMessage(128, new Point3f(point3f));
    }

    void initPosition(float f2, float f3, float f4) {
        this.position.x = f2;
        this.position.y = f3;
        this.position.z = f4;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position, this.position);
        }
    }

    void setPosition(float f2, float f3, float f4) {
        this.setPosition(new Point3f(f2, f3, f4));
    }

    void getPosition(Point3f point3f) {
        point3f.set(this.position);
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(point3f, point3f);
        }
    }

    void initAttenuation(Point3f point3f) {
        this.attenuation.set(point3f);
    }

    void setAttenuation(Point3f point3f) {
        this.initAttenuation(point3f);
        this.sendMessage(256, new Point3f(point3f));
    }

    void initAttenuation(float f2, float f3, float f4) {
        this.attenuation.x = f2;
        this.attenuation.y = f3;
        this.attenuation.z = f4;
    }

    void setAttenuation(float f2, float f3, float f4) {
        this.setAttenuation(new Point3f(f2, f3, f4));
    }

    void getAttenuation(Point3f point3f) {
        point3f.set(this.attenuation);
    }

    void update(Context context, int n2, double d2) {
        this.validateAttenuationInEc(d2);
        Pipeline.getPipeline().updatePointLight(context, n2, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z);
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        J3dMessage j3dMessage = super.initMessage(9);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[7] = new Point3f(this.position);
        objectArray[8] = new Point3f(this.attenuation);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void doSetLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
    }

    J3dMessage initMessage(int n2) {
        J3dMessage j3dMessage = super.initMessage(n2);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[7] = new Point3f(this.position);
        objectArray[8] = new Point3f(this.attenuation);
        return j3dMessage;
    }

    void updateMirrorObject(Object[] objectArray) {
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n2 & 0x80) != 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!(lightRetainedArray[i2] instanceof PointLightRetained)) continue;
                PointLightRetained pointLightRetained = (PointLightRetained)lightRetainedArray[i2];
                Transform3D transform3D = pointLightRetained.getLastLocalToVworld();
                pointLightRetained.position = (Point3f)objectArray[4];
                transform3D.transform(pointLightRetained.position, pointLightRetained.xformPosition);
                pointLightRetained.localToVworldScale = transform3D.getDistanceScale();
            }
        } else if ((n2 & 0x100) != 0) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!(lightRetainedArray[i3] instanceof PointLightRetained)) continue;
                PointLightRetained pointLightRetained = (PointLightRetained)lightRetainedArray[i3];
                pointLightRetained.attenuation.set((Point3f)objectArray[4]);
            }
        } else if ((n2 & 0x20) != 0) {
            for (int i4 = 0; i4 < n3; ++i4) {
                if (!(lightRetainedArray[i4] instanceof PointLightRetained)) continue;
                PointLightRetained pointLightRetained = (PointLightRetained)this.mirrorLights[i4];
                pointLightRetained.position = (Point3f)((Object[])objectArray[4])[7];
                pointLightRetained.attenuation.set((Point3f)((Object[])objectArray[4])[8]);
                Transform3D transform3D = pointLightRetained.getLastLocalToVworld();
                transform3D.transform(pointLightRetained.position, pointLightRetained.xformPosition);
                pointLightRetained.localToVworldScale = transform3D.getDistanceScale();
            }
        }
        super.updateMirrorObject(objectArray);
    }

    void validateAttenuationInEc(double d2) {
        double d3 = this.localToVworldScale * d2;
        this.linearAttenuationInEc = (float)((double)this.attenuation.y / d3);
        this.quadraticAttenuationInEc = (float)((double)this.attenuation.z / (d3 * d3));
    }

    protected Object clone() {
        PointLightRetained pointLightRetained = (PointLightRetained)super.clone();
        pointLightRetained.attenuation = new Point3f(this.attenuation);
        pointLightRetained.position = new Point3f(this.position);
        pointLightRetained.xformPosition = new Point3f();
        return pointLightRetained;
    }

    void updateTransformChange() {
        super.updateTransformChange();
        Transform3D transform3D = this.getLastLocalToVworld();
        transform3D.transform(this.position, this.xformPosition);
        this.localToVworldScale = transform3D.getDistanceScale();
        this.validateAttenuationInEc(0.0861328125);
    }

    void sendMessage(int n2, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 19;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

