/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.SoundRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;

class PointSoundRetained
extends SoundRetained {
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    Point3f xformPosition = new Point3f();
    Transform3D trans = new Transform3D();
    float[] attenuationDistance;
    float[] attenuationGain;

    PointSoundRetained() {
        this.nodeType = 13;
    }

    void setPosition(Point3f point3f) {
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(point3f, this.position);
        } else {
            this.position.set(point3f);
        }
        this.getLastLocalToVworld().transform(point3f, this.xformPosition);
        this.dispatchAttribChange(64, new Point3f(this.position));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setPosition(float f2, float f3, float f4) {
        this.position.x = f2;
        this.position.y = f3;
        this.position.z = f4;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position);
        }
        this.getLastLocalToVworld().transform(this.position, this.xformPosition);
        this.dispatchAttribChange(64, new Point3f(this.position));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getPosition(Point3f point3f) {
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(this.position, point3f);
        } else {
            point3f.set(this.position);
        }
    }

    void getXformPosition(Point3f point3f) {
        point3f.set(this.xformPosition);
    }

    void setDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.attenuationDistance = null;
            this.attenuationGain = null;
            return;
        }
        int n2 = point2fArray.length;
        this.attenuationDistance = new float[n2];
        this.attenuationGain = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attenuationDistance[i2] = point2fArray[i2].x;
            this.attenuationGain[i2] = point2fArray[i2].y;
        }
        this.dispatchAttribChange(128, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setDistanceGain(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            this.attenuationDistance = null;
            this.attenuationGain = null;
            return;
        }
        int n2 = fArray2.length;
        int n3 = fArray.length;
        this.attenuationDistance = new float[n3];
        this.attenuationGain = new float[n3];
        System.arraycopy(fArray, 0, this.attenuationDistance, 0, n3);
        if (n3 <= n2) {
            System.arraycopy(fArray2, 0, this.attenuationGain, 0, n3);
        } else {
            System.arraycopy(fArray2, 0, this.attenuationGain, 0, n2);
            for (int i2 = n2; i2 < n3; ++i2) {
                this.attenuationGain[i2] = fArray2[n2 - 1];
            }
        }
        Point2f[] point2fArray = new Point2f[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            point2fArray[i3] = new Point2f(this.attenuationDistance[i3], this.attenuationGain[i3]);
        }
        this.dispatchAttribChange(128, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getDistanceGainLength() {
        if (this.attenuationDistance == null) {
            return 0;
        }
        return this.attenuationDistance.length;
    }

    void getDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.attenuationDistance == null || this.attenuationGain == null) {
            return;
        }
        int n2 = this.attenuationDistance.length;
        int n3 = point2fArray.length;
        if (n2 > n3) {
            n2 = n3;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            point2fArray[i2].x = this.attenuationDistance[i2];
            point2fArray[i2].y = this.attenuationGain[i2];
        }
    }

    void getDistanceGain(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.attenuationDistance == null || this.attenuationGain == null) {
            return;
        }
        int n2 = fArray.length;
        int n3 = this.attenuationDistance.length;
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.attenuationDistance, 0, fArray, 0, n2);
        n3 = this.attenuationDistance.length;
        int n4 = fArray2.length;
        if (n4 > n3) {
            n4 = n3;
        }
        System.arraycopy(this.attenuationGain, 0, fArray2, 0, n4);
    }

    void updateMirrorObject(Object[] objectArray) {
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        SoundRetained[] soundRetainedArray = (SoundRetained[])objectArray[3];
        if (n2 == -1) {
            this.initMirrorObject((PointSoundRetained)objectArray[2]);
            return;
        }
        if ((n2 & 0x40) != 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                PointSoundRetained pointSoundRetained = (PointSoundRetained)soundRetainedArray[i2];
                pointSoundRetained.position = (Point3f)objectArray[4];
                pointSoundRetained.getLastLocalToVworld().transform(pointSoundRetained.position, pointSoundRetained.xformPosition);
            }
        }
        super.updateMirrorObject(objectArray);
    }

    synchronized void initMirrorObject(PointSoundRetained pointSoundRetained) {
        super.initMirrorObject(pointSoundRetained);
        pointSoundRetained.position.set(this.position);
        pointSoundRetained.xformPosition.set(this.xformPosition);
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.position, this.xformPosition);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

