/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Vector3d;

public class PositionInterpolator
extends TransformInterpolator {
    private Transform3D translation = new Transform3D();
    private Vector3d transv = new Vector3d();
    float startPosition;
    float endPosition;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    PositionInterpolator() {
    }

    public PositionInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha, transformGroup);
        this.startPosition = 0.0f;
        this.endPosition = 1.0f;
    }

    public PositionInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f2, float f3) {
        super(alpha, transformGroup, transform3D);
        this.startPosition = f2;
        this.endPosition = f3;
    }

    public void setStartPosition(float f2) {
        this.startPosition = f2;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public void setEndPosition(float f2) {
        this.endPosition = f2;
    }

    public float getEndPosition() {
        return this.endPosition;
    }

    public void setAxisOfTranslation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfTranslation() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f2, Transform3D transform3D) {
        double d2 = (1.0 - (double)f2) * (double)this.startPosition + (double)(f2 * this.endPosition);
        this.transv.set(d2, 0.0, 0.0);
        this.translation.setTranslation(this.transv);
        transform3D.mul(this.axis, this.translation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        PositionInterpolator positionInterpolator = new PositionInterpolator();
        positionInterpolator.duplicateNode(this, bl);
        return positionInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PositionInterpolator positionInterpolator = (PositionInterpolator)node;
        this.setStartPosition(positionInterpolator.getStartPosition());
        this.setEndPosition(positionInterpolator.getEndPosition());
    }
}

