/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsDevice;
import java.io.PrintStream;
import javax.media.j3d.Canvas3D;

public class RenderingError {
    private int errorCode = 0;
    private String errorMessage = null;
    private String detailMessage = null;
    private GraphicsDevice graphicsDevice = null;
    private Canvas3D canvas = null;
    public static final int NO_ERROR = 0;
    public static final int UNEXPECTED_RENDERING_ERROR = 1;
    public static final int GRAPHICS_CONFIG_ERROR = 2;
    public static final int CONTEXT_CREATION_ERROR = 3;
    public static final int OFF_SCREEN_BUFFER_ERROR = 4;

    public RenderingError() {
    }

    public RenderingError(int n2, String string) {
        this.errorCode = n2;
        this.errorMessage = string;
    }

    public void printVerbose() {
        this.printVerbose(System.err);
    }

    public void printVerbose(PrintStream printStream) {
        printStream.println(this);
        if (this.graphicsDevice != null) {
            printStream.println("graphicsDevice = " + this.graphicsDevice);
        }
        if (this.canvas != null) {
            printStream.println("canvas = " + this.canvas);
        }
        if (this.detailMessage != null) {
            printStream.println();
            printStream.println("Detail Message");
            printStream.println("--------------");
            printStream.println(this.detailMessage);
        }
    }

    public void setErrorCode(int n2) {
        this.errorCode = n2;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setDetailMessage(String string) {
        this.detailMessage = string;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public void setGraphicsDevice(GraphicsDevice graphicsDevice) {
        this.graphicsDevice = graphicsDevice;
    }

    public GraphicsDevice getGraphicsDevice() {
        return this.graphicsDevice;
    }

    public void setCanvas3D(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas;
    }

    public String toString() {
        String string;
        switch (this.errorCode) {
            case 0: {
                string = "NO_ERROR";
                break;
            }
            case 1: {
                string = "UNEXPECTED_RENDERING_ERROR";
                break;
            }
            case 2: {
                string = "GRAPHICS_CONFIG_ERROR";
                break;
            }
            case 3: {
                string = "CONTEXT_CREATION_ERROR";
                break;
            }
            case 4: {
                string = "OFF_SCREEN_BUFFER_ERROR";
                break;
            }
            default: {
                string = "UNKNOWN ERROR CODE (" + this.errorCode + ")";
            }
        }
        if (this.errorMessage == null) {
            return string;
        }
        return string + ": " + this.errorMessage;
    }
}

