/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class ShaderAttributeSetRetained
extends NodeComponentRetained {
    private Map attrs = new HashMap();
    Object liveStateLock = new Object();

    ShaderAttributeSetRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(ShaderAttribute shaderAttribute) {
        Object object = this.liveStateLock;
        synchronized (object) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)shaderAttribute.retained;
            assert (shaderAttributeRetained != null);
            this.attrs.put(shaderAttributeRetained.attrName, shaderAttributeRetained);
            if (this.source.isLive()) {
                shaderAttributeRetained.setLive(this.inBackgroundGroup, this.refCount);
                shaderAttributeRetained.copyMirrorUsers(this);
                this.sendMessage(1, shaderAttributeRetained.mirror);
            }
        }
    }

    ShaderAttribute get(String string) {
        return (ShaderAttribute)((ShaderAttributeRetained)this.attrs.get((Object)string)).source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String string) {
        Object object = this.liveStateLock;
        synchronized (object) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)this.attrs.get(string);
            this.attrs.remove(string);
            if (this.source.isLive()) {
                shaderAttributeRetained.clearLive(this.refCount);
                shaderAttributeRetained.removeMirrorUsers(this);
                this.sendMessage(2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ShaderAttribute shaderAttribute) {
        Object object = this.liveStateLock;
        synchronized (object) {
            String string = shaderAttribute.getAttributeName();
            if (this.attrs.get(string) == shaderAttribute) {
                this.attrs.remove(string);
                if (this.source.isLive()) {
                    ((ShaderAttributeRetained)shaderAttribute.retained).clearLive(this.refCount);
                    ((ShaderAttributeRetained)shaderAttribute.retained).removeMirrorUsers(this);
                    this.sendMessage(2, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.liveStateLock;
        synchronized (object) {
            this.attrs.clear();
            if (this.source.isLive()) {
                ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
                shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
                for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
                    shaderAttributeRetainedArray[i2].clearLive(this.refCount);
                    shaderAttributeRetainedArray[i2].removeMirrorUsers(this);
                }
                this.sendMessage(4, null);
            }
        }
    }

    ShaderAttribute[] getAll() {
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        ShaderAttribute[] shaderAttributeArray = new ShaderAttribute[shaderAttributeRetainedArray.length];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeArray[i2] = (ShaderAttribute)shaderAttributeRetainedArray[i2].source;
        }
        return shaderAttributeArray;
    }

    int size() {
        return this.attrs.size();
    }

    void updateNative(Canvas3D canvas3D, ShaderProgramRetained shaderProgramRetained) {
        shaderProgramRetained.setShaderAttributes(canvas3D, this);
    }

    Map getAttrs() {
        return this.attrs;
    }

    void setLive(boolean bl, int n2) {
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeRetainedArray[i2].setLive(bl, n2);
        }
        super.doSetLive(bl, n2);
        super.markAsLive();
    }

    synchronized void addAMirrorUser(Shape3DRetained shape3DRetained) {
        super.addAMirrorUser(shape3DRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeRetainedArray[i2].addAMirrorUser(shape3DRetained);
        }
    }

    synchronized void removeAMirrorUser(Shape3DRetained shape3DRetained) {
        super.removeAMirrorUser(shape3DRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeRetainedArray[i2].removeAMirrorUser(shape3DRetained);
        }
    }

    synchronized void removeMirrorUsers(NodeComponentRetained nodeComponentRetained) {
        super.removeMirrorUsers(nodeComponentRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeRetainedArray[i2].removeMirrorUsers(nodeComponentRetained);
        }
    }

    synchronized void copyMirrorUsers(NodeComponentRetained nodeComponentRetained) {
        super.copyMirrorUsers(nodeComponentRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeRetainedArray[i2].copyMirrorUsers(nodeComponentRetained);
        }
    }

    void clearLive(int n2) {
        super.clearLive(n2);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            shaderAttributeRetainedArray[i2].clearLive(n2);
        }
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeSetRetained shaderAttributeSetRetained = new ShaderAttributeSetRetained();
            this.mirror = shaderAttributeSetRetained;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    void initMirrorObject() {
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i2 = 0; i2 < shaderAttributeRetainedArray.length; ++i2) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)shaderAttributeRetainedArray[i2].mirror;
            assert (shaderAttributeRetained != null);
            ((ShaderAttributeSetRetained)this.mirror).attrs.put(shaderAttributeRetained.attrName, shaderAttributeRetained);
        }
    }

    synchronized void updateMirrorObject(int n2, Object object) {
        ShaderAttributeSetRetained shaderAttributeSetRetained = (ShaderAttributeSetRetained)this.mirror;
        if ((n2 & 1) != 0) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)object;
            assert (shaderAttributeRetained != null);
            ((ShaderAttributeSetRetained)this.mirror).attrs.put(shaderAttributeRetained.attrName, shaderAttributeRetained);
        } else if ((n2 & 2) != 0) {
            ((ShaderAttributeSetRetained)this.mirror).attrs.remove((String)object);
        } else if ((n2 & 4) != 0) {
            ((ShaderAttributeSetRetained)this.mirror).attrs.clear();
        } else assert (false);
    }

    final void sendMessage(int n2, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 64;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 64;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n2);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setFrequencyChangeMask(int n2, int n3) {
        if (this.source.getCapability(n2)) {
            this.changedFrequent |= n3;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~n3;
        }
    }

    void handleFrequencyChange(int n2) {
        if (n2 == 1) {
            this.setFrequencyChangeMask(n2, 1);
        }
    }
}

