/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NnuId;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;

class Shape3DRetained
extends LeafRetained {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int LAST_DEFINED_BIT = 16;
    static final int targetThreads = 4224;
    AppearanceRetained appearance = null;
    ArrayList geometryList = null;
    private GeometryAtom geomAtom = null;
    private MRSWLock mirrorShape3DLock = null;
    ArrayList mirrorShape3D = new ArrayList(1);
    NodeRetained sourceNode = null;
    HashKey key = null;
    boolean inImmCtx = false;
    int isDirty = 65535;
    LightRetained[] lights = null;
    int numlights = 0;
    FogRetained[] fogs = null;
    int numfogs = 0;
    ModelClipRetained[] modelClips = null;
    int numModelClips = 0;
    AlternateAppearanceRetained[] altApps = null;
    int numAltApps = 0;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    boolean appearanceOverrideEnable = false;
    AppearanceRetained otherAppearance = null;
    Bounds bounds = null;
    BoundingBox vwcBounds = null;
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    OrderedPath orderedPath = null;
    ArrayList viewList = null;
    int changedFrequent = 0;

    Shape3DRetained() {
        this.nodeType = 11;
        this.numlights = 0;
        this.numfogs = 0;
        this.numModelClips = 0;
        this.numAltApps = 0;
        this.localBounds = new BoundingBox((Bounds)null);
        this.mirrorShape3DLock = new MRSWLock();
        this.geometryList = new ArrayList(1);
        this.geometryList.add(null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8192;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            j3dMessage.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getLocalBounds(Bounds bounds) {
        if (this.localBounds != null) {
            this.localBounds.set(bounds);
        } else {
            this.localBounds = new BoundingBox(bounds);
        }
        return this.localBounds;
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 35;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            j3dMessage.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds(int n2) {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void addGeometry(Geometry geometry) {
        GeometryRetained geometryRetained = null;
        this.checkEquivalenceClass(geometry, -1);
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null) {
                geometryRetained = (GeometryRetained)geometry.retained;
                geometryRetained.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.add(geometryRetained);
            } else {
                this.geometryList.add(null);
                geometryRetained = null;
            }
            this.sendDataChangedMessage(geometryRetained);
        } else if (geometry != null) {
            this.geometryList.add((GeometryRetained)geometry.retained);
        } else {
            this.geometryList.add(null);
        }
        this.dirtyBoundsCache();
    }

    void setGeometry(Geometry geometry, int n2) {
        GeometryRetained geometryRetained = null;
        GeometryRetained geometryRetained2 = null;
        this.checkEquivalenceClass(geometry, n2);
        if (((Shape3D)this.source).isLive()) {
            geometryRetained2 = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained2 != null) {
                geometryRetained2.clearLive(this.refCount);
                for (int i2 = 0; i2 < this.mirrorShape3D.size(); ++i2) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(i2);
                    geometryRetained2.removeUser(shape3DRetained);
                }
                geometryRetained2.decRefCnt();
            }
            if (geometry != null) {
                geometryRetained = (GeometryRetained)geometry.retained;
                geometryRetained.incRefCnt();
                geometryRetained.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.set(n2, geometryRetained);
                this.sendDataChangedMessage(geometryRetained);
            } else {
                this.geometryList.set(n2, null);
                this.sendDataChangedMessage(null);
            }
        } else {
            geometryRetained2 = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained2 != null) {
                geometryRetained2.decRefCnt();
            }
            if (geometry != null) {
                this.geometryList.set(n2, (GeometryRetained)geometry.retained);
                ((GeometryRetained)geometry.retained).incRefCnt();
            } else {
                this.geometryList.set(n2, null);
            }
        }
        this.dirtyBoundsCache();
    }

    void insertGeometry(Geometry geometry, int n2) {
        GeometryRetained geometryRetained = null;
        Object var6_4 = null;
        this.checkEquivalenceClass(geometry, -1);
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null) {
                geometryRetained = (GeometryRetained)geometry.retained;
                geometryRetained.incRefCnt();
                this.geometryList.add(n2, geometryRetained);
                geometryRetained.setLive(this.inBackgroundGroup, this.refCount);
                this.sendDataChangedMessage(geometryRetained);
            } else {
                this.geometryList.add(n2, null);
                this.sendDataChangedMessage(null);
            }
        } else if (geometry != null) {
            this.geometryList.add(n2, (GeometryRetained)geometry.retained);
            ((GeometryRetained)geometry.retained).incRefCnt();
        } else {
            this.geometryList.add(n2, null);
        }
        this.dirtyBoundsCache();
    }

    void removeGeometry(int n2) {
        GeometryRetained geometryRetained = null;
        if (((Shape3D)this.source).isLive()) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained != null) {
                geometryRetained.clearLive(this.refCount);
                geometryRetained.decRefCnt();
                for (int i2 = 0; i2 < this.mirrorShape3D.size(); ++i2) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(i2);
                    geometryRetained.removeUser(shape3DRetained);
                }
            }
            this.geometryList.remove(n2);
            this.sendDataChangedMessage(null);
        } else {
            geometryRetained = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained != null) {
                geometryRetained.decRefCnt();
            }
            this.geometryList.remove(n2);
        }
        this.dirtyBoundsCache();
    }

    Geometry getGeometry(int n2, int n3) {
        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(n2);
        return geometryRetained == null ? null : (Geometry)geometryRetained.source;
    }

    Enumeration getAllGeometries(int n2) {
        GeometryRetained geometryRetained = null;
        Vector<Geometry> vector = new Vector<Geometry>(this.geometryList.size());
        for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained != null) {
                vector.add((Geometry)geometryRetained.source);
                continue;
            }
            vector.add(null);
        }
        return vector.elements();
    }

    int numGeometries(int n2) {
        return this.geometryList.size();
    }

    void setAppearance(Appearance appearance) {
        boolean bl = false;
        if (((Shape3D)this.source).isLive()) {
            Shape3DRetained shape3DRetained;
            int n2;
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                for (n2 = 0; n2 < this.mirrorShape3D.size(); ++n2) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n2);
                    this.appearance.removeAMirrorUser(shape3DRetained);
                }
            }
            if (appearance != null) {
                ((AppearanceRetained)appearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)appearance.retained;
                for (n2 = 0; n2 < this.mirrorShape3D.size(); ++n2) {
                    shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n2);
                    this.appearance.addAMirrorUser(shape3DRetained);
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    bl = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                bl = true;
            }
            n2 = 0;
            n2 = bl ? 2 : 1;
            J3dMessage[] j3dMessageArray = new J3dMessage[n2];
            j3dMessageArray[0] = new J3dMessage();
            j3dMessageArray[0].threads = 4224;
            j3dMessageArray[0].type = 24;
            j3dMessageArray[0].universe = this.universe;
            j3dMessageArray[0].args[0] = this;
            j3dMessageArray[0].args[1] = new Integer(2);
            Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(shape3DRetainedArray);
            j3dMessageArray[0].args[2] = shape3DRetainedArray;
            Object[] objectArray = new Object[]{appearance == null ? null : this.appearance.mirror, new Integer(this.changedFrequent)};
            j3dMessageArray[0].args[3] = objectArray;
            j3dMessageArray[0].args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            if (bl) {
                j3dMessageArray[1] = new J3dMessage();
                j3dMessageArray[1].threads = 64;
                j3dMessageArray[1].type = 24;
                j3dMessageArray[1].universe = this.universe;
                j3dMessageArray[1].args[0] = this;
                j3dMessageArray[1].args[1] = new Integer(2);
                j3dMessageArray[1].args[2] = this.visible ? Boolean.TRUE : Boolean.FALSE;
                j3dMessageArray[1].args[3] = j3dMessageArray[0].args[4];
            }
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        } else {
            this.appearance = appearance == null ? null : (AppearanceRetained)appearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void setAppearanceOverrideEnable(boolean bl) {
        if (((Shape3D)this.source).isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 24;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(16);
            Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(shape3DRetainedArray);
            j3dMessage.args[2] = shape3DRetainedArray;
            Object[] objectArray = new Object[]{bl ? Boolean.TRUE : Boolean.FALSE, new Integer(this.changedFrequent)};
            j3dMessage.args[3] = objectArray;
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.appearanceOverrideEnable = bl;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int n2) {
        Transform3D transform3D;
        Transform3D transform3D2 = pickInfo.getLocalToVWorldRef();
        if (this instanceof OrientedShape3DRetained) {
            transform3D = ((OrientedShape3DRetained)this).getOrientedTransform(this.getPrimaryViewIdx());
            transform3D2.mul(transform3D);
        }
        transform3D = new Transform3D();
        transform3D.invert(transform3D2);
        PickShape pickShape2 = pickShape.transform(transform3D);
        int n3 = this.geometryList.size();
        if ((n2 & 8) == 0 && (n2 & 0x10) == 0 && (n2 & 0x20) == 0 && (n2 & 0x40) == 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                if (geometryRetained == null) continue;
                if (geometryRetained.mirrorGeometry != null) {
                    geometryRetained = geometryRetained.mirrorGeometry;
                }
                if (!geometryRetained.intersect(pickShape2, null, 0, null, null, 0)) continue;
                return true;
            }
        } else {
            double d2 = Double.POSITIVE_INFINITY;
            Point3d point3d = new Point3d();
            Point3d point3d2 = new Point3d();
            Point3d point3d3 = new Point3d();
            for (int i3 = 0; i3 < n3; ++i3) {
                GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i3);
                if (geometryRetained == null) continue;
                if (geometryRetained.mirrorGeometry != null) {
                    geometryRetained = geometryRetained.mirrorGeometry;
                }
                if (!geometryRetained.intersect(pickShape2, pickInfo, n2, point3d2, geometryRetained, i3)) continue;
                point3d3.set(point3d2);
                transform3D2.transform(point3d3);
                double d3 = pickShape.distance(point3d3);
                if (!(d2 > d3)) continue;
                d2 = d3;
                point3d.set(point3d2);
            }
            if (d2 < Double.POSITIVE_INFINITY) {
                if ((n2 & 0x10) != 0) {
                    pickInfo.setClosestDistance(d2);
                }
                if ((n2 & 8) != 0) {
                    pickInfo.setClosestIntersectionPoint(point3d);
                }
                return true;
            }
        }
        return false;
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape, double[] dArray) {
        PickInfo pickInfo = new PickInfo();
        Transform3D transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        pickInfo.setLocalToVWorldRef(transform3D);
        if (dArray == null) {
            return this.intersect(pickInfo, pickShape, 0);
        }
        int n2 = 16;
        if (this.intersect(pickInfo, pickShape, n2)) {
            dArray[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    private void initMirrorShape3D(SetLiveState setLiveState, Shape3DRetained shape3DRetained, int n2) {
        shape3DRetained.inBackgroundGroup = this.inBackgroundGroup;
        shape3DRetained.geometryBackground = this.geometryBackground;
        shape3DRetained.source = this.source;
        shape3DRetained.universe = this.universe;
        shape3DRetained.inSharedGroup = false;
        shape3DRetained.locale = this.locale;
        shape3DRetained.parent = this.parent;
        shape3DRetained.boundsAutoCompute = this.boundsAutoCompute;
        shape3DRetained.localBounds = this.localBounds;
        OrderedPath orderedPath = (OrderedPath)setLiveState.orderedPaths.get(n2);
        shape3DRetained.orderedPath = orderedPath.pathElements.size() == 0 ? null : orderedPath;
        shape3DRetained.staticTransform = this.staticTransform;
        shape3DRetained.appearanceOverrideEnable = this.appearanceOverrideEnable;
        shape3DRetained.geometryList = this.geometryList;
        shape3DRetained.sourceNode = this;
        if (this instanceof OrientedShape3DRetained) {
            OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)this;
            OrientedShape3DRetained orientedShape3DRetained2 = (OrientedShape3DRetained)shape3DRetained;
            orientedShape3DRetained2.initAlignmentMode(orientedShape3DRetained.mode);
            orientedShape3DRetained2.initAlignmentAxis(orientedShape3DRetained.axis);
            orientedShape3DRetained2.initRotationPoint(orientedShape3DRetained.rotationPoint);
            orientedShape3DRetained2.initConstantScaleEnable(orientedShape3DRetained.constantScale);
            orientedShape3DRetained2.initScale(orientedShape3DRetained.scaleFactor);
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n2;
        int n3;
        Object[] objectArray2;
        int n4 = (Integer)objectArray[1];
        Shape3DRetained[] shape3DRetainedArray = (Shape3DRetained[])objectArray[2];
        if ((n4 & 2) != 0) {
            objectArray2 = (Object[])objectArray[3];
            n3 = (Integer)objectArray2[1];
            for (n2 = shape3DRetainedArray.length - 1; n2 >= 0; --n2) {
                shape3DRetainedArray[n2].appearance = (AppearanceRetained)objectArray2[0];
                shape3DRetainedArray[n2].changedFrequent = n3;
            }
        }
        if ((n4 & 0x10) != 0) {
            objectArray2 = (Object[])objectArray[3];
            n3 = (Integer)objectArray2[1];
            for (n2 = shape3DRetainedArray.length - 1; n2 >= 0; --n2) {
                shape3DRetainedArray[n2].appearanceOverrideEnable = (Boolean)objectArray2[0];
                shape3DRetainedArray[n2].changedFrequent = n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.cachedBounds != null) {
                return (Bounds)this.cachedBounds.clone();
            }
            if (this.geometryList != null) {
                BoundingBox boundingBox = new BoundingBox((Bounds)null);
                for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                    if (geometryRetained == null || geometryRetained.geoType == -1) continue;
                    geometryRetained.computeBoundingBox();
                    BoundingBox boundingBox2 = geometryRetained.geoBounds;
                    synchronized (boundingBox2) {
                        boundingBox.combine(geometryRetained.geoBounds);
                        continue;
                    }
                }
                return boundingBox;
            }
            return null;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCombineBounds(Bounds bounds) {
        block20: {
            block19: {
                if (!this.boundsAutoCompute) break block19;
                if (this.geometryList == null) break block20;
                BoundingBox boundingBox = null;
                if (this.staticTransform != null) {
                    boundingBox = new BoundingBox((Bounds)null);
                }
                if (!VirtualUniverse.mc.cacheAutoComputedBounds) {
                    for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
                        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                        if (geometryRetained == null || geometryRetained.geoType == -1) continue;
                        geometryRetained.computeBoundingBox();
                        BoundingBox boundingBox2 = geometryRetained.geoBounds;
                        synchronized (boundingBox2) {
                            if (this.staticTransform != null) {
                                boundingBox.set(geometryRetained.geoBounds);
                                boundingBox.transform(this.staticTransform.transform);
                                bounds.combine(boundingBox);
                            } else {
                                bounds.combine(geometryRetained.geoBounds);
                            }
                            continue;
                        }
                    }
                } else {
                    if (this.cachedBounds == null) {
                        this.cachedBounds = new BoundingBox((Bounds)null);
                        for (int i3 = 0; i3 < this.geometryList.size(); ++i3) {
                            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i3);
                            if (geometryRetained == null || geometryRetained.geoType == -1) continue;
                            geometryRetained.computeBoundingBox();
                            BoundingBox boundingBox3 = geometryRetained.geoBounds;
                            synchronized (boundingBox3) {
                                if (this.staticTransform != null) {
                                    boundingBox.set(geometryRetained.geoBounds);
                                    boundingBox.transform(this.staticTransform.transform);
                                    this.cachedBounds.combine(boundingBox);
                                } else {
                                    this.cachedBounds.combine(geometryRetained.geoBounds);
                                }
                                continue;
                            }
                        }
                    }
                    bounds.combine(this.cachedBounds);
                }
                break block20;
            }
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        this.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetLive(SetLiveState setLiveState) {
        Cloneable cloneable;
        Shape3DRetained shape3DRetained;
        int n2;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        super.doSetLive(setLiveState);
        this.nodeId = this.universe.getNodeId();
        if (this.inSharedGroup) {
            for (n2 = 0; n2 < setLiveState.keys.length; ++n2) {
                int n3;
                shape3DRetained = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
                shape3DRetained.key = setLiveState.keys[n2];
                shape3DRetained.localToVworld = new Transform3D[1][];
                shape3DRetained.localToVworldIndex = new int[1][];
                int n4 = setLiveState.keys[n2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                shape3DRetained.localToVworld[0] = this.localToVworld[n4];
                shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[n4];
                shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(n4);
                shape3DRetained.isPickable = setLiveState.pickable[n2];
                shape3DRetained.isCollidable = setLiveState.collidable[n2];
                this.initMirrorShape3D(setLiveState, shape3DRetained, n4);
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[n2] != null) {
                    setLiveState.switchTargets[n2].addNode(shape3DRetained, 0);
                    shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[n2];
                    shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[n2];
                }
                shape3DRetained.switchState = (SwitchState)setLiveState.switchStates.get(n4);
                if (setLiveState.lights != null && (cloneable = (ArrayList)setLiveState.lights.get(n4)) != null) {
                    for (n3 = 0; n3 < ((ArrayList)cloneable).size(); ++n3) {
                        shape3DRetained.addLight((LightRetained)((ArrayList)cloneable).get(n3));
                    }
                }
                if (setLiveState.fogs != null && (cloneable = (ArrayList)setLiveState.fogs.get(n4)) != null) {
                    for (n3 = 0; n3 < ((ArrayList)cloneable).size(); ++n3) {
                        shape3DRetained.addFog((FogRetained)((ArrayList)cloneable).get(n3));
                    }
                }
                if (setLiveState.modelClips != null && (cloneable = (ArrayList)setLiveState.modelClips.get(n4)) != null) {
                    for (n3 = 0; n3 < ((ArrayList)cloneable).size(); ++n3) {
                        shape3DRetained.addModelClip((ModelClipRetained)((ArrayList)cloneable).get(n3));
                    }
                }
                if (setLiveState.altAppearances != null && (cloneable = (ArrayList)setLiveState.altAppearances.get(n4)) != null) {
                    for (n3 = 0; n3 < ((ArrayList)cloneable).size(); ++n3) {
                        shape3DRetained.addAltApp((AlternateAppearanceRetained)((ArrayList)cloneable).get(n3));
                    }
                }
                cloneable = this.mirrorShape3D;
                synchronized (cloneable) {
                    this.mirrorShape3D.add(n4, shape3DRetained);
                }
                arrayList.add(shape3DRetained);
                shape3DRetained.viewList = setLiveState.viewLists != null ? (ArrayList)setLiveState.viewLists.get(n4) : null;
            }
        } else {
            shape3DRetained = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
            shape3DRetained.localToVworld = new Transform3D[1][];
            shape3DRetained.localToVworldIndex = new int[1][];
            shape3DRetained.localToVworld[0] = this.localToVworld[0];
            shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape3DRetained.isPickable = setLiveState.pickable[0];
            shape3DRetained.isCollidable = setLiveState.collidable[0];
            this.initMirrorShape3D(setLiveState, shape3DRetained, 0);
            if (setLiveState.lights != null) {
                cloneable = (ArrayList)setLiveState.lights.get(0);
                for (n2 = 0; n2 < ((ArrayList)cloneable).size(); ++n2) {
                    shape3DRetained.addLight((LightRetained)((ArrayList)cloneable).get(n2));
                }
            }
            if (setLiveState.fogs != null) {
                cloneable = (ArrayList)setLiveState.fogs.get(0);
                for (n2 = 0; n2 < ((ArrayList)cloneable).size(); ++n2) {
                    shape3DRetained.addFog((FogRetained)((ArrayList)cloneable).get(n2));
                }
            }
            if (setLiveState.modelClips != null) {
                cloneable = (ArrayList)setLiveState.modelClips.get(0);
                for (n2 = 0; n2 < ((ArrayList)cloneable).size(); ++n2) {
                    shape3DRetained.addModelClip((ModelClipRetained)((ArrayList)cloneable).get(n2));
                }
            }
            if (setLiveState.altAppearances != null) {
                cloneable = (ArrayList)setLiveState.altAppearances.get(0);
                for (n2 = 0; n2 < ((ArrayList)cloneable).size(); ++n2) {
                    shape3DRetained.addAltApp((AlternateAppearanceRetained)((ArrayList)cloneable).get(n2));
                }
            }
            cloneable = this.mirrorShape3D;
            synchronized (cloneable) {
                this.mirrorShape3D.add(shape3DRetained);
            }
            arrayList.add(shape3DRetained);
            shape3DRetained.viewList = setLiveState.viewLists != null ? (ArrayList)setLiveState.viewLists.get(0) : null;
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(shape3DRetained, 0);
                shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[0];
                shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[0];
            }
            shape3DRetained.switchState = (SwitchState)setLiveState.switchStates.get(0);
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object object;
            cloneable = (Shape3DRetained)arrayList.get(i2);
            if (this.appearance != null) {
                Object object2 = this.appearance.liveStateLock;
                synchronized (object2) {
                    if (i2 == 0) {
                        this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
                        this.appearance.initMirrorObject();
                        if (this.appearance.renderingAttributes != null) {
                            this.visible = this.appearance.renderingAttributes.visible;
                        }
                    }
                    ((Shape3DRetained)cloneable).appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser((Shape3DRetained)cloneable);
                }
            } else {
                ((Shape3DRetained)cloneable).appearance = null;
            }
            if (this.geometryList != null) {
                for (int i3 = 0; i3 < this.geometryList.size(); ++i3) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i3);
                    if (geometryRetained == null) continue;
                    object = geometryRetained.liveStateLock;
                    synchronized (object) {
                        if (i2 == 0) {
                            geometryRetained.setLive(this.inBackgroundGroup, setLiveState.refCount);
                        }
                        geometryRetained.addUser((Shape3DRetained)cloneable);
                        continue;
                    }
                }
            }
            if (i2 == 0 && this.boundsAutoCompute) {
                if (!(this.localBounds instanceof BoundingBox)) {
                    this.localBounds = new BoundingBox((Bounds)null);
                }
                this.getCombineBounds((BoundingBox)this.localBounds);
            }
            this.initializeGAtom((Shape3DRetained)cloneable);
            object = Shape3DRetained.getGeomAtom((Shape3DRetained)cloneable);
            setLiveState.nodeList.add(object);
            if (setLiveState.transformTargets == null || setLiveState.transformTargets[i2] == null) continue;
            setLiveState.transformTargets[i2].addNode((NnuId)object, 0);
        }
        setLiveState.notifyThreads |= 0x30C0;
    }

    void clearMirrorShape() {
        int n2;
        this.source = null;
        this.sourceNode = null;
        this.parent = null;
        if (this.otherAppearance != null) {
            this.otherAppearance.sgApp.removeAMirrorUser(this);
            this.otherAppearance = null;
        }
        this.appearance = null;
        this.branchGroupPath = null;
        this.isPickable = true;
        this.isCollidable = true;
        this.branchGroupPath = null;
        this.geometryList = null;
        for (n2 = 0; n2 < this.numfogs; ++n2) {
            this.fogs[n2] = null;
        }
        this.numfogs = 0;
        for (n2 = 0; n2 < this.numModelClips; ++n2) {
            this.modelClips[n2] = null;
        }
        this.numModelClips = 0;
        for (n2 = 0; n2 < this.numlights; ++n2) {
            this.lights[n2] = null;
        }
        this.numlights = 0;
        for (n2 = 0; n2 < this.numAltApps; ++n2) {
            this.altApps[n2] = null;
        }
        this.numAltApps = 0;
        this.viewList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLive(SetLiveState setLiveState) {
        NnuId nnuId;
        Shape3DRetained shape3DRetained;
        int n2;
        Object object;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        super.clearLive(setLiveState);
        if (this.inSharedGroup) {
            object = this.mirrorShape3D;
            synchronized (object) {
                Object[] objectArray = this.mirrorShape3D.toArray();
                for (n2 = 0; n2 < setLiveState.keys.length; ++n2) {
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        shape3DRetained = (Shape3DRetained)objectArray[i2];
                        if (!shape3DRetained.key.equals((Object)setLiveState.keys[n2])) continue;
                        this.mirrorShape3D.remove(this.mirrorShape3D.indexOf(shape3DRetained));
                        if (setLiveState.switchTargets != null && setLiveState.switchTargets[n2] != null) {
                            setLiveState.switchTargets[n2].addNode(shape3DRetained, 0);
                        }
                        arrayList.add(shape3DRetained);
                        nnuId = Shape3DRetained.getGeomAtom(shape3DRetained);
                        setLiveState.nodeList.add(nnuId);
                        if (setLiveState.transformTargets == null || setLiveState.transformTargets[n2] == null) continue;
                        setLiveState.transformTargets[n2].addNode(nnuId, 0);
                    }
                }
            }
        }
        shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
        object = this.mirrorShape3D;
        synchronized (object) {
            this.mirrorShape3D.remove(0);
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(shape3DRetained, 0);
        }
        arrayList.add(shape3DRetained);
        object = Shape3DRetained.getGeomAtom(shape3DRetained);
        setLiveState.nodeList.add(object);
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode((NnuId)object, 0);
        }
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            Object object2;
            nnuId = (Shape3DRetained)arrayList.get(i3);
            if (this.appearance != null) {
                object2 = this.appearance.liveStateLock;
                synchronized (object2) {
                    if (i3 == 0) {
                        this.appearance.clearLive(setLiveState.refCount);
                    }
                    this.appearance.removeAMirrorUser((Shape3DRetained)nnuId);
                }
            }
            if (this.geometryList == null) continue;
            for (int i4 = 0; i4 < this.geometryList.size(); ++i4) {
                GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i4);
                if (geometryRetained == null) continue;
                object2 = geometryRetained.liveStateLock;
                synchronized (object2) {
                    if (i3 == 0) {
                        geometryRetained.clearLive(setLiveState.refCount);
                    }
                    geometryRetained.removeUser((Shape3DRetained)nnuId);
                    continue;
                }
            }
        }
        setLiveState.notifyThreads |= 0x30C0;
        if (!this.source.isLive()) {
            for (n2 = 0; n2 < this.numfogs; ++n2) {
                this.fogs[n2] = null;
            }
            this.numfogs = 0;
            for (n2 = 0; n2 < this.numModelClips; ++n2) {
                this.modelClips[n2] = null;
            }
            this.numModelClips = 0;
            for (n2 = 0; n2 < this.numlights; ++n2) {
                this.lights[n2] = null;
            }
            this.numlights = 0;
            for (n2 = 0; n2 < this.numAltApps; ++n2) {
                this.altApps[n2] = null;
            }
            this.numAltApps = 0;
        }
    }

    boolean isStatic() {
        return !this.source.getCapability(15) && !this.source.getCapability(13) && !this.source.getCapability(19);
    }

    boolean staticXformCanBeApplied() {
        if (this.isPickable || this.isCollidable || this.source.getCapability(6) || this.source.getCapability(8)) {
            return false;
        }
        if (this.appearance != null && this.appearance.transparencyAttributes != null && this.appearance.transparencyAttributes.transparencyMode != 4) {
            return false;
        }
        for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained == null) continue;
            if (geometryRetained.refCnt > 1) {
                return false;
            }
            boolean bl = this.isAlphaEditable(geometryRetained);
            if (geometryRetained instanceof GeometryArrayRetained) {
                boolean bl2 = geometryRetained.isEditable = !((GeometryArrayRetained)geometryRetained).isWriteStatic();
                if (geometryRetained.source.getCapability(0) || geometryRetained.source.getCapability(4)) {
                    return false;
                }
            }
            if (geometryRetained.canBeInDisplayList(bl)) continue;
            return false;
        }
        return true;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if (this.isStatic() && this.staticXformCanBeApplied()) {
            this.mergeFlag = 1;
        } else {
            this.mergeFlag = 0;
            compileState.keepTG = true;
        }
        if (this.appearance != null) {
            this.appearance.compile(compileState);
            if (this.appearance.isStatic()) {
                AppearanceRetained appearanceRetained;
                this.appearance = appearanceRetained = compileState.getAppearance(this.appearance);
            }
        }
        for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained == null) continue;
            geometryRetained.compile(compileState);
        }
    }

    void merge(CompileState compileState) {
        if (this.mergeFlag == 0) {
            TransformGroupRetained transformGroupRetained = compileState.staticTransform;
            compileState.staticTransform = null;
            super.merge(compileState);
            compileState.staticTransform = transformGroupRetained;
        } else {
            super.merge(compileState);
        }
        if (this.shapeIsMergeable(compileState)) {
            compileState.addShape(this);
        }
    }

    boolean shapeIsMergeable(CompileState compileState) {
        boolean bl = true;
        GeometryRetained geometryRetained = null;
        int n2 = 0;
        if (this.staticTransform != null) {
            return false;
        }
        if (this.parent instanceof OrderedGroupRetained || this.parent instanceof SwitchRetained) {
            return false;
        }
        for (int i2 = 0; geometryRetained == null && i2 < this.geometryList.size(); ++i2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(i2);
        }
        if (!(geometryRetained instanceof GeometryArrayRetained)) {
            return false;
        }
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
        for (n2 = i2; n2 < this.geometryList.size() && bl; ++n2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained == null) continue;
            GeometryArrayRetained geometryArrayRetained2 = (GeometryArrayRetained)geometryRetained;
            if (!geometryArrayRetained2.isWriteStatic()) {
                bl = false;
            }
            if (geometryArrayRetained2.vertexFormat == geometryArrayRetained.vertexFormat) continue;
            bl = false;
        }
        if (this.source.getCapability(17) || this.source.getCapability(15) || this.source.getCapability(19) || this.source.getCapability(10) || this.source.getCapability(4) || this.source.getCapability(8) || this.source.getCapability(6) || this.source.getCapability(13)) {
            bl = false;
        }
        return bl;
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained;
        if (this.inSharedGroup) {
            if (hashKey.count == 0) {
                return;
            }
            shape3DRetained = this.getMirrorShape(hashKey);
        } else {
            shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        arrayList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
    }

    void addLight(LightRetained lightRetained) {
        if (this.lights == null) {
            this.lights = new LightRetained[10];
        } else if (this.lights.length == this.numlights) {
            LightRetained[] lightRetainedArray = new LightRetained[this.numlights * 2];
            for (int i2 = 0; i2 < this.numlights; ++i2) {
                lightRetainedArray[i2] = this.lights[i2];
            }
            this.lights = lightRetainedArray;
        }
        this.lights[this.numlights] = lightRetained;
        ++this.numlights;
    }

    void removeLight(LightRetained lightRetained) {
        int n2;
        for (n2 = 0; n2 < this.numlights; ++n2) {
            if (this.lights[n2] != lightRetained) continue;
            this.lights[n2] = null;
            break;
        }
        ++n2;
        while (n2 < this.numlights) {
            this.lights[n2 - 1] = this.lights[n2];
            ++n2;
        }
        --this.numlights;
    }

    void addFog(FogRetained fogRetained) {
        if (this.fogs == null) {
            this.fogs = new FogRetained[10];
        } else if (this.fogs.length == this.numfogs) {
            FogRetained[] fogRetainedArray = new FogRetained[this.numfogs * 2];
            for (int i2 = 0; i2 < this.numfogs; ++i2) {
                fogRetainedArray[i2] = this.fogs[i2];
            }
            this.fogs = fogRetainedArray;
        }
        this.fogs[this.numfogs] = fogRetained;
        ++this.numfogs;
    }

    void removeFog(FogRetained fogRetained) {
        int n2;
        for (n2 = 0; n2 < this.numfogs; ++n2) {
            if (this.fogs[n2] != fogRetained) continue;
            this.fogs[n2] = null;
            break;
        }
        ++n2;
        while (n2 < this.numfogs) {
            this.fogs[n2 - 1] = this.fogs[n2];
            ++n2;
        }
        --this.numfogs;
    }

    void addModelClip(ModelClipRetained modelClipRetained) {
        if (this.modelClips == null) {
            this.modelClips = new ModelClipRetained[10];
        } else if (this.modelClips.length == this.numModelClips) {
            ModelClipRetained[] modelClipRetainedArray = new ModelClipRetained[this.numModelClips * 2];
            for (int i2 = 0; i2 < this.numModelClips; ++i2) {
                modelClipRetainedArray[i2] = this.modelClips[i2];
            }
            this.modelClips = modelClipRetainedArray;
        }
        this.modelClips[this.numModelClips] = modelClipRetained;
        ++this.numModelClips;
    }

    void removeModelClip(ModelClipRetained modelClipRetained) {
        int n2;
        for (n2 = 0; n2 < this.numModelClips; ++n2) {
            if (this.modelClips[n2] != modelClipRetained) continue;
            this.modelClips[n2] = null;
            break;
        }
        ++n2;
        while (n2 < this.numModelClips) {
            this.modelClips[n2 - 1] = this.modelClips[n2];
            ++n2;
        }
        --this.numModelClips;
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        if (this.altApps == null) {
            this.altApps = new AlternateAppearanceRetained[10];
        } else if (this.altApps.length == this.numAltApps) {
            AlternateAppearanceRetained[] alternateAppearanceRetainedArray = new AlternateAppearanceRetained[this.numAltApps * 2];
            for (int i2 = 0; i2 < this.numAltApps; ++i2) {
                alternateAppearanceRetainedArray[i2] = this.altApps[i2];
            }
            this.altApps = alternateAppearanceRetainedArray;
        }
        this.altApps[this.numAltApps] = alternateAppearanceRetained;
        ++this.numAltApps;
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        int n2;
        for (n2 = 0; n2 < this.numAltApps; ++n2) {
            if (this.altApps[n2] != alternateAppearanceRetained) continue;
            this.altApps[n2] = null;
            break;
        }
        ++n2;
        while (n2 < this.numAltApps) {
            this.altApps[n2 - 1] = this.altApps[n2];
            ++n2;
        }
        --this.numAltApps;
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updatePickable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isPickable = blArray[0];
        } else {
            int n2 = this.mirrorShape3D.size();
            block0: for (int i2 = 0; i2 < hashKeyArray.length; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(i3);
                    if (!hashKeyArray[i2].equals((Object)shape3DRetained.key)) continue;
                    shape3DRetained.isPickable = blArray[i2];
                    continue block0;
                }
            }
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updateCollidable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isCollidable = blArray[0];
        } else {
            int n2 = this.mirrorShape3D.size();
            block0: for (int i2 = 0; i2 < hashKeyArray.length; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(i3);
                    if (!hashKeyArray[i2].equals((Object)shape3DRetained.key)) continue;
                    shape3DRetained.isCollidable = blArray[i2];
                    continue block0;
                }
            }
        }
    }

    private void sendDataChangedMessage(GeometryRetained geometryRetained) {
        Object object;
        CachedTargets[] cachedTargetsArray;
        Object object2;
        int n2;
        GeometryAtom[] geometryAtomArray = null;
        GeometryAtom[] geometryAtomArray2 = null;
        Object var7_4 = null;
        int n3 = 0;
        GeometryRetained geometryRetained2 = null;
        int n4 = this.mirrorShape3D.size();
        if (n4 < 1) {
            return;
        }
        Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.mirrorShape3DLock.writeLock();
        GeometryAtom geometryAtom = shape3DRetained.geomAtom;
        GeometryAtom geometryAtom2 = new GeometryAtom();
        if (geometryRetained != null) {
            geometryRetained.addUser(shape3DRetained);
        }
        int n5 = this.geometryList.size();
        for (n2 = 0; n2 < n5; ++n2) {
            geometryRetained2 = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained2 == null) continue;
            geometryAtom2.geoType = geometryRetained2.geoType;
            geometryAtom2.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained2);
            break;
        }
        if (geometryRetained2 != null && geometryRetained2.geoType == 16) {
            for (n2 = 0; n2 < n5; ++n2) {
                geometryRetained2 = (GeometryRetained)this.geometryList.get(n2);
                if (geometryRetained2 != null) {
                    object2 = (Text3DRetained)geometryRetained2;
                    n3 += ((Text3DRetained)object2).numChars;
                    continue;
                }
                ++n3;
            }
            geometryAtom2.geometryArray = new GeometryRetained[n3];
            geometryAtom2.lastLocalTransformArray = new Transform3D[n3];
            n3 = 0;
        } else {
            geometryAtom2.geometryArray = new GeometryRetained[n5];
        }
        geometryAtom2.locale = shape3DRetained.locale;
        geometryAtom2.visible = this.visible;
        geometryAtom2.source = shape3DRetained;
        for (int i2 = 0; i2 < n5; ++i2) {
            geometryRetained2 = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained2 == null) {
                geometryAtom2.geometryArray[n3++] = null;
                continue;
            }
            if (geometryRetained2.geoType == 16) {
                object2 = (Text3DRetained)geometryRetained2;
                n2 = 0;
                while (n2 < ((Text3DRetained)object2).numChars) {
                    cachedTargetsArray = ((Text3DRetained)object2).geometryList[n2];
                    if (cachedTargetsArray != null) {
                        geometryAtom2.geometryArray[n3] = cachedTargetsArray;
                        geometryAtom2.lastLocalTransformArray[n3] = ((Text3DRetained)object2).charTransforms[n2];
                    } else {
                        geometryAtom2.geometryArray[n3] = null;
                        geometryAtom2.lastLocalTransformArray[n3] = null;
                    }
                    ++n2;
                    ++n3;
                }
                continue;
            }
            geometryAtom2.geometryArray[n3++] = geometryRetained2;
        }
        geometryAtomArray2 = new GeometryAtom[n4];
        geometryAtomArray = new GeometryAtom[n4];
        geometryAtomArray2[0] = geometryAtom;
        geometryAtomArray[0] = geometryAtom2;
        shape3DRetained.geomAtom = geometryAtom2;
        shape3DRetained.mirrorShape3DLock.writeUnlock();
        for (n2 = 1; n2 < n4; ++n2) {
            shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n2);
            shape3DRetained.mirrorShape3DLock.writeLock();
            geometryAtom = shape3DRetained.geomAtom;
            geometryAtom2 = new GeometryAtom();
            if (geometryRetained != null) {
                geometryRetained.addUser(shape3DRetained);
            }
            geometryAtom2.geoType = geometryAtomArray[0].geoType;
            geometryAtom2.locale = shape3DRetained.locale;
            geometryAtom2.visible = this.visible;
            geometryAtom2.source = shape3DRetained;
            geometryAtom2.alphaEditable = geometryAtomArray[0].alphaEditable;
            geometryAtom2.geometryArray = new GeometryRetained[geometryAtomArray[0].geometryArray.length];
            for (int i3 = 0; i3 < geometryAtom2.geometryArray.length; ++i3) {
                geometryAtom2.geometryArray[i3] = geometryAtomArray[0].geometryArray[i3];
            }
            geometryAtomArray2[n2] = geometryAtom;
            geometryAtomArray[n2] = geometryAtom2;
            shape3DRetained.geomAtom = geometryAtom2;
            shape3DRetained.mirrorShape3DLock.writeUnlock();
        }
        object2 = ((GroupRetained)this.parent).getClosestTargetsInterface(0);
        cachedTargetsArray = null;
        if (object2 != null) {
            cachedTargetsArray = new CachedTargets[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                object = object2.getCachedTargets(0, n2, -1);
                if (object != null) {
                    cachedTargetsArray[n2] = new CachedTargets();
                    cachedTargetsArray[n2].copy((CachedTargets)object);
                    cachedTargetsArray[n2].replace(geometryAtomArray2[n2], geometryAtomArray[n2], 0);
                    continue;
                }
                cachedTargetsArray[n2] = null;
            }
            object2.resetCachedTargets(0, cachedTargetsArray, -1);
        }
        object = new J3dMessage();
        ((J3dMessage)object).type = 24;
        ((J3dMessage)object).threads = 8384;
        ((J3dMessage)object).universe = this.universe;
        ((J3dMessage)object).args[0] = this;
        ((J3dMessage)object).args[1] = new Integer(1);
        ((J3dMessage)object).args[2] = geometryAtomArray2;
        ((J3dMessage)object).args[3] = geometryAtomArray;
        if (object2 != null) {
            ((J3dMessage)object).args[4] = object2;
            ((J3dMessage)object).args[5] = cachedTargetsArray;
        }
        if (this.boundsAutoCompute) {
            this.getCombineBounds((BoundingBox)this.localBounds);
        }
        VirtualUniverse.mc.processMessage((J3dMessage)object);
    }

    Shape3DRetained getMirrorShape(SceneGraphPath sceneGraphPath) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey hashKey = new HashKey("");
        sceneGraphPath.getHashKey(hashKey);
        return this.getMirrorShape(hashKey);
    }

    Shape3DRetained getMirrorShape(HashKey hashKey) {
        if (hashKey == null) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n2 >= 0) {
            return (Shape3DRetained)this.mirrorShape3D.get(n2);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            int n2;
            if (bl) {
                this.localBounds = new BoundingBox((Bounds)null);
                if (this.source.isLive() && this.geometryList != null) {
                    n2 = this.geometryList.size() * this.mirrorShape3D.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                        geometryRetained.incrComputeGeoBounds();
                    }
                }
                this.getCombineBounds((BoundingBox)this.localBounds);
            } else if (this.source.isLive() && this.geometryList != null) {
                n2 = this.geometryList.size() * this.mirrorShape3D.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i3);
                    geometryRetained.decrComputeGeoBounds();
                }
            }
            super.setBoundsAutoCompute(bl);
            if (this.source.isLive()) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                j3dMessage.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBounds() {
        this.localBounds = new BoundingBox((Bounds)null);
        this.getCombineBounds((BoundingBox)this.localBounds);
        ArrayList arrayList = this.mirrorShape3D;
        synchronized (arrayList) {
            if (this.source.isLive()) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                j3dMessage.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    boolean allowIntersect() {
        GeometryRetained geometryRetained = null;
        for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained == null || geometryRetained.source.getCapability(18)) continue;
            return false;
        }
        return true;
    }

    boolean intersectGeometryList(Shape3DRetained shape3DRetained) {
        ArrayList arrayList = shape3DRetained.geometryList;
        int n2 = arrayList.size();
        Transform3D transform3D = shape3DRetained.getCurrentLocalToVworld();
        Transform3D transform3D2 = this.getCurrentLocalToVworld();
        Object var8_6 = null;
        int n3 = -1;
        if (this instanceof OrientedShape3DRetained) {
            n3 = this.getPrimaryViewIdx();
            transform3D2.mul(((OrientedShape3DRetained)this).getOrientedTransform(n3));
        }
        if (shape3DRetained instanceof OrientedShape3DRetained) {
            if (n3 < 0) {
                n3 = this.getPrimaryViewIdx();
            }
            transform3D.mul(((OrientedShape3DRetained)shape3DRetained).getOrientedTransform(n3));
        }
        for (int i2 = this.geometryList.size() - 1; i2 >= 0; --i2) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained == null) continue;
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                GeometryRetained geometryRetained2 = (GeometryRetained)arrayList.get(i3);
                if (geometryRetained2 == null || !geometryRetained.intersect(transform3D2, transform3D, geometryRetained2)) continue;
                return true;
            }
        }
        return false;
    }

    boolean intersectGeometryList(Transform3D transform3D, Bounds bounds) {
        if (this instanceof OrientedShape3DRetained) {
            Transform3D transform3D2 = ((OrientedShape3DRetained)this).getOrientedTransform(this.getPrimaryViewIdx());
            transform3D.mul(transform3D2);
        }
        for (int i2 = this.geometryList.size() - 1; i2 >= 0; --i2) {
            GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
            if (geometryRetained == null || !geometryRetained.intersect(transform3D, bounds)) continue;
            return true;
        }
        return false;
    }

    void initMirrorShape3D(SetLiveState setLiveState, MorphRetained morphRetained, int n2) {
        Object var5_4 = null;
        this.universe = morphRetained.universe;
        this.inSharedGroup = morphRetained.inSharedGroup;
        this.inBackgroundGroup = morphRetained.inBackgroundGroup;
        this.geometryBackground = morphRetained.geometryBackground;
        this.parent = morphRetained.parent;
        this.locale = morphRetained.locale;
        OrderedPath orderedPath = (OrderedPath)setLiveState.orderedPaths.get(n2);
        this.orderedPath = orderedPath.pathElements.size() == 0 ? null : orderedPath;
        this.staticTransform = morphRetained.staticTransform;
        if (morphRetained.boundsAutoCompute) {
            this.localBounds.set(morphRetained.localBounds);
        }
        this.bounds = this.localBounds;
        this.vwcBounds = new BoundingBox((Bounds)null);
        this.vwcBounds.transform(this.bounds, this.getCurrentLocalToVworld(0));
        if (morphRetained.collisionBound == null) {
            this.collisionBound = null;
            this.collisionVwcBound = this.vwcBounds;
        } else {
            this.collisionBound = morphRetained.collisionBound;
            this.collisionVwcBound = (Bounds)this.collisionBound.clone();
            this.collisionVwcBound.transform(this.getCurrentLocalToVworld(0));
        }
        this.appearanceOverrideEnable = morphRetained.appearanceOverrideEnable;
        this.geometryList = new ArrayList(1);
        this.geometryList.add((GeometryArrayRetained)morphRetained.morphedGeometryArray.retained);
        GeometryAtom geometryAtom = new GeometryAtom();
        geometryAtom.geometryArray = new GeometryRetained[1];
        geometryAtom.locale = this.locale;
        geometryAtom.visible = morphRetained.visible;
        geometryAtom.source = this;
        GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(0);
        if (geometryRetained == null) {
            geometryAtom.geometryArray[0] = null;
        } else {
            geometryAtom.geometryArray[0] = (GeometryArrayRetained)morphRetained.morphedGeometryArray.retained;
            geometryAtom.geoType = geometryAtom.geometryArray[0].geoType;
        }
        this.geomAtom = geometryAtom;
        this.sourceNode = morphRetained;
    }

    void setMorphGeometry(Geometry geometry, ArrayList arrayList) {
        Object object;
        int n2;
        int n3 = arrayList.size();
        GeometryAtom[] geometryAtomArray = new GeometryAtom[n3];
        GeometryAtom[] geometryAtomArray2 = new GeometryAtom[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList.get(n2);
            GeometryAtom geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
            shape3DRetained.geometryList = new ArrayList(1);
            shape3DRetained.geometryList.add((GeometryArrayRetained)geometry.retained);
            GeometryAtom geometryAtom2 = new GeometryAtom();
            geometryAtom2.geometryArray = new GeometryRetained[1];
            if (geometry == null) {
                geometryAtom2.geometryArray[0] = null;
            } else {
                geometryAtom2.geometryArray[0] = (GeometryArrayRetained)geometry.retained;
                geometryAtom2.geoType = geometryAtom2.geometryArray[0].geoType;
            }
            geometryAtom2.locale = this.locale;
            geometryAtom2.visible = geometryAtom.visible;
            geometryAtom2.source = this;
            geometryAtomArray[n2] = geometryAtom;
            geometryAtomArray2[n2] = geometryAtom2;
            Shape3DRetained.setGeomAtom(shape3DRetained, geometryAtom2);
        }
        TargetsInterface targetsInterface = ((GroupRetained)this.parent).getClosestTargetsInterface(0);
        CachedTargets[] cachedTargetsArray = null;
        if (targetsInterface != null) {
            cachedTargetsArray = new CachedTargets[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object = targetsInterface.getCachedTargets(0, n2, -1);
                if (object != null) {
                    cachedTargetsArray[n2] = new CachedTargets();
                    cachedTargetsArray[n2].copy((CachedTargets)object);
                    cachedTargetsArray[n2].replace(geometryAtomArray[n2], geometryAtomArray2[n2], 0);
                    continue;
                }
                cachedTargetsArray[n2] = null;
            }
        }
        object = new J3dMessage();
        ((J3dMessage)object).type = 24;
        ((J3dMessage)object).threads = 8384;
        ((J3dMessage)object).universe = this.universe;
        ((J3dMessage)object).args[0] = this;
        ((J3dMessage)object).args[1] = new Integer(1);
        ((J3dMessage)object).args[2] = geometryAtomArray;
        ((J3dMessage)object).args[3] = geometryAtomArray2;
        if (targetsInterface != null) {
            ((J3dMessage)object).args[4] = targetsInterface;
            ((J3dMessage)object).args[5] = cachedTargetsArray;
        }
        VirtualUniverse.mc.processMessage((J3dMessage)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final GeometryAtom[] getGeomAtomsArray(ArrayList geometryAtomArray) {
        Shape3DRetained shape3DRetained = null;
        GeometryAtom[] geometryAtomArray2 = null;
        int n2 = 0;
        GeometryAtom[] geometryAtomArray3 = geometryAtomArray;
        synchronized (geometryAtomArray) {
            int n3;
            int n4 = geometryAtomArray.size();
            geometryAtomArray2 = new GeometryAtom[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                shape3DRetained = (Shape3DRetained)geometryAtomArray.get(n3);
                shape3DRetained.mirrorShape3DLock.readLock();
                if (shape3DRetained.geomAtom == null) {
                    ++n2;
                }
                geometryAtomArray2[n3] = shape3DRetained.geomAtom;
                shape3DRetained.mirrorShape3DLock.readUnlock();
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            if (n2 == 0) {
                return geometryAtomArray2;
            }
            if (n2 == n4) {
                return null;
            }
            geometryAtomArray3 = new GeometryAtom[n4 - n2];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                if (geometryAtomArray2[n3] == null) continue;
                geometryAtomArray3[n5++] = geometryAtomArray2[n3];
            }
            return geometryAtomArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ArrayList getGeomAtomsList(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<ArrayList<GeometryAtom>> arrayList3 = new ArrayList<ArrayList<GeometryAtom>>();
        ArrayList<GeometryAtom> arrayList4 = null;
        Shape3DRetained shape3DRetained = null;
        boolean bl = false;
        VirtualUniverse virtualUniverse = null;
        ArrayList arrayList5 = arrayList;
        synchronized (arrayList5) {
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                shape3DRetained = (Shape3DRetained)arrayList.get(i2);
                if (!bl) {
                    if (virtualUniverse == null) {
                        virtualUniverse = shape3DRetained.universe;
                        arrayList2.add(shape3DRetained.universe);
                        arrayList4 = new ArrayList<GeometryAtom>();
                        arrayList3.add(arrayList4);
                    } else if (virtualUniverse != shape3DRetained.universe) {
                        bl = true;
                        arrayList2.add(shape3DRetained.universe);
                        arrayList4 = new ArrayList();
                        arrayList3.add(arrayList4);
                    }
                } else {
                    int n2 = arrayList2.indexOf(shape3DRetained.universe);
                    if (n2 < 0) {
                        arrayList2.add(shape3DRetained.universe);
                        arrayList4 = new ArrayList();
                        arrayList3.add(arrayList4);
                    } else {
                        arrayList4 = (ArrayList<GeometryAtom>)arrayList3.get(n2);
                    }
                }
                shape3DRetained.mirrorShape3DLock.readLock();
                if (shape3DRetained.geomAtom != null) {
                    arrayList4.add(shape3DRetained.geomAtom);
                }
                shape3DRetained.mirrorShape3DLock.readUnlock();
            }
        }
        return arrayList3;
    }

    static final GeometryAtom getGeomAtom(Shape3DRetained shape3DRetained) {
        shape3DRetained.mirrorShape3DLock.readLock();
        GeometryAtom geometryAtom = shape3DRetained.geomAtom;
        shape3DRetained.mirrorShape3DLock.readUnlock();
        return geometryAtom;
    }

    static final void setGeomAtom(Shape3DRetained shape3DRetained, GeometryAtom geometryAtom) {
        shape3DRetained.mirrorShape3DLock.writeLock();
        shape3DRetained.geomAtom = geometryAtom;
        shape3DRetained.mirrorShape3DLock.writeUnlock();
    }

    boolean isAlphaEditable(GeometryRetained geometryRetained) {
        boolean bl = false;
        if (this.appearanceOverrideEnable) {
            bl = true;
        } else if (geometryRetained != null && this.appearance != null) {
            AppearanceRetained appearanceRetained = this.appearance;
            if (this.source.getCapability(15) || this.source.getCapability(19) || appearanceRetained.source.getCapability(13) || appearanceRetained.source.getCapability(11) || appearanceRetained.renderingAttributes != null && (appearanceRetained.renderingAttributes.source.getCapability(3) || appearanceRetained.renderingAttributes.source.getCapability(10)) || appearanceRetained.transparencyAttributes != null && (appearanceRetained.transparencyAttributes.source.getCapability(1) || appearanceRetained.transparencyAttributes.source.getCapability(3))) {
                bl = true;
            } else if (geometryRetained instanceof GeometryArrayRetained && (appearanceRetained.source.getCapability(7) || appearanceRetained.textureAttributes != null && appearanceRetained.textureAttributes.source.getCapability(1))) {
                bl = true;
            } else if (geometryRetained instanceof RasterRetained && (((RasterRetained)geometryRetained).type & 1) != 0 && ((RasterRetained)geometryRetained).source.getCapability(5)) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getCombineBounds(BoundingBox boundingBox) {
        if (this.geometryList != null) {
            BoundingBox boundingBox2 = null;
            if (this.staticTransform != null) {
                boundingBox2 = new BoundingBox((Bounds)null);
            }
            BoundingBox boundingBox3 = boundingBox;
            synchronized (boundingBox3) {
                boundingBox.setLower(1.0, 1.0, 1.0);
                boundingBox.setUpper(-1.0, -1.0, -1.0);
                for (int i2 = 0; i2 < this.geometryList.size(); ++i2) {
                    GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                    if (geometryRetained == null || geometryRetained.geoType == -1) continue;
                    BoundingBox boundingBox4 = geometryRetained.geoBounds;
                    synchronized (boundingBox4) {
                        if (this.staticTransform != null) {
                            boundingBox2.set(geometryRetained.geoBounds);
                            boundingBox2.transform(this.staticTransform.transform);
                            boundingBox.combine(boundingBox2);
                        } else {
                            boundingBox.combine(geometryRetained.geoBounds);
                        }
                        continue;
                    }
                }
            }
            if (this instanceof OrientedShape3DRetained) {
                double d2 = Math.abs(boundingBox.lower.x);
                double d3 = Math.abs(boundingBox.upper.x);
                if (d3 > d2) {
                    d2 = d3;
                }
                if ((d3 = Math.abs(boundingBox.lower.y)) > d2) {
                    d2 = d3;
                }
                if ((d3 = Math.abs(boundingBox.upper.y)) > d2) {
                    d2 = d3;
                }
                if ((d3 = Math.abs(boundingBox.lower.z)) > d2) {
                    d2 = d3;
                }
                if ((d3 = Math.abs(boundingBox.upper.z)) > d2) {
                    d2 = d3;
                }
                boundingBox.setLower(-d2, -d2, -d2);
                boundingBox.setUpper(d2, d2, d2);
            }
        }
    }

    boolean isEquivalent(Shape3DRetained shape3DRetained) {
        if (this.appearance != shape3DRetained.appearance || this.appearanceOverrideEnable != shape3DRetained.appearanceOverrideEnable || this.isPickable != shape3DRetained.isPickable || this.isCollidable != shape3DRetained.isCollidable) {
            return false;
        }
        if (this.boundsAutoCompute) {
            if (!shape3DRetained.boundsAutoCompute) {
                return false;
            }
        } else if (this.localBounds != null) {
            if (shape3DRetained.localBounds != null) {
                return this.localBounds.equals(shape3DRetained.localBounds);
            }
        } else if (shape3DRetained.localBounds != null) {
            return false;
        }
        if (this.collisionBound != null) {
            if (shape3DRetained.collisionBound == null) {
                return false;
            }
            return this.collisionBound.equals(shape3DRetained.collisionBound);
        }
        return shape3DRetained.collisionBound == null;
    }

    void initializeGAtom(Shape3DRetained shape3DRetained) {
        Text3DRetained text3DRetained;
        int n2;
        int n3 = 0;
        int n4 = this.geometryList.size();
        GeometryRetained geometryRetained = null;
        shape3DRetained.bounds = this.localBounds;
        shape3DRetained.vwcBounds = new BoundingBox((Bounds)null);
        shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
        if (this.collisionBound == null) {
            shape3DRetained.collisionBound = null;
            shape3DRetained.collisionVwcBound = shape3DRetained.vwcBounds;
        } else {
            shape3DRetained.collisionBound = this.collisionBound;
            shape3DRetained.collisionVwcBound = (Bounds)shape3DRetained.collisionBound.clone();
            shape3DRetained.collisionVwcBound.transform(shape3DRetained.getCurrentLocalToVworld(0));
        }
        GeometryAtom geometryAtom = new GeometryAtom();
        for (n2 = 0; n2 < n4; ++n2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained == null) continue;
            geometryAtom.geoType = geometryRetained.geoType;
            geometryAtom.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained);
            break;
        }
        if (geometryRetained != null && geometryRetained.geoType == 16) {
            for (n2 = 0; n2 < n4; ++n2) {
                geometryRetained = (GeometryRetained)this.geometryList.get(n2);
                if (geometryRetained != null) {
                    text3DRetained = (Text3DRetained)geometryRetained;
                    n3 += text3DRetained.numChars;
                    continue;
                }
                ++n3;
            }
            geometryAtom.geometryArray = new GeometryRetained[n3];
            geometryAtom.lastLocalTransformArray = new Transform3D[n3];
            n3 = 0;
        } else {
            geometryAtom.geometryArray = new GeometryRetained[n4];
        }
        for (n2 = 0; n2 < this.geometryList.size(); ++n2) {
            geometryRetained = (GeometryRetained)this.geometryList.get(n2);
            if (geometryRetained == null) {
                geometryAtom.geometryArray[n2] = null;
                continue;
            }
            if (geometryRetained.geoType == 16) {
                text3DRetained = (Text3DRetained)geometryRetained;
                int n5 = 0;
                while (n5 < text3DRetained.numChars) {
                    GeometryArrayRetained geometryArrayRetained = text3DRetained.geometryList[n5];
                    if (geometryArrayRetained != null) {
                        geometryAtom.geometryArray[n3] = geometryArrayRetained;
                        geometryAtom.lastLocalTransformArray[n3] = text3DRetained.charTransforms[n5];
                    } else {
                        geometryAtom.geometryArray[n3] = null;
                        geometryAtom.lastLocalTransformArray[n3] = null;
                    }
                    ++n5;
                    ++n3;
                }
                continue;
            }
            geometryAtom.geometryArray[n2] = geometryRetained;
        }
        geometryAtom.locale = shape3DRetained.locale;
        geometryAtom.visible = this.visible;
        geometryAtom.source = shape3DRetained;
        shape3DRetained.geomAtom = geometryAtom;
    }

    void checkEquivalenceClass(Geometry geometry, int n2) {
        if (geometry != null) {
            for (int i2 = this.geometryList.size() - 1; i2 >= 0; --i2) {
                GeometryRetained geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                if (geometryRetained == null || n2 == i2) continue;
                if (geometryRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) break;
                throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
            }
        }
    }

    int indexOfGeometry(Geometry geometry) {
        if (geometry != null) {
            return this.geometryList.indexOf(geometry.retained);
        }
        return this.geometryList.indexOf(null);
    }

    void removeGeometry(Geometry geometry) {
        int n2 = this.indexOfGeometry(geometry);
        if (n2 >= 0) {
            this.removeGeometry(n2);
        }
    }

    void removeAllGeometries() {
        int n2 = this.geometryList.size();
        GeometryRetained geometryRetained = null;
        if (((Shape3D)this.source).isLive()) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                geometryRetained = (GeometryRetained)this.geometryList.get(i2);
                if (geometryRetained != null) {
                    geometryRetained.clearLive(this.refCount);
                    geometryRetained.decRefCnt();
                    for (int i3 = 0; i3 < this.mirrorShape3D.size(); ++i3) {
                        Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(i3);
                        geometryRetained.removeUser(shape3DRetained);
                    }
                }
                this.geometryList.remove(i2);
            }
            this.sendDataChangedMessage(null);
        } else {
            for (int i4 = n2 - 1; i4 >= 0; --i4) {
                geometryRetained = (GeometryRetained)this.geometryList.get(i4);
                if (geometryRetained != null) {
                    geometryRetained.decRefCnt();
                }
                this.geometryList.remove(i4);
            }
        }
        this.dirtyBoundsCache();
    }

    boolean willRemainOpaque(int n2) {
        return this.appearance == null || this.appearance.isStatic() && this.appearance.isOpaque(n2);
    }

    void handleFrequencyChange(int n2) {
        int n3 = 0;
        if (n2 == 13) {
            n3 = 1;
        } else if (n2 == 15) {
            n3 = 2;
        } else if (n2 == 19) {
            n3 = 16;
        }
        if (n3 != 0) {
            if (this.source.getCapabilityIsFrequent(n2)) {
                this.changedFrequent |= n3;
            } else if (!this.source.isLive()) {
                this.changedFrequent &= ~n3;
            }
        }
    }

    boolean isAlphaFrequentlyEditable(GeometryRetained geometryRetained) {
        boolean bl = false;
        if (this.appearanceOverrideEnable) {
            bl = true;
        } else if (geometryRetained != null && this.appearance != null) {
            AppearanceRetained appearanceRetained = this.appearance;
            if ((this.changedFrequent & 0x12) != 0 || (appearanceRetained.changedFrequent & 0x60) != 0 || appearanceRetained.renderingAttributes != null && (appearanceRetained.renderingAttributes.changedFrequent & 0x28) != 0 || appearanceRetained.transparencyAttributes != null && appearanceRetained.transparencyAttributes.changedFrequent != 0) {
                bl = true;
            } else if (geometryRetained instanceof GeometryArrayRetained && (appearanceRetained.changedFrequent & 8) != 0 || appearanceRetained.textureAttributes != null && (appearanceRetained.textureAttributes.changedFrequent & 1) != 0) {
                bl = true;
            } else if (geometryRetained instanceof RasterRetained && (((RasterRetained)geometryRetained).type & 1) != 0 && ((RasterRetained)geometryRetained).cachedChangedFrequent != 0) {
                bl = true;
            }
        }
        return bl;
    }

    int getPrimaryViewIdx() {
        UnorderList unorderList = VirtualUniverse.mc.cloneView();
        View[] viewArray = (View[])unorderList.toArray(false);
        int n2 = unorderList.arraySize();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!viewArray[i2].primaryView) continue;
            return viewArray[i2].viewIndex;
        }
        return 0;
    }

    void searchGeometryAtoms(UnorderList unorderList) {
        unorderList.add(Shape3DRetained.getGeomAtom(this.getMirrorShape(this.key)));
    }
}

