/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dClock;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.media.j3d.WakeupOnElapsedTimeHeap;

class TimerThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private WakeupOnElapsedTimeHeap heap = new WakeupOnElapsedTimeHeap();
    private WakeupOnElapsedTime inputDeviceSchedCond = new WakeupOnElapsedTime(InputDeviceScheduler.samplingTime);
    private WakeupOnElapsedTime soundSchedCond = new WakeupOnElapsedTime(120000L);
    private volatile boolean running = true;
    private boolean waiting = false;
    private boolean ready = false;

    TimerThread(ThreadGroup threadGroup) {
        super(threadGroup, "J3D-TimerThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(WakeupOnElapsedTime wakeupOnElapsedTime) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.insert(wakeupOnElapsedTime);
        }
        this.runMonitor(1, 0L);
    }

    void addInputDeviceSchedCond() {
        this.inputDeviceSchedCond.triggeredTime = (long)InputDeviceScheduler.samplingTime + J3dClock.currentTimeMillis();
        this.add(this.inputDeviceSchedCond);
    }

    void addSoundSchedCond(long l2) {
        this.soundSchedCond.triggeredTime = l2;
        this.add(this.soundSchedCond);
    }

    void finish() {
        this.runMonitor(2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(WakeupOnElapsedTime wakeupOnElapsedTime) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.extract(wakeupOnElapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l2 = -1L;
        block3: while (this.running) {
            this.runMonitor(0, l2);
            long l3 = J3dClock.currentTimeMillis();
            while (true) {
                WakeupOnElapsedTime wakeupOnElapsedTime = null;
                l2 = -1L;
                WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
                synchronized (wakeupOnElapsedTimeHeap) {
                    if (!this.heap.isEmpty() && (l2 = this.heap.getMin().triggeredTime - l3) <= 0L) {
                        wakeupOnElapsedTime = this.heap.extractMin();
                    }
                }
                if (wakeupOnElapsedTime == null) continue block3;
                if (wakeupOnElapsedTime == this.inputDeviceSchedCond) {
                    VirtualUniverse.mc.sendRunMessage(4);
                    continue;
                }
                if (wakeupOnElapsedTime == this.soundSchedCond) {
                    VirtualUniverse.mc.sendRunMessage(2);
                    continue;
                }
                wakeupOnElapsedTime.setTriggered();
            }
        }
    }

    synchronized void runMonitor(int n2, long l2) {
        switch (n2) {
            case 0: {
                if (this.running && !this.ready) {
                    this.waiting = true;
                    try {
                        if (l2 < 0L) {
                            this.wait();
                        } else {
                            this.wait(l2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
            }
        }
    }
}

