/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TransparencyAttributesRetained;

public class TransparencyAttributes
extends NodeComponent {
    public static final int ALLOW_MODE_READ = 0;
    public static final int ALLOW_MODE_WRITE = 1;
    public static final int ALLOW_VALUE_READ = 2;
    public static final int ALLOW_VALUE_WRITE = 3;
    public static final int ALLOW_BLEND_FUNCTION_READ = 4;
    public static final int ALLOW_BLEND_FUNCTION_WRITE = 5;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int BLENDED = 2;
    public static final int SCREEN_DOOR = 3;
    public static final int NONE = 4;
    public static final int BLEND_ZERO = 0;
    public static final int BLEND_ONE = 1;
    public static final int BLEND_SRC_ALPHA = 2;
    public static final int BLEND_ONE_MINUS_SRC_ALPHA = 3;
    public static final int BLEND_DST_COLOR = 4;
    public static final int BLEND_ONE_MINUS_DST_COLOR = 5;
    public static final int BLEND_SRC_COLOR = 6;
    public static final int BLEND_ONE_MINUS_SRC_COLOR = 7;
    static final int BLEND_CONSTANT_COLOR = 8;
    static final int MAX_BLEND_FUNC_TABLE_SIZE = 9;
    private static final int[] readCapabilities = new int[]{4, 0, 2};

    public TransparencyAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TransparencyAttributes(int n2, float f2) {
        this(n2, f2, 2, 3);
    }

    public TransparencyAttributes(int n2, float f2, int n3, int n4) {
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes6"));
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes7"));
            }
        }
        switch (n4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes8"));
            }
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((TransparencyAttributesRetained)this.retained).initTransparencyMode(n2);
        ((TransparencyAttributesRetained)this.retained).initTransparency(f2);
        ((TransparencyAttributesRetained)this.retained).initSrcBlendFunction(n3);
        ((TransparencyAttributesRetained)this.retained).initDstBlendFunction(n4);
    }

    public void setTransparencyMode(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes0"));
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes6"));
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setTransparencyMode(n2);
        } else {
            ((TransparencyAttributesRetained)this.retained).initTransparencyMode(n2);
        }
    }

    public int getTransparencyMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes1"));
        }
        return ((TransparencyAttributesRetained)this.retained).getTransparencyMode();
    }

    public void setTransparency(float f2) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes2"));
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setTransparency(f2);
        } else {
            ((TransparencyAttributesRetained)this.retained).initTransparency(f2);
        }
    }

    public float getTransparency() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes3"));
        }
        return ((TransparencyAttributesRetained)this.retained).getTransparency();
    }

    public void setSrcBlendFunction(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes4"));
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes7"));
            }
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setSrcBlendFunction(n2);
        } else {
            ((TransparencyAttributesRetained)this.retained).initSrcBlendFunction(n2);
        }
    }

    public int getSrcBlendFunction() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes5"));
        }
        return ((TransparencyAttributesRetained)this.retained).getSrcBlendFunction();
    }

    public void setDstBlendFunction(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes4"));
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes8"));
            }
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setDstBlendFunction(n2);
        } else {
            ((TransparencyAttributesRetained)this.retained).initDstBlendFunction(n2);
        }
    }

    public int getDstBlendFunction() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes5"));
        }
        return ((TransparencyAttributesRetained)this.retained).getDstBlendFunction();
    }

    void createRetained() {
        this.retained = new TransparencyAttributesRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.duplicateNodeComponent(this);
        return transparencyAttributes;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        TransparencyAttributesRetained transparencyAttributesRetained = (TransparencyAttributesRetained)nodeComponent.retained;
        TransparencyAttributesRetained transparencyAttributesRetained2 = (TransparencyAttributesRetained)this.retained;
        transparencyAttributesRetained2.initTransparencyMode(transparencyAttributesRetained.getTransparencyMode());
        transparencyAttributesRetained2.initTransparency(transparencyAttributesRetained.getTransparency());
        transparencyAttributesRetained2.initSrcBlendFunction(transparencyAttributesRetained.getSrcBlendFunction());
        transparencyAttributesRetained2.initDstBlendFunction(transparencyAttributesRetained.getDstBlendFunction());
    }
}

