/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

class UnorderList
implements Cloneable,
Serializable {
    transient Object[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;

    UnorderList(int n2, Class clazz) {
        this.componentType = clazz;
        this.elementData = (Object[])Array.newInstance(clazz, n2);
    }

    UnorderList(Class clazz) {
        this(10, clazz);
    }

    UnorderList(int n2) {
        this(n2, Object.class);
    }

    UnorderList() {
        this(10, Object.class);
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(Object object) {
        if (object != null) {
            for (int i2 = this.size - 1; i2 >= 0; --i2) {
                if (!object.equals(this.elementData[i2])) continue;
                return true;
            }
        } else {
            for (int i3 = this.size - 1; i3 >= 0; --i3) {
                if (this.elementData[i3] != null) continue;
                return true;
            }
        }
        return false;
    }

    final synchronized boolean addUnique(Object object) {
        if (!this.contains(object)) {
            this.add(object);
            return true;
        }
        return false;
    }

    final synchronized int indexOf(Object object) {
        if (object != null) {
            for (int i2 = this.size - 1; i2 >= 0; --i2) {
                if (!object.equals(this.elementData[i2])) continue;
                return i2;
            }
        } else {
            for (int i3 = this.size - 1; i3 >= 0; --i3) {
                if (this.elementData[i3] != null) continue;
                return i3;
            }
        }
        return -1;
    }

    protected final synchronized Object clone() {
        try {
            UnorderList unorderList = (UnorderList)super.clone();
            unorderList.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, unorderList.elementData, 0, this.size);
            this.isDirty = true;
            return unorderList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean bl) {
        if (bl) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final synchronized Object[] toArray(Object object) {
        int n2 = this.indexOf(object);
        if (n2 < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int n3 = this.size - n2;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n3);
        System.arraycopy(this.elementData, n2, objectArray, 0, n3);
        return objectArray;
    }

    final synchronized void toArrayAndClear(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        Arrays.fill(this.elementData, 0, this.size, null);
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            Object[] objectArray = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int n2) {
        return this.elementData[n2];
    }

    final synchronized void set(int n2, Object object) {
        this.elementData[n2] = object;
        this.isDirty = true;
    }

    final synchronized void add(Object object) {
        if (this.elementData.length == this.size) {
            Object[] objectArray = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = object;
        this.isDirty = true;
    }

    final synchronized void remove(int n2) {
        this.elementData[n2] = this.elementData[--this.size];
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized void removeOrdered(int n2) {
        --this.size;
        if (n2 < this.size) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, this.size - n2);
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        Object object = this.elementData[--this.size];
        this.elementData[this.size] = null;
        this.isDirty = true;
        return object;
    }

    final synchronized void shift(Object[] objectArray, int n2) {
        int n3 = this.size;
        System.arraycopy(this.elementData, 0, objectArray, 0, n2);
        this.size -= n2;
        if (this.size > 0) {
            System.arraycopy(this.elementData, n2, this.elementData, 0, this.size);
        }
        Arrays.fill(this.elementData, this.size, n3, null);
    }

    final synchronized boolean remove(Object object) {
        --this.size;
        if (object != null) {
            for (int i2 = this.size; i2 >= 0; --i2) {
                if (!object.equals(this.elementData[i2])) continue;
                this.elementData[i2] = this.elementData[this.size];
                this.elementData[this.size] = null;
                this.isDirty = true;
                return true;
            }
        } else {
            for (int i3 = this.size; i3 >= 0; --i3) {
                if (this.elementData[i3] != null) continue;
                this.elementData[i3] = this.elementData[this.size];
                this.elementData[this.size] = null;
                this.isDirty = true;
                return true;
            }
        }
        ++this.size;
        return false;
    }

    final synchronized void clear() {
        if (this.size > 0) {
            Arrays.fill(this.elementData, 0, this.size, null);
            this.size = 0;
            this.isDirty = true;
        }
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            Arrays.fill(this.cloneData, 0, this.cloneData.length, null);
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("Size = " + this.size + "\n[");
        int n2 = this.size - 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object = this.elementData[i2];
            if (object != null) {
                stringBuffer.append(this.elementData[i2].toString());
            } else {
                stringBuffer.append("NULL");
            }
            if (i2 == n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeObject(this.elementData[i2]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = (Object[])Array.newInstance(this.componentType, n2);
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elementData[i2] = objectInputStream.readObject();
        }
    }
}

