/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.VecMathUtil;

public abstract class Tuple3d
implements Serializable,
Cloneable {
    static final long serialVersionUID = 5542096614926168415L;
    public double x;
    public double y;
    public double z;

    public Tuple3d(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Tuple3d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Tuple3d(Tuple3d tuple3d) {
        this.x = tuple3d.x;
        this.y = tuple3d.y;
        this.z = tuple3d.z;
    }

    public Tuple3d(Tuple3f tuple3f) {
        this.x = tuple3f.x;
        this.y = tuple3f.y;
        this.z = tuple3f.z;
    }

    public Tuple3d() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public final void set(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public final void set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public final void set(Tuple3d tuple3d) {
        this.x = tuple3d.x;
        this.y = tuple3d.y;
        this.z = tuple3d.z;
    }

    public final void set(Tuple3f tuple3f) {
        this.x = tuple3f.x;
        this.y = tuple3f.y;
        this.z = tuple3f.z;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
    }

    public final void get(Tuple3d tuple3d) {
        tuple3d.x = this.x;
        tuple3d.y = this.y;
        tuple3d.z = this.z;
    }

    public final void add(Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.x = tuple3d.x + tuple3d2.x;
        this.y = tuple3d.y + tuple3d2.y;
        this.z = tuple3d.z + tuple3d2.z;
    }

    public final void add(Tuple3d tuple3d) {
        this.x += tuple3d.x;
        this.y += tuple3d.y;
        this.z += tuple3d.z;
    }

    public final void sub(Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.x = tuple3d.x - tuple3d2.x;
        this.y = tuple3d.y - tuple3d2.y;
        this.z = tuple3d.z - tuple3d2.z;
    }

    public final void sub(Tuple3d tuple3d) {
        this.x -= tuple3d.x;
        this.y -= tuple3d.y;
        this.z -= tuple3d.z;
    }

    public final void negate(Tuple3d tuple3d) {
        this.x = -tuple3d.x;
        this.y = -tuple3d.y;
        this.z = -tuple3d.z;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void scale(double d2, Tuple3d tuple3d) {
        this.x = d2 * tuple3d.x;
        this.y = d2 * tuple3d.y;
        this.z = d2 * tuple3d.z;
    }

    public final void scale(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
    }

    public final void scaleAdd(double d2, Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.x = d2 * tuple3d.x + tuple3d2.x;
        this.y = d2 * tuple3d.y + tuple3d2.y;
        this.z = d2 * tuple3d.z + tuple3d2.z;
    }

    public final void scaleAdd(double d2, Tuple3f tuple3f) {
        this.scaleAdd(d2, new Point3d(tuple3f));
    }

    public final void scaleAdd(double d2, Tuple3d tuple3d) {
        this.x = d2 * this.x + tuple3d.x;
        this.y = d2 * this.y + tuple3d.y;
        this.z = d2 * this.z + tuple3d.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.x);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.y);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.z);
        return (int)(l2 ^ l2 >> 32);
    }

    public boolean equals(Tuple3d tuple3d) {
        try {
            return this.x == tuple3d.x && this.y == tuple3d.y && this.z == tuple3d.z;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            Tuple3d tuple3d = (Tuple3d)object;
            return this.x == tuple3d.x && this.y == tuple3d.y && this.z == tuple3d.z;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(Tuple3d tuple3d, double d2) {
        double d3 = this.x - tuple3d.x;
        if (Double.isNaN(d3)) {
            return false;
        }
        double d4 = d3 < 0.0 ? -d3 : d3;
        if (d4 > d2) {
            return false;
        }
        d3 = this.y - tuple3d.y;
        if (Double.isNaN(d3)) {
            return false;
        }
        double d5 = d3 < 0.0 ? -d3 : d3;
        if (d5 > d2) {
            return false;
        }
        d3 = this.z - tuple3d.z;
        if (Double.isNaN(d3)) {
            return false;
        }
        double d6 = d3 < 0.0 ? -d3 : d3;
        return !(d6 > d2);
    }

    public final void clamp(float f2, float f3, Tuple3d tuple3d) {
        this.clamp((double)f2, (double)f3, tuple3d);
    }

    public final void clamp(double d2, double d3, Tuple3d tuple3d) {
        this.x = tuple3d.x > d3 ? d3 : (tuple3d.x < d2 ? d2 : tuple3d.x);
        this.y = tuple3d.y > d3 ? d3 : (tuple3d.y < d2 ? d2 : tuple3d.y);
        this.z = tuple3d.z > d3 ? d3 : (tuple3d.z < d2 ? d2 : tuple3d.z);
    }

    public final void clampMin(float f2, Tuple3d tuple3d) {
        this.clampMin((double)f2, tuple3d);
    }

    public final void clampMin(double d2, Tuple3d tuple3d) {
        this.x = tuple3d.x < d2 ? d2 : tuple3d.x;
        this.y = tuple3d.y < d2 ? d2 : tuple3d.y;
        this.z = tuple3d.z < d2 ? d2 : tuple3d.z;
    }

    public final void clampMax(float f2, Tuple3d tuple3d) {
        this.clampMax((double)f2, tuple3d);
    }

    public final void clampMax(double d2, Tuple3d tuple3d) {
        this.x = tuple3d.x > d2 ? d2 : tuple3d.x;
        this.y = tuple3d.y > d2 ? d2 : tuple3d.y;
        this.z = tuple3d.z > d2 ? d2 : tuple3d.z;
    }

    public final void absolute(Tuple3d tuple3d) {
        this.x = Math.abs(tuple3d.x);
        this.y = Math.abs(tuple3d.y);
        this.z = Math.abs(tuple3d.z);
    }

    public final void clamp(float f2, float f3) {
        this.clamp((double)f2, (double)f3);
    }

    public final void clamp(double d2, double d3) {
        if (this.x > d3) {
            this.x = d3;
        } else if (this.x < d2) {
            this.x = d2;
        }
        if (this.y > d3) {
            this.y = d3;
        } else if (this.y < d2) {
            this.y = d2;
        }
        if (this.z > d3) {
            this.z = d3;
        } else if (this.z < d2) {
            this.z = d2;
        }
    }

    public final void clampMin(float f2) {
        this.clampMin((double)f2);
    }

    public final void clampMin(double d2) {
        if (this.x < d2) {
            this.x = d2;
        }
        if (this.y < d2) {
            this.y = d2;
        }
        if (this.z < d2) {
            this.z = d2;
        }
    }

    public final void clampMax(float f2) {
        this.clampMax((double)f2);
    }

    public final void clampMax(double d2) {
        if (this.x > d2) {
            this.x = d2;
        }
        if (this.y > d2) {
            this.y = d2;
        }
        if (this.z > d2) {
            this.z = d2;
        }
    }

    public final void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
    }

    public final void interpolate(Tuple3d tuple3d, Tuple3d tuple3d2, float f2) {
        this.interpolate(tuple3d, tuple3d2, (double)f2);
    }

    public final void interpolate(Tuple3d tuple3d, Tuple3d tuple3d2, double d2) {
        this.x = (1.0 - d2) * tuple3d.x + d2 * tuple3d2.x;
        this.y = (1.0 - d2) * tuple3d.y + d2 * tuple3d2.y;
        this.z = (1.0 - d2) * tuple3d.z + d2 * tuple3d2.z;
    }

    public final void interpolate(Tuple3d tuple3d, float f2) {
        this.interpolate(tuple3d, (double)f2);
    }

    public final void interpolate(Tuple3d tuple3d, double d2) {
        this.x = (1.0 - d2) * this.x + d2 * tuple3d.x;
        this.y = (1.0 - d2) * this.y + d2 * tuple3d.y;
        this.z = (1.0 - d2) * this.z + d2 * tuple3d.z;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d2) {
        this.x = d2;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d2) {
        this.y = d2;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d2) {
        this.z = d2;
    }
}

