/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

public final class Sort {
    private static final CompareFunc comparableCompareFunc = new CompareFunc(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };

    private Sort() {
    }

    public static void sort(Comparable[] comparableArray) {
        Sort.sort(comparableArray, comparableCompareFunc);
    }

    public static void sort(Object[] objectArray, CompareFunc compareFunc) {
        Sort.sort(objectArray, compareFunc, 0, objectArray.length - 1);
    }

    private static void sort(Object[] objectArray, CompareFunc compareFunc, int n2, int n3) {
        Object object;
        if (n2 >= n3) {
            return;
        }
        if (n3 - n2 <= 6) {
            for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                Object object2 = objectArray[i2];
                for (int i3 = i2 - 1; i3 >= n2 && compareFunc.compare(objectArray[i3], object2) > 0; --i3) {
                    objectArray[i3 + 1] = objectArray[i3];
                }
                objectArray[i3 + 1] = object2;
            }
            return;
        }
        Object object3 = objectArray[n3];
        int n4 = n2 - 1;
        int n5 = n3;
        while (true) {
            if (n4 < n5 && compareFunc.compare(objectArray[++n4], object3) < 0) {
                continue;
            }
            while (n5 > n4 && compareFunc.compare(objectArray[--n5], object3) > 0) {
            }
            object = objectArray[n4];
            objectArray[n4] = objectArray[n5];
            objectArray[n5] = object;
            if (n4 >= n5) break;
        }
        object = objectArray[n4];
        objectArray[n4] = objectArray[n3];
        objectArray[n3] = object;
        Sort.sort(objectArray, compareFunc, n2, n4 - 1);
        Sort.sort(objectArray, compareFunc, n4 + 1, n3);
    }

    public static interface CompareFunc {
        public int compare(Object var1, Object var2);
    }

    public static interface Comparable {
        public int compareTo(Object var1);
    }
}

