/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.mappy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.io.MapReader;
import tiled.io.PluginLogger;
import tiled.plugins.mappy.Chunk;
import tiled.plugins.mappy.Util;

public class MappyMapReader
implements MapReader {
    private LinkedList chunks;
    private Vector blocks;
    private static final int BLKSTR_WIDTH = 32;
    private int twidth;
    private int theight;
    private PluginLogger logger;

    public Map readMap(String string) throws Exception {
        return this.readMap(new FileInputStream(string));
    }

    public Map readMap(InputStream inputStream) throws Exception {
        Chunk chunk;
        Map map = null;
        this.chunks = new LinkedList();
        this.blocks = new Vector();
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        long l = Util.readLongReverse(inputStream);
        inputStream.read(byArray);
        try {
            chunk = new Chunk(inputStream);
            while (chunk.isGood()) {
                this.chunks.add(chunk);
                chunk = new Chunk(inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((chunk = this.findChunk("MPHD")) == null) {
            throw new IOException("No MPHD chunk found!");
        }
        map = this.readMPHDChunk(chunk.getInputStream());
        chunk = this.findChunk("BODY");
        if (chunk == null) {
            throw new IOException("No BODY chunk found!");
        }
        this.readBODYChunk(map, chunk.getInputStream());
        return map;
    }

    public TileSet readTileset(String string) throws Exception {
        this.logger.error((Object)"Tilesets aren't supported!");
        return null;
    }

    public TileSet readTileset(InputStream inputStream) {
        this.logger.error((Object)"Tilesets aren't supported!");
        return null;
    }

    public String getFilter() throws Exception {
        return "*.fmp";
    }

    public String getPluginPackage() {
        return "Mappy input plugin";
    }

    public String getDescription() {
        return "+---------------------------------------------+\n|      An experimental reader for Mappy       |\n|                 FMAP v0.36                  |\n|            (c) Adam Turk 2004               |\n|          aturk@biggeruniverse.com           |\n|                                             |\n| Currently unsupported:                      |\n|  * Animated tiles                           |\n|  * The ATHR block                           |\n|  * Collision bits on BLKSTR structures      |\n|  * bitdepths other than 16bit               |\n|  * object layers                            |\n+---------------------------------------------+";
    }

    public String getName() {
        return "Mappy Reader";
    }

    public boolean accept(File file) {
        try {
            String string = file.getCanonicalPath().toLowerCase();
            if (string.endsWith(".fmp")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setLogger(PluginLogger pluginLogger) {
        this.logger = pluginLogger;
    }

    private Chunk findChunk(String string) {
        for (Chunk chunk : this.chunks) {
            if (!chunk.equals(string)) continue;
            return chunk;
        }
        return null;
    }

    private Map readMPHDChunk(InputStream inputStream) throws IOException {
        Map map = null;
        TileSet tileSet = new TileSet();
        int n = inputStream.read();
        int n2 = inputStream.read();
        inputStream.skip(2L);
        map = new Map(Util.readShort(inputStream), Util.readShort(inputStream));
        Properties properties = map.getProperties();
        map.setOrientation(1);
        properties.setProperty("(s)fmap reader", "Don't modify properties marked (s) unless you really know what you're doing.");
        properties.setProperty("version", "" + n + "." + n2);
        inputStream.skip(4L);
        this.twidth = Util.readShort(inputStream);
        this.theight = Util.readShort(inputStream);
        map.setTileWidth(this.twidth);
        map.setTileHeight(this.theight);
        tileSet.setName("Static tiles");
        map.addTileset(tileSet);
        int n3 = Util.readShort(inputStream);
        if (n3 < 16) {
            throw new IOException("Tile bitdepths less than 16 are not supported!");
        }
        properties.setProperty("(s)depth", String.valueOf(n3));
        inputStream.skip(2L);
        int n4 = Util.readShort(inputStream);
        int n5 = Util.readShort(inputStream);
        Chunk chunk = this.findChunk("BKDT");
        if (chunk == null) {
            throw new IOException("No BKDT block found!");
        }
        TileLayer tileLayer = new TileLayer(map, map.getWidth(), map.getHeight());
        tileLayer.setName("bg");
        map.addLayer((MapLayer)tileLayer);
        for (int i = 1; i < 7; ++i) {
            tileLayer = new ObjectGroup(map, 0, 0);
            tileLayer.setName("ObjectLayer " + i);
            map.addLayer((MapLayer)tileLayer);
        }
        tileLayer = new TileLayer(map, map.getWidth(), map.getHeight());
        tileLayer.setName("fg 1");
        map.addLayer((MapLayer)tileLayer);
        tileLayer = new TileLayer(map, map.getWidth(), map.getHeight());
        tileLayer.setName("fg 2");
        map.addLayer((MapLayer)tileLayer);
        tileLayer = new TileLayer(map, map.getWidth(), map.getHeight());
        tileLayer.setName("fg 3");
        map.addLayer((MapLayer)tileLayer);
        this.readBKDTChunk(map, chunk.getInputStream(), n4);
        chunk = this.findChunk("BGFX");
        if (chunk == null) {
            throw new IOException("No BGFX chunk found!");
        }
        this.readBGFXChunk(map, chunk.getInputStream(), n5);
        this.logger.debug((Object)map.toString());
        return map;
    }

    private void readATHRChunk(Map map, InputStream inputStream) {
    }

    private void readBKDTChunk(Map map, InputStream inputStream, int n) throws IOException {
        this.logger.debug((Object)("Reading " + n + " blocks..."));
        for (int i = 0; i < n; ++i) {
            this.blocks.add(this.readBLKSTR(inputStream));
        }
    }

    private void readBODYChunk(Map map, InputStream inputStream) throws IOException {
        TileSet tileSet = (TileSet)map.getTilesets().get(0);
        TileLayer tileLayer = (TileLayer)map.getLayer(0);
        TileLayer tileLayer2 = (TileLayer)map.getLayer(7);
        TileLayer tileLayer3 = (TileLayer)map.getLayer(8);
        TileLayer tileLayer4 = (TileLayer)map.getLayer(9);
        for (int i = 0; i < map.getHeight(); ++i) {
            for (int j = 0; j < map.getWidth(); ++j) {
                int n = (Util.readShort(inputStream) & 0xFF) / 32;
                BlkStr blkStr = (BlkStr)this.blocks.get(n);
                tileLayer.setTileAt(j, i, tileSet.getTile((int)blkStr.bg));
                tileLayer2.setTileAt(j, i, tileSet.getTile((int)blkStr.fg0));
                tileLayer3.setTileAt(j, i, tileSet.getTile((int)blkStr.fg1));
                tileLayer4.setTileAt(j, i, tileSet.getTile((int)blkStr.fg2));
            }
        }
    }

    private void readBGFXChunk(Map map, InputStream inputStream, int n) throws IOException {
        TileSet tileSet = (TileSet)map.getTilesets().get(0);
        tileSet.addTile(new Tile());
        Util.readRawImage(inputStream, this.twidth, this.theight);
        for (int i = 1; i < n; ++i) {
            Tile tile = new Tile();
            int n2 = tileSet.addImage(Util.readRawImage(inputStream, this.twidth, this.theight));
            tileSet.addTile(tile);
        }
    }

    private BlkStr readBLKSTR(InputStream inputStream) throws IOException {
        BlkStr blkStr = new BlkStr();
        long l = this.twidth * this.theight * 512;
        blkStr.bg = Util.readLongReverse(inputStream) / l;
        blkStr.fg0 = Util.readLongReverse(inputStream) / l;
        blkStr.fg1 = Util.readLongReverse(inputStream) / l;
        blkStr.fg2 = Util.readLongReverse(inputStream) / l;
        blkStr.user1 = Util.readLongReverse(inputStream);
        blkStr.user2 = Util.readLongReverse(inputStream);
        blkStr.user3 = Util.readShort(inputStream);
        blkStr.user4 = Util.readShort(inputStream);
        blkStr.user5 = inputStream.read();
        blkStr.user6 = inputStream.read();
        blkStr.user7 = inputStream.read();
        blkStr.bits = inputStream.read();
        return blkStr;
    }

    public static class BlkStr {
        public long bg;
        public long fg0;
        public long fg1;
        public long fg2;
        public long user1;
        public long user2;
        public int user3;
        public int user4;
        public int user5;
        public int user6;
        public int user7;
        public int bits;
    }
}

