//============================================================================
//  midi.cpp ver.1.00 uMIDI (ŏo[W)v
//----------------------------------------------------------------------------
//													Programmed by 
//============================================================================
#include <windows.h>
#include <mmsystem.h>
#include "midi.h"

// X^eBbNϐ
static UINT uMidiDeviceId = 0;
static HMIDIOUT hMidi = 0;

//============================================================================
//  MIDI foCXI[v
//----------------------------------------------------------------------------
//In  : uSetMidiDeviceId = MIDI ̃foCX ID (MIDI_MAPPER)
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOpen( UINT uSetMidiDeviceId )
{
	BOOL bRetCode = FALSE;
	MMRESULT mmResult;
	if ( uMidiDeviceId != uSetMidiDeviceId ) {
		MidiClose();
	} else {
		// łɃfoCX̓I[vĂ
		bRetCode = TRUE;
	}
	uMidiDeviceId = uSetMidiDeviceId;
	mmResult = midiOutOpen( &hMidi, uMidiDeviceId, 0, 0, CALLBACK_NULL );
	if ( MMSYSERR_NOERROR == mmResult ) {
		bRetCode = TRUE;
	}
	return bRetCode;
}

//============================================================================
//  MIDI foCXN[Y
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiClose( void )
{
	BOOL bRetCode = FALSE;
	if ( hMidi != 0 ) {
		midiOutReset( hMidi );
		midiOutClose( hMidi );
		hMidi = 0;
		bRetCode = TRUE;
	}
	return bRetCode;
}

//============================================================================
//  MIDI R}hM
//----------------------------------------------------------------------------
//In  : byData1 = 1 oCg
//    : byData2 = 2 oCg
//    : byData3 = 3 oCg
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOut( BYTE byData1, BYTE byData2, BYTE byData3 )
{
	BOOL bRetCode = FALSE;
	if ( hMidi != 0 ) {
		typedef union {
			DWORD dwData;
			BYTE byData[4];
		} DATA;
		DATA Data;
		Data.byData[0] = byData1;
		Data.byData[1] = byData2;
		Data.byData[2] = byData3;
		Data.byData[3] = 0;
		if ( midiOutShortMsg( hMidi, Data.dwData ) == MMSYSERR_NOERROR ) {
			bRetCode = TRUE;
		}
	}
	return bRetCode;
}

//============================================================================
//  MIDI R}hM (GNXN[VuEObZ[W)
//----------------------------------------------------------------------------
// In  : lpMidiHdr = MIDIHDR \̂ւ̃|C^
// Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOutEx( LPMIDIHDR lpMidiHdr )
{
	BOOL bRetCode = FALSE;
	if ( hMidi != 0 ) {
		midiOutPrepareHeader( hMidi, lpMidiHdr, sizeof( MIDIHDR ) );
		if ( midiOutLongMsg( hMidi, lpMidiHdr, sizeof( MIDIHDR ) ) == MMSYSERR_NOERROR ) {
			bRetCode = TRUE;
		}
	}
	return bRetCode;
}

//============================================================================
//  MIDI Zbg
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : Ȃ
//============================================================================
void MidiReset( void )
{
	int i;
	for ( i=0; i<MIDITRACK_MAX; i++ ) {
		MidiOut( (BYTE)( 0xB0 + i ), 0x79, 0x00 );	// GtFNg̏
		MidiOut( (BYTE)( 0xB0 + i ), 0x7B, 0x00 );	// SẲ
		MidiOut( (BYTE)( 0xB0 + i ), 0x7B, 0x00 );	// SẲ
	}
}
