/******************************************************************************
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*                        EmuZ-2000  Extend Board DLL
*                               << MZ-1E08 >>
*                          Header File [MZ1E08.H]
*               12 Mar. 2003  version 0.01  - Create
*               20 Mar. 2003  version 0.03  - Bmp font support
*               10 Apl. 2010  version 0.10  - EmuZ-2000 TF-Edition Font Rom support
*                1 Mar. 2013  version 0.11  - Rename Rom FileName, Change Windows Font
*                6 Mar. 2013  version 0.12  - Add Windows Font Pattern File
*                      Programmed by 2003 S.Tsuneoka
******************************************************************************/
#ifndef __MZ1E08_H__
#define __MZ1E08_H__

#define MSGDISPATCH(msg, fn)	case msg: return fn(hWnd, wParam, lParam)

#define CONTROLPORT				0xfe
#define DATAPORT				0xff
#define BASEIOPORT				CONTROLPORT
#define USINGPORTS				2

/* Printer Code */
#define CR						0x0d	/* Caridge */
#define LF						0x0a	/* Line Feed */
#define FF						0x0c	/* Form Feed */
#define ESC						0x1b	/* Escape */

#define DOCNAME					"EmuZ-2000"
#define PRINTMODE_ROW			1L
#define PRINTMODE_COOKED		2L
#define PRINTMODE_WINDOWSFONT	4L
#define PRINTMODE_BMPFONT		8L
#define PRINTMODE_FONTROM_JP	16L
#define PRINTMODE_FONTROM_EN	32L
#define PRINTMODE_RASTERVIEW	64L

#define BUFFSIZE				1024
#define PRINTBUFFSIZE			BUFFSIZE
#define FONTFILEBUFFSIZE		5120
#define FONTBUFFSIZE			164384
#define PATTERNBUFFSIZE			1024

#define FONTFILENAME			"mzfont24.bmp"
#define FONTROM_JP_FILENAME		"mzfont.rom"
#define FONTROM_EN_FILENAME		"mzfonte.rom"
#define DEBUGLOGFILENAME		"mz_1e08.log"
#define PATTERNFILENAME			"mz_1e08_print.txt"

/* prototypes */
#ifdef __cplusplus
extern "C" {
#endif

/* mz1e08.c */
LPCSTR  GetEmuZDirectory(VOID);
VOID    DbgPrintf(LPCSTR, ...);
BYTE    InportFunction(WORD);
int     OutportFunction(WORD, BYTE);

/* spool.c */
BOOL    IsInitiarizeSpooler(VOID);
LRESULT InitiarizeSpooler(DWORD, LPSTR, LPSTR);
VOID    TerminateSpooler(VOID);
LRESULT PrintSpooler(WORD);
LRESULT FlushSpooler(VOID);
LPSTR   GetDefaultPrintDevice(LPSTR, DWORD);
LPSTR   GetPrintDeviceList(LPSTR, DWORD);
BOOL	ReadPatternFile(LPCSTR);

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* __MZ1E08_H__ */
