/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                        EmuZ-2000  Extend Board DLL
*
*                               << MZ-1R13 >>
*
*                          Main Module [MZ1R13.C]
*
*               Programmed & Porting by 2003 EmuZ-2000 (M.Y)
*               Programmed & Porting by 2003-2006 Suga
*               TF-Edition state save support and modified by T.Fukui (2010-2016)
*
*********************************************************************************/
//
// yύXz
// 2003N0216 Ver.0.1
//	ƎҁFSuga
//	@eFō쐬
//
// 2003N0301 Ver.0.2
//	ƎҁFSuga
//	@eFAt@C݂ȂꍇAROMC[W͑SFFŖ߂B
//			t@CEmuZ-2500Ɠ KANJI2.ROM g悤ɕύXB
//			sv폜ARgǉB
//
// 2003N0305 Ver.0.3
//	ƎҁFEmuZ-2000 (M.Y)
//	@eFrbg㉺֏ύX (if̕тfor[v)
//
// 2003N0306 Ver.0.4
//	ƎҁFSuga
//	@eFrbg㉺ԈႢCAsvRg폜
//
// 2006N0413 Ver.0.41
//	ƎҁFSuga
//	@eFURL,[AhXύX
//
// 2010N0420 Ver.0.5
//	ƎҁFT.Fukui
//	@eFmz1R13Bank̏ǉATF-Edition Xe[gZ[uT|[g
//
// 2010N0809 Ver.0.51
//	ƎҁFT.Fukui
//	@eFVer0.5Ver.0.4x[XłVer.0.41x[X֕ύX
//
// 2013Nxxxx Ver.0.6
//	ƎҁFS.Tsuneoka
//	@eFQƃt@C̕ύX
//
// 2016N0226 Ver.0.7
//	ƎҁFT.Fukui
//	@eFrbg]ǂݏo[h̃oOC
//          (JET-2200ÅROM[h삷悤ɂȂ)

#include <windows.h>
#include "resource.h"
#include "..\interface\emuz2000ioBoard.h"
//Support Debugger
//#include "..\interface\emuz2000debug.h"
#include "..\interface\plugin_ex.h"

////////////////////////////////////
// Prototype 
////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	) ;

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	) ;

////////////////////////////////////
// Global Variable 
////////////////////////////////////
HINSTANCE		h_instdll = NULL ;

EMUZ2000EBIH	mz1R13EBIH = {
	"4F499AF5-B66D-44a6-9459-2C6F3EA87264",
	"MZ-1R13 by SHARP",
	"Kanji Rom Board",
	"Copyright (C) 2006 EmuZ-2000 & Suga, 2010-2013 S.Tsuneoka, 2010-2016 T.Fukui",
	"http://www.ne.jp/asahi/suga/junkyard/",
	//"http://www.cisnet.or.jp/home/suga/",
	"suga@mar.email.ne.jp",
	//"suga@po.cisnet.or.jp",
	0x00000000,//Reserved
	InportFunction,
	OutportFunction,
	0xb8,		// JnI/OAhX
	0x4			// gpAhX
} ;

USHORT	address = 0 ;			// qnlAhX
UCHAR	mz1R13Kanji[131072] ;	// qnl
UCHAR	mz1R13Dic[16384] ;		// qnl
UCHAR	mz1R13Bank = 1;			// (0)E(1)ؑ (modified by T.Fukui)

DWORD	gId = 0 ;
DWORD	dwBase = 0 ;

////////////////////////////////////
// Extern
////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Logic Start
//
///////////////////////////////////////////////////////
// System interface
///////////////////////////////////////////////////////
BOOL WINAPI
DllMain(
	HINSTANCE	inst,
	DWORD		q_mode,
	LPVOID		vp_res_c )
{
	switch (q_mode) {
	case DLL_PROCESS_ATTACH :
		h_instdll = inst;
		break;
	case DLL_THREAD_ATTACH :
		break;
	case DLL_THREAD_DETACH :
		break;
	case DLL_PROCESS_DETACH :
		h_instdll = NULL;
		break;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
// window Proc.
BOOL
WINAPI
InfomationDlgProc(
	HWND hDlg,
	UINT msg,
	WPARAM wPrm,
	LPARAM lPrm
	)
{

	return TRUE;

}

/////////////////////////////////////////////////////////////////////
// I/O Function Interface
/////////////////////////////////////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	)
{
	UCHAR	data = 0xff ;
	UCHAR	rom_data = 0xff ;
	ULONG	rom_address ;

	rom_address = (ULONG)address * 2 ;
	switch( port )
	{
	case	0xb8:
	case	0xba:
		if (mz1R13Bank == 1)	// tHg
		{
			rom_data = mz1R13Kanji[ rom_address ] ;
		} else					// qnlP
		{
			rom_data = mz1R13Dic[ rom_address & 0x3fff ] ;
		}
		break ;
	case	0xb9:
	case	0xbb:
		if (mz1R13Bank == 1)	// tHgE
		{
			rom_data = mz1R13Kanji[ rom_address + 1 ] ;
		} else					// qnlQ
		{
			rom_data = mz1R13Dic[ ( rom_address & 0x3fff ) + 1 ] ;
		}
		//
		// qnlAhXʂWrbgJEgAbv
		address = (USHORT)( ( address & 0xff00 ) + ( (address + 1) & 0x00ff) ) ;
		address %= 0xffff ;
		break ;
	}

	switch( port )
	{
	case	0xb8:	// Wf[^ǂݏo
	case	0xb9:	// ROM D0->D0,D1->D1,...D6->D6,D7->D7
		data = rom_data ;
		break ;
	case	0xba:	// rbg㉺֓ǂݏo
	case	0xbb:	// ROM D0->D7,D1->D6,...D6->D1,D7->D0
		{			// iffor[v֕ύX EmuZ-2000 (M.Y) 2003N0305
			UCHAR	lop ;
			for( lop = 0, data = 0x00 ; lop < 8 ; lop++, rom_data <<= 1 ) {
 				data >>= 1;						// 1bit̂C
				data |= ( rom_data & 0x80 );	// ㉺ԈႢC 2003N0305
			}
		}
		break ;
	}

	return	data ;
}

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	)
{
	switch( port )
	{
	case	0xb8:	// ROMAhXʂWrbg
		address &= 0xff00 ;
		address |= (USHORT)data ;
		address %= 0xffff ;
		break ;
	case	0xb9:	// ROMAhXʂWrbg
		address &= 0xff ;
		address |= (USHORT)(data<<8) ;
		address %= 0xffff ;
		break ;
	case	0xba:	// (0)E(1)ROMؑ
		mz1R13Bank = (UCHAR)( data & 0x01 ) ;
		break;
	case	0xfa:
		break ;
	}
	return	0 ;
}

/////////////////////////////////////////////////////////////////////
// EmuZ-2000 Interface
/////////////////////////////////////////////////////////////////////
BOOL
WINAPI
IntializeBoard( 
	VOID
	)
{
	HANDLE h_File ;
	DWORD dwReadSize ;

	//------*< qnlC[Wt@Cǂݍ >*

	// t@C݂ȂꍇɔSFFŖ߂Ƃ 2003N0301
	memset(mz1R13Kanji, 0xff, 131072);

	// t@Cu1R13KAN.ROMvǍpŃI[v
	h_File = CreateFile ( "mz_1r13_kan.rom",
			GENERIC_READ,FILE_SHARE_READ,
			NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL ) ;

	if ( h_File == INVALID_HANDLE_VALUE )	// I[vs
	{
		// t@CuKANJI2.ROMvǍpŃI[v 2003N0301
		h_File = CreateFile ( "mz_1r13_kan25.rom",
				GENERIC_READ,FILE_SHARE_READ,
				NULL,OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL,NULL ) ;
	}

	if ( h_File != INVALID_HANDLE_VALUE )	// I[vǍ
	{
		ReadFile( h_File, mz1R13Kanji, 131072, &dwReadSize, NULL );
		CloseHandle( h_File ) ;
	}

	
	//------*< qnlC[Wt@Cǂݍ >*

	// t@C݂ȂꍇɔSFFŖ߂Ƃ 2003N0301
	memset(mz1R13Dic, 0xff, 16384);

	// t@Cu1R13DIC.ROMvǍpŃI[v
	h_File = CreateFile ( "mz_1r13_dic.rom",
			GENERIC_READ,FILE_SHARE_READ,
			NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL ) ;

	if ( h_File != INVALID_HANDLE_VALUE )	// I[vǍ
	{
		ReadFile( h_File, mz1R13Dic, 16384, &dwReadSize, NULL );
		CloseHandle( h_File ) ;
	}


	// I/O }bsOAhXݒFB8H
	dwBase = 0xb8 ;
	mz1R13EBIH.ioMapper.ucStartPort = (UCHAR)dwBase ;

	address = 0 ;
	mz1R13Bank = 1;

	return	TRUE ;
}

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	)
{
	address = 0 ;
	mz1R13Bank = 1;
	return	TRUE ;
}


VOID
WINAPI
FinalizeBoard( 
	VOID 
	)
{
	return ;
}

VOID
WINAPI
ReportCpuClock( 
	int clk
	)
{
	return ;
}

VOID
WINAPI
InfomationDialog( 
	HWND	hWnd 
	)
{
	return ;
}

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	)
{

	*info = &mz1R13EBIH ;
	gId = id ;
	return	TRUE ;
}

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, DWORD *size, PUCHAR *buf )
{
	static unsigned int data[2];

	data[0] = address;
	data[1] = mz1R13Bank;

	*size = sizeof(data);
	*buf = (void *)data;
	*ver = 1;				/* Data Format Ver.1 */
	return TRUE;
}

BOOL WINAPI StateSaveInputDataEx( int ver, DWORD size, PUCHAR buf )
{
	unsigned int *data = (void *)buf;
	unsigned int tdata[2] = { 0, 0 };	/* for automatic size calculation */

	if (ver > 1)				/* Newer Data Format Ver. */
		return FALSE;
	if (size != sizeof(tdata))
		return FALSE;
	address    = (USHORT)data[0];
	mz1R13Bank = (UCHAR)data[1];
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	)
{
	*size = 0 ;
	buf = NULL ;
	return	TRUE ;
}

BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	)
{
	return	TRUE ;
}
#endif
