/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                                  EmuZ-2000
*
*           EmuZ-2000 Extend I/O Board Header [EmuZ2000ioBoard.h]
*
*             Programmed & Porting by 2002-2003 EmuZ-2000 (M.Y)
*
*********************************************************************************/
//   emuz2000ioBoard.h
//
//
//

#ifndef	_emuz2000ioBoard_h_
#define	_emuz2000ioBoard_h_

///////////////////////////////
// Define

#define	MAX_GUID_LENGTH	48
#define	MAX_BOARD_NAME_LENGTH		128
#define	MAX_BOARD_INFO_LENGTH		128
#define	MAX_DLL_COPYRIGHT_LENGTH	128
#define	MAX_DLL_MAKER_URL_LENGTH	256
#define	MAX_DLL_MAKER_MAIL_LENGTH	128

#define	MAKE_USE_ID(n)				(1<<(n))
#define	USE_INTERRUPT				MAKE_USE_ID(0)
#define	USE_MAINMEMORY				MAKE_USE_ID(1)
#define	USE_TEXTVRAM				MAKE_USE_ID(2)
#define	USE_GRAPHICVRAM				MAKE_USE_ID(3)
#define	USE_VIEWCHGMSG				MAKE_USE_ID(4)
#define	USE_OTHERIO					MAKE_USE_ID(5)
#define	USE_KEYEMU					MAKE_USE_ID(6)
#define	USE_CALLBACKCLKCHG			MAKE_USE_ID(7)
#define	USE_STATESAVE				MAKE_USE_ID(8)
#define	USE_MEMORYSEGMENT			MAKE_USE_ID(28)
#define	USE_SOUNDUPLOAD				MAKE_USE_ID(29)
#define	USE_DEBUGGER				MAKE_USE_ID(30)
#define	USE_INFODIALOG				MAKE_USE_ID(31)
///////////////////////////////
// Typedefs
typedef	UCHAR (*EMUZ2000INPORTFUNC)( USHORT port ) ;
typedef	int (*EMUZ2000OUTPORTFUNC)( USHORT port, UCHAR data ) ;

typedef	UCHAR	(*EMUZ2000READMEMORYFUNC)( USHORT addr ) ;
typedef	int		(*EMUZ2000WRITEMEMORYFUNC)( USHORT addr, UCHAR value ) ;

///////////////////////////////
// Structures & unions
typedef	struct	_mapmemorystruct{
	int						seg ;
	UCHAR					*ptr ;
	EMUZ2000READMEMORYFUNC	readf ;
	EMUZ2000WRITEMEMORYFUNC	writef ;
} MAPMEMORYSTRUCT, *PMAPMEMORYSTRUCT ;

typedef	struct	_boarduseflg{
	DWORD	bInterrupt:1 ;
	DWORD	bMainMemory:1 ;
	DWORD	bTextVram:1 ;
	DWORD	bGraphicVram:1 ;
	DWORD	bViewChgMsg:1 ;
	DWORD	bOtherIo:1 ;
	DWORD	bKeyEmu:1 ;
	DWORD	bCallbackClkChg:1 ;
	DWORD	bStateSave:1 ;
	DWORD	bExt9:1 ;
	DWORD	bExt10:1 ;
	DWORD	bExt11:1 ;
	DWORD	bExt12:1 ;
	DWORD	bExt13:1 ;
	DWORD	bExt14:1 ;
	DWORD	bExt15:1 ;
	DWORD	bExt16:1 ;
	DWORD	bExt17:1 ;
	DWORD	bExt18:1 ;
	DWORD	bExt19:1 ;
	DWORD	bExt20:1 ;
	DWORD	bExt21:1 ;
	DWORD	bExt22:1 ;
	DWORD	bExt23:1 ;
	DWORD	bExt24:1 ;
	DWORD	bExt25:1 ;
	DWORD	bExt26:1 ;
	DWORD	bExt27:1 ;
	DWORD	bMemorySegment:1 ;
	DWORD	bSoundDataUpload:1 ;
	DWORD	bExtDbgInfo:1 ;
	DWORD	bMoreInfo:1 ; //Board Setting Dialog
}BOARDUSEFLG, *PBOARDUSEFLG ;

typedef	union	_extflg{
	DWORD		val ;
	BOARDUSEFLG	flg ;
}EXTFLG, *PEXTFLG ;

typedef	struct	_mapiostruct{
	EMUZ2000INPORTFUNC	fInportFunc ;
	EMUZ2000OUTPORTFUNC	fOutportFunc ;
	UCHAR	ucStartPort ;
	UCHAR	nCount ;
}MAPIOSTRUCT, *PMAPIOSTRUCT ;

typedef	struct	_emuz2000extendboardinfomationheader{
	TCHAR		szGuidCode[MAX_GUID_LENGTH] ;
	TCHAR		szBoardName[MAX_BOARD_NAME_LENGTH] ;
	TCHAR		szBoardInfo[MAX_BOARD_INFO_LENGTH] ;
	TCHAR		szDllCopyright[MAX_DLL_COPYRIGHT_LENGTH] ;
	TCHAR		szDllMakerUrl[MAX_DLL_MAKER_URL_LENGTH] ;
	TCHAR		szDllMakerMail[MAX_DLL_MAKER_MAIL_LENGTH] ;
	DWORD		dwIoMode ;
	
	MAPIOSTRUCT	ioMapper ;
	
	EXTFLG		flgs ;
}EmuZ2000ExtendBoardInfomationHeader, EMUZ2000EBIH, *PEmuZ2000ExtendBoardInfomationHeader, *PEMUZ2000EBIH ;

//////////////////////////////////
// Call by DLLs Prototype
short
WINAPI
emuz2000_getCpuMode(
	DWORD	id
	) ;

int
WINAPI
emuz2000_getCpuClock(
	DWORD	id
	) ;

PVOID
WINAPI
emuz2000_getMainMemoryPointer(
	DWORD	id
	) ;

PVOID
WINAPI
emuz2000_getTextVramPointer(
	DWORD	id
	) ;

VOID
WINAPI
emuz2000_getGraphicRamPointers(
	DWORD	id,
	PVOID	g1,
	PVOID	g2,
	PVOID	g3
	) ;

VOID
WINAPI
emuz2000_setViewChange(
	DWORD	id
	) ;

VOID
WINAPI
emuz2000_sendKeyMessage(
	DWORD	id,
	UCHAR	keyCode,
	UCHAR	flg
	) ;

VOID
WINAPI
emuz2000_signalInterrupt(
	DWORD	id,
	UCHAR	code
	) ;

UCHAR
WINAPI
emuz2000_inputPort(
	DWORD	id,
	USHORT	port
	) ;

VOID
WINAPI
emuz2000_outputPort(
	DWORD	id,
	USHORT	port,
	UCHAR	data
	) ;

//Profile Service
DWORD
WINAPI
emuz2000_readProfileDword(
	DWORD	id,
	LPCTSTR	lpKey
	) ;

DWORD
WINAPI
emuz2000_readProgileString(
	DWORD	id,
	LPCTSTR	lpKey,
	LPTSTR	lpGetBuf,
	DWORD	nGetMaxSize
	) ;

BOOL
WINAPI
emuz2000_writeProfileDword(
	DWORD	id,
	LPCTSTR	lpKey,
	DWORD	value
	) ;

BOOL
WINAPI
emuz2000_writeProgileString(
	DWORD	id,
	LPCTSTR	lpKey,
	LPCTSTR	lpString
	) ;

//Memory Segment Collection
BOOL
WINAPI
emuz2000_getMemorySegmentInfo(
	DWORD				id,
	PMAPMEMORYSTRUCT	pmms
	) ;


BOOL
WINAPI
emuz2000_setMemorySegmentInfo(
	DWORD				id,
	PMAPMEMORYSTRUCT	pmms
	) ;
//////////////////////////////////////////////////////////////////////////////////////////////
//Sound Service
BOOL
WINAPI
emuz2000_ext_Sound_Create(
	DWORD	id,
	DWORD	no
	) ;

BOOL
WINAPI
emuz2000_ext_Sound_Play(
	DWORD	id,
	DWORD	no
	) ;

BOOL
WINAPI
emuz2000_ext_Sound_Stop(
	DWORD	id,
	DWORD	no
	) ;


#ifndef	_NO_BOARD_API_
BOOL
WINAPI
IntializeBoard( 
	VOID
	) ;

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	) ;

VOID
WINAPI
FinalizeBoard( 
	VOID 
	) ;

VOID
WINAPI
ReportCpuClock( 
	int clk
	) ;

VOID
WINAPI
InfomationDialog( 
	HWND hWnd 
	) ;

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	) ;

BOOL
WINAPI
SoundDataUpload( 
	DWORD size,
	PUCHAR buf
	) ;

BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	) ;

BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	) ;

#endif //_NO_BOARD_API_

#endif	//_emuz2000ioBoard_h_
