/* File: common.h

	Common Settings Headders

	Copyright (C) 1998-2019 FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __COMMON_H_INCLUDED
#define __COMMON_H_INCLUDED

#include <windows.h>
#include <stdio.h>
#include <stdarg.h>

#ifndef LNMAX
#define LNMAX	256
#endif

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

/* malloc definitions */
#define MALLOC(_X)	malloc((_X))
#define REALLOC(_X,_Y)	realloc((_X),(_Y))
#define CALLOC(_X,_Y)	calloc((_X),(_Y))
#define FREE(_X)	free((_X))

#ifdef HAVE_GETTEXT
#define _(_STR)		gettext(_STR)
#define N_(_STR)	gettext_noop(_STR)
#define gettext_noop(_STR) (_STR)
#else
#define _(_STR)		(_STR)
#define N_(_STR)	(_STR)
#endif /* HAVE_GETTEXT */

extern char module_name[LNMAX];

#ifdef WIN32
#ifdef _DEBUG
static void _TRACE( char *s, ... )
{
	char ___debug_buf[LNMAX];
	va_list arg_ptr;

	va_start( arg_ptr, s );
	_vsnprintf(___debug_buf, LNMAX, s, arg_ptr);
	___debug_buf[LNMAX - 1] = '\0';
	va_end( arg_ptr );
	OutputDebugString(___debug_buf);
}
#else
static void _TRACE( char *s, ... )
{
	return;
}
#endif /* _DEBUG */
#else
#ifdef NDEBUG
#define _TRACE(X...)
#define _TRACEN(X...)
#else
static inline int _TRACE_0( const char *file, const char *func, int line, const char *s, ... )
{
	char ___msg_buf[LNMAX];
	va_list arg_ptr;

	printf("%s(%s/L=%d):", file, func, line);
#ifdef USE_PROFILER
	profiler_timedisp( stdout, &profiler_debug_timectxt );
	printf(": ");
#endif
	va_start( arg_ptr, s );
	vsnprintf(___msg_buf, LNMAX, s, arg_ptr);
	va_end( arg_ptr );
	printf("%s", ___msg_buf);
	fflush(stdout);
	return TRUE;
}

static inline int _TRACEN( const char *s, ... )
{
	char ___msg_buf[LNMAX];
	va_list arg_ptr;

	va_start( arg_ptr, s );
	vsnprintf(___msg_buf, LNMAX, s, arg_ptr);
	va_end( arg_ptr );
	printf("%s", ___msg_buf);
	fflush(stdout);
	return TRUE;
}

#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define _TRACE(_X...) _TRACE_0(__FILE__, __func__, __LINE__, _X)
#elif defined(__GNUC__)
#define _TRACE(_X...) _TRACE_0(__FILE__, __PRETTY_FUNCTION__, __LINE__, _X)
#else
#define _TRACE(_X...) _TRACE_0(__FILE__, "", __LINE__, _X)
#endif

#endif /* NDEBUG */

static inline int WARNMSG( const char *s, ... )
{
	char ___msg_buf[LNMAX];
	va_list arg_ptr;

	fprintf(stderr, "%s: ", module_name);
#ifdef DEBUG
#ifdef USE_PROFILER
	profiler_timedisp( stderr, &profiler_debug_timectxt );
	fprintf( stderr, ": ");
#endif
#endif
	va_start( arg_ptr, s );
	vsnprintf(___msg_buf, LNMAX, s, arg_ptr);
	va_end( arg_ptr );
	fprintf(stderr, "%s", ___msg_buf);
	fflush(stderr);
	return FALSE;
}

static inline int ERRMSG( const char *s, ... )
{
	char ___msg_buf[LNMAX];
	va_list arg_ptr;

	fprintf(stderr, "%s: ", module_name);
#ifdef DEBUG
#ifdef USE_PROFILER
	profiler_timedisp( stderr, &profiler_debug_timectxt );
	fprintf( stderr, ": ");
#endif
#endif
	va_start( arg_ptr, s );
	vsnprintf(___msg_buf, LNMAX, s, arg_ptr);
	va_end( arg_ptr );
	fprintf(stderr, "%s", ___msg_buf);
	fflush(stderr);
	return FALSE;
}
#endif /* WIN32 */

#endif /* __COMMON_H_INCLUDED */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
