/* File: screen.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		CRTC / Interfaces

	Collect and extend the EmuZ-2000 screen codes by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.

	Caution !!
	This file is including the old EmuZ-2000 program code.
	These are no copyright information and released open source code.
*/

#include "config.h"

#include "common.h"
#include "mz2000.h"

static DWORD exchgVram[MZ_GRAMPAGE_SIZE];

BOOL screen_clear( MZ2000 *mz2000 )
{
	int i;

	for (i = 0; i < TEXT_CLIP; i++)
		mz2000 -> vram[i] = 0;
	return TRUE;
}

BOOL screen_putmsg( MZ2000 *mz2000, int adr, const char *s )
{
	int i;

	for (i = 0; i < (int)strlen(s); i++) {
		if (!s[i] || s[i] == 0x0d)
			break;
		mz2000 -> vram[adr + i] = s[i];
	}
	return TRUE;
}

BOOL screen_putmsgn( MZ2000 *mz2000, int adr, const char *s, int n )
{
	int i;

	for (i = 0; i < n; i++) {
		if (!s[i] || s[i] == 0x0d)
			break;
		mz2000 -> vram[adr + i] = s[i];
	}
	return TRUE;
}

BOOL screen_region_add_textvram( MZ2000 *mz, int addr )
{
	mz->vramChg = mz->viewMsg = TRUE;
	WaitForSingleObject( viewarea.hmutex, INFINITE );
	if (!(mz->ioinfo->port_e8 & 0x20U))
		textDraw40( mz, addr );
	else
		textDraw80( mz, addr );
	playview_add_redrawct();
	ReleaseMutex( viewarea.hmutex );
	return TRUE;
}

static void exchgChecker( DWORD adr )
{
	viewarea.minx = min( viewarea.minx, adr % MZ2000_DISPLAY_WIDTH );
	viewarea.maxx = max( viewarea.maxx, (adr + 7) % MZ2000_DISPLAY_WIDTH );
	viewarea.max = max( viewarea.max, adr + MZ2000_DISPLAY_WIDTH + 7 );
	viewarea.min = min( viewarea.min, adr );
	return;
}

BOOL screen_region_add_gram2000( MZ2000 *mz, int page, int addr )
{
	u8 value;

	switch (page) {
	case 0 :
		if (mz->graphMask[0]) {
			PVRAMIMG vimg;
			DWORD addres;
			DWORD col;

			value =	mz->gram1[addr];
			mz->gram1Chg = mz->viewMsg = TRUE;
			addres = exchgVram[addr];
			vimg = (PVRAMIMG)(PUCHAR)mz->gdimem+addres;
			WaitForSingleObject( viewarea.hmutex, INFINITE );
			exchgChecker(addres);
			if (!mz -> screen_highreso) {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.b = PADBYTE_INDEX;
					vimg->bit.b = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg++;
				}
			} else {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.b = vimg->bit.b = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg++;
				}
			}
			mz->viewChg = TRUE;
			playview_add_redrawct();
			ReleaseMutex( viewarea.hmutex );
		}
		break;
	case 1 :
		if (mz->graphMask[1]) {
			PVRAMIMG vimg;
			DWORD addres;
			DWORD col;

			value =	mz->gram2[addr];
			mz->gram1Chg = mz->viewMsg = TRUE;
			addres = exchgVram[addr];
			vimg = (PVRAMIMG)(PUCHAR)mz->gdimem+addres;
			WaitForSingleObject( viewarea.hmutex, INFINITE );
			exchgChecker(addres);
			if (!mz -> screen_highreso) {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.r = PADBYTE_INDEX;
					vimg->bit.r = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg++;
				}
			} else {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.r = vimg->bit.r = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg++;
				}
			}
			mz->viewChg = TRUE;
			playview_add_redrawct();
			ReleaseMutex( viewarea.hmutex );
		}
		break;
	case 2 :
		if (mz->graphMask[2]) {
			PVRAMIMG vimg;
			DWORD addres;
			DWORD col;

			value =	mz->gram3[addr];
			mz->gram1Chg = mz->viewMsg = TRUE;
			addres = exchgVram[addr];
			vimg = (PVRAMIMG)(PUCHAR)mz->gdimem+addres;
			WaitForSingleObject( viewarea.hmutex, INFINITE );
			exchgChecker(addres);
			if (!mz -> screen_highreso) {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.g = PADBYTE_INDEX;
					vimg->bit.g = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg++;
				}
			} else {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.g = vimg->bit.g = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg++;
				}
			}
			mz->viewChg = TRUE;
			playview_add_redrawct();
			ReleaseMutex( viewarea.hmutex );
		}
		break;
	default :
		break;
	}
	return TRUE;
}

static void exchgChecker80B( DWORD adr )
{
	viewarea.minx = min( viewarea.minx, adr % MZ2000_DISPLAY_WIDTH );
	viewarea.maxx = max( viewarea.maxx, (adr + 15) % MZ2000_DISPLAY_WIDTH );
	viewarea.max = max( viewarea.max, adr + MZ2000_DISPLAY_WIDTH + 7 );
	viewarea.min = min( viewarea.min, adr );
	return;
}

BOOL screen_region_add_gram80B( MZ2000 *mz, int page, int addr )
{
	u8 value;

	switch (page) {
	case 0 :
		if (mz->graphMask[0]) {
			static PVRAMIMG vimg;
			static DWORD addres, col;

			value = mz->gram1[addr];
			mz->gram1Chg = mz->viewMsg = TRUE;
			addres = exchgVram[addr];
			vimg = (PVRAMIMG)(PUCHAR)mz->gdimem+addres;
			WaitForSingleObject( viewarea.hmutex, INFINITE );
			exchgChecker80B( addres );
			if (!mz -> screen_highreso) {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.b = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.b =
						PADBYTE_INDEX;
					vimg[1].bit.b = vimg->bit.b = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg += 2;
				}
			} else {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.b = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.b =
						vimg[1].bit.b = vimg->bit.b = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg += 2;
				}
			}
			mz->viewChg = TRUE;
			playview_add_redrawct();
			ReleaseMutex( viewarea.hmutex );
		}
		break;
	case 1 :
		if (mz->graphMask[1]) {
			static PVRAMIMG vimg;
			static DWORD addres, col;

			value = mz->gram2[addr];
			mz->gram1Chg = mz->viewMsg = TRUE;
			addres = exchgVram[addr];
			vimg = (PVRAMIMG)(PUCHAR)mz->gdimem+addres;
			WaitForSingleObject( viewarea.hmutex, INFINITE );
			exchgChecker80B( addres );
			if (!mz -> screen_highreso) {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.r = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.r =
						PADBYTE_INDEX;
					vimg[1].bit.r = vimg->bit.r = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg += 2;
				}
			} else {
				for (col = 0; col < 8; col++) {
					vimg[MZ2000_DISPLAY_WIDTH].bit.r = vimg[MZ2000_DISPLAY_WIDTH + 1].bit.r =
						vimg[1].bit.r = vimg->bit.r = (value & 0x1) ? 1 : 0;
					value >>= 1;
					vimg += 2;
				}
			}
			mz->viewChg = TRUE;
			playview_add_redrawct();
			ReleaseMutex( viewarea.hmutex );
		}
		break;
	default :
		break;
	}
	return TRUE;
}

BOOL screen_region_add_all( MZ2000 *mz2000 )
{
	WaitForSingleObject( viewarea.hmutex, INFINITE );
	if (!(mz2000 -> ioinfo -> port_e8 & 0x20U))
		textDraw40( mz2000, TEXT_ALL_REDRAW );
	else
		textDraw80( mz2000, TEXT_ALL_REDRAW );
	mz2000 -> mzChgGraphMode = TRUE;
	mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	playview_add_redrawct();
	ReleaseMutex( viewarea.hmutex );
	return TRUE;
}

BOOL screen_portF4( MZ2000 *mz2000, unsigned char value )
{
	mz2000 -> backColor = value;
	mz2000 -> mzChgGraphMode = TRUE;
	mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_portF5( MZ2000 *mz2000, unsigned char value )
{
	if (mz2000 -> ioinfo -> port_f5 > 0x07U) {
		mz2000 -> displayAttr = TRUE;
		mz2000 -> textColor = value & 0x07U;
	} else {
		mz2000 -> displayAttr = FALSE;
		mz2000 -> textColor = value & 0x07U;
	}
	mz2000 -> mzChgGraphMode
		= mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_portF6( MZ2000 *mz2000, unsigned char value )
{
	int i;

	if (value > 0x07) {
		if (mz2000 -> greenGraphOn) 
			mz2000 -> greenGraphOn = FALSE;
	} else {
		if (!(mz2000 -> greenGraphOn))
			mz2000 -> greenGraphOn = TRUE;
	}
	for (i = 0; i < 3; i++) {
		if (value & 1)
			mz2000 -> graphMask[i] = 0xffU;
		else
			mz2000 -> graphMask[i] = 0x00U;
		value >>= 1;
	}
	mz2000 -> mzChgGraphMode = TRUE;
	mz2000 -> gram1Chg = mz2000 -> gram2Chg = TRUE;
	if (!mz2000 -> mzmode)
		mz2000 -> gram3Chg = TRUE;
	mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_setreverse( MZ2000 *mz2000, BOOL flag )
{
	mz2000 -> mzChgGraphMode = TRUE;
	mz2000 -> viewMsg = TRUE;
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_setblank( MZ2000 *mz2000, BOOL flag )
{
	if (flag) {
		mz2000 -> greenGraphOn =
		mz2000 -> greenTextOn  = FALSE;
		mz2000 -> mzChgGraphMode = TRUE;
	} else {
		mz2000 -> greenGraphOn =
		mz2000 -> greenTextOn  = TRUE;
		mz2000 -> mzChgGraphMode = TRUE;
		mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
		WaitForSingleObject( viewarea.hmutex, INFINITE );
		if (!(mz2000 -> ioinfo-> port_e8 & 0x20U))
			textDraw40( mz2000, TEXT_ALL_REDRAW );
		else
			textDraw80( mz2000, TEXT_ALL_REDRAW );
		ReleaseMutex( viewarea.hmutex );
	}
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_setchrsize( MZ2000 *mz2000, BOOL chr80_flag )
{
	WaitForSingleObject( viewarea.hmutex, INFINITE );
	if (!chr80_flag) {
		mz2000 -> ioinfo-> port_e8 &= ~0x20U;
		textDraw40( mz2000, TEXT_ALL_REDRAW );
	} else {
		mz2000 -> ioinfo-> port_e8 |= 0x20U;
		textDraw80( mz2000, TEXT_ALL_REDRAW );
	}
	ReleaseMutex( viewarea.hmutex );
	mz2000 -> mzChgGraphMode = TRUE;
	mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	Sleep( 100 );
	PostMessage( mz2000 -> ghWnd, WM_PAINT, 0, 0 );
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_setmonitor( MZ2000 *mz2000, BOOL color_flag )
{
	if (!color_flag) {
		mz2000 -> displayMode = FALSE;
		mz2000 -> mzChgGraphMode = TRUE;
		mz2000 -> viewMsg = TRUE;
	} else {
		mz2000 -> displayMode = TRUE;
		mz2000 -> mzChgGraphMode = TRUE;
		mz2000 -> viewMsg = TRUE;
	}
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_sethighreso( MZ2000 *mz2000, BOOL highreso_flag )
{
	if (!highreso_flag) {
		mz2000 -> screen_highreso = FALSE;
		WaitForSingleObject( viewarea.hmutex, INFINITE );
		ChangeHighresoInit( mz2000 );
		if (!(mz2000 -> ioinfo-> port_e8 & 0x20U))
			textDraw40( mz2000, TEXT_ALL_REDRAW );
		else
			textDraw80( mz2000, TEXT_ALL_REDRAW );
		ReleaseMutex( viewarea.hmutex );
		mz2000 -> mzChgGraphMode = TRUE;
		mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	} else {
		mz2000 -> screen_highreso = TRUE;
		WaitForSingleObject( viewarea.hmutex, INFINITE );
		ChangeHighresoInit( mz2000 );
		if (!(mz2000 -> ioinfo -> port_e8 & 0x20U))
			textDraw40( mz2000, TEXT_ALL_REDRAW );
		else
			textDraw80( mz2000, TEXT_ALL_REDRAW );
		ReleaseMutex( viewarea.hmutex );
		mz2000 -> mzChgGraphMode = TRUE;
		mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	}
	playview_add_redrawct();
	return TRUE;
}

BOOL screen_setfontlang( MZ2000 *mz2000, BOOL english_flag )
{
	mz2000 -> font_english = english_flag;
	mz2000 -> mzChgGraphMode = TRUE;
	mz2000 -> vramChg = mz2000 -> viewMsg = TRUE;
	WaitForSingleObject( viewarea.hmutex, INFINITE );
	if (!(mz2000 -> ioinfo-> port_e8 & 0x20U))
		textDraw40( mz2000, TEXT_ALL_REDRAW );
	else
		textDraw80( mz2000, TEXT_ALL_REDRAW );
	playview_add_redrawct();
	ReleaseMutex( viewarea.hmutex );
	return TRUE;
}

BOOL screen_setgreencolor( MZ2000 *mz,
	unsigned char nfr, unsigned char nfg, unsigned char nfb,
	unsigned char nbr, unsigned char nbg, unsigned char nbb,
	unsigned char rfr, unsigned char rfg, unsigned char rfb,
	unsigned char rbr, unsigned char rbg, unsigned char rbb )
{
	screen_crtc_setgreencolor( mz,
		nfr, nfg, nfb, nbr, nbg, nbb,
		rfr, rfg, rfb, rbr, rbg, rbb );
	memcpy( (void *)mz -> paletteTableTemp, paletteTable, sizeof(paletteTable) );
	return TRUE;
}

BOOL screen_initattr2( MZ2000 *mz )
{
	/* initial setting */
	mz->graphMask[0] =
	mz->graphMask[1] =
	mz->graphMask[2] = FALSE;

	mz->textColor = 7;		// Text Color
	mz->backColor = 0;		// Background Color
	mz->greenGraphOn = TRUE;	// Green Display Graphic On
					// 0:GreenMode Graph off 1:GreenMode Graph on
	mz->greenTextOn = TRUE;		// Green Display Text On
					// 0:GreenMode Text off  1:Green Mode Text on
	mz->displayAttr = FALSE;	// Priority Text Front
					// 0:t-Front.. 1:G-Front (displayMode+dispAttr)=...
	PaletteChange( mz );
	return TRUE;
}

BOOL screen_initattr( MZ2000 *mz )
{
	/* clear Text V-RAM and G-RAM and initialize */
	memory_clear( mz, 2 );
	return screen_initattr2( mz );
}

BOOL screen_initarch( MZ2000 *mz )
{
	DWORD lop;
	DWORD adr = 0;

	/* for Windows screen update */
	/* create address conversion table for speed up */
	if (!mz->mzmode) {
		/* MZ-2000 */
		for (lop = 0; lop < GRAM_CLIP; lop++) {
			if (!(lop % 80) && lop)
				adr += 1280;
			exchgVram[lop] = adr + (lop % 80) * 8;
		}
	} else {
		/* MZ-80B */
		for (lop = 0; lop < GRAM_CLIP_80B; lop++) {
			if (!(lop % 40) && lop)
				adr += 1280;
			exchgVram[lop] = adr + (lop % 40) * 16;
		}
	}
	memcpy( (void *)mz -> paletteTableTemp, paletteTable, sizeof(paletteTable) );
	return TRUE;
}

void screen_exit( MZ2000 *mz2000 )
{
	MZ2000 *mz = mz2000;

	if (mz -> dgram) {
		FREE( mz -> dgram );
		mz -> dgram = NULL;
	}
	if (mz -> dvram) {
		FREE( mz -> dvram );
		mz -> dvram = NULL;
	}
	return;
}

BOOL screen_init( MZ2000 *mz2000 )
{
	MZ2000 *mz = mz2000;

	if (!(mz->dvram = (u8 *)CALLOC( MZ_TEXTVRAM_SIZE, 1 ))) {
		fprintf(stderr, "No enough memory (dvram)\n");
		return FALSE;
	}
	if (!(mz->dgram = (u8 *)CALLOC( MZ_GRAMPAGE_SIZE, 1 ))) {
		fprintf(stderr, "No enough memory (dgram)\n");
		FREE( mz -> dvram );
		return FALSE;
	}
	mz->dwDebugPrint = FALSE;
	screen_initarch( mz2000 );
	screen_initattr( mz2000 );
	return TRUE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
