/* File: screen_crtc2.cpp

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		CRTC Fullscreen / Direct Draw

	Extend the EmuZ-2000 mz2000CRTC2.cpp by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.

	Caution !!
	This file is including the old EmuZ-2000 program codes.
	These are released open source code without copyright information.
*/

#include <windows.h>
#include <ddraw.h>
#include <string.h>

extern "C" {
#include "config.h"
#include "common.h"
#include "mz2000.h"
}

#define DISP_BLANKHEIGHT	24
#define SCREEN_STRETCHBLT_MODE	COLORONCOLOR
//#define SCREEN_STRETCHBLT_MODE	HALFTONE

SCREEN_INFO *screen_info = NULL;
int screeninfo_maxnum = 1;
static int screeninfo_tct = 0;
int screen_full_autoflag = TRUE;
int screen_full_width  = MZ2000_DISPLAY_WIDTH;
int screen_full_height = MZ2000_DISPLAY_HEIGHT;
static int blackwidth_size = 0;
static int blackheight_size = 0;
static BOOL screen_stretch = FALSE;

#if DIRECTDRAW_VERSION >= 0x700
#define LPDIRECTDRAWN		LPDIRECTDRAW7
#define LPDIRECTDRAWSURFACEN	LPDIRECTDRAWSURFACE7
#define DDSURFACEDESCN		DDSURFACEDESC2
#else
#define LPDIRECTDRAWN		LPDIRECTDRAW
#define LPDIRECTDRAWSURFACEN	LPDIRECTDRAWSURFACE
#define DDSURFACEDESCN		DDSURFACEDESC
#endif
static LPDIRECTDRAWN lpDD = NULL;
static LPDIRECTDRAWSURFACEN lpDDSPrimary = NULL;
static LPDIRECTDRAWSURFACEN lpDDSSurface1 = NULL;

#if DIRECTDRAW_VERSION >= 0x700
BOOL WINAPI DDEnumCallbackEx_ct( GUID FAR *lpGUID,
	LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext, HMONITOR hm )
{
	if (!hm)
		return TRUE;
	_TRACE("%s %s\n", lpDriverDescription, lpDriverName );
	screeninfo_maxnum++;
	return TRUE;
}

BOOL WINAPI DDEnumCallbackEx( GUID FAR *lpGUID,
	LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext, HMONITOR hm )
{
	if (!hm)
		return TRUE;
	if (screeninfo_tct < SCREENINFO_DRIVERNAME_MAXNUM) {
		screen_info[screeninfo_tct] . guid = *lpGUID;
		strncpy( screen_info[screeninfo_tct] . DriverName, lpDriverName, SCREENINFO_DRIVERNAME_MAXNUM );
		screen_info[screeninfo_tct] . DriverName[SCREENINFO_DRIVERNAME_MAXNUM - 1] = '\0';
		screeninfo_tct++;
	}
	return TRUE;
}

HRESULT WINAPI EnumModesCallback2( LPDDSURFACEDESC2 lpDDSurfaceDesc2, LPVOID lpContext )
{
	int i;
	LPDDSURFACEDESC2 p = lpDDSurfaceDesc2;

	if (p -> dwFlags & (DDSD_WIDTH | DDSD_HEIGHT | DDSD_REFRESHRATE)) {
		for (i = 0; i < screen_info[screeninfo_tct] . res_maxnum; i++) {
			if (p -> dwWidth == screen_info[screeninfo_tct] . sx[i]
				&& p -> dwHeight == screen_info[screeninfo_tct] . sy[i]
				&& p -> dwRefreshRate == screen_info[screeninfo_tct] . srefresh[i] ) {
				return DDENUMRET_OK;
			}
		}
		//_TRACE( "--> %d x %d (%d)\n", p -> dwWidth, p -> dwHeight, p -> dwRefreshRate );
		i = screen_info[screeninfo_tct] . res_maxnum;
		if (i < SCREENINFO_RES_MAXNUM) {
			screen_info[screeninfo_tct] . sx[i] = p -> dwWidth;
			screen_info[screeninfo_tct] . sy[i] = p -> dwHeight;
			screen_info[screeninfo_tct] . srefresh[i] = p -> dwRefreshRate;
			screen_info[screeninfo_tct] . res_maxnum++;
		}
	}
	return DDENUMRET_OK;
}
#else
HRESULT WINAPI EnumModesCallback( LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext )
{
	int i;
	LPDDSURFACEDESC p = lpDDSurfaceDesc;

	if (p -> dwFlags & (DDSD_WIDTH | DDSD_HEIGHT)) {
		for (i = 0; i < screen_info[screeninfo_tct] . res_maxnum; i++) {
			if (p -> dwWidth == screen_info[screeninfo_tct] . sx[i]
					&& p -> dwHeight == screen_info[screeninfo_tct] . sy[i])
				return DDENUMRET_OK;
		}
		//_TRACE( "--> %d x %d\n", p -> dwWidth, p -> dwHeight );
		i = screen_info[screeninfo_tct] . res_maxnum;
		if (i < SCREENINFO_RES_MAXNUM) {
			screen_info[screeninfo_tct] . sx[i] = p -> dwWidth;
			screen_info[screeninfo_tct] . sy[i] = p -> dwHeight;
			screen_info[screeninfo_tct] . srefresh[i] = 0;
			screen_info[screeninfo_tct] . res_maxnum++;
		}
	}
	return DDENUMRET_OK;
}
#endif

int GetScreenResolutions( HWND hWnd )
{
	bool flag;
	int i, j;
	unsigned int t;
	HRESULT hRes;

#if DIRECTDRAW_VERSION >= 0x700
	screeninfo_maxnum = 0;
	hRes = DirectDrawEnumerateEx( DDEnumCallbackEx_ct, NULL, DDENUM_ATTACHEDSECONDARYDEVICES );
	if (hRes != DD_OK) {
		MessageBox( hWnd, "DirectDrawEnumerateEx() Failed - 1", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
		return -1;
	}
	screeninfo_maxnum++;	/* for Mode Default */
	screen_info = (SCREEN_INFO *)MALLOC( screeninfo_maxnum * sizeof(SCREEN_INFO) );
	if (!screen_info) {
		MessageBox( hWnd, "Memory Allocation Failed", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
		return -1;
	}
	memset( screen_info, 0, screeninfo_maxnum * sizeof(SCREEN_INFO) );
	strncpy( screen_info[0] . DriverName, "Default", SCREENINFO_DRIVERNAME_MAXNUM );
	screen_info[0] . DriverName[SCREENINFO_DRIVERNAME_MAXNUM - 1] = '\0';
	screeninfo_tct = 1;
	hRes = DirectDrawEnumerateEx( DDEnumCallbackEx, NULL, DDENUM_ATTACHEDSECONDARYDEVICES );
	if (hRes != DD_OK) {
		MessageBox( hWnd, "DirectDrawEnumerateEx() Failed - 2", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
		return -1;
	}
#else
	screeninfo_maxnum = 1;
	screen_info = (SCREEN_INFO *)MALLOC( screeninfo_maxnum * sizeof(SCREEN_INFO) );
	if (!screen_info) {
		MessageBox( hWnd, "Memory Allocation Failed", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
		return -1;
	}
	memset( screen_info, 0, screeninfo_maxnum * sizeof(SCREEN_INFO) );
	strncpy( screen_info[0] . DriverName, "Default", SCREENINFO_DRIVERNAME_MAXNUM );
	screen_info[0] . DriverName[SCREENINFO_DRIVERNAME_MAXNUM - 1] = '\0';
#endif

	for (screeninfo_tct = 0; screeninfo_tct < screeninfo_maxnum; screeninfo_tct++) {
#if DIRECTDRAW_VERSION >= 0x700
		if (!memcmp( &screen_info[screeninfo_tct] . guid, "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0", 16 ))
			hRes = DirectDrawCreateEx( &screen_info[screeninfo_tct] . guid, (void **)&lpDD, IID_IDirectDraw7, NULL );
		else
			hRes = DirectDrawCreateEx( &screen_info[screeninfo_tct] . guid, (void **)&lpDD, IID_IDirectDraw7, NULL );
		if (hRes != DD_OK)
#else
		if (DirectDrawCreate( NULL, &lpDD, NULL ) != DD_OK)
#endif
		{
			MessageBox( hWnd, "DirectDrawCreate() Failed", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
			if (lpDD) {
				lpDD -> Release();
				lpDD = NULL;
			}
			return -1;
		}
		screen_info[screeninfo_tct] . res_maxnum = 0;
#if DIRECTDRAW_VERSION >= 0x700
		hRes = lpDD -> EnumDisplayModes( DDEDM_REFRESHRATES, NULL, NULL, EnumModesCallback2 );
		if (hRes != DD_OK) {
			MessageBox( hWnd, "EnumDisplayModes() Failed", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
			if (lpDD) {
				lpDD -> Release();
				lpDD = NULL;
			}
			return -1;
		}
#else
		hRes = lpDD -> EnumDisplayModes( 0, NULL, NULL, EnumModesCallback );
		if (hRes != DD_OK) {
			MessageBox( hWnd, "EnumDisplayModes() Failed", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
			if (lpDD) {
				lpDD -> Release();
				lpDD = NULL;
			}
			return -1;
		}
#endif
		if (lpDD) {
			lpDD -> Release();
			lpDD = NULL;
		}

		/* sort screen_info by sx,sy,srefresh */
		for (i = 0; i < screen_info[screeninfo_tct] . res_maxnum - 1; i++) {
			for (j = i + 1; j < screen_info[screeninfo_tct] . res_maxnum; j++) {
				flag = FALSE;
				if (screen_info[screeninfo_tct] . sx[i] > screen_info[screeninfo_tct] . sx[j])
					flag = TRUE;
				if ((screen_info[screeninfo_tct] . sx[i] == screen_info[screeninfo_tct] . sx[j])
				 && (screen_info[screeninfo_tct] . sy[i] > screen_info[screeninfo_tct] . sy[j]))
					flag = TRUE;
				if ((screen_info[screeninfo_tct] . sx[i] == screen_info[screeninfo_tct] . sx[j])
				 && (screen_info[screeninfo_tct] . sy[i] == screen_info[screeninfo_tct] . sy[j])
				 && (screen_info[screeninfo_tct] . srefresh[i] > screen_info[screeninfo_tct] . srefresh[j]))
					flag = TRUE;
				if (flag) {
					t = screen_info[screeninfo_tct] . sx[i];
					screen_info[screeninfo_tct] . sx[i] = screen_info[screeninfo_tct] . sx[j];
					screen_info[screeninfo_tct] . sx[j] = t;
					t = screen_info[screeninfo_tct] . sy[i];
					screen_info[screeninfo_tct] . sy[i] = screen_info[screeninfo_tct] . sy[j];
					screen_info[screeninfo_tct] . sy[j] = t;
					t = screen_info[screeninfo_tct] . srefresh[i];
					screen_info[screeninfo_tct] . srefresh[i] = screen_info[screeninfo_tct] . srefresh[j];
					screen_info[screeninfo_tct] . srefresh[j] = t;
				}
			}
		}
		for (i = 0; i < screen_info[screeninfo_tct] . res_maxnum; i++)
			_TRACE( "%d x %d (%d)\n", screen_info[screeninfo_tct] . sx[i],
				screen_info[screeninfo_tct] . sy[i], screen_info[screeninfo_tct] . srefresh[i] );

		if (!screen_info[screeninfo_tct] . res_maxnum) {
			MessageBox( hWnd, "No refresh rate 60Hz resolutions monitor found.", "SCREEN_CRTC2", MB_OK | MB_ICONSTOP | MB_TASKMODAL );
			return -1;
		}
	}
	return 0;
}

BOOL DDrawRelease( HWND hWnd )
{
	if (lpDDSSurface1) {
		lpDDSSurface1 -> Release();
		lpDDSSurface1 = NULL;
	}
	if (lpDDSPrimary) {
		lpDDSPrimary -> Release();
		lpDDSPrimary = NULL;
	}
	if (lpDD) {
		lpDD -> SetCooperativeLevel( hWnd, DDSCL_NORMAL );
		lpDD -> Release();
		lpDD = NULL;
	}
	return TRUE;
}

void EraseSurface( LPDIRECTDRAWSURFACEN lpDDSurfPtr )
{
	DDBLTFX ddbltfx;
	HRESULT ddrval;

	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0;
	if (!lpDDSurfPtr)
		return;
	while (1) {
		ddrval = lpDDSurfPtr -> Blt( NULL, NULL, NULL, DDBLT_COLORFILL, &ddbltfx );
		if (ddrval == DD_OK)
			break;
		if (ddrval == DDERR_SURFACELOST) {
			ddrval = lpDDSPrimary->Restore();
			if (ddrval != DD_OK)
				break;
		}
		if (ddrval != DDERR_WASSTILLDRAWING)
			break;
	}
	return;
}

LPDIRECTDRAWSURFACEN CreateUnattachedSurface( int width, int height )
{
	LPDIRECTDRAWSURFACEN lpDDSurface;
	DDSURFACEDESCN ddsd;
	HRESULT ddrval;

	memset( &ddsd, 0, sizeof(ddsd) );
	ddsd.dwSize = sizeof( ddsd );
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwHeight = height;
	ddsd.dwWidth = width;
	ddrval = lpDD -> CreateSurface( &ddsd, &lpDDSurface, NULL );
	if (ddrval != DD_OK)
		return NULL;
	return (LPDIRECTDRAWSURFACEN)lpDDSurface; 
}

BOOL DDrawCreate( HWND hWnd )
{
	int i, bpp;
	double ratio;
	DDSURFACEDESCN ddsd;

#if DIRECTDRAW_VERSION >= 0x700
	HRESULT hRes;

	if (!memcmp( &screen_info[screeninfo_tct] . guid, "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0", 16 ))
		hRes = DirectDrawCreateEx( &screen_info[mz2000_global -> fullscreen_device] . guid, (void **)&lpDD, IID_IDirectDraw7, NULL );
	else
		hRes = DirectDrawCreateEx( &screen_info[mz2000_global -> fullscreen_device] . guid, (void **)&lpDD, IID_IDirectDraw7, NULL );
	if (hRes != DD_OK)
#else
	if (DirectDrawCreate( NULL, &lpDD, NULL ) != DD_OK)
#endif
		return FALSE;
	lpDD -> Initialize( NULL );
	lpDD -> SetCooperativeLevel( hWnd, DDSCL_FULLSCREEN | DDSCL_EXCLUSIVE );
	screen_stretch = TRUE;
	bpp = mz2000_global -> fullscreen_bpp;
	if (mz2000_global -> fullscreen_resolution == SCREEN_RESOLUTION_AUTO) {
#if DIRECTDRAW_VERSION >= 0x700
		if (lpDD -> SetDisplayMode( 640, 480, bpp, 60, 0 ) == DD_OK) {
#else
		if (lpDD -> SetDisplayMode( 640, 480, bpp ) == DD_OK) {
#endif
			screen_full_width  = 640;
			screen_full_height = 480;
			screen_stretch = FALSE;
#if DIRECTDRAW_VERSION >= 0x700
		} else if (lpDD -> SetDisplayMode( 800, 480, bpp, 60, 0 ) == DD_OK) {
#else
		} else if (lpDD -> SetDisplayMode( 800, 480, bpp ) == DD_OK) {
#endif
			screen_full_width  = 800;
			screen_full_height = 480;
			screen_stretch = FALSE;
#if DIRECTDRAW_VERSION >= 0x700
		} else if (lpDD -> SetDisplayMode( 960, 600, bpp, 60, 0 ) == DD_OK) {
#else
		} else if (lpDD -> SetDisplayMode( 960, 600, bpp ) == DD_OK) {
#endif
			screen_full_width  = 960;
			screen_full_height = 600;
#if DIRECTDRAW_VERSION >= 0x700
		} else if (lpDD -> SetDisplayMode( 800, 600, bpp, 60, 0 ) == DD_OK) {
#else
		} else if (lpDD -> SetDisplayMode( 800, 600, bpp ) == DD_OK) {
#endif
			screen_full_width  = 800;
			screen_full_height = 600;
		} else {
			lpDD -> Release();
			lpDD = NULL;
			return FALSE;
		}
		i = 60;
	} else {
		screen_full_width  = screen_info[mz2000_global -> fullscreen_device]
			. sx[mz2000_global -> fullscreen_resolution - 1];
		screen_full_height = screen_info[mz2000_global -> fullscreen_device]
			. sy[mz2000_global -> fullscreen_resolution - 1];
		i = screen_info[mz2000_global -> fullscreen_device]
			. srefresh[mz2000_global -> fullscreen_resolution - 1];
		_TRACE( "Try -> %d x %d (%dHz)\n", screen_full_width, screen_full_height, i );
#if DIRECTDRAW_VERSION >= 0x700
		if (lpDD -> SetDisplayMode( screen_full_width, screen_full_height, bpp, i, 0 ) != DD_OK) {
#else
		if (lpDD -> SetDisplayMode( screen_full_width, screen_full_height, bpp ) != DD_OK) {
#endif
			lpDD -> Release();
			lpDD = NULL;
			return FALSE;
		}
		if (screen_full_width == 640 && screen_full_height == 480)
			screen_stretch = FALSE;
		if (screen_full_width == 800 && screen_full_height == 480)
			screen_stretch = FALSE;
	}
	_TRACE( "%d x %d (%dHz)\n", screen_full_width, screen_full_height, i );
	ratio = (double)screen_full_width / (double)screen_full_height;
	if (ratio > 1.0) {
		blackwidth_size  = (int)((double)((1.0/ratio) * (4.0/3.0) * screen_full_width));
		//_TRACE( "width: %d %d\n", blackwidth_size, screen_full_width - blackwidth_size );
		blackwidth_size  = (screen_full_width - blackwidth_size) / 2;
		if (blackwidth_size < 0)
			blackwidth_size = 0;
		blackheight_size = DISP_BLANKHEIGHT;
	} else if (ratio < 1.0) {
		blackwidth_size = 0;
		blackheight_size = (int)((double)(ratio * (3.0/4.0) * screen_full_height));
		_TRACE( "height: %d %d\n", blackheight_size, screen_full_height - blackheight_size );
		blackheight_size = (screen_full_height - blackheight_size) / 2;
		if (blackheight_size < DISP_BLANKHEIGHT)
			blackheight_size = DISP_BLANKHEIGHT;
	} else {
		blackwidth_size = 0;
		blackheight_size = DISP_BLANKHEIGHT;
	}

	ZeroMemory( &ddsd, sizeof(ddsd) );
	ddsd.dwSize = sizeof( ddsd );
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	lpDD -> CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if (!lpDDSPrimary) {
		lpDD -> Release();
		lpDD = NULL;
		return FALSE;
	}
	lpDDSSurface1 = CreateUnattachedSurface( MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT );
	if (!lpDDSSurface1) {
		DDrawRelease( mz2000_global -> ghWnd );
		return FALSE;
	}
	EraseSurface( lpDDSSurface1 );
	return TRUE;
}

void _DDrawDrawStatusBar( HWND hWnd, HDC hDC )
{
	int bkmode_bk;
	COLORREF tcolor_bk, bcolor_bk;
	HANDLE hFont_bk, hFont;
	RECT rect;
	char buf[LNMAX];

	if (!bFullScreenMenu)
		return;

	bkmode_bk = SetBkMode( hDC, TRANSPARENT );
	bcolor_bk = SetBkColor( hDC, GetSysColor(COLOR_MENU) );
	tcolor_bk = SetTextColor( hDC, GetSysColor(COLOR_MENUTEXT) );
	hFont = GetStockObject( SYSTEM_FIXED_FONT );
	hFont_bk = SelectObject( hDC, /* hFont */ g_hFSStatusBarFont );

	rect.left   = 0;
	rect.top    = screen_full_height - 1 - g_statusbar_height + 1;
	rect.right  = screen_full_width - 1;
	rect.bottom = screen_full_height - 1;
	strncpy( buf, (char *)g_statusbar_msg, LNMAX - 1 );
	buf[LNMAX - 1] = '\0';
	ExtTextOut( hDC, 8, screen_full_height - 1 - g_statusbar_height + 5, ETO_OPAQUE, &rect, buf, strlen(buf), NULL );

	SelectObject( hDC, hFont_bk );
	SetTextColor( hDC, tcolor_bk );
	SetBkColor( hDC, bcolor_bk );
	SetBkMode( hDC, bkmode_bk );
	return;
}

void _DDrawUpdateScreen( HWND hWnd, MZ2000 *mz )
{
	HDC hdc;
	DWORD flg = mz->dwDebugPrint;
#ifdef ENABLE_DDRAWBLT
	HRESULT ddrval;
#endif

	if (!mz -> gdimem)
		return;
	if (!lpDDSPrimary)
		return;
#ifdef ENABLE_DDRAWBLT
	if (!lpDDSSurface1)
		return;
	if (lpDDSSurface1 -> GetDC( &hdc ) != DD_OK) {
		if (lpDDSSurface1 -> IsLost())
			lpDDSSurface1 -> Restore();
		return;
	}
#else
	if (lpDDSPrimary -> GetDC( &hdc ) != DD_OK) {
		if (lpDDSPrimary -> IsLost())
			lpDDSPrimary-> Restore();
		return;
	}
#endif
	if (mz->dwDebugPrint || mz->dwDebugPrint_state) {
		if (mz->dwDebugPrint_state != mz->dwDebugPrint) {
			mz->dwDebugPrint_state = mz->dwDebugPrint;
			PaletteChange( mz );
		}
		debugTextDraw80( mz, mz->dwDebugPrint );
	}
	if (!(mz -> ioinfo -> port_e8 & 0x20))
		textDraw40( mz, TEXT_ALL_REDRAW );
	else
		textDraw80( mz, TEXT_ALL_REDRAW );
	if (mz -> mzmode)
		drawGraph80B( mz );
	else
		drawGraph( mz );

#ifdef VIEWCHG
	if (mz->viewChg) {
#endif
#ifdef ENABLE_DDRAWBLT
		if (lpDDSSurface1 -> IsLost())
			lpDDSSurface1 -> Restore();
		DWORD r;
		r = BitBlt( hdc, 0, 0,
			MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT,
			mz -> Buffer, 0, 0, SRCCOPY );
		if (!r)
			_TRACE("BitBlt error\n");
		RECT rect, rect2;

		if (screen_stretch) {
			rect.left = blackwidth_size;
			rect.top  = blackheight_size;
			rect.right  = rect.left
				+ screen_full_width  - blackwidth_size  * 2 - 1;
			rect.bottom = rect.top
				+ screen_full_height - blackheight_size * 2 - 1;
			rect2.left = 0;
			rect2.top  = 0;
			rect2.right  = rect.left + MZ2000_DISPLAY_WIDTH - 1;
			rect2.bottom = rect.top + MZ2000_DISPLAY_HEIGHT - 1;
		} else {
			rect.left = (screen_full_width - MZ2000_DISPLAY_WIDTH) / 2;
			rect.top  = (screen_full_height - MZ2000_DISPLAY_HEIGHT) / 2;
			rect.right  = rect.left + MZ2000_DISPLAY_WIDTH - 1;
			rect.bottom = rect.top + MZ2000_DISPLAY_HEIGHT - 1;
			rect2.left = 0;
			rect2.top  = 0;
			rect2.right  = rect.left + MZ2000_DISPLAY_WIDTH - 1;
			rect2.bottom = rect.top + MZ2000_DISPLAY_HEIGHT - 1;
		}
		while (1) {
			EraseSurface( lpDDSPrimary );
			//ddrval = lpDDSPrimary -> BltFast( 0, 0, lpDDSSurface1, &rect,
			//		DDBLTFAST_WAIT | DDBLTFAST_NOCOLORKEY );
			ddrval = lpDDSPrimary -> Blt( &rect, lpDDSSurface1, &rect2,
				DDBLT_WAIT, NULL );
			if (ddrval == DD_OK)
				break;
			if (ddrval == DDERR_SURFACELOST) {
				ddrval = lpDDSPrimary -> Restore();
				if (ddrval != DD_OK)
					break;
				ddrval = lpDDSSurface1 -> Restore();
			}
			if (ddrval != DDERR_WASSTILLDRAWING) {
				_TRACE("ddrval: %d\n", ddrval);
				break;
			}
		}
#else /* ndef ENABLE_DDRAWBLT */
		if (screen_stretch) {
			SetStretchBltMode( hdc, SCREEN_STRETCHBLT_MODE );
			StretchBlt( hdc, blackwidth_size, blackheight_size,
				screen_full_width  - blackwidth_size  * 2,
				screen_full_height - blackheight_size * 2,
				mz -> Buffer, 0, 0, MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT, SRCCOPY );
		} else {
			BitBlt( hdc,
				(screen_full_width - MZ2000_DISPLAY_WIDTH) / 2,
				(screen_full_height - MZ2000_DISPLAY_HEIGHT) / 2,
				MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT,
				mz -> Buffer, 0, 0, SRCCOPY );
		}
		if (lpDDSPrimary -> IsLost())
			lpDDSPrimary -> Restore();
#endif
#ifdef VIEWCHG
	}
#endif
	mz -> viewChg = FALSE;
#if 0 //ndef ENABLE_DDRAWBLT
	if (bFullScreenMenu) {
		if (blackheight_size
				- GetSystemMetrics(SM_CYMENU)
				- GetSystemMetrics(SM_CYFIXEDFRAME)
				- GetSystemMetrics(SM_CYEDGE) > 0) {
			PatBlt( hdc, 0, GetSystemMetrics(SM_CYMENU)
					+ GetSystemMetrics(SM_CYFIXEDFRAME)
					+ GetSystemMetrics(SM_CYEDGE),
				screen_full_width, blackheight_size
					- GetSystemMetrics(SM_CYMENU)
					- GetSystemMetrics(SM_CYFIXEDFRAME)
					- GetSystemMetrics(SM_CYEDGE),
					BLACKNESS );
			PatBlt( hdc, 0, screen_full_height - blackheight_size,
				screen_full_width, blackheight_size
					- GetSystemMetrics(SM_CYMENU)
					- GetSystemMetrics(SM_CYFIXEDFRAME)
					- GetSystemMetrics(SM_CYEDGE) * 2,
					BLACKNESS );
		}
	} else {
		PatBlt( hdc, 0, 0, screen_full_width, blackheight_size, BLACKNESS );
		PatBlt( hdc, 0, screen_full_height - blackheight_size,
				screen_full_width, blackheight_size, BLACKNESS );
	}
#endif
	_DDrawDrawStatusBar( hWnd, hdc );
	lpDDSPrimary -> ReleaseDC( hdc );
	return;
}

void _DDrawUpdateScreenAll( HWND hWnd, MZ2000 *mz )
{
	HDC hdc;
	DWORD flg = mz->dwDebugPrint;
	static DWORD sx,sy,ex,ey;
	static DWORD tmp;
#ifdef ENABLE_DDRAWBLT
	HRESULT ddrval;
#endif

	if (!mz -> gdimem)
		return;
	if (!lpDDSPrimary)
		return;
#ifdef ENABLE_DDRAWBLT
	if (!lpDDSSurface1)
		return;
	if (lpDDSSurface1 -> GetDC( &hdc ) != DD_OK) {
		if (lpDDSSurface1 -> IsLost())
			lpDDSSurface1 -> Restore();
		return;
	}
#else
	if (lpDDSPrimary -> GetDC( &hdc ) != DD_OK) {
		if (lpDDSPrimary -> IsLost())
			lpDDSPrimary-> Restore();
		return;
	}
#endif
	if (viewarea.min != 0xffffff) {
		WaitForSingleObject( viewarea.hmutex, INFINITE );
		sy = viewarea.min / MZ2000_DISPLAY_WIDTH;
		ey = viewarea.max / MZ2000_DISPLAY_WIDTH;
		sx = viewarea.minx;
		ex = viewarea.maxx;
		viewarea.maxx = 0x0;
		viewarea.minx = 0xffff;
		viewarea.max = 0x0;
		viewarea.min = 0xffffff;
		ReleaseMutex( viewarea.hmutex );
#ifdef ENABLE_DDRAWBLT
		if (lpDDSSurface1 -> IsLost())
			lpDDSSurface1 -> Restore();
		DWORD r;
		r = BitBlt( hdc, 0, 0,
			MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT,
			mz -> Buffer, 0, 0, SRCCOPY );
		if (!r)
			_TRACE("BitBlt error\n");
		RECT rect, rect2;

		if (screen_stretch) {
			rect.left = blackwidth_size;
			rect.top  = blackheight_size;
			rect.right  = rect.left
				+ screen_full_width  - blackwidth_size  * 2 - 1;
			rect.bottom = rect.top
				+ screen_full_height - blackheight_size * 2 - 1;
			rect2.left = 0;
			rect2.top  = 0;
			rect2.right  = rect.left + MZ2000_DISPLAY_WIDTH - 1;
			rect2.bottom = rect.top + MZ2000_DISPLAY_HEIGHT - 1;
		} else {
			rect.left = (screen_full_width - MZ2000_DISPLAY_WIDTH) / 2;
			rect.top  = (screen_full_height - MZ2000_DISPLAY_HEIGHT) / 2;
			rect.right  = rect.left + MZ2000_DISPLAY_WIDTH - 1;
			rect.bottom = rect.top + MZ2000_DISPLAY_HEIGHT - 1;
			rect2.left = 0;
			rect2.top  = 0;
			rect2.right  = rect.left + MZ2000_DISPLAY_WIDTH - 1;
			rect2.bottom = rect.top + MZ2000_DISPLAY_HEIGHT - 1;
		}
		while (1) {
			EraseSurface( lpDDSPrimary );
			//ddrval = lpDDSPrimary -> BltFast( 0, 0, lpDDSSurface1, &rect,
			//		DDBLTFAST_WAIT | DDBLTFAST_NOCOLORKEY );
			ddrval = lpDDSPrimary -> Blt( &rect, lpDDSSurface1, &rect2,
				DDBLT_WAIT, NULL );
			if (ddrval == DD_OK)
				break;
			if (ddrval == DDERR_SURFACELOST) {
				ddrval = lpDDSPrimary -> Restore();
				if (ddrval != DD_OK)
					break;
				ddrval = lpDDSSurface1 -> Restore();
			}
			if (ddrval != DDERR_WASSTILLDRAWING) {
				_TRACE("ddrval: %d\n", ddrval);
				break;
			}
		}
#else
		if (screen_stretch) {
			SetStretchBltMode( hdc, SCREEN_STRETCHBLT_MODE );
			StretchBlt( hdc, blackwidth_size, blackheight_size,
				screen_full_width  - blackwidth_size * 2,
				screen_full_height - blackheight_size * 2,
				mz -> Buffer, 0, 0, MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT, SRCCOPY );
		} else {
			BitBlt( hdc,
				(screen_full_width  - MZ2000_DISPLAY_WIDTH) / 2,
				(screen_full_height - MZ2000_DISPLAY_HEIGHT) / 2,
				MZ2000_DISPLAY_WIDTH, MZ2000_DISPLAY_HEIGHT,
				mz -> Buffer, 0, 0, SRCCOPY );
		}
		if (lpDDSPrimary -> IsLost())
			lpDDSPrimary -> Restore();
#endif
		mz->viewChg = FALSE;
	}
#ifndef ENABLE_DDRAWBLT
#if 1
	if (bFullScreenMenu) {
		if (blackheight_size
				- GetSystemMetrics(SM_CYMENU)
				- GetSystemMetrics(SM_CYFIXEDFRAME)
				- GetSystemMetrics(SM_CYEDGE) > 0) {
			PatBlt( hdc, 0, GetSystemMetrics(SM_CYMENU)
					+ GetSystemMetrics(SM_CYFIXEDFRAME)
					+ GetSystemMetrics(SM_CYEDGE),
				screen_full_width, blackheight_size
					- GetSystemMetrics(SM_CYMENU)
					- GetSystemMetrics(SM_CYFIXEDFRAME)
					- GetSystemMetrics(SM_CYEDGE),
					BLACKNESS );
			PatBlt( hdc, 0, screen_full_height - blackheight_size,
				screen_full_width, blackheight_size
					- GetSystemMetrics(SM_CYMENU)
					- GetSystemMetrics(SM_CYFIXEDFRAME)
					- GetSystemMetrics(SM_CYEDGE) * 2,
					BLACKNESS );
		}
	} else {
		PatBlt( hdc, 0, 0, screen_full_width, blackheight_size, BLACKNESS );
		PatBlt( hdc, 0, screen_full_height - blackheight_size,
				screen_full_width, blackheight_size, BLACKNESS );
	}
#endif
#endif
	_DDrawDrawStatusBar( hWnd, hdc );
	lpDDSPrimary -> ReleaseDC( hdc );
	return;
}

void DDrawUpdateScreen( HWND hWnd, MZ2000 *mz, BOOL force_flag )
{
	if (force_flag)
		_DDrawUpdateScreenAll( hWnd, mz );
	else
		_DDrawUpdateScreen( hWnd, mz );
	return;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
