/* File: util.h

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		Utilities Subroutines Headers

	Created by FUKUI, Toshio and TSUNEOKA, Shinji.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#ifndef __UTIL_H__
#define __UTIL_H__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/stat.h>

#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <fnmatch.h>
#endif

#define MAX_LINEBUFF		1024

#ifdef WIN32
#define CRLF_CODE			"\r\n"
#else
#define TRUE				1
#define FALSE				0
#define MAX_PATH			PATH_MAX
#define CRLF_CODE			"\n"
#endif

#ifdef __cplusplus	/* for C++ */
extern "C" {
#endif
	int          StrICmp(const char*, const char*);
	char         *StrIStr(const char*, const char *);

	int          CreateSnapshot(const char*, void**, unsigned int*);
	int          EnumUserProfileSection(char*,unsigned int, int*, const char*);
	unsigned int GetUserProfileString(const char*, const char*,
	                     const char *, char*, unsigned int, const char*);
	int          WriteUserProfileString(const char*,
	                     const char*, const char*, const char*);
#ifdef WIN32
	LRESULT SetRegistory(HKEY, const char*, const char*, const char*);
#else
	unsigned int GetTempFileName(const char*,const char*, unsigned int, char*);
#endif
#ifdef __cplusplus	/* for C++ */
}
#endif

#endif	/* __UTIL_H__ */

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
