/* File: versionDlg.c

	SHARP MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		About Dialog

	Modified EmuZ-2000 versionDlg.c by FUKUI, Toshio.
	This file is part of the EmuZ-2000 software.
	See copyright notice in the COPYING file.
*/

#include "config.h"

#include <windows.h>
#include <string.h>

#include "common.h"
#include "mz2000.h"
#include "versionDlg.h"
#include "resource.h"

#define	VERSION_INFO	"ver." EMZ2000_VERSION

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* get the target center positions */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* move to center positions */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* update the real window positions */
	SetWindowPos( hDlg, NULL, rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

BOOL WINAPI DlgProcVersion( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch (msg) {
	case WM_INITDIALOG :
		/* set the window attributes */
		DlgCenterWindow( hDlg, NULL );
		/* set the parameters */
		SendDlgItemMessage( hDlg, IDC_VERSION_INFO, WM_SETTEXT,
			0, (LPARAM)VERSION_INFO );
		return TRUE;
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
			EndDialog( hDlg, TRUE );
			return TRUE;
		case IDCANCEL :
			EndDialog( hDlg, FALSE );
			return TRUE;
		}
		break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
