#include <stdio.h>
#include "z80.h"
#include "z80operand.h"


int wr;

int exec_xx00()
{
	NOP();
	return 4;
}
int exec_xx01()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(BC,f2);
	return 10;
}
int exec_xx02()
{
	LD_RM_R8(BC,A);
	return 7;
}
int exec_xx03()
{
	INC_R16(BC);
	return 6;
}
int exec_xx04()
{
	INC_R8(B);
	return 4;
}
int exec_xx05()
{
	DEC_R8(B);
	return 4;
}
int exec_xx06()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(B,f2);
	return 7;
}
int exec_xx07()
{
	RLCA();
	return 4;
}
int exec_xx08()
{
	EX_R16_R16(AF,AF2);
	return 4;
}
int exec_xx09()
{
	ADD_R16_R16(HL,BC);
	return 11;
}
int exec_xx0a()
{
	LD_R8_RM(A,BC);
	return 0;
}
int exec_xx0b()
{
	DEC_R16(BC);
	return 6;
}
int exec_xx0c()
{
	INC_R8(C);
	return 4;
}
int exec_xx0d()
{
	DEC_R8(C);
	return 4;
}
int exec_xx0e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(C,f2);
	return 7;
}
int exec_xx0f()
{
	RRCA();
	return 4;
}
int exec_xx10()
{
	int f1;
	fetchPC(f1);
	DJNZ_N(f1);
	return (readReg(B)!=0)? 13 : 8;
}
int exec_xx11()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(DE,f2);
	return 10;
}
int exec_xx12()
{
	LD_RM_R8(DE,A);
	return 7;
}
int exec_xx13()
{
	INC_R16(DE);
	return 6;
}
int exec_xx14()
{
	INC_R8(D);
	return 4;
}
int exec_xx15()
{
	DEC_R8(D);
	return 4;
}
int exec_xx16()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(D,f2);
	return 7;
}
int exec_xx17()
{
	RLA();
	return 4;
}
int exec_xx18()
{
	int f1;
	fetchPC(f1);
	JR_N(f1);
	return 12;
}
int exec_xx19()
{
	ADD_R16_R16(HL,DE);
	return 11;
}
int exec_xx1a()
{
	LD_R8_RM(A,DE);
	return 0;
}
int exec_xx1b()
{
	DEC_R16(DE);
	return 6;
}
int exec_xx1c()
{
	INC_R8(E);
	return 4;
}
int exec_xx1d()
{
	DEC_R8(E);
	return 4;
}
int exec_xx1e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(E,f2);
	return 7;
}
int exec_xx1f()
{
	RRA();
	return 4;
}
int exec_xx20()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(NZ,f2);
	return (!bitFlg(Z))? 12 : 7;
}
int exec_xx21()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(HL,f2);
	return 10;
}
int exec_xx22()
{
	int f1;
	fetch2PC(f1);
	LD_M_R16(f1,HL);
	return 16;
}
int exec_xx23()
{
	INC_R16(HL);
	return 6;
}
int exec_xx24()
{
	INC_R8(H);
	return 4;
}
int exec_xx25()
{
	DEC_R8(H);
	return 4;
}
int exec_xx26()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(H,f2);
	return 7;
}
int exec_xx27()
{
	DAA();
	return 4;
}
int exec_xx28()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(Z,f2);
	return (bitFlg(Z))? 12 : 7;
}
int exec_xx29()
{
	ADD_R16_R16(HL,HL);
	return 11;
}
int exec_xx2a()
{
	int f2;
	fetch2PC(f2);
	LD_R16_M(HL,f2);
	return 16;
}
int exec_xx2b()
{
	DEC_R16(HL);
	return 6;
}
int exec_xx2c()
{
	INC_R8(L);
	return 4;
}
int exec_xx2d()
{
	DEC_R8(L);
	return 4;
}
int exec_xx2e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(L,f2);
	return 7;
}
int exec_xx2f()
{
	CPL();
	return 4;
}
int exec_xx30()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(NC,f2);
	return (!bitFlg(C))? 12 : 7;
}
int exec_xx31()
{
	int f2;
	fetch2PC(f2);
	LD_R16_N(SP,f2);
	return 10;
}
int exec_xx32()
{
	int f1;
	fetch2PC(f1);
	LD_M_R8(f1,A);
	return 13;
}
int exec_xx33()
{
	INC_R16(SP);
	return 6;
}
int exec_xx34()
{
	INC_RM(HL);
	return 11;
}
int exec_xx35()
{
	DEC_RM(HL);
	return 11;
}
int exec_xx36()
{
	int f2;
	fetchPC(f2);
	LD_RM_N(HL,f2);
	return 10;
}
int exec_xx37()
{
	SCF();
	return 4;
}
int exec_xx38()
{
	int f2;
	fetchPC(f2);
	JR_FLG_N(C,f2);
	return (bitFlg(C))? 12 : 7;
}
int exec_xx39()
{
	ADD_R16_R16(HL,SP);
	return 11;
}
int exec_xx3a()
{
	int f2;
	fetch2PC(f2);
	LD_R8_M(A,f2);
	return 13;
}
int exec_xx3b()
{
	DEC_R16(SP);
	return 6;
}
int exec_xx3c()
{
	INC_R8(A);
	return 4;
}
int exec_xx3d()
{
	DEC_R8(A);
	return 4;
}
int exec_xx3e()
{
	int f2;
	fetchPC(f2);
	LD_R8_N(A,f2);
	return 7;
}
int exec_xx3f()
{
	CCF();
	return 4;
}
int exec_xx40()
{
	LD_R8_R8(B,B);
	return 4;
}
int exec_xx41()
{
	LD_R8_R8(B,C);
	return 4;
}
int exec_xx42()
{
	LD_R8_R8(B,D);
	return 4;
}
int exec_xx43()
{
	LD_R8_R8(B,E);
	return 4;
}
int exec_xx44()
{
	LD_R8_R8(B,H);
	return 4;
}
int exec_xx45()
{
	LD_R8_R8(B,L);
	return 4;
}
int exec_xx46()
{
	LD_R8_RM(B,HL);
	return 7;
}
int exec_xx47()
{
	LD_R8_R8(B,A);
	return 4;
}
int exec_xx48()
{
	LD_R8_R8(C,B);
	return 4;
}
int exec_xx49()
{
	LD_R8_R8(C,C);
	return 4;
}
int exec_xx4a()
{
	LD_R8_R8(C,D);
	return 4;
}
int exec_xx4b()
{
	LD_R8_R8(C,E);
	return 4;
}
int exec_xx4c()
{
	LD_R8_R8(C,H);
	return 4;
}
int exec_xx4d()
{
	LD_R8_R8(C,L);
	return 4;
}
int exec_xx4e()
{
	LD_R8_RM(C,HL);
	return 7;
}
int exec_xx4f()
{
	LD_R8_R8(C,A);
	return 4;
}
int exec_xx50()
{
	LD_R8_R8(D,B);
	return 4;
}
int exec_xx51()
{
	LD_R8_R8(D,C);
	return 4;
}
int exec_xx52()
{
	LD_R8_R8(D,D);
	return 4;
}
int exec_xx53()
{
	LD_R8_R8(D,E);
	return 4;
}
int exec_xx54()
{
	LD_R8_R8(D,H);
	return 4;
}
int exec_xx55()
{
	LD_R8_R8(D,L);
	return 4;
}
int exec_xx56()
{
	LD_R8_RM(D,HL);
	return 7;
}
int exec_xx57()
{
	LD_R8_R8(D,A);
	return 4;
}
int exec_xx58()
{
	LD_R8_R8(E,B);
	return 4;
}
int exec_xx59()
{
	LD_R8_R8(E,C);
	return 4;
}
int exec_xx5a()
{
	LD_R8_R8(E,D);
	return 4;
}
int exec_xx5b()
{
	LD_R8_R8(E,E);
	return 4;
}
int exec_xx5c()
{
	LD_R8_R8(E,H);
	return 4;
}
int exec_xx5d()
{
	LD_R8_R8(E,L);
	return 4;
}
int exec_xx5e()
{
	LD_R8_RM(E,HL);
	return 7;
}
int exec_xx5f()
{
	LD_R8_R8(E,A);
	return 4;
}
int exec_xx60()
{
	LD_R8_R8(H,B);
	return 4;
}
int exec_xx61()
{
	LD_R8_R8(H,C);
	return 4;
}
int exec_xx62()
{
	LD_R8_R8(H,D);
	return 4;
}
int exec_xx63()
{
	LD_R8_R8(H,E);
	return 4;
}
int exec_xx64()
{
	LD_R8_R8(H,H);
	return 4;
}
int exec_xx65()
{
	LD_R8_R8(H,L);
	return 4;
}
int exec_xx66()
{
	LD_R8_RM(H,HL);
	return 7;
}
int exec_xx67()
{
	LD_R8_R8(H,A);
	return 4;
}
int exec_xx68()
{
	LD_R8_R8(L,B);
	return 4;
}
int exec_xx69()
{
	LD_R8_R8(L,C);
	return 4;
}
int exec_xx6a()
{
	LD_R8_R8(L,D);
	return 4;
}
int exec_xx6b()
{
	LD_R8_R8(L,E);
	return 4;
}
int exec_xx6c()
{
	LD_R8_R8(L,H);
	return 4;
}
int exec_xx6d()
{
	LD_R8_R8(L,L);
	return 4;
}
int exec_xx6e()
{
	LD_R8_RM(L,HL);
	return 7;
}
int exec_xx6f()
{
	LD_R8_R8(L,A);
	return 4;
}
int exec_xx70()
{
	LD_RM_R8(HL,B);
	return 7;
}
int exec_xx71()
{
	LD_RM_R8(HL,C);
	return 7;
}
int exec_xx72()
{
	LD_RM_R8(HL,D);
	return 7;
}
int exec_xx73()
{
	LD_RM_R8(HL,E);
	return 7;
}
int exec_xx74()
{
	LD_RM_R8(HL,H);
	return 7;
}
int exec_xx75()
{
	LD_RM_R8(HL,L);
	return 7;
}
int exec_xx76()
{
	HALT();
	return 4;
}
int exec_xx77()
{
	LD_RM_R8(HL,A);
	return 7;
}
int exec_xx78()
{
	LD_R8_R8(A,B);
	return 4;
}
int exec_xx79()
{
	LD_R8_R8(A,C);
	return 4;
}
int exec_xx7a()
{
	LD_R8_R8(A,D);
	return 4;
}
int exec_xx7b()
{
	LD_R8_R8(A,E);
	return 4;
}
int exec_xx7c()
{
	LD_R8_R8(A,H);
	return 4;
}
int exec_xx7d()
{
	LD_R8_R8(A,L);
	return 4;
}
int exec_xx7e()
{
	LD_R8_RM(A,HL);
	return 7;
}
int exec_xx7f()
{
	LD_R8_R8(A,A);
	return 4;
}
int exec_xx80()
{
	ADD_R8_R8(A,B);
	return 4;
}
int exec_xx81()
{
	ADD_R8_R8(A,C);
	return 4;
}
int exec_xx82()
{
	ADD_R8_R8(A,D);
	return 4;
}
int exec_xx83()
{
	ADD_R8_R8(A,E);
	return 4;
}
int exec_xx84()
{
	ADD_R8_R8(A,H);
	return 4;
}
int exec_xx85()
{
	ADD_R8_R8(A,L);
	return 4;
}
int exec_xx86()
{
	ADD_R8_RM(A,HL);
	return 7;
}
int exec_xx87()
{
	ADD_R8_R8(A,A);
	return 4;
}
int exec_xx88()
{
	ADC_R8_R8(A,B);
	return 4;
}
int exec_xx89()
{
	ADC_R8_R8(A,C);
	return 4;
}
int exec_xx8a()
{
	ADC_R8_R8(A,D);
	return 4;
}
int exec_xx8b()
{
	ADC_R8_R8(A,E);
	return 4;
}
int exec_xx8c()
{
	ADC_R8_R8(A,H);
	return 4;
}
int exec_xx8d()
{
	ADC_R8_R8(A,L);
	return 4;
}
int exec_xx8e()
{
	ADC_R8_RM(A,HL);
	return 7;
}
int exec_xx8f()
{
	ADC_R8_R8(A,A);
	return 4;
}
int exec_xx90()
{
	SUB_R8(B);
	return 4;
}
int exec_xx91()
{
	SUB_R8(C);
	return 4;
}
int exec_xx92()
{
	SUB_R8(D);
	return 4;
}
int exec_xx93()
{
	SUB_R8(E);
	return 4;
}
int exec_xx94()
{
	SUB_R8(H);
	return 4;
}
int exec_xx95()
{
	SUB_R8(L);
	return 4;
}
int exec_xx96()
{
	SUB_RM(HL);
	return 7;
}
int exec_xx97()
{
	SUB_R8(A);
	return 4;
}
int exec_xx98()
{
	SBC_R8_R8(A,B);
	return 4;
}
int exec_xx99()
{
	SBC_R8_R8(A,C);
	return 4;
}
int exec_xx9a()
{
	SBC_R8_R8(A,D);
	return 4;
}
int exec_xx9b()
{
	SBC_R8_R8(A,E);
	return 4;
}
int exec_xx9c()
{
	SBC_R8_R8(A,H);
	return 4;
}
int exec_xx9d()
{
	SBC_R8_R8(A,L);
	return 4;
}
int exec_xx9e()
{
	SBC_R8_RM(A,HL);
	return 7;
}
int exec_xx9f()
{
	SBC_R8_R8(A,A);
	return 4;
}
int exec_xxa0()
{
	AND_R8(B);
	return 4;
}
int exec_xxa1()
{
	AND_R8(C);
	return 4;
}
int exec_xxa2()
{
	AND_R8(D);
	return 4;
}
int exec_xxa3()
{
	AND_R8(E);
	return 4;
}
int exec_xxa4()
{
	AND_R8(H);
	return 4;
}
int exec_xxa5()
{
	AND_R8(L);
	return 4;
}
int exec_xxa6()
{
	AND_RM(HL);
	return 7;
}
int exec_xxa7()
{
	AND_R8(A);
	return 4;
}
int exec_xxa8()
{
	XOR_R8(B);
	return 4;
}
int exec_xxa9()
{
	XOR_R8(C);
	return 4;
}
int exec_xxaa()
{
	XOR_R8(D);
	return 4;
}
int exec_xxab()
{
	XOR_R8(E);
	return 4;
}
int exec_xxac()
{
	XOR_R8(H);
	return 4;
}
int exec_xxad()
{
	XOR_R8(L);
	return 4;
}
int exec_xxae()
{
	XOR_RM(HL);
	return 7;
}
int exec_xxaf()
{
	XOR_R8(A);
	return 4;
}
int exec_xxb0()
{
	OR_R8(B);
	return 4;
}
int exec_xxb1()
{
	OR_R8(C);
	return 4;
}
int exec_xxb2()
{
	OR_R8(D);
	return 4;
}
int exec_xxb3()
{
	OR_R8(E);
	return 4;
}
int exec_xxb4()
{
	OR_R8(H);
	return 4;
}
int exec_xxb5()
{
	OR_R8(L);
	return 4;
}
int exec_xxb6()
{
	OR_RM(HL);
	return 7;
}
int exec_xxb7()
{
	OR_R8(A);
	return 4;
}
int exec_xxb8()
{
	CP_R8(B);
	return 4;
}
int exec_xxb9()
{
	CP_R8(C);
	return 4;
}
int exec_xxba()
{
	CP_R8(D);
	return 4;
}
int exec_xxbb()
{
	CP_R8(E);
	return 4;
}
int exec_xxbc()
{
	CP_R8(H);
	return 4;
}
int exec_xxbd()
{
	CP_R8(L);
	return 4;
}
int exec_xxbe()
{
	CP_RM(HL);
	return 7;
}
int exec_xxbf()
{
	CP_R8(A);
	return 4;
}
int exec_xxc0()
{
	RET_FLG(NZ);
	return (!bitFlg(Z))? 11 : 5;
}
int exec_xxc1()
{
	POP_R16(BC);
	return 10;
}
int exec_xxc2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(NZ,f2);
	return 10;
}
int exec_xxc3()
{
	int f1;
	fetch2PC(f1);
	JP_N(f1);
	return 10;
}
int exec_xxc4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(NZ,f2);
	return (!bitFlg(Z))? 17 : 10;
}
int exec_xxc5()
{
	PUSH_R16(BC);
	return 10;
}
int exec_xxc6()
{
	int f2;
	fetchPC(f2);
	ADD_R8_N(A,f2);
	return 7;
}
int exec_xxc7()
{
	RST_N(0);
	return 11;
}
int exec_xxc8()
{
	RET_FLG(Z);
	return (bitFlg(Z))? 11 : 5;
}
int exec_xxc9()
{
	RET();
	return 10;
}
int exec_xxca()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(Z,f2);
	return 10;
}
int exec_xxcb()
{
	return exec_instruction(GROUP_CB);
}
int exec_xxcc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(Z,f2);
	return (bitFlg(Z))? 17 : 10;
}
int exec_xxcd()
{
	int f1;
	fetch2PC(f1);
	CALL_N(f1);
	return 17;
}
int exec_xxce()
{
	int f2;
	fetchPC(f2);
	ADC_R8_N(A,f2);
	return 7;
}
int exec_xxcf()
{
	RST_N(8);
	return 11;
}
int exec_xxd0()
{
	RET_FLG(NC);
	return (!bitFlg(C))? 11 : 5;
}
int exec_xxd1()
{
	POP_R16(DE);
	return 10;
}
int exec_xxd2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(NC,f2);
	return 10;
}
int exec_xxd3()
{
	int f1;
	fetchPC(f1);
	OUT_M_R8(f1,A);
	return 11;
}
int exec_xxd4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(NC,f2);
	return (!bitFlg(C))? 17 : 10;
}
int exec_xxd5()
{
	PUSH_R16(DE);
	return 10;
}
int exec_xxd6()
{
	int f1;
	fetchPC(f1);
	SUB_N(f1);
	return 7;
}
int exec_xxd7()
{
	RST_N(16);
	return 11;
}
int exec_xxd8()
{
	RET_FLG(C);
	return (bitFlg(C))? 11 : 5;
}
int exec_xxd9()
{
	EXX();
	return 4;
}
int exec_xxda()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(C,f2);
	return 10;
}
int exec_xxdb()
{
	int f2;
	fetchPC(f2);
	IN_R8_M(A,f2);
	return 11;
}
int exec_xxdc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(C,f2);
	return (bitFlg(C))? 17 : 10;
}
int exec_xxdd()
{
	return exec_instruction(GROUP_DD)+4;
}
int exec_xxde()
{
	int f2;
	fetchPC(f2);
	SBC_R8_N(A,f2);
	return 7;
}
int exec_xxdf()
{
	RST_N(24);
	return 11;
}
int exec_xxe0()
{
	RET_FLG(PO);
	return (!bitFlg(PV))? 11 : 5;
}
int exec_xxe1()
{
	POP_R16(HL);
	return 10;
}
int exec_xxe2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(PO,f2);
	return 10;
}
int exec_xxe3()
{
	EX_RM_R16(SP,HL);
	return 19;
}
int exec_xxe4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(PO,f2);
	return (!bitFlg(PV))? 17 : 10;
}
int exec_xxe5()
{
	PUSH_R16(HL);
	return 10;
}
int exec_xxe6()
{
	int f1;
	fetchPC(f1);
	AND_N(f1);
	return 7;
}
int exec_xxe7()
{
	RST_N(32);
	return 11;
}
int exec_xxe8()
{
	RET_FLG(PE);
	return (bitFlg(PV))? 11 : 5;
}
int exec_xxe9()
{
	JP_R16(HL);
	return 4;
}
int exec_xxea()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(PE,f2);
	return 10;
}
int exec_xxeb()
{
	EX_R16_R16(DE,HL);
	return 4;
}
int exec_xxec()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(PE,f2);
	return (bitFlg(PV))? 17 : 10;
}
int exec_xxed()
{
	return exec_instruction(GROUP_ED);
}
int exec_xxee()
{
	int f1;
	fetchPC(f1);
	XOR_N(f1);
	return 7;
}
int exec_xxef()
{
	RST_N(40);
	return 11;
}
int exec_xxf0()
{
	RET_FLG(P);
	return (!bitFlg(S))? 11 : 5;
}
int exec_xxf1()
{
	POP_R16(AF);
	return 10;
}
int exec_xxf2()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(P,f2);
	return 10;
}
int exec_xxf3()
{
	DI();
	return 4;
}
int exec_xxf4()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(P,f2);
	return (!bitFlg(S))? 17 : 10;
}
int exec_xxf5()
{
	PUSH_R16(AF);
	return 10;
}
int exec_xxf6()
{
	int f1;
	fetchPC(f1);
	OR_N(f1);
	return 7;
}
int exec_xxf7()
{
	RST_N(48);
	return 11;
}
int exec_xxf8()
{
	RET_FLG(M);
	return (bitFlg(S))? 11 : 5;
}
int exec_xxf9()
{
	LD_R16_R16(SP,HL);
	return 6;
}
int exec_xxfa()
{
	int f2;
	fetch2PC(f2);
	JP_FLG_N(M,f2);
	return 10;
}
int exec_xxfb()
{
	EI();
	return 4;
}
int exec_xxfc()
{
	int f2;
	fetch2PC(f2);
	CALL_FLG_N(M,f2);
	return (bitFlg(S))? 17 : 10;
}
int exec_xxfd()
{
	return exec_instruction(GROUP_FD)+4;
}
int exec_xxfe()
{
	int f1;
	fetchPC(f1);
	CP_N(f1);
	return 7;
}
int exec_xxff()
{
	RST_N(56);
	return 11;
}

int (*(instr_xx[]))() = {
	exec_xx00,
	exec_xx01,
	exec_xx02,
	exec_xx03,
	exec_xx04,
	exec_xx05,
	exec_xx06,
	exec_xx07,
	exec_xx08,
	exec_xx09,
	exec_xx0a,
	exec_xx0b,
	exec_xx0c,
	exec_xx0d,
	exec_xx0e,
	exec_xx0f,
	exec_xx10,
	exec_xx11,
	exec_xx12,
	exec_xx13,
	exec_xx14,
	exec_xx15,
	exec_xx16,
	exec_xx17,
	exec_xx18,
	exec_xx19,
	exec_xx1a,
	exec_xx1b,
	exec_xx1c,
	exec_xx1d,
	exec_xx1e,
	exec_xx1f,
	exec_xx20,
	exec_xx21,
	exec_xx22,
	exec_xx23,
	exec_xx24,
	exec_xx25,
	exec_xx26,
	exec_xx27,
	exec_xx28,
	exec_xx29,
	exec_xx2a,
	exec_xx2b,
	exec_xx2c,
	exec_xx2d,
	exec_xx2e,
	exec_xx2f,
	exec_xx30,
	exec_xx31,
	exec_xx32,
	exec_xx33,
	exec_xx34,
	exec_xx35,
	exec_xx36,
	exec_xx37,
	exec_xx38,
	exec_xx39,
	exec_xx3a,
	exec_xx3b,
	exec_xx3c,
	exec_xx3d,
	exec_xx3e,
	exec_xx3f,
	exec_xx40,
	exec_xx41,
	exec_xx42,
	exec_xx43,
	exec_xx44,
	exec_xx45,
	exec_xx46,
	exec_xx47,
	exec_xx48,
	exec_xx49,
	exec_xx4a,
	exec_xx4b,
	exec_xx4c,
	exec_xx4d,
	exec_xx4e,
	exec_xx4f,
	exec_xx50,
	exec_xx51,
	exec_xx52,
	exec_xx53,
	exec_xx54,
	exec_xx55,
	exec_xx56,
	exec_xx57,
	exec_xx58,
	exec_xx59,
	exec_xx5a,
	exec_xx5b,
	exec_xx5c,
	exec_xx5d,
	exec_xx5e,
	exec_xx5f,
	exec_xx60,
	exec_xx61,
	exec_xx62,
	exec_xx63,
	exec_xx64,
	exec_xx65,
	exec_xx66,
	exec_xx67,
	exec_xx68,
	exec_xx69,
	exec_xx6a,
	exec_xx6b,
	exec_xx6c,
	exec_xx6d,
	exec_xx6e,
	exec_xx6f,
	exec_xx70,
	exec_xx71,
	exec_xx72,
	exec_xx73,
	exec_xx74,
	exec_xx75,
	exec_xx76,
	exec_xx77,
	exec_xx78,
	exec_xx79,
	exec_xx7a,
	exec_xx7b,
	exec_xx7c,
	exec_xx7d,
	exec_xx7e,
	exec_xx7f,
	exec_xx80,
	exec_xx81,
	exec_xx82,
	exec_xx83,
	exec_xx84,
	exec_xx85,
	exec_xx86,
	exec_xx87,
	exec_xx88,
	exec_xx89,
	exec_xx8a,
	exec_xx8b,
	exec_xx8c,
	exec_xx8d,
	exec_xx8e,
	exec_xx8f,
	exec_xx90,
	exec_xx91,
	exec_xx92,
	exec_xx93,
	exec_xx94,
	exec_xx95,
	exec_xx96,
	exec_xx97,
	exec_xx98,
	exec_xx99,
	exec_xx9a,
	exec_xx9b,
	exec_xx9c,
	exec_xx9d,
	exec_xx9e,
	exec_xx9f,
	exec_xxa0,
	exec_xxa1,
	exec_xxa2,
	exec_xxa3,
	exec_xxa4,
	exec_xxa5,
	exec_xxa6,
	exec_xxa7,
	exec_xxa8,
	exec_xxa9,
	exec_xxaa,
	exec_xxab,
	exec_xxac,
	exec_xxad,
	exec_xxae,
	exec_xxaf,
	exec_xxb0,
	exec_xxb1,
	exec_xxb2,
	exec_xxb3,
	exec_xxb4,
	exec_xxb5,
	exec_xxb6,
	exec_xxb7,
	exec_xxb8,
	exec_xxb9,
	exec_xxba,
	exec_xxbb,
	exec_xxbc,
	exec_xxbd,
	exec_xxbe,
	exec_xxbf,
	exec_xxc0,
	exec_xxc1,
	exec_xxc2,
	exec_xxc3,
	exec_xxc4,
	exec_xxc5,
	exec_xxc6,
	exec_xxc7,
	exec_xxc8,
	exec_xxc9,
	exec_xxca,
	exec_xxcb,
	exec_xxcc,
	exec_xxcd,
	exec_xxce,
	exec_xxcf,
	exec_xxd0,
	exec_xxd1,
	exec_xxd2,
	exec_xxd3,
	exec_xxd4,
	exec_xxd5,
	exec_xxd6,
	exec_xxd7,
	exec_xxd8,
	exec_xxd9,
	exec_xxda,
	exec_xxdb,
	exec_xxdc,
	exec_xxdd,
	exec_xxde,
	exec_xxdf,
	exec_xxe0,
	exec_xxe1,
	exec_xxe2,
	exec_xxe3,
	exec_xxe4,
	exec_xxe5,
	exec_xxe6,
	exec_xxe7,
	exec_xxe8,
	exec_xxe9,
	exec_xxea,
	exec_xxeb,
	exec_xxec,
	exec_xxed,
	exec_xxee,
	exec_xxef,
	exec_xxf0,
	exec_xxf1,
	exec_xxf2,
	exec_xxf3,
	exec_xxf4,
	exec_xxf5,
	exec_xxf6,
	exec_xxf7,
	exec_xxf8,
	exec_xxf9,
	exec_xxfa,
	exec_xxfb,
	exec_xxfc,
	exec_xxfd,
	exec_xxfe,
	exec_xxff,
};
