/*********************************************************************************
*
*               SHARP MZ-80B/80B2/2000/2200 Emulator for Win32
*
*                        EmuZ-2000  Extend Board DLL
*
*                               << EmuZ-1M02 >>
*
*                          Main Module [emuz_1m02.c]
*
*               Programmed & Porting by 2003 EmuZ-2000 (M.Y) & TAGO
*		TF-Edition support by T.Fukui (2017)
*
*********************************************************************************/
//
//
#include <windows.h>
#include "resource.h"
#include "../interface/emuz2000ioBoard.h"
//Support Debugger
//#include "../interface/emuz2000debug.h"
#include "../interface/plugin_ex.h"
#include <mmsystem.h>
#include <stdio.h>
#include "emuz_1m02.h"
#include "midi.h"
#include "tonedef.h"
#include "debug.h"

// NCu̎w
#pragma comment( lib, "Winmm.lib" )

// vCx[g֐
void MidiInCallbackProc( DWORD msg );

////////////////////////////////////
// Prototype 
////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	) ;

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	) ;

////////////////////////////////////
// Global Variable 
////////////////////////////////////
HINSTANCE		h_instdll = NULL ;

EMUZ2000EBIH	emuz_1m02EBIH = {
	"31DD2499-F757-481B-9BCA-314D30322020",
	"EmuZ-1M02 EZ-MIDI",
	"EmuZ-1M02 Version " EmuZ1M02_VERSION,
	"Copyright 2003 by EmuZ-2000 & TAGO, 2017 by T.Fukui",
	"http://www.geocities.co.jp/SiliconValley-Sunnyvale/2521/",
	"mz-2500@erato.dricas.com",
	0x00000000,	//Reserved
	InportFunction,
	OutportFunction,
	0x80,
	0x07,
	USE_INFODIALOG
} ;

//  C     C+    D     D+    E     F     F+    G     G+    A     A+    B
BYTE NoteToTone[] = {
   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,	//   0
   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,	//  12
   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,	//  24
   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,	//  36
  O1C, O1CS,  O1D, O1DS,  O1E,  O1F, O1FS,  O1G, O1GS,  O1A, O1AS,  O1B,	//  48
  O2C, O2CS,  O2D, O2DS,  O2E,  O2F, O2FS,  O2G, O2GS,  O2A, O2AS,  O2B,	//  60
  O3C, O3CS,  O3D, O3DS,  O3E,  O3F, O3FS,  O3G, O3GS,  O3A, O3AS,  O3B,	//  72
  O4C, O4CS,  O4D, O4DS,  O4E,  O4F, O4FS,  O4G, O4GS,  O4A, O4AS,  O4B,	//  84
  O5C, O5CS,  O5D, O5DS,  O5E,  O5F, O5FS,  O5G, O5GS,  O5A, O5AS,  O5B,	//  96
   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR,	// 108
   NR,   NR,   NR,   NR,   NR,   NR,   NR,   NR								// 120
};

DWORD	gId = 0 ;
DWORD	dwBase = 0x80 ;
BYTE	byData[ 6 ];
BYTE	byDataFlag = 0;
int		nBias = 0;

////////////////////////////////////
// Extern
////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Logic Start
//
///////////////////////////////////////////////////////
// System interface
///////////////////////////////////////////////////////
BOOL WINAPI
DllMain(
	HINSTANCE	inst,
	DWORD		q_mode,
	LPVOID		vp_res_c )
{
	switch (q_mode) {
	case DLL_PROCESS_ATTACH :
		h_instdll = inst;
		break;
	case DLL_THREAD_ATTACH :
		break;
	case DLL_THREAD_DETACH :
		break;
	case DLL_PROCESS_DETACH :
		h_instdll = NULL;
		break;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
// window Proc.
BOOL
WINAPI
InfomationDlgProc(
	HWND hDlg,
	UINT msg,
	WPARAM wPrm,
	LPARAM lPrm
	)
{
	switch( msg ){
		case	WM_INITDIALOG:
			SetDlgItemInt( hDlg, IDC_BIAS, nBias, TRUE ) ;
			return	TRUE ;

		case	WM_COMMAND:
			switch( wPrm ){
				case	IDOK:
					nBias = GetDlgItemInt( hDlg, IDC_BIAS, NULL, TRUE ) ;
					EndDialog( hDlg, TRUE ) ;
					return	TRUE ;

				case	IDCANCEL:
					EndDialog( hDlg, FALSE ) ;
					return	TRUE ;

			}
			break ;
	}
	return	FALSE ;
}

/////////////////////////////////////////////////////////////////////
// I/O Function Interface
/////////////////////////////////////////////////////////////////////
UCHAR
InportFunction(
	USHORT	port
	)
{
	UCHAR	data = 0 ;

	switch( port )
	{
	case	0x80:
		data = byDataFlag ;
		break ;
	case	0x81:
		data = byData[ 0 ] ;
		break ;
	case	0x82:
		data = byData[ 1 ] ;
		break ;
	case	0x83:
		data = byData[ 2 ] ;
		break ;
	case	0x84:
		data = byData[ 3 ] ;
		break ;
	case	0x85:
		data = byData[ 4 ] ;
		break ;
	case	0x86:
		data = byData[ 5 ] ;
		break ;
	}

/*
	// fobO
	if ( port != 0x80 ) {
		DEBUGOUT( "In  : Port = " ) ;
		DEBUGOUTVALUEHEX2( port ) ;
		DEBUGOUT( " Data = " ) ;
		DEBUGOUTVALUEHEX2( data ) ;
		DEBUGOUT( "\n" ) ;
	}
//*/

	return	data ;
}

int
OutportFunction(
	USHORT	port,
	UCHAR	data
	)
{
/*
	// fobO
	DEBUGOUT( "Out : Port = " ) ;
	DEBUGOUTVALUEHEX2( port ) ;
	DEBUGOUT( " Data = " ) ;
	DEBUGOUTVALUEHEX2( data ) ;
	DEBUGOUT( "\n" ) ;
//*/
	switch( port )
	{
	case	0x80:
		byDataFlag &= ~data ;
	}

	return	0 ;
}

/////////////////////////////////////////////////////////////////////
// EmuZ-2000 Interface
/////////////////////////////////////////////////////////////////////
BOOL
WINAPI
IntializeBoard( 
	VOID
	)
{
	// |[gԍݒ
	dwBase = emuz2000_readProfileDword( gId, "BaseAddress" ) ;
	switch( dwBase )
	{
	case	0x80:
		break ;
	default:
		dwBase = 0x80 ;
		break ;
	}
	// I/O |[gAhX擾
	emuz_1m02EBIH.ioMapper.ucStartPort = (UCHAR)dwBase ;
	// MIDI IN 
	MidiInOpen( 0, (DWORD)MidiInCallbackProc ) ;
	MidiInStart() ;
	// ϐ
	byData[ 0 ] = NR ;
	byData[ 1 ] = NR ;
	byData[ 2 ] = NR ;
	byData[ 3 ] = 0 ;
	byData[ 4 ] = 0 ;
	byData[ 5 ] = 0 ;

//	DEBUGOUT( "EmuZ-1M02 EmuZ-MIDI SYSTEM START.\n" ) ;

	return	TRUE ;
}

BOOL
WINAPI
ReIntializeBoard( 
	VOID
	)
{
	return	TRUE ;
}


VOID
WINAPI
FinalizeBoard( 
	VOID 
	)
{
	emuz2000_writeProfileDword( gId, "BaseAddress", dwBase ) ;
	// MIDI IN J
	MidiInClose();
	return ;
}

VOID
WINAPI
ReportCpuClock( 
	int clk
	)
{
	return ;
}

VOID
WINAPI
InfomationDialog( 
	HWND	hWnd 
	)
{
	DialogBox( h_instdll, MAKEINTATOM(IDD_DIALOG_BASEADDRESS), 
		hWnd, InfomationDlgProc) ;

	return ;
}

BOOL
WINAPI
BoardInfomationService( 
	PEMUZ2000EBIH *info,
	DWORD id
	)
{

	*info = &emuz_1m02EBIH ;
	gId = id ;
	return	TRUE ;
}

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveOutputDataEx( int *ver, LPDWORD lpdwSize, LPBYTE *lpbBuff )
{
	*lpdwSize = 0;
	*lpbBuff = NULL;
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveOutputData( 
	DWORD *size,
	PUCHAR buf
	)
{
	*size = 0 ;
	buf = NULL ;
	return	TRUE ;
}
#endif

#ifdef EMUZ2000EX
BOOL WINAPI StateSaveInputDataEx( int ver, DWORD dwSize, PBYTE lpbBuff )
{
	return TRUE;
}
#else
BOOL
WINAPI
StateSaveInputData( 
	DWORD size,
	PUCHAR buf
	)
{
	return	TRUE ;
}
#endif

void MidiInCallbackProc( DWORD msg )
{
	BYTE	status ;
	BYTE	data1 ;
	BYTE	data2 ;
	BYTE	ch ;
	status = LOBYTE( LOWORD( msg ) ) ;
	data1 = HIBYTE( LOWORD( msg ) ) ;
	data2 = LOBYTE( HIWORD( msg ) ) ;
	ch = status & 0xF ;
	switch ( status & 0xF0 ) {
		case 0x80:
			if ( ch < 3 ) {
				byData[ ch ] = NR ;
				if ( ( NR == byData[ 0 ] ) && ( NR == byData[ 1 ] ) && ( NR == byData[ 2 ] ) ) {
					byDataFlag |= 2 ;
				} else {
					byDataFlag |= 1 ;
				}
/*
{
	// fobO
	char strin1[ 100 ];
	sprintf( strin1, "Midi in : %02X %02X %02X\n", status, data1, data2 );
	DEBUGOUT( strin1 );
}//*/
			}
			break;
		case 0x90:
			if ( ch < 3 ) {
				if ( data2 ) {
					byData[ ch ] = NoteToTone[ data1 + nBias ];
					byDataFlag = 1 ;
				} else {
					byData[ ch ] = NR ;
					if ( ( NR == byData[ 0 ] ) && ( NR == byData[ 1 ] ) && ( NR == byData[ 2 ] ) ) {
						byDataFlag |= 2 ;
					} else {
						byDataFlag |= 1 ;
					}
				}
/*
{
	// fobO
	char strin2[ 100 ];
	sprintf( strin2, "Midi in : %02X %02X %02X\n", status, data1, data2 );
	DEBUGOUT( strin2 );
}
//*/
			}
			break;
		case 0xB0:	// I[m[gIt 0xB0, 0x7B
			if ( ( 0x7B == data1 ) && ( ch < 3 ) ) {
				byData[ ch ] = NR ;
				if ( ( NR == byData[ 0 ] ) && ( NR == byData[ 1 ] ) && ( NR == byData[ 2 ] ) ) {
					byDataFlag |= 2 ;
				} else {
					byDataFlag |= 1 ;
				}
			}
			break;
		case 0xC0:
			if ( ch < 3 ) {
				byData[ 3 + ch ] = data1 & 1;
				byDataFlag |= 4 ;
/*
{
	// fobO
	char strin3[ 100 ];
	sprintf( strin3, "Midi in : %02X %02X %02X\n", status, data1, data2 );
	DEBUGOUT( strin3 );
}
//*/
			}
			break;
	}
}
