//============================================================================
//  midi.cpp ver.1.00 uMIDI (ŏo[W)v
//----------------------------------------------------------------------------
//													Programmed by 
//============================================================================
#include <windows.h>
#include <mmsystem.h>
#include "midi.h"

// X^eBbNϐ
// MIDI OUT
static UINT uMidiOutDeviceId = -1;
static HMIDIOUT MIDIOutHandle = 0;
// MIDI IN
static UINT uMidiInDeviceId = -1;
static HMIDIIN MIDIInHandle = 0;
static DWORD MidiInProcAddress;
void ( *MidiInCallback )( DWORD msg );
static MIDIHDR MidiHdr;
// vCx[g֐`
void CALLBACK MidiInProc( HMIDIIN midiinhandle, UINT msg, DWORD instance, DWORD param1, DWORD param2 );

//============================================================================
//  MIDI OUT foCXI[v
//----------------------------------------------------------------------------
//In  : index = MIDI OUT foCX̔ԍ (0`)
//    : devicename = foCX̖O
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOutList( int index, char *devicename )
{
	int devicecount;
	MIDIOUTCAPS caps;
	devicecount = midiOutGetNumDevs();
	if ( index >= devicecount ) {
		return FALSE;
	}
	midiOutGetDevCaps( index, (LPMIDIOUTCAPS)&caps, sizeof( caps ) );
	return TRUE;
}

//============================================================================
//  MIDI foCXI[v
//----------------------------------------------------------------------------
//In  : deviceid = MIDI ̃foCX ID (MIDI_MAPPER)
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOpen( UINT deviceid )
{
	BOOL bRetCode = FALSE;
	MMRESULT mmResult;
	if ( uMidiOutDeviceId == deviceid ) {
		// łɃfoCX̓I[vĂ
		return TRUE;
	} else if ( uMidiOutDeviceId != -1 ) {
		MidiClose();
	}
	uMidiOutDeviceId = deviceid;
	mmResult = midiOutOpen( &MIDIOutHandle, uMidiOutDeviceId, 0, 0, CALLBACK_NULL );
	if ( MMSYSERR_NOERROR == mmResult ) {
		bRetCode = TRUE;
	}
	return bRetCode;
}

//============================================================================
//  MIDI foCXN[Y
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiClose( void )
{
	BOOL bRetCode = FALSE;
	if ( MIDIOutHandle != 0 ) {
		midiOutReset( MIDIOutHandle );
		midiOutClose( MIDIOutHandle );
		MIDIOutHandle = 0;
		bRetCode = TRUE;
	}
	return bRetCode;
}

//============================================================================
//  MIDI R}hM
//----------------------------------------------------------------------------
//In  : byData1 = 1 oCg
//    : byData2 = 2 oCg
//    : byData3 = 3 oCg
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOut( BYTE byData1, BYTE byData2, BYTE byData3 )
{
	BOOL bRetCode = FALSE;
	if ( MIDIOutHandle != 0 ) {
		typedef union {
			DWORD dwData;
			BYTE byData[4];
		} DATA;
		DATA Data;
		Data.byData[0] = byData1;
		Data.byData[1] = byData2;
		Data.byData[2] = byData3;
		Data.byData[3] = 0;
		if ( midiOutShortMsg( MIDIOutHandle, Data.dwData ) == MMSYSERR_NOERROR ) {
			bRetCode = TRUE;
		}
	}
	return bRetCode;
}

//============================================================================
//  MIDI R}hM (GNXN[VuEObZ[W)
//----------------------------------------------------------------------------
// In  : lpMidiHdr = MIDIHDR \̂ւ̃|C^
// Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiOutEx( LPMIDIHDR lpMidiHdr )
{
	BOOL bRetCode = FALSE;
	if ( MIDIOutHandle != 0 ) {
		midiOutPrepareHeader( MIDIOutHandle, lpMidiHdr, sizeof( MIDIHDR ) );
		if ( midiOutLongMsg( MIDIOutHandle, lpMidiHdr, sizeof( MIDIHDR ) ) == MMSYSERR_NOERROR ) {
			bRetCode = TRUE;
		}
	}
	return bRetCode;
}

//============================================================================
//  MIDI Zbg
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : Ȃ
//============================================================================
void MidiReset( void )
{
	int i;
	for ( i=0; i<MIDITRACK_MAX; i++ ) {
		MidiOut( (BYTE)( 0xB0 + i ), 0x79, 0x00 );	// GtFNg̏
		MidiOut( (BYTE)( 0xB0 + i ), 0x7B, 0x00 );	// SẲ
		MidiOut( (BYTE)( 0xB0 + i ), 0x7B, 0x00 );	// SẲ
	}
}

//============================================================================
//  MIDI IN foCXI[v
//----------------------------------------------------------------------------
//In  : index = MIDI IN foCX̔ԍ (0`)
//    : devicename = foCX̖O
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiInList( int index, char *devicename )
{
	int devicecount;
	MIDIINCAPS caps;
	devicecount = midiInGetNumDevs();
	if ( index >= devicecount ) {
		return FALSE;
	}
	midiInGetDevCaps( index, (LPMIDIINCAPS)&caps, sizeof( caps ) );
	return TRUE;
}

//============================================================================
//  MIDI IN foCXI[v
//----------------------------------------------------------------------------
//In  : deviceid = MIDI ̃foCX ID (MIDI_MAPPER)
//    : callbackaddress = MIDI IN f[^M̃R[obNAhX
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiInOpen( UINT deviceid, DWORD callbackaddress )
{
	MMRESULT result;
	if ( uMidiInDeviceId == deviceid ) {
		// łɃfoCX̓I[vĂ
		return TRUE;
	} else if ( uMidiInDeviceId != -1 ) {
		MidiInClose();
	}
	uMidiInDeviceId = deviceid;
	MidiInCallback = (void *)callbackaddress;
	// I[v
	result = midiInOpen( &MIDIInHandle, 0, (DWORD)MidiInProc, 0, CALLBACK_FUNCTION );
	if ( MMSYSERR_NOERROR != result ) {
		return FALSE;
	}
	// obt@쐬
	result = midiInPrepareHeader( MIDIInHandle, &MidiHdr, sizeof( MidiHdr ) );
	if ( MMSYSERR_NOERROR != result ) {
		MidiInClose();
		return FALSE;
	}
	return TRUE;
}

//============================================================================
//  MIDI IN Jn
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiInStart( void )
{
	if ( 0 == MIDIInHandle ) {
		return FALSE;
	}
	midiInStart( MIDIInHandle );
	return TRUE;
}

//============================================================================
//  MIDI IN ~
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiInStop( void )
{
	if ( 0 == MIDIInHandle ) {
		return FALSE;
	}
	midiInStop( MIDIInHandle );
	return TRUE;
}

//============================================================================
//  MIDI IN foCXN[Y
//----------------------------------------------------------------------------
//In  : Ȃ
//Out : TRUE = , FALSE = s
//============================================================================
BOOL MidiInClose( void )
{
	if ( 0 == MIDIInHandle ) {
		return FALSE;
	}
	midiInStop( MIDIInHandle );
	midiInReset( MIDIInHandle );
	midiInUnprepareHeader( MIDIInHandle, &MidiHdr, sizeof( MidiHdr ) );
	midiInClose( MIDIInHandle );
	MIDIInHandle = 0;
	return TRUE;
}

//============================================================================
//  MIDI IN R[obN
//============================================================================
void CALLBACK MidiInProc( HMIDIIN midiinhandle, UINT msg, DWORD instance, DWORD param1, DWORD param2 )
{
	(*MidiInCallback)( param1 );
}
