;
; MZ-2000 CORE PROGRAM.
;
;   Copyright 2002 by EmuZ-2000(M.Y)
;
	INCLUDE	"SOUND.INC"
	INCLUDE	"EMUZCORE.INC"
	
	ORG	0H
	JP	STARTUP
WIDTH:
	DEFB	40
CURSORY:
	DEFB	0
CURSORX:
	DEFB	0

;Restart 08h Not Function.
	ORG	8H
	ret
GRAPHX:
	DEFW	0
GRAPHY:
	DEFW	0

;Restart 10h Not Function.
	ORG	10H
	ret
TCOLOR:
	DEFB	7
BCOLOR:
	DEFB	0
GRAPHOUT:
	DEFB	0
GRAPHWRT:
	DEFB	0

;Restart 18h Math Function.
	ORG	18H
	JP	FUNC18H
;GRAPHIC CLIP AREA
CLIPSX:
	DW	0
CLIPSY:
	DW	0

;Restart 20h Not Function.
	ORG	20H
	JP	FUNC20H
;GRAPHIC CLIP AREA
CLIPEX:
	DW	639
CLIPEY:
	DW	200

;Restart 28h SERVICE Function.
	ORG	28H
	RET
;ITS-2000݊t@NVɂȂ\
;	JP	TS2000

;Restart 30h Not Function.
	ORG	30H
	JP	GLIB
;GRAPHIC STACK POINT 
GSTACK:
	DW	0

;Restart 38h Not Function.
	ORG	38H
	ret
;;;;;;;;;;;;;;;;;;;
XPDX:
	DW	0
XMDX:
	DW	0
XPDY:
	DW	0
XMDY:
	DW	0
YPDY:
	DW	0
YMDY:
	DW	0
YPDX:
	DW	0
YMDX:
	DW	0
TMPCLE:
	DW	0
CIRDY:
	DW	0
CIRDX:
	DW	0
GLINETMP:
	DEFS	24

;Non Mascable Interrupt Function.
	ORG	66H
	retn

	DEFB	"Hello! My name is EmuZ-2000."
	DEFB	"This area is Temp Stack."
	DEFB	"good bye."
	
	ORG	0100H
TEMPSTACK:
	NOP
	NOP
;*******************************************************
;*
;*  RST 18H  MATH Function
;*
;*    ALWAYS BROKEN REVERSE REGISTER and A,IX,IY REGISTER!
;*******************************************************
FUNC18H:
	EX	AF,AF'
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	CP	05H
;	RET	NC
	JR	C,FUNC18H1
	EX	AF,AF'
	RET
FUNC18H1:	
	PUSH	HL
	PUSH	DE
	LD	DE,FUNC18TBL
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	POP	DE
	PUSH	HL
	POP	IX
	POP	HL
	EX	AF,AF'
	JP	(IX)

FUNC18TBL:
	DW	ADD64
	DW	SUB64
	DW	MT16
	DW	MT32
	DW	DV32
	DW	NOOP
	
;*******************************************************
;*
;*  RST 20H  SERVICE Function
;*
;*    ALWAYS BROKEN REVERSE REGISTER and A,IX,IY REGISTER!
;*******************************************************
FUNC20H:
	EX	AF,AF'
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	CP	028H
;	RET	NC
	JR	C,FUNC20H1
	EX	AF,AF'
	RET
FUNC20H1:
	PUSH	HL
	PUSH	DE
	LD	DE,FUNC20TBL
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	POP	DE
	PUSH	HL
	POP	IX
	POP	HL
	EX	AF,AF'
	JP	(IX)

FUNC20TBL:
	DW	WIDTH80		;00:
	DW	WIDTH40		;01:
	DW	REVERS		;02:
	DW	NOMAL		;03:
	DW	CLS		;04:
	DW	SCROOLUP	;05:
	DW	CHAROUT		;06:Acc = Char
	DW	MSGOUT		;07:HL = Message
	DW	CCOLOR		;08:Acc = Color Number
	DW	BKCOLOR		;09:Acc = Color Number
	DW	DISPLAYSEL	;0A:Acc = Port F6h Code
	DW	GRAMSEL		;0B:Acc = Port F7h Code
	DW	WAIT		;0C:B * HL wait number
	DW	SETCSR		;0D:D = X, E = Y
	DW	NOOP		;0E:
	DW	NOOP		;0F:

	DW	COUT		;10: NEXT DB = Char
	DW	PRINTS		;11: 00H TERM Message
	DW	PRNSPC		;12: SPACE PRINT
	DW	PRNHEXACC	;13: PRINT ACC to ASCII 2CHAR
	DW	PRNHEXHL	;14: PRINT HL to ASCII 4CHAR
	DW	CCOL		;15: NEXT DB = Color Number
	DW	BKCOL		;16: NEXT DB = Color Number
	DW	DISSEL		;17: NEXT DB = Port F6h Code
	DW	GRSEL		;18: NEXT DB = Port F7h Code
	DW	SETCSRDB	;19: NEXT DB CURSOR X,Y
	DW	NOOP		;1A:
	DW	NOOP		;1B:
	DW	NOOP		;1C:
	DW	NOOP		;1D:
	DW	NOOP		;1E:
	DW	NOOP		;1F:

	DW	PLAYALL		;20:PLAY MUSIC IY = DATA
	DW	PLAYONE		;21:ONE PLAY MUSIC IY = DATA
	DW	SOUT		;22:HL,DE SOUND OUT
	DW	NOOP		;23:
	DW	NOOP		;24:
	DW	P3VMSA		;25:SET MUSIC DATA HL = DATA
	DW	P3VMLOP		;26:ONE PLAY MUSIC -> CY RET. PLAY END
	DW	P3VMALOP	;27:ALL PLAY MUSIC HL = DATA
	DW	NOOP		;28:

;*******************************************************
;*
;*  RST 30H  GRAPHIC Library Function
;*
;*CALL SEQUENCE:
;*  IY <- PARAMETER POINTER
;*  RST 30H
;*  DEFB FUNCTION
;*
;*    ALWAYS BROKEN REVERSE REGISTER and A,IX,IY REGISTER!
;*******************************************************
FUNC30H:
GLIB:
	EX	AF,AF'
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	CP	08H
;	RET	NC
	JR	C,FUNC30H1
	EX	AF,AF'
	RET
FUNC30H1:	
	PUSH	HL
	PUSH	DE
	LD	DE,FUNC30TBL
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	POP	DE
	PUSH	HL
	POP	IX
	POP	HL
	EX	AF,AF'

	PUSH	AF
	PUSH	HL
	LD	(GSTACK),SP
	LD	SP,TEMPSTACK
	LD	HL,RETF30
	PUSH	HL
	JP	(IX)

RETF30:
	LD	SP,(GSTACK)
	POP	HL
	POP	AF
	RET

FUNC30TBL:
	DW	GCLEAR
	DW	GFILL
	DW	GCLIPSET
	DW	GPSET
	DW	GLINE
	DW	GBOX
	DW	GCIRCLE
	DW	NOOP

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
; SUBROUTINE
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;------------------------------------
; COLOR CLIP & PROGRAM CHANGE
;
; IN)
;    IY<- USER PARAM
; OUT)
;    IY<- COPY USER PARAM
;    (PROGRAM CHANGE+)
;------------------------------------
;***************************
; COLOR CLIP SET/RESET SET
;
; INTERNAL USE
;***************************
NCCPC6:
	RRA
	JR	C,NCCPC61
	RES	6,H
NCCPC61:
	RRA
	JR	C,NCCPC62
	RES	6,L
NCCPC62:
	RRA
	JR	C,NCCPC63
	RES	6,D
NCCPC63:
	RET

;***************************
; COLOR CLIP JUMP ADR SET
;
; INTERNAL USE
;***************************
NCCPCJ:
	RRA
	JR	C,NCCPCJ1
	LD	H,4
NCCPCJ1:
	RRA
	JR	C,NCCPCJ2
	LD	L,4
NCCPCJ2:
	RRA
	JR	C,NCCPCJ3
	LD	D,4
NCCPCJ3:
	RET

;----------------------------
; SUBROUTINE START COLOR CLIP
;IN)
;   A <- COLOR
;   E <- WRITE MODE
;         NCCPC
;----------------------------
NCCPC:
	PUSH	HL
	PUSH	IX
	;COLOR CLIP
	AND	07H
	LD	B,A
	LD	H,0
	LD	L,0
	LD	D,0
	EXX
	LD	H,0C6H
	LD	L,0C6H
	LD	D,0C6H
	CALL	NCCPC6
	EXX
	
	LD	A,E
	CP	0
	JR	Z,NCCPCE ;ABSOLUTE MODE
	LD	A,B
	CALL	NCCPCJ
NCCPCE:
	PUSH	IY
	LD	IX,GPSW00
	LD	IY,LINW1J
	LD	(IY+1),H
	LD	(IY+8),L  
	LD	(IY+15),D 
	EXX
	LD	(IX+1),H
	LD	(IX+7),L
	LD	(IX+13),D
	EXX
	POP	IY
	
	LD	IX,GLINETMP
	
	;PARAMETER COPY
	PUSH	IX
	PUSH	IY
	PUSH	IX
	POP	DE
	POP	HL
	LD	BC,10
	LDIR
	POP	IY
	POP	IX
	POP	HL
	RET
	

;------------------------------------
; GRAPHIC AREA CLIP
;
;   HL = X
;   BC = Y
;RETURN  CY = 1 Z = 0 START ERROR
;RETURN  CY = 1 Z = 1 END ERROR
;------------------------------------
GPSLCLP:
	PUSH	HL
	PUSH	BC
	PUSH	DE
	
	LD	DE,(CLIPSX)
	CALL	CP16
	JR	C,GPSLCERR
	LD	DE,(CLIPEX)
	EX	DE,HL
	CALL	CP16
	JR	C,GPSLCERR0
	
	PUSH	BC
	POP	HL
	LD	DE,(CLIPSY)
	CALL	CP16
	JR	C,GPSLCERR
	LD	DE,(CLIPEY)
	EX	DE,HL
	CALL	CP16
	JR	C,GPSLCERR0
	JR	GPSLCERR1

GPSLCERR0:
	CP	A
GPSLCERR:
	SCF
GPSLCERR1:
	POP	DE
	POP	BC
	POP	HL
	RET

;------------------------------------------
;GPSETLIN
;     LINE USE PSET
;(INTERNAL USE)
;   HL = X
;   BC = Y
;------------------------------------------
GPSETLIN:
	;HL = X
	;BC = Y
	CALL	GPSLCLP
	RET	C
	RET	Z
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	BC
	EX	(SP),HL
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	PUSH	HL
	SLA	L
	RL	H
	SLA	L
	RL	H
	POP	BC
	ADD	HL,BC ;*64+*16 = *80

	EX	(SP),HL
	LD	A,L
	; HL >= 3
	SRL	H
	RR	L
	SRL	H
	RR	L
	SRL	H
	RR	L
	POP	DE
	;GET WRITE ADDRESS
	ADD	HL,DE
	;+C000H
	SET	6,H
	SET	7,H
	;POINT CLIP
	AND	7
	RLA
	RLA
	RLA
	LD	B,A
GPSW00:
	OR	0C6H
	LD	(LINW1J+5),A
	LD	A,B
	OR	0C6H
	LD	(LINW1J+12),A
	LD	A,B
	OR	0C6H
	LD	(LINW1J+19),A

	LD	B,1
	LD	C,0F7H
	IN	A,(0E8H)
	AND	0BFH
	OR	080H
	OUT	(0E8H),A

LINW1J:
	JR	$+0
	OUT	(C),B
	SET	0,(HL)
	
	INC	B
	JR	$+0
	OUT	(C),B
	SET	0,(HL)

	INC	B
	JR	$+0
	OUT	(C),B
	SET	0,(HL)

	IN	A,(0E8H);
	AND	07FH
	OUT	(0E8H),A
	POP	BC
	POP	DE
	POP	HL
	RET

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@



;-----------------------------------
;GRAPHIC MEMORY CLEAR (IY)<-CLEAR PAGE
;-----------------------------------
GCLEAR:
	LD	A,(IY)
	DB	SVC,SGRAMOUT,1
	RRCA
	CALL	C,GCLR_RT
	DB	SVC,SGRAMOUT,2
	RRCA
	CALL	C,GCLR_RT
	DB	SVC,SGRAMOUT,3
	RRCA
	CALL	C,GCLR_RT
	DB	SVC,SGRAMOUT,0
	RET

GCLR_RT:
	PUSH	AF
	XOR	A
GCLR_RT1:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	HL,0C000H
	LD	DE,0C001H
	LD	BC,16001
	LD	(HL),A
	LDIR
	POP	BC
	POP	DE
	POP	HL
	POP	AF
	RET
;-----------------------------------
;GRAPHIC MEMORY FILL (IY)<-FILL PAGE
;-----------------------------------
GFILL:
	LD	A,(IY)
	DB	SVC,SGRAMOUT,1
	RRCA
	CALL	C,GFIL_RT
	DB	SVC,SGRAMOUT,2
	RRCA
	CALL	C,GFIL_RT
	DB	SVC,SGRAMOUT,3
	RRCA
	CALL	C,GFIL_RT
	DB	SVC,SGRAMOUT,0
	RET

GFIL_RT:
	PUSH	AF
	LD	A,0FFH
	JR	GCLR_RT1
;-----------------------------------
;CLIP AREA SET (IY)<-X1w,Y1w,X2w,Y2w
;-----------------------------------
GCLIPSET:
	PUSH	HL
	LD	L,(IY+0)
	LD	H,(IY+1)
	LD	(CLIPSX),HL
	LD	L,(IY+2)
	LD	H,(IY+3)
	LD	(CLIPSY),HL

	LD	L,(IY+4)
	LD	H,(IY+5)
	LD	(CLIPEX),HL
	LD	L,(IY+6)
	LD	H,(IY+7)
	LD	(CLIPEY),HL
	POP	HL
	RET

;-----------------------------------
;PSET (IY)<- Xw,Yw,Cb,WMb
;-----------------------------------
GPSET:
	PUSH	HL
	PUSH	BC
	PUSH	DE
	PUSH	IY
	LD	A,(IY+4)
	LD	E,(IY+5)
	CALL	NCCPC
	LD	L,(IY+0)
	LD	H,(IY+1)
	LD	C,(IY+2)
	LD	B,(IY+3)
	CALL	GPSETLIN
GPSETE:
	POP	IY
	POP	DE
	POP	BC
	POP	HL
	RET	
;-----------------------------------
;GLINE IY<-SXw,SYw,EXw,EYw,Cb,WMb
;
;  Bresenham Algorithms
;-----------------------------------
GLINE:
	PUSH	AF
	PUSH	DE
	PUSH	HL
	PUSH	BC
	PUSH	IY
	PUSH	IX

	LD	A,(IY+8)
	LD	E,(IY+9)
	CALL	NCCPC

	;Get Inclination SX
	LD	BC,1
	LD	L,(IY+0)
	LD	H,(IY+1)
	LD	E,(IY+4)
	LD	D,(IY+5)
	CALL	CP16
	JR	Z,GLINC11
	JR	C,GLINC1
	LD	BC,-1
	JR	GLINC1
GLINC11:
	LD	BC,0
GLINC1:
	LD	(IY+10),C ;SXL
	LD	(IY+11),B ;SXH

	;DX(DE) = X2-X1
	EX	DE,HL
	XOR	A
	SBC	HL,DE
	CALL	ABS16
	LD	(IY+12),L ;DXL
	LD	(IY+13),H ;DXH

	;Get Inclination SY
	LD	BC,1
	LD	L,(IY+2)
	LD	H,(IY+3)
	LD	E,(IY+6)
	LD	D,(IY+7)
	CALL	CP16
	JR	Z,GLINC22
	JR	C,GLINC2
	LD	BC,-1
	JR	GLINC2
GLINC22:
	LD	BC,0
GLINC2:
	LD	(IY+14),C ;SYL
	LD	(IY+15),B ;SYH

	;DY(DE) = Y2-Y1
	EX	DE,HL
	XOR	A
	SBC	HL,DE
	CALL	ABS16
	LD	(IY+16),L ;DYL
	LD	(IY+17),H ;DYH

	;IY+00 : X1
	;IY+02 : Y1
	;IY+04 : X2
	;IY+06 : Y2
	;IY+08 : COLOR
	;IY+09 : WRITE MODE
	;IY+10 : SX
	;IY+12 : ABS(DX)
	;IY+14 : SY
	;IY+16 : ABS(DY)
	;IY+18 : A
	;IY+20 : A1
	;IY+22 : E
	; DX >= DY ?
	LD	E,(IY+12)
	LD	D,(IY+13)
	EX	DE,HL
	CALL	CP16
	PUSH	AF
	CALL	NC,LINEX
	POP	AF
	CALL	C,LINEY
	POP	IX
	POP	IY
	POP	BC
	POP	HL
	POP	DE
	POP	AF
	RET
LINEX:
	; A=DY*2 = DE
	LD	E,(IY+16)
	LD	D,(IY+17)
	SLA	E
	RL	D
	LD	(IY+18),E
	LD	(IY+19),D
	; A1 = A-(DX*2) = HL
	LD	L,(IY+12)
	LD	H,(IY+13)
	PUSH	HL
	SLA	L
	RL	H
	OR	A
	EX	DE,HL
	SBC	HL,DE
	EX	(SP),HL
	; E = A-DX
	LD	E,(IY+18)
	LD	D,(IY+19)
	OR	A
	EX	DE,HL
	SBC	HL,DE
	EX	(SP),HL
	POP	BC
	; BC = A1
	; HL = E
	LD	(IY+20),L
	LD	(IY+21),H
	LD	(IY+22),C
	LD	(IY+23),B
;Preparation LOOP
	; HL = X1
	; DE = X2
	; BC = Y1
	LD	L,(IY+0)
	LD	H,(IY+1)
	LD	E,(IY+4)
	LD	D,(IY+5)
	LD	C,(IY+2)
	LD	B,(IY+3)
	EXX
	; HL' = A
	; DE' = A1
	; BC' = E
	LD	L,(IY+18)
	LD	H,(IY+19)
	LD	E,(IY+20)
	LD	D,(IY+21)
	LD	C,(IY+22)
	LD	B,(IY+23)
	EXX
	; IX = SX
	; IY = SY
	PUSH	HL
	PUSH	DE
	LD	L,(IY+10)
	LD	H,(IY+11)
	LD	E,(IY+14)
	LD	D,(IY+15)
	PUSH	HL
	PUSH	DE
	POP	IY
	POP	IX
	POP	DE
	POP	HL

	; HL = X1
	; DE = X2
	; BC = Y1
	; HL' = A
	; DE' = A1
	; BC' = E
	; IX = SX
	; IY = SY
; LOOP IN!
LINXLOP:
	CALL	CP16
	JR	Z,LINXLOPE
	CALL	GPSETLIN
	JR	NZ,LINXLOP1 ;*****CLIPNOERR
	JR	LINXLOPE    ;*****CLIPERR
	
LINXLOP1:
	EXX
	;IF E>=0
	BIT	7,B
	JR	NZ,LINXLOP2
	;Y=Y+SY
	EXX
	PUSH	IY
	ADD	IY,BC
	PUSH	IY
	POP	BC
	POP	IY
	;E=E+A1
	EXX
	PUSH	BC
	EX	(SP),HL
	ADD	HL,DE
	EX	(SP),HL
	POP	BC
	JR	LINXLOP3
LINXLOP2:
	;E=E+A
	PUSH	HL
	ADD	HL,BC
	EX	(SP),HL
	POP	BC
LINXLOP3:
	EXX
	;X1=X1+SX
	PUSH	DE
	PUSH	IX
	POP	DE
	ADD	HL,DE
	POP	DE
	JR	LINXLOP
LINXLOPE:
	RET


LINEY:
	; A=DX*2
	LD	E,(IY+12)
	LD	D,(IY+13)
	SLA	E
	RL	D
	LD	(IY+18),E
	LD	(IY+19),D
	; A1 = A-(DY*2)
	LD	L,(IY+16)
	LD	H,(IY+17)
	PUSH	HL
	SLA	L
	RL	H
	OR	A
	EX	DE,HL
	SBC	HL,DE
	EX	(SP),HL
	; E = A-DX
	LD	E,(IY+16)
	LD	D,(IY+17)
	OR	A
	EX	DE,HL
	SBC	HL,DE
	EX	(SP),HL
	POP	BC
	; BC = E
	; HL = A1
	LD	(IY+20),L
	LD	(IY+21),H
	LD	(IY+22),C
	LD	(IY+23),B

;Preparation LOOP
	; HL = Y1
	; DE = Y2
	; BC = X1
	LD	L,(IY+2)
	LD	H,(IY+3)
	LD	E,(IY+6)
	LD	D,(IY+7)
	LD	C,(IY+0)
	LD	B,(IY+1)
	EXX
	; HL' = A
	; DE' = A1
	; BC' = E
	LD	L,(IY+18)
	LD	H,(IY+19)
	LD	E,(IY+20)
	LD	D,(IY+21)
	LD	C,(IY+22)
	LD	B,(IY+23)
	EXX
	; IX = SX
	; IY = SY
	PUSH	HL
	PUSH	DE
	LD	L,(IY+10)
	LD	H,(IY+11)
	LD	E,(IY+14)
	LD	D,(IY+15)
	PUSH	HL
	PUSH	DE
	POP	IY
	POP	IX
	POP	DE
	POP	HL

	; HL = X1
	; DE = X2
	; BC = Y1
	; HL' = A
	; DE' = A1
	; BC' = E
	; IX = SX
	; IY = SY
	INC	DE
	
; LOOP IN!
LINYLOP:
	CALL	CP16
	JR	Z,LINYLOPE
	PUSH	HL
	PUSH	BC
	POP	HL
	POP	BC
	CALL	GPSETLIN
	PUSH	HL
	PUSH	BC
	POP	HL
	POP	BC
	JR	NZ,LINYLOP1 ;*****CLIPNOERR
	JR	LINYLOPE    ;*****CLIPERR
	
LINYLOP1:
	EXX
	;IF E>=0
	BIT	7,B
	JR	NZ,LINYLOP2
	;X=X+SX
	EXX
	PUSH	IX
	ADD	IX,BC
	PUSH	IX
	POP	BC
	POP	IX
	;E=E+A1
	EXX
	PUSH	BC
	EX	(SP),HL
	ADD	HL,DE
	EX	(SP),HL
	POP	BC
	JR	LINYLOP3
LINYLOP2:
	;E=E+A
	PUSH	HL
	ADD	HL,BC
	EX	(SP),HL
	POP	BC
LINYLOP3:
	EXX
	;Y1=Y1+SY
	PUSH	DE
	PUSH	IY
	POP	DE
	ADD	HL,DE
	POP	DE
	JR	LINYLOP
LINYLOPE:
	RET

;-----------------------------------
; GBOX (IY)<-X1w,Y1w,X2w,Y2w,Cb,WMb
;-----------------------------------
GBOX:
	PUSH	IY
	PUSH	HL
	;X1
	LD	L,(IY+0)
	LD	H,(IY+1)
	LD	(GBOXP1),HL
	LD	(GBOXP1+4),HL
	LD	(GBOXP2),HL
	LD	(GBOXP3),HL

	;Y1
	LD	L,(IY+2)
	LD	H,(IY+3)
	LD	(GBOXP1+2),HL
	LD	(GBOXP2+2),HL
	LD	(GBOXP2+6),HL
	LD	(GBOXP4+2),HL

	;X2
	LD	L,(IY+4)
	LD	H,(IY+5)
	LD	(GBOXP2+4),HL
	LD	(GBOXP3+4),HL
	LD	(GBOXP4),HL
	LD	(GBOXP4+4),HL

	;Y2
	LD	L,(IY+6)
	LD	H,(IY+7)
	LD	(GBOXP1+6),HL
	LD	(GBOXP3+2),HL
	LD	(GBOXP3+6),HL
	LD	(GBOXP4+6),HL

	LD	H,(IY+8)
	LD	L,(IY+9)
	LD	IY,GBOXP1
	LD	(IY+8),H
	LD	(IY+9),L
	LD	(IY+18),H
	LD	(IY+19),L
	LD	(IY+28),H
	LD	(IY+29),L
	LD	(IY+38),H
	LD	(IY+39),L
	
	CALL	GLINE
	LD	IY,GBOXP2
	CALL	GLINE
	LD	IY,GBOXP3
	CALL	GLINE
	LD	IY,GBOXP4
	CALL	GLINE
	
	POP	HL
	POP	IY
	RET	
;LINE PARAM FOR BOX ^^;
GBOXP1:
	DS	10
GBOXP2:
	DS	10
GBOXP3:
	DS	10
GBOXP4:
	DS	10
;-----------------------------------
; GCIRCLE (IY)<-Xw,Yw,Rw,Cb,WMb
;
;  Bresenham Algorithms
;-----------------------------------
GCIRCLE:
	PUSH	IY
	PUSH	HL
	PUSH	DE
	PUSH	BC

	LD	A,(IY+6)
	LD	E,(IY+7)
	CALL	NCCPC
	
	; CIRCLE Preparation 
	;X READ
	LD	L,(IY+0)
	LD	H,(IY+1)
	;R READ
	LD	E,(IY+4)
	LD	D,(IY+5)
	PUSH	HL ;X PARAM COPY
	PUSH	HL ;X PARAM COPY
	; X+DX
	ADD	HL,DE
	LD	(XPDX),HL
	POP	HL
	; X-DX
	OR	A
	SBC	HL,DE
	LD	(XMDX),HL
	POP	HL
	; X+DY
	; X-DY
	LD	(XPDY),HL
	LD	(XMDY),HL

	;Y READ
	LD	L,(IY+2)
	LD	H,(IY+3)
	PUSH	HL ;Y PARAM COPY
	PUSH	HL ;Y PARAM COPY
	; Y+DX
	ADD	HL,DE
	LD	(YPDX),HL
	POP	HL
	; Y-DX
	OR	A
	SBC	HL,DE
	LD	(YMDX),HL
	POP	HL
	; Y+DY
	; Y-DY
	LD	(YPDY),HL
	LD	(YMDY),HL
	
	;R COPY
	EX	DE,HL
	LD	(TMPCLE),HL
	LD	(CIRDX),HL
	LD	HL,0
	LD	(CIRDY),HL
	
CIRLOP:
	LD	HL,(YPDY)
	PUSH	HL
	LD	HL,(YMDY)
	PUSH	HL
	LD	HL,(XPDX)
	POP	DE ;YMDY
	POP	BC ;YPDY
	PUSH	BC
	PUSH	HL
	PUSH	DE
	PUSH	HL
	LD	HL,(XMDX)
	PUSH	BC
	PUSH	HL
	PUSH	DE
	PUSH	HL

	LD	HL,(YPDX)
	PUSH	HL
	LD	HL,(YMDX)
	PUSH	HL
	LD	HL,(XPDY)
	POP	DE ;YMDX
	POP	BC ;YPDX

	PUSH	BC
	PUSH	HL
	PUSH	DE
	PUSH	HL
	LD	HL,(XMDY)
	PUSH	BC
	PUSH	HL
	PUSH	DE
	PUSH	HL

	LD	D,8
CIRLOP1:
	POP	HL
	POP	BC
	CALL	GPSETLIN
	DEC	D
	JR	NZ,CIRLOP1
	
	LD	HL,(CIRDY)
	SLA	L
	RL	H
	INC	HL
	EX	DE,HL
	LD	HL,(TMPCLE)
	OR	A
	SBC	HL,DE
	LD	(TMPCLE),HL
	BIT	7,H
	JR	Z,CIRLOP2 ;S>=0
	;S<0
	EX	DE,HL
	LD	HL,(CIRDX)
	DEC	HL
	PUSH	HL
	SLA	L
	RL	H
	ADD	HL,DE
	LD	(TMPCLE),HL
	POP	HL
	LD	(CIRDX),HL

	LD	HL,(XPDX)
	DEC	HL
	LD	(XPDX),HL

	LD	HL,(XMDX)
	INC	HL
	LD	(XMDX),HL

	LD	HL,(YPDX)
	DEC	HL
	LD	(YPDX),HL

	LD	HL,(YMDX)
	INC	HL
	LD	(YMDX),HL

CIRLOP2:
	LD	HL,(CIRDY)
	INC	HL
	LD	(CIRDY),HL
	
	LD	HL,(XPDY)
	DEC	HL
	LD	(XPDY),HL

	LD	HL,(XMDY)
	INC	HL
	LD	(XMDY),HL

	LD	HL,(YPDY)
	DEC	HL
	LD	(YPDY),HL

	LD	HL,(YMDY)
	INC	HL
	LD	(YMDY),HL
	
	LD	HL,(CIRDY)
	EX	DE,HL
	LD	HL,(CIRDX)
	CALL	CP16
	JP	NC,CIRLOP
	
CIRLOP3:
	POP	BC
	POP	DE
	POP	HL
	POP	IY
	RET	
;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------

;-----------------------------------
; CP16   CP HL,DE
;           HL = DE  CY=0,ZF=1
;           HL < DE  CY=1,ZF=0
;           HL > DE  CY=0,ZF=0 
; Acc Always Brokun
;-----------------------------------
CP16:
	PUSH	HL
	PUSH	DE
	XOR	A
	SBC	HL,DE
	POP	DE
	POP	HL
	RET

;-----------------------------------
; ABS16      ABS(HL)
;-----------------------------------
ABS16:
	PUSH	AF
	BIT	7,H
	JR	Z,ABS16R
	LD	A,L
	CPL
	LD	L,A
	LD	A,H
	CPL
	LD	H,A
	INC	HL
ABS16R:
	POP	AF
	RET

;-----------------------------------
; BC DE + HL IX = CY HL BC
;-----------------------------------
ADD64:
	ADD	IX,DE
	ADC	HL,BC
	PUSH	IX
	POP	BC
	RET

;-----------------------------------
; HL IX - BC DE = CY HL BC
;-----------------------------------
SUB64:
	AND	A
	SBC	HL,DE
	PUSH	HL
	POP	DE
	PUSH	IX
	POP	HL
	SBC	HL,BC
	RET
	
;-----------------------------------
; B * E = BC
;-----------------------------------
MT16:
	PUSH	AF
	PUSH	HL
	LD	HL,0
	LD	C,0
	SRL	B
	RR	C
	LD	A,8
MT17:
	SLA	E
	JR	NC,MT18
	ADD	HL,BC
MT18:
	SRL	B
	RR	C
	DEC	A
	JR	NZ,MT17
	LD	C,L
	LD	B,H
	POP	HL
	POP	AF
	RET

;-----------------------------------
; HL * BC = HL BC
;-----------------------------------
MT32:
	PUSH	AF
	PUSH	DE
	PUSH	IX
	PUSH	IY
	PUSH	HL
	POP	IY
	EXX
	LD	DE,0
	LD	HL,0
	LD	IX,0
	PUSH	IY
	POP	BC
	SRL	B
	RR	C
	RR	D
	RR	E
	EXX
	LD	A,16
MT33:
	SLA	C
	RL	B
	EXX
	JR	NC,MT34
	PUSH	BC
	CALL	ADD64
	PUSH	BC
	POP	IX
	POP	BC
MT34:
	SRL	B
	RR	C
	RR	D
	RR	E
	EXX
	DEC	A
	JR	NZ,MT33
	EXX
	PUSH	IX
	POP	BC
	POP	IY
	POP	IX
	POP	DE
	POP	AF
	RET

;-----------------------------------
; DE / BC = BC ... DE
;-----------------------------------
DV32:
	PUSH	AF
	PUSH	HL
	PUSH	IX
	EXX
	LD	BC,0
	EXX
	LD	HL,0
	LD	A,16
DV33:
	SLA	E
	RL	D
	RL	L
	RL	H
	PUSH	HL
	AND	A
	SBC	HL,BC
	JR	NC,DV34
	POP	HL
	EXX
	AND	A
DV35:
	RL	C
	RL	B
	EXX
	DEC	A
	JR	NZ,DV33
	PUSH	HL
	POP	IX
	EXX
	PUSH	IX
	POP	DE
	POP	IX
	POP	HL
	POP	AF
	RET
DV34:
	POP	IX
	EXX
	SCF
	JR	DV35

;--------------------------------
; SCROOL UP
;
;--------------------------------
SCROOLUP:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
	
	IN	A,(0E8H)
	OR	0C0H
	OUT	(0E8H),A
	
	LD	HL,WIDTH
	LD	A,(HL)
	CP	40
	JR	NZ,SCROOL80
SCROOL40:
	LD	DE,0D000H
	LD	HL,0D000H+40
	LD	BC,2048
	JR	SCROOL80E
SCROOL80:
	LD	DE,0D000H
	LD	HL,0D000H+80
	LD	BC,2048
SCROOL80E:
	LDIR
	
	IN	A,(0E8H)
	AND	07FH
	OUT	(0E8H),A

	POP	AF
	POP	BC
	POP	DE
	POP	HL

	RET

;--------------------------------
; CLEAR SCREEN
;
;--------------------------------
CLS:
	PUSH	HL
	PUSH	BC
	PUSH	AF
	
	LD	HL,0D000H
	LD	BC,3000

	IN	A,(0E8H)
	OR	0C0H
	OUT	(0E8H),A
	
CLSLOP:
	XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,CLSLOP
	
	IN	A,(0E8H)
	AND	07FH
	OUT	(0E8H),A
	
	LD	HL,CURSORY
	XOR	A
	LD	(HL),A
	INC	HL
	LD	(HL),A
	
	POP	AF
	POP	BC
	POP	HL
	RET
	
;--------------------------------
; CHARACTER OUT
;  Acc = CHARACTER
;--------------------------------
CHAROUT:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	
	CP	01DH
	JR	C,CONTROL
	
	LD	HL,WIDTH
	LD	B,(HL)
	INC	HL
	LD	E,(HL)
	CALL	MT16
	PUSH	HL
	LD	HL,0D000H
	ADD	HL,BC
	PUSH	HL
	POP	BC
	POP	HL
	INC	HL
	LD	D,0
	LD	E,(HL)
	PUSH	BC
	POP	HL
	ADD	HL,DE
	EX	DE,HL

	LD	HL,WIDTH
	LD	B,A
	LD	A,40
	CP	(HL)
	JR	NZ,CHAR80
CHAR40:
	IN	A,(0E8H)
	OR	0C0H
	AND	0DFH
	OUT	(0E8H),A
	PUSH	AF
	LD	A,B
	LD	(DE),A
	POP	AF
	AND	07FH
	OUT	(0E8H),A
	JR	CHAR80E
CHAR80:
	IN	A,(0E8H)
	OR	0E0H
	OUT	(0E8H),A
	PUSH	AF
	LD	A,B
	LD	(DE),A
	POP	AF
	AND	07FH
	OUT	(0E8H),A
CHAR80E:
	LD	D,(HL)	;WIDTH
	INC	HL
	LD	E,(HL)	;Y
	LD	C,E
	INC	HL
	LD	A,(HL)	;X
	INC	A
	LD	B,A
	CP	D
	JR	NZ,CHAROUTE
	LD	B,0
	LD	A,E
	INC	A
	LD	C,A
	CP	25
	JR	NZ,PREEND
	CALL	SCROOLUP
	LD	C,24
	LD	B,0
PREEND:
	LD	A,B
	LD	E,C
CHAROUTE:
	LD	HL,CURSORY
	LD	(HL),E
	INC	HL
	LD	(HL),A
CHARFINAL:
	POP	BC
	POP	DE
	POP	HL
	RET

;---------------------------------
CONTROL:
	LD	HL,CURSORY
	CP	1
	JR	Z,CURDOWN
	CP	0AH
	JR	Z,CURDOWN
	CP	2
	JR	Z,CURUP
	CP	3
	JR	Z,CURRIGHT
	CP	4
	JR	Z,CURLEFT
	CP	5
	JR	Z,CURHOME
	CP	0DH
	JR	Z,LINEHOME
	CP	6
	CALL	Z,CLS
	JR	CONTROLE
;****************
CURDOWN:
	LD	A,(HL)
	INC	A
	CP	25
	JR	NZ,CURDOWNE
	CALL	SCROOLUP
	LD	A,24
CURDOWNE:
	LD	(HL),A
	JR	CONTROLE
;****************
CURUP:
	LD	A,(HL)
	CP	0
	JR	Z,CURUPE
	DEC	A
CURUPE:
	LD	(HL),A
	JR	CONTROLE
;****************
CURRIGHT:
	LD	IX,WIDTH
	LD	D,(HL)	;Y
	INC	HL
	LD	E,(HL)	;X
	DEC	HL
	LD	A,E
	INC	A
	CP	(IX+0)
	JR	Z,RIGHT1
	LD	E,A
	JR	LEFTE
RIGHT1:
	INC	D
	LD	A,D
	CP	25
	JR	NZ,RIGHTE
	LD	D,24
	CALL	SCROOLUP
	LD	E,0
RIGHTE:
	LD	(HL),D
	INC	HL
	LD	(HL),E
	JR	CONTROLE
;****************
CURLEFT:
	LD	D,(HL)	;Y
	INC	HL
	LD	E,(HL)	;X
	DEC	HL
	LD	A,E
	CP	0
	JR	Z,LEFT1
	DEC	E
	JR	LEFTE
LEFT1:
	LD	A,D
	CP	0
	JR	Z,LEFTE
	DEC	D
	LD	A,(WIDTH)
	DEC	A
	LD	E,A
LEFTE:
	LD	(HL),D
	INC	HL
	LD	(HL),E
	JR	CONTROLE
;****************
CURHOME:
	XOR	A
	LD	(HL),A
	INC	HL
	LD	(HL),A
	JR	CONTROLE
;****************
LINEHOME:
	INC	HL
	XOR	A
	LD	(HL),A
;****************
CONTROLE:
	JP	CHARFINAL

	
;--------------------------------
; CONSOLE C80
; 
;--------------------------------
WIDTH80:
	PUSH	HL
	PUSH	AF
	LD	HL,WIDTH
	LD	A,80
	LD	(HL),A
	CALL	CLS
	POP	AF
	POP	HL
	RET
	
;--------------------------------
; CONSOLE C40
; 
;--------------------------------
WIDTH40:
	PUSH	HL
	PUSH	AF
	LD	HL,WIDTH
	LD	A,40
	LD	(HL),A
	CALL	CLS
	POP	AF
	POP	HL
	RET

;--------------------------------
; CONSOLE R
; 
;--------------------------------
REVERS:
	PUSH	AF
	IN	A,(0E0H)
	AND	0EFH
	OUT	(0E0H),A
	POP	AF
	RET
	
;--------------------------------
; CONSOLE N
; 
;--------------------------------
NOMAL:
	PUSH	AF
	IN	A,(0E0H)
	OR	010H
	OUT	(0E0H),A
	POP	AF
	RET
	
;--------------------------------
; TEXT CHARACTER COLOR
;   Acc = COLOR NO.
;--------------------------------
CCOLOR:
	PUSH	AF
	PUSH	HL
	LD	HL,TCOLOR
	AND	0FH
	LD	(HL),A
	OUT	(0F5H),A
	POP	HL
	POP	AF
	RET
	
;--------------------------------
; TEXT CHARACTER COLOR
;   NEXT DB = COLOR NO.
;--------------------------------
CCOL:
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	JR	CCOLOR
	
;--------------------------------
; TEXT BACKGROUND COLOR
;   Acc = COLOR NO.
;--------------------------------
BKCOLOR:
	PUSH	AF
	PUSH	HL
	LD	HL,BCOLOR
	AND	07H
	LD	(HL),A
	OUT	(0F4H),A
	POP	HL
	POP	AF
	RET

;--------------------------------
; TEXT BACKGROUND COLOR
;   NEXT DB = COLOR NO.
;--------------------------------
BKCOL:
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	JR	BKCOLOR
	
;--------------------------------
; GRAPHIC DISPLAY PLANE
;   Acc = PORT F6H DATA
;--------------------------------
DISPLAYSEL:
	PUSH	AF
	PUSH	HL
	LD	HL,GRAPHOUT
	AND	0FH
	LD	(HL),A
	OUT	(0F6H),A
	POP	HL
	POP	AF
	RET

;--------------------------------
; GRAPHIC DISPLAY PLANE
;   NEXT DB = PORT F6H DATA
;--------------------------------
DISSEL:
	EX	AF,AF'
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	CALL	DISPLAYSEL
	EX	AF,AF'
	RET
	
;--------------------------------
; GRAPHIC RAM SELECT
;   Acc = PORT F7H DATA
;--------------------------------
GRAMSEL:
	PUSH	AF
	PUSH	HL
	LD	HL,GRAPHWRT
	AND	03H
	LD	(HL),A
	OUT	(0F7H),A

	CP	0
	JR	Z,GRAMSEL1
	IN	A,(0E8H)
	AND	0BFH
	OR	080H
	OUT	(0E8H),A
	JR	GRAMSEL2
GRAMSEL1:
	IN	A,(0E8H)
	AND	07FH
	OUT	(0E8H),A
GRAMSEL2:
	POP	HL
	POP	AF
	RET

;--------------------------------
; GRAPHIC RAM SELECT
;   NEXT DB = PORT F7H DATA
;--------------------------------
GRSEL:
	EX	AF,AF'
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	CALL	GRAMSEL
	EX	AF,AF'
	RET
	
;--------------------------------
; WAIT
;  Delay( B * HL )
;--------------------------------
WAIT:
	PUSH	HL
	PUSH	BC
	PUSH	DE
	PUSH	AF
	PUSH	HL
	POP	DE
WAITLOP:
	PUSH	DE
	POP	HL
WAITLOP1:
	DEC	HL
	LD	A,H
	OR	L
	JR	NZ,WAITLOP1
	DJNZ	WAITLOP
	
	POP	AF
	POP	DE
	POP	BC
	POP	HL
	RET

;--------------------------------
; SET CURSOR
;   D=X  E=Y
;--------------------------------
SETCSR:
	PUSH	HL
	LD	HL,CURSORY
	LD	(HL),E
	INC	HL
	LD	(HL),D
	POP	HL
	RET
	
;--------------------------------
; SET CURSOR DEFB
;--------------------------------
SETCSRDB:
	EXX
	EX	(SP),HL
	LD	D,(HL)
	INC	HL
	LD	E,(HL)
	INC	HL
	EX	(SP),HL
	CALL	SETCSR
	EXX
	RET
	
;--------------------------------
; MESSAGE STRING OUT
;  HL = MESSAGE POINTER(NULL TERM.)
;--------------------------------
MSGOUT:
	PUSH	AF
MSGLOP:
	LD	A,(HL)
	CP	0
	JR	Z,MSGLOPE
	CALL	CHAROUT
	INC	HL
;	CALL	WAIT
	JR	MSGLOP
MSGLOPE:
	POP	AF
	RET

;--------------------------------
; PRINT ONE CHARACTER
;  NEXT DB = PRINT OUT CHARACTER
;--------------------------------
COUT:
	EXX
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	EXX
	JP	CHAROUT

;--------------------------------
; PRINT ONE SPACE
;
;--------------------------------
PRNSPC:
	PUSH	AF
	LD	A,20H
	CALL	CHAROUT
	POP	AF
	RET
;--------------------------------
; MESSAGE STRING OUT
;  00H TERM STRING
;--------------------------------
PRINTS:
	EXX
	EX	AF,AF'
	EX	(SP),HL
	PUSH	HL
	POP	DE
PRINTSL:
	LD	A,(HL)
	CP	0
	JR	Z,PRINTSLE
	INC	HL
	JR	PRINTSL
PRINTSLE:
	INC	HL
	EX	(SP),HL
	PUSH	DE
	EX	AF,AF'
	EXX
	POP	HL
	JR	MSGOUT
	


;----------------------------
; SOUND OUT
;   HL = ONTEI
;   BC = ONCYOU
;----------------------------
SOUT:
	PUSH	BC
	PUSH	DE
SOUT1:
	LD	A,5
	CALL	SOUT2
	LD	A,4
	CALL	SOUT2
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,SOUT1
	POP	DE
	POP	HL
	RET

SOUT2:
	OUT	(0E3H),A
	LD	D,H
	LD	E,L
SOUT21:
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,SOUT21
	RET
	
;----------------------------
; PRINT ACC HEX DATA
;   Acc = HEX DATA
;----------------------------
PRNHEXACC:
	PUSH	AF
	PUSH	AF
	AND	0F0H
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	ASC
	CALL	CHAROUT
	POP	AF
	AND	0FH
	CALL	ASC
	CALL	CHAROUT
	POP	AF
	RET

;----------------------------
; PRINT HL HEX DATA
;   HL = HEX
;----------------------------
PRNHEXHL:
	PUSH	AF
	LD	A,H
	CALL	PRNHEXACC
	LD	A,L
	CALL	PRNHEXACC
	POP	AF
	RET

; ----------------------------------------
;|       HEX 4 Bit CNV. TO ASCII Acc      |
; ----------------------------------------
ASC:
	AND	0FH
	ADD	A,30H
	CP	3AH
	RET	C
	ADD	A,07H
	RET
;
;
;
;
; ----------------------------------------
;|   (DE)`(DE+3) ASCII CNV. TO HEX HL    |
; ----------------------------------------
;
;IF ERROR THEN Carry F. = 1 | HL=????H | RET
;
HLHEX:
	PUSH	AF
	PUSH	DE
	CALL	TOWHEX
	JR	C,HL1
	LD	H,A
	CALL	TOWHEX
	JR	C,HL1
	LD	L,A
HL1:
	POP	DE
	POP	AF
	RET
;
;
; ----------------------------------------
;|   (DE)`(DE+1) ASCII CNV. TO HEX Acc   |
; ----------------------------------------
;
;IF ERROR THEN Carry F. = 1 | Acc=?? | RET
;
TOWHEX:
	PUSH	BC
	LD	A,(DE)
	INC	DE
	CALL	HEX
	JR	C,TOHEX1
	RRCA
	RRCA
	RRCA
	RRCA
	LD	C,A
	LD	A,(DE)
	INC	DE
	CALL	HEX
	JR	C,TOHEX1
	OR	C			;ZERO F. RESET!
TOHEX1:
	POP	BC
	RET
;
;
; ----------------------------------------
;|     ASCII Acc CNV. TO HEX 4Bit Acc     |
; ----------------------------------------
;
;IF ERROR THEN Carry F. = 1 | Acc=??H | RET
;
HEX:
	CP	47H
	JR	NC,HEXCR
	CP	41H
	JR	NC,HEX1
	CP	3AH
	JR	NC,HEXCR
	CP	30H
	RET	C
	SUB	30H
	RET
HEX1:
	SUB	37H
	RET
HEXCR:
	SCF
	RET
;
;----------------------------
; NOT INPREMENT
;----------------------------
NOOP:
	RET


;--------------------------------
; 6 Voice Music System
;
;--------------------------------
SND1:
	DEFB	0	;CH1
	DEFB	0	;CH2
	DEFB	0	;CH3
	DEFB	0	;CH4
	DEFB	0	;CH5
	DEFB	0	;CH6
SND2:
	DEFB	5	;CH1
	DEFB	5	;CH2
	DEFB	5	;CH3
	DEFB	5	;CH4
	DEFB	5	;CH5
	DEFB	5	;CH6
SND3:
	DEFB	0	;CH1
	DEFB	0	;CH2
	DEFB	0	;CH3
	DEFB	0	;CH4
	DEFB	0	;CH5
	DEFB	0	;CH6
SNDLEN:
	DEFW	0	;LENGTH

R3VMS:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	IX
R3VMS0:
	LD	IX,SND1
	LD	DE,SND2
	LD	HL,SND3
	LD	B,3
R3VMS1:
	LD	A,(DE)
	OUT	(0E3H),A
	LD	C,(HL)
	DEC	C
	LD	(HL),C
	JR	NZ,R3VMS2
	XOR	1
	LD	(DE),A
	LD	A,(IX+0)
	LD	(HL),A
	CP	0
	JR	NZ,R3VMS2
	LD	A,5
	LD	(DE),A
R3VMS2:
	INC	HL
	INC	DE
	INC	IX
	DJNZ	R3VMS1
	LD	HL,(SNDLEN)
	DEC	HL
	LD	(SNDLEN),HL
	LD	A,H
	CP	0FFH
	JR	NZ,R3VMS0
	POP	IX
	POP	BC
	POP	DE
	POP	HL
	RET

;-------------------------------------
;  PLAY ALL
;    IY = PLAY DATA
;-------------------------------------
PLAYALL:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	IX
PLAYALL0:	
	LD	IX,SND1
	LD	DE,6
	LD	B,6
PLAYALLLOP:
	LD	A,(IY+0)
	LD	(IX+0),A
	LD	(IX+12),A
	INC	IX
	INC	IY
	DJNZ	PLAYALLLOP
	LD	A,5
	LD	(IX+0),A
	LD	(IX+1),A
	LD	(IX+2),A
	LD	(IX+3),A
	LD	(IX+4),A
	LD	(IX+5),A
	LD	H,(IY+1)
	LD	L,(IY+0)
	LD	A,H
	OR	L
	JR	Z,PLAYALLEND
	LD	(SNDLEN),HL
	INC	IY
	INC	IY
	CALL	R3VMS
	JR	PLAYALL0
PLAYALLEND:
	POP	IX
	POP	BC
	POP	DE
	POP	HL
	RET
	
;-------------------------------------
;  PLAY One
;    IY = PLAY DATA
;-------------------------------------
POEND:
	DW	0
PLAYONE:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	IX
	LD	HL,(POEND)
	LD	A,H
	OR	L
	JR	Z,PLAYONE0
	PUSH	HL
	POP	IY
PLAYONE0:	
	LD	IX,SND1
	LD	DE,6
	LD	B,6
PLAYONELOP:
	LD	A,(IY+0)
	LD	(IX+0),A
	LD	(IX+12),A
	INC	IX
	INC	IY
	DJNZ	PLAYONELOP
	LD	A,5
	LD	(IX+0),A
	LD	(IX+1),A
	LD	(IX+2),A
	LD	(IX+3),A
	LD	(IX+4),A
	LD	(IX+5),A
	LD	H,(IY+1)
	LD	L,(IY+0)
	LD	A,H
	OR	L
	JR	Z,PLAYONEEND
	LD	(SNDLEN),HL
	INC	IY
	INC	IY
	CALL	R3VMS
	PUSH	IY
	POP	HL
	JR	PONEEND1
PLAYONEEND:
	LD	HL,0
PONEEND1:
	LD	(POEND),HL
	POP	IX
	POP	BC
	POP	DE
	POP	HL
	RET
	

;----------------------------------
; C3VMS MZ-A Compatible SET MUSIC DATA
;    HL = MUSIC DATA ADDRESS
;
;HL:
;  DB VIB1,VIB2,VIB3    ----  0:NON VIB  1:ON VIB
;  DW Pn                ----  LENGTH 1
;  DB PART1,PART2,PART3 ----  MUSICDATA 1
;  DW Pn                ----  LENGTH 2
;  DB PART1,PART2,PART3 ----  MUSICDATA 2
;         :   :     :
;  DW Pn                ----  LENGTH n
;  DB PART1,PART2,PART3 ----  MUSICDATA n
;  DW DEND              ----  DATA END MARK.
;----------------------------------
P3VMSA:
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
	LD	DE,VIB1
	EX	DE,HL
	LD	B,3
P3VMSAL:
	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	P3VMSAL
	EX	DE,HL
	
	EX	DE,HL		
	LD	HL,C3PARAM	
	LD	A,(HL)		
	INC	HL		
	DEC	A		
	JR	Z,P3V001	
	LD	A,0AFH		
P3V001:	LD	(P3V002),A	
	LD	A,(HL)		
	INC	HL		
	DEC	A		
	JR	Z,P3V003	
	LD	A,0AFH		
P3V003:	LD	(P3V004),A	
	LD	A,(HL)		
	INC	HL		
	DEC	A		
	JR	Z,P3V005	
	LD	A,0AFH		
P3V005:	LD	(P3V006),A	
	EX	DE,HL		
	LD	(PADRLIVE),HL	
	LD	(PADRORG),HL	
	POP	AF
	POP	BC
	POP	DE
	POP	HL
	RET
	
;----------------------------------
; C3VMS MZ-A  Compatible
;           PLAY ALL MUSIC DATA
;    HL = MUSIC DATA ADDRESS
;    PLAYEND RETURN 
;----------------------------------
P3VMALOP:
	CALL	P3VMSA
P3VMAL0:
	CALL	P3VMLOP
	JR	NC,P3VMAL0
	RET

;----------------------------------
; C3VMS MZ-A Compatible
;         PLAY ONE MUSIC DATA
;    RETURN CARRY F.SET -> PLAY END
;----------------------------------
P3VMLOP:
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY

	LD	HL,(PADRLIVE)
	LD	A,(HL)
	INC	HL
	DEFB	0DDH,06FH	;LD IXL,A
	LD	A,(HL)
	INC	HL
	DEFB	0DDH,067H	;LD IXH,A ;IX=TONE LENGTH
	OR	A
	JP	Z,P3VEND	;SOUND PLAY END.	
	LD	A,(HL)
	INC	HL
	CP	01H
	JR	NZ,P3V007
	XOR	A
	JR	P3V008
P3V007:	LD	(P3VR00+1),A
	INC	A
	LD	(P3VR02+1),A
	LD	A,01H
P3V008:	LD	(P3VR01+1),A
P3V002:	NOP
	LD	(P3VR03+1),A
	LD	A,(HL)
	INC	HL
	CP	01H
	JR	NZ,P3V009
	XOR	A
	JR	P3V010
P3V009:	LD	(P3VR04+1),A
	INC	A
	LD	(P3VR06+1),A
	LD	A,01H
P3V010:	LD	(P3VR05+1),A
P3V004:	NOP
	LD	(P3VR07+1),A
	LD	A,(HL)
	INC	HL
	CP	01H
	JR	NZ,P3V011
	XOR	A
	JR	P3V012
P3V011:	LD	(P3VR08+1),A
	INC	A
	LD	(P3VR0A+1),A
	LD	A,01H
P3V012:	LD	(P3VR09+1),A
P3V006:	NOP
	LD	(P3VR0B+1),A
	PUSH	HL
P3VR50:	LD	HL,0404H
P3VR51:	LD	DE,0404H
P3VR52:	LD	BC,04E3H
	EXX
P3VR53:	LD	HL,0404H
P3VR54:	LD	DE,0404H
P3VR55:	LD	BC,04E3H
	LD	A,04H
	EX	AF,AF'
P3V019:	DJNZ	P3V013
P3VR00:	LD	B,00H
	LD	A,E
P3VR01:	XOR	00H
	LD	E,A
P3V013:	OUT	(C),E
	DEC	D
	JR	NZ,P3V014
P3VR02:	LD	D,00H
	LD	A,E
P3VR03:	XOR	00H
	LD	E,A
P3V014:	DEC	H
	JR	NZ,P3V015
P3VR04:	LD	H,00H
	EX	AF,AF'
P3VR05:	XOR	00H
	EX	AF,AF'
P3V015:	EX	AF,AF'
	OUT	(0E3H),A
	EX	AF,AF'
	EXX
	DEC	H
	JR	NZ,P3V016
P3VR06:	LD	H,00H
	EX	AF,AF'
P3VR07:	XOR	00H
	EX	AF,AF'
P3V016:	DEC	D
	JR	NZ,P3V017
P3VR08:	LD	D,00H
	LD	A,E
P3VR09:	XOR	00H
	LD	E,A
P3V017:	OUT	(C),E
	DJNZ	P3V018
P3VR0A:	LD	B,00H
	LD	A,E
P3VR0B:	XOR	00H
	LD	E,A
P3V018:	EXX
	IN	A, (80h)
	OR	A
	JP	NZ,P3VEND2	;A 0=LOOP, 1,2,3=END
	DEFB	0DDH,02DH	;DEC IXL
	JP	NZ,P3V019
	DEFB	0DDH,025H	;DEC IXH
	JP	NZ,P3V019
P3VEND2:
	LD	(P3VR50+1),HL
	LD	(P3VR51+1),DE
	LD	(P3VR52+1),BC
	EXX
	LD	(P3VR53+1),HL
	LD	(P3VR54+1),DE
	LD	(P3VR55+1),BC
	POP	HL
	OR	A
	JP	P3VEND1

P3VEND:
	LD	HL,(PADRORG)
	SCF
P3VEND1:
	LD	(PADRLIVE),HL
	POP	IY
	POP	IX
	POP	HL
	POP	DE
	POP	BC
	RET
	
C3PARAM:	
VIB1:	DB	0		
VIB2:	DB	1		
VIB3:	DB	1		
	NOP
	NOP			
PADRLIVE:
	DW	0		
PADRORG:
	DW	0		
	NOP			
	NOP			


;--------------------------------
; INITILIZE IO LOGIC
;
;--------------------------------
INITIALIO:
	LD	HL,IOTBL
INIIO1:
	LD	A,(HL)
	INC	HL
	LD	C,(HL)
	INC	HL
	OUT	(C),A
	INC	A
	JR	NZ,INIIO1
	
	DB	SVC,CONSC80
	DB	SVC,CONSN
	DB	SVC,CLEAR
	DB	SVC,STXTCOL,7
	DB	SVC,SBGCOL,0
	DB	SVC,SDISPOUT,7
	DB	SVC,SGRAMOUT,0
	LD	IY,DATCLR
	DB	GFC,GRCLS
	RET
IOTBL:
	DEFW	0E302H
	DEFW	0E734H
	DEFW	0E774H
	DEFW	0E7B4H
	DEFW	0E600H
	DEFW	0E600H
	DEFW	0E502H
	DEFW	0E500H
	DEFW	0E402H
	DEFW	0E400H
	DEFW	0E9CFH
	DEFW	0E900H
	DEFW	0E840H
	DEFW	0F700H
	DEFW	0F600H
	DEFW	0F507H
	DEFW	0F400H
	DEFW	0EBCFH
	DEFW	0EBFFH

DATCLR:
	DB	GRPAGE_123

;----------------------------------------------------------
STARTUP:
	LD	SP,0FFFFH-1
	IM	2
	CALL	INITIALIO


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;DȃvOĉ
;;
;; EmuZ-1M02 EmuZ-MIDI System ver.1.00
;; Copyright 2003 (C) by EmuZ-2000 & TAGO.
;;

STLOP:
	DB	SVC,SPUTS
	DB	"** Monitor EmuZ-2000 ** ",0Dh,0Ah
	DB	"--------------------------------------",0Dh,0Ah
	DB	"  EmuZ-2000 TEST Monitor",0Dh,0Ah
	DB	0DH,0AH
	DB	"  Copyright 2002 (C) by EmuZ-2000.",0Dh,0Ah
	DB	"--------------------------------------",0Dh,0Ah
	DB	"EmuZ-1M02 EmuZ-MIDI 3 voices music system ver.1.00",0Dh,0Ah
	DB	"Copyright 2003 (C) by EmuZ-2000 & TAGO.",0Dh,0Ah
	DB	"http://www.geocities.co.jp/SiliconValley-Sunnyvale/2521/",0Dh,0Ah
	DB	0
	
LOOP:
	IN	A, (80h)
	BIT	0, A
	JR	NZ, PLAY	; b0 = 1 
	BIT	1, A
	JR	NZ, PAUSE	; b1 = 1 [v
	BIT	2, A
	JR	NZ, TONE	; b2 = 1 FύX
	JR	LOOP		; 0 [v

TONE:
	LD	HL, TONE1
	IN	A, (84h)
	LD	(HL), A
	LD	HL, TONE2
	IN	A, (85h)
	LD	(HL), A
	LD	HL, TONE3
	IN	A, (86h)
	LD	(HL), A
	LD	A, 4
	OUT	(80h), A
	JR	LOOP

PLAY:
	IN	A, (81h)
	LD	(PITCH1), A
	IN	A, (82h)
	LD	(PITCH2), A
	IN	A, (83h)
	LD	(PITCH3), A
	LD	HL, 60000
	LD	(LENGTH), HL
	LD	A, 1

	OUT	(80h), A
	LD	HL, MUSICD
	DB	SVC, C3VMSET
	DB	SVC, C3VMONE
	JR	LOOP

PAUSE:
	LD	A, 2
	OUT	(80h), A
	JR	LOOP

	HALT

MUSICD:
TONE1:	DB	0
TONE2:	DB	0
TONE3:	DB	0
LENGTH:	DW	60000
PITCH1:	DB	NR
PITCH2:	DB	NR
PITCH3:	DB	NR
	DW	1
	DB	NR, NR, NR
	DW	DEND

	END
