/* File: SerialDlg.c

	MZ-2000/2200/80B/B2 Emulator "EmuZ-2000"
		MZ-1E24F(to File) DLL - Serial I/F Setting Dialog

	Copyright (C) 2017 Toshio Fukui
	This file is part of the EmuZ-2000 plugins software.
	See copyright notice in the COPYING file.
*/

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "SerialDlg.h"
#include "resource.h"

#define LNMAX	1024

static BOOL DlgCenterWindow( HWND hDlg, HWND hWndParent )
{
	RECT rect;
	int tx, ty, dx, dy, sx, sy;

	/* Get the target center position */
	if (!hWndParent)
		hWndParent = GetWindow( hDlg, GW_OWNER );
	if (!hWndParent)
		return FALSE;
	GetWindowRect( hWndParent, &rect );
	tx = (rect.left + rect.right) / 2;
	ty = (rect.top + rect.bottom) / 2;

	/* Move to center position */
	GetWindowRect( hDlg, &rect );
	dx = tx - (rect.left + rect.right) / 2;
	dy = ty - (rect.top + rect.bottom) / 2;
	rect.left   += dx;
	rect.right  += dx;
	rect.top    += dy;
	rect.bottom += dy;

	/* Move to inside of screen */
	sx = GetSystemMetrics( SM_CXSCREEN );
	sy = GetSystemMetrics( SM_CYSCREEN );
	if (rect.right >= sx) {
		int dd = sx - rect.right;
		rect.left  += dd;
		rect.right += dd;
	}
	if (rect.bottom >= sy) {
		int dd = sy - rect.bottom;
		rect.top    += dd;
		rect.bottom += dd;
	}
	if (rect.left < 0) {
		rect.right += -rect.left;
		rect.left = 0;
	}
	if (rect.top < 0) {
		rect.bottom += -rect.top;
		rect.top = 0;
	}

	/* Update the real window position */
	SetWindowPos( hDlg, NULL,
		rect.left, rect.top, 0, 0,
		SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	return TRUE;
}

static void DlgSetWindowState( HWND hDlg )
{
	/* input END items */
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_INPUTCLOSE ), input_fp ? TRUE : FALSE );
	/* input START items */
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_INPUTOPEN ), !input_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_EDIT_INPUTFILE ), !input_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_INPUTFILE ), !input_fp ? TRUE : FALSE );

	/* output END items */
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_END ), output_fp ? TRUE : FALSE );
	/* output START items */
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_START ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_EDIT_OUTPUTFILE ), !output_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_BUTTON_OUTPUTFILE ), !output_fp ? TRUE : FALSE );

	/* common */
	EnableWindow( GetDlgItem( hDlg, IDC_COMBO_Z80SIOCH ), !output_fp && !input_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), !output_fp && !input_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_CHECK_ERACTRLS ), !output_fp && !input_fp ? TRUE : FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_CHECK_EOFTOCHAR ), !output_fp && !input_fp ? TRUE : FALSE );
	return;
}

BOOL WINAPI DlgProcSerialSettings( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	int r;

	switch (msg) {
	case WM_INITDIALOG :
		/* set the window attributes */
		DlgCenterWindow( hDlg, NULL );

		/* set dialog items */
		SendDlgItemMessage( hDlg, IDC_EDIT_INPUTFILE, WM_SETTEXT, 0, (LPARAM)input_fn );
		SendDlgItemMessage( hDlg, IDC_EDIT_OUTPUTFILE, WM_SETTEXT, 0, (LPARAM)output_fn );
		SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_SETCHECK, enable_nocodeconv, 0 );
		SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERACTRLS ), BM_SETCHECK, enable_erasectrlchars, 0 );
		SendMessage( GetDlgItem( hDlg, IDC_CHECK_EOFTOCHAR ), BM_SETCHECK, enable_eoftochar, 0 );
		SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_RESETCONTENT, 0, 0 );
		SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_ADDSTRING, 0, (LPARAM)"A" );
		SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_ADDSTRING, 0, (LPARAM)"B" );
		SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_SETCURSEL, file_channel, 0 );

		/* set dialog items - II */ 
		DlgSetWindowState( hDlg );
		return TRUE;
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
		case IDCLOSE :
			SendDlgItemMessage( hDlg, IDC_EDIT_INPUTFILE, WM_GETTEXT, MAX_PATH, (LPARAM)input_fn );
			input_fn[MAX_PATH - 1] = '\0';
			SendDlgItemMessage( hDlg, IDC_EDIT_OUTPUTFILE, WM_GETTEXT, MAX_PATH, (LPARAM)output_fn );
			output_fn[MAX_PATH - 1] = '\0';
			enable_nocodeconv = SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_erasectrlchars = SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERACTRLS ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_eoftochar = SendMessage( GetDlgItem( hDlg, IDC_CHECK_EOFTOCHAR ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			r = SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_GETCURSEL, 0, 0 );
			if (r != CB_ERR && r >= 0 && r <= 1)
				file_channel = r;
			EndDialog( hDlg, TRUE );
			return TRUE;
		case IDCANCEL :
			EndDialog( hDlg, FALSE );
			return TRUE;
		case IDC_BUTTON_INPUTFILE :
			SendDlgItemMessage( hDlg, IDC_EDIT_INPUTFILE, WM_GETTEXT, MAX_PATH, (LPARAM)input_fn );
			input_fn[MAX_PATH - 1] = '\0';
			{
				OPENFILENAME ofn;
				char *cp, szFileName[MAX_PATH] = "";
				char szFileTitle[MAX_PATH] = "";

				strncpy( szFileName, (char *)input_fn, MAX_PATH );
				szFileName[MAX_PATH - 1] = '\0';
				if (szFileName[strlen(szFileName) - 1] == '\\') {
					strncat( szFileName, "*.txt", MAX_PATH - strlen(szFileName) - 1 );
					szFileName[MAX_PATH - 1] = '\0';
				}
				memset( &ofn, 0, sizeof(OPENFILENAME) );
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hDlg;
				ofn.lpstrFilter = 
					"Generic Text (*.txt)\0*.txt\0"
					"All Files (*.*)\0*.*\0\0";
				ofn.lpstrFile = szFileName;
				ofn.lpstrFileTitle = szFileTitle;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
				cp = strrchr( szFileName, '.' );
				if (cp) {
					cp++;
					if (!stricmp( cp, "txt" )) {
						ofn.nFilterIndex = 1; 
						ofn.lpstrDefExt = "txt";
					} else {
						ofn.nFilterIndex = 2; 
						ofn.lpstrDefExt = "";
					}
				} else {
					ofn.nFilterIndex = 1; 
					ofn.lpstrDefExt = "txt";
				}
				ofn.lpstrTitle = "Select MZ State File";
				if (!GetSaveFileName(&ofn)) {
					/* cancel */
					return TRUE;
				}
				strncpy( (void *)input_fn, szFileName, MAX_PATH );
				input_fn[MAX_PATH - 1] = '\0';

				SendDlgItemMessage( hDlg, IDC_EDIT_INPUTFILE, WM_SETTEXT, 0, (LPARAM)input_fn );
				return TRUE;
			}
		case IDC_BUTTON_OUTPUTFILE :
			SendDlgItemMessage( hDlg, IDC_EDIT_OUTPUTFILE, WM_GETTEXT, MAX_PATH, (LPARAM)output_fn );
			output_fn[MAX_PATH - 1] = '\0';
			{
				OPENFILENAME ofn;
				char *cp, szFileName[MAX_PATH] = "";
				char szFileTitle[MAX_PATH] = "";

				strncpy( szFileName, (char *)output_fn, MAX_PATH );
				szFileName[MAX_PATH - 1] = '\0';
				if (szFileName[strlen(szFileName) - 1] == '\\') {
					strncat( szFileName, "*.txt", MAX_PATH - strlen(szFileName) - 1 );
					szFileName[MAX_PATH - 1] = '\0';
				}
				memset( &ofn, 0, sizeof(OPENFILENAME) );
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hDlg;
				ofn.lpstrFilter = 
					"Generic Text (*.txt)\0*.txt\0"
					"All Files (*.*)\0*.*\0\0";
				ofn.lpstrFile = szFileName;
				ofn.lpstrFileTitle = szFileTitle;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
				cp = strrchr( szFileName, '.' );
				if (cp) {
					cp++;
					if (!stricmp( cp, "txt" )) {
						ofn.nFilterIndex = 1; 
						ofn.lpstrDefExt = "txt";
					} else {
						ofn.nFilterIndex = 2; 
						ofn.lpstrDefExt = "";
					}
				} else {
					ofn.nFilterIndex = 1; 
					ofn.lpstrDefExt = "txt";
				}
				ofn.lpstrTitle = "Select MZ State File";
				if (!GetSaveFileName(&ofn)) {
					/* cancel */
					return TRUE;
				}
				strncpy( (void *)output_fn, szFileName, MAX_PATH );
				output_fn[MAX_PATH - 1] = '\0';

				SendDlgItemMessage( hDlg, IDC_EDIT_OUTPUTFILE, WM_SETTEXT, 0, (LPARAM)output_fn );
				return TRUE;
			}
		case IDC_BUTTON_INPUTCLOSE :
			if (input_fp) {
				fclose( input_fp );
				input_fp = NULL;
				recvdata_reset();
			} else
				MessageBox( hDlg, "Serial input file is closed already.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
			DlgSetWindowState( hDlg );
			return TRUE;
		case IDC_BUTTON_INPUTOPEN :
			if (input_fp) {
				fclose( input_fp );
				input_fp = NULL;
				recvdata_reset();
			}
			SendDlgItemMessage( hDlg, IDC_EDIT_INPUTFILE, WM_GETTEXT, MAX_PATH, (LPARAM)input_fn );
			input_fn[MAX_PATH - 1] = '\0';
			if (strlen( input_fn ) < 1 ) {
				MessageBox( hDlg, "Please input output file name.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
				return TRUE;
			}
			input_fp = fopen( input_fn, "rb" );
			if (!input_fp) {
				MessageBox( hDlg, "Can't open the file for read.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
				return TRUE;
			}
			enable_nocodeconv = SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_erasectrlchars = SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERACTRLS ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_eoftochar = SendMessage( GetDlgItem( hDlg, IDC_CHECK_EOFTOCHAR ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			r = SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_GETCURSEL, 0, 0 );
			if (r != CB_ERR && r >= 0 && r <= 1)
				file_channel = r;
			DlgSetWindowState( hDlg );
			return TRUE;
		case IDC_BUTTON_START :
			if (output_fp) {
				fclose( output_fp );
				output_fp = NULL;
			}
			SendDlgItemMessage( hDlg, IDC_EDIT_OUTPUTFILE, WM_GETTEXT, MAX_PATH, (LPARAM)output_fn );
			output_fn[MAX_PATH - 1] = '\0';
			if (strlen( output_fn ) < 1 ) {
				MessageBox( hDlg, "Please input output file name.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
				return TRUE;
			}
			output_fp = fopen( output_fn, "wb" );
			if (!output_fp) {
				MessageBox( hDlg, "Can't create the file for write.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
				return TRUE;
			}
			enable_nocodeconv = SendMessage( GetDlgItem( hDlg, IDC_CHECK_NOCODECONV ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_erasectrlchars = SendMessage( GetDlgItem( hDlg, IDC_CHECK_ERACTRLS ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			enable_eoftochar = SendMessage( GetDlgItem( hDlg, IDC_CHECK_EOFTOCHAR ), BM_GETCHECK, 0, 0 ) ? TRUE : FALSE;
			r = SendDlgItemMessage( hDlg, IDC_COMBO_Z80SIOCH, CB_GETCURSEL, 0, 0 );
			if (r != CB_ERR && r >= 0 && r <= 1)
				file_channel = r;
			DlgSetWindowState( hDlg );
			return TRUE;
		case IDC_BUTTON_END :
			if (output_fp) {
				fclose( output_fp );
				output_fp = NULL;
			} else
				MessageBox( hDlg, "Serial output file is closed already.", MZ_MESSAGEBOX_TITLE, MB_ICONEXCLAMATION | MB_OK );
			DlgSetWindowState( hDlg );
			return TRUE;
		default :
			break;
		}
		break;
	}
	return FALSE;
}

/*
	Local Variables:
	mode:c++
	c-set-style:"k&r"
	c-basic-offset:8
	tab-width:8
	End:
*/
